/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.DWLMClientServiceContextImpl;
import com.ibm.ws.dwlm.client.RequestFlowInfoImpl;
import com.ibm.ws.dwlm.client.URIMatcherImpl;
import com.ibm.ws.dwlm.client.VHostMatcherImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.wsspi.dwlm.client.DWLMClientServiceContext;
import com.ibm.wsspi.dwlm.client.RequestFlowInfo;
import com.ibm.wsspi.dwlm.client.RequestMapper;
import com.ibm.wsspi.dwlm.client.RequestMapperInvalidationListener;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventEdgeChange;
import com.ibm.wsspi.odc.ODCEventNodeChange;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTransactionListener;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class RequestMapperImpl
implements RequestMapper,
ODCTransactionListener {
    protected static final TraceComponent tc = Tr.register(RequestMapperImpl.class, "DWLMClient", "com.ibm.ws.dwlm.client.nls.Messages");
    protected final ODCTree targetTree;
    protected ODCHelper odc;
    protected ODCEventType[] interestEvents;
    protected VHostMatcherImpl vhostMatcher;
    protected URIMatcherImpl uriMatcher;
    protected Exception matcherException;
    protected Set invalidationListeners;

    public RequestMapperImpl(ODCTree oDCTree) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.targetTree = oDCTree;
        if (oDCTree == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "disabled");
            }
            return;
        }
        this.odc = ODCHelper.getInstance();
        this.interestEvents = this.createInterestEvents();
        this.invalidationListeners = new TreeSet();
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor", "initialized");
        }
    }

    protected ODCEventType[] createInterestEvents() throws Exception {
        return new ODCEventType[]{this.odc.mgr.findEdgeType(this.odc.application, this.odc.webModule), this.odc.mgr.findEdgeType(this.odc.webModule, this.odc.uri), this.odc.mgr.findEdgeType(this.odc.cell, this.odc.vhostGroup), this.odc.mgr.findEdgeType(this.odc.vhostGroup, this.odc.vhost), this.odc.appLastChangeTime, this.odc.vhostHost, this.odc.vhostPort, this.odc.webModuleRoutingEnabled};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.targetTree.addListener(this);
        try {
            if (!Util.isProxy() && !Util.isODR()) {
                this.targetTree.waitForInitializationCompletion(60000);
            }
        }
        catch (Exception exception) {
            TrUtil.warning(exception, this, "TargetTreeInitializationError", tc);
        }
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            this.makeMatchers();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public boolean isEnabled() {
        return this.targetTree != null;
    }

    public ODCNode mapRequestToODCNode(HttpRequestMessage httpRequestMessage, int n) throws Exception {
        String string = httpRequestMessage.getVirtualHost();
        int n2 = httpRequestMessage.getVirtualPort();
        if (n2 == -1) {
            n2 = n;
        }
        String string2 = httpRequestMessage.getRequestURI();
        return this.mapRequestToODCNode(string, n2, string2);
    }

    public String mapRequestToClusterName(String string, int n, String string2) throws Exception {
        ODCNode oDCNode = this.mapRequestToODCNode(string, n, string2);
        if (oDCNode == null) {
            return null;
        }
        return this.mapODCNodeToClusterName(oDCNode);
    }

    public String[] mapRequestToClusterNames(String string, int n, String string2) throws Exception {
        ODCNode oDCNode = this.mapRequestToODCNode(string, n, string2);
        if (oDCNode == null) {
            return null;
        }
        return this.mapODCNodeToClusterNames(oDCNode);
    }

    public ODCNode mapRequestToODCNode(String string, int n, String string2) throws Exception {
        Object object;
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapRequestToODCNode", new Object[]{string, new Integer(n), string2});
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapRequestToODCNode", "disabled");
            }
            return null;
        }
        if (this.matcherException != null) {
            throw this.matcherException;
        }
        int n2 = string2.indexOf(59);
        if (n2 >= 0) {
            string2 = string2.substring(0, n2);
        }
        if ((oDCNode = this.convertTargetToODCNode(object = this.uriMatcher.match(string, n, string2))) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mapRequestToODCNode", "URL " + string + ":" + n + "/" + string2 + " not found");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapRequestToODCNode", oDCNode);
        }
        return oDCNode;
    }

    public ODCNode getWebModuleNode(ODCNode oDCNode) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getWebModuleNode " + oDCNode);
        }
        return oDCNode.getNode(this.odc.webModule);
    }

    public String mapODCNodeToClusterName(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapODCNodeToClusterName", oDCNode);
        }
        String[] stringArray = this.mapODCNodeToClusterNames(oDCNode);
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapODCNodeToClusterName", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapRequest(String string, int n, String string2, RequestFlowInfo requestFlowInfo) throws Exception {
        ODCNode oDCNode = this.mapRequestToODCNode(string, n, string2);
        RequestFlowInfoImpl requestFlowInfoImpl = (RequestFlowInfoImpl)requestFlowInfo;
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            oDCNode = this.targetTree.refreshNode(oDCNode);
            if (oDCNode != null) {
                ODCNode oDCNode2 = oDCNode.getParent();
                ODCNode oDCNode3 = oDCNode2.getParent();
                ODCNode oDCNode4 = oDCNode3.getParent();
                ODCNode oDCNode5 = oDCNode2.getNode(this.odc.vhostGroup);
                ODCNode[] oDCNodeArray = oDCNode2.getNodes(this.odc.cluster);
                requestFlowInfoImpl.setCellName(oDCNode4.getName());
                requestFlowInfoImpl.setApplicationName(oDCNode3.getName());
                requestFlowInfoImpl.setWebModuleName(oDCNode2.getName());
                requestFlowInfoImpl.setUriPattern(oDCNode.getName());
                if (oDCNodeArray.length > 0) {
                    requestFlowInfoImpl.setClusterName(oDCNodeArray[0].getName());
                }
                if (oDCNode5 != null) {
                    requestFlowInfoImpl.setVirtualHostName(oDCNode5.getName());
                }
            }
        }
    }

    public String[] mapODCNodeToClusterNames(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapODCNodeToClusterNames", oDCNode);
        }
        ODCNode[] oDCNodeArray = this.getWebModuleNode(oDCNode).getNodes(this.odc.cluster);
        String[] stringArray = new String[oDCNodeArray.length];
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            stringArray[i] = oDCNodeArray[i].getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapODCNodeToClusterNames", stringArray);
        }
        return stringArray;
    }

    public String mapODCNodeToServerName(ODCNode oDCNode) throws Exception {
        ODCNode[] oDCNodeArray = this.getWebModuleNode(oDCNode).getNodes(this.odc.server);
        if (oDCNodeArray.length != 1) {
            return null;
        }
        return oDCNodeArray[0].getName();
    }

    public ODCNode mapODCNodeToModule(ODCNode oDCNode) throws Exception {
        return oDCNode.getNode(this.odc.webModule);
    }

    public void mapRequest(HttpRequestMessage httpRequestMessage, int n, DWLMClientServiceContext dWLMClientServiceContext) throws Exception {
        String string;
        ODCNode oDCNode;
        String string2 = httpRequestMessage.getVirtualHost();
        int n2 = httpRequestMessage.getVirtualPort();
        if (n2 == -1) {
            n2 = n;
        }
        if ((oDCNode = this.mapRequestToODCNode(string2, n2, string = httpRequestMessage.getRequestURI())) != null) {
            DWLMClientServiceContextImpl dWLMClientServiceContextImpl = (DWLMClientServiceContextImpl)dWLMClientServiceContext;
            dWLMClientServiceContextImpl.setODCNode(oDCNode);
        }
    }

    public synchronized boolean addInvalidationListener(RequestMapperInvalidationListener requestMapperInvalidationListener) throws IllegalArgumentException {
        if (requestMapperInvalidationListener == null) {
            throw new IllegalArgumentException("invalidationListener argument can not be null.");
        }
        return this.invalidationListeners.add(requestMapperInvalidationListener);
    }

    public synchronized boolean removeInvalidationListener(RequestMapperInvalidationListener requestMapperInvalidationListener) throws IllegalArgumentException {
        if (requestMapperInvalidationListener == null) {
            throw new IllegalArgumentException("invalidationListener argument can not be null.");
        }
        return this.invalidationListeners.remove(requestMapperInvalidationListener);
    }

    public ODCEventType[] interestEventTypes() {
        return this.interestEvents;
    }

    public void handleEvents(ODCEvent[] oDCEventArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleEvents", oDCEventArray);
        }
        for (int i = 0; i < oDCEventArray.length; ++i) {
            for (int j = 0; j < this.interestEvents.length; ++j) {
                if (oDCEventArray[i].getEventType() != this.interestEvents[j]) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "remaking matchers due to event = " + oDCEventArray[i]);
                }
                this.makeMatchers();
                this.callListeners(oDCEventArray[i]);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleEvents", "remade matchers");
                }
                return;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleEvents", "did not remake matchers");
        }
    }

    public void handleEvent(ODCEvent oDCEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleEvent", oDCEvent);
        }
        this.makeMatchers();
        this.callListeners(oDCEvent);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleEvent");
        }
    }

    protected synchronized void makeMatchers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeMatchers");
        }
        HashSet hashSet = new HashSet();
        while (!this.makeMatchers(hashSet)) {
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeMatchers");
        }
    }

    protected synchronized boolean makeMatchers(Set set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeMatchers", set);
        }
        try {
            URIMatcherImpl uRIMatcherImpl = this.createURIMatcher("soleMatcher");
            ODCNode[] oDCNodeArray = this.targetTree.getRoot().getNodes(this.odc.cell);
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell=" + oDCNodeArray[i]);
                }
                ODCNode[] oDCNodeArray2 = oDCNodeArray[i].getNodes(this.odc.vhostGroup);
                for (int j = 0; j < oDCNodeArray2.length; ++j) {
                    Object object;
                    ODCNode oDCNode = oDCNodeArray2[j];
                    VHostMatcherImpl vHostMatcherImpl = this.createVHostMatcher(oDCNode.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "vhostGroup=" + oDCNode);
                    }
                    ArrayList<VHostMatcherImpl> arrayList = new ArrayList<VHostMatcherImpl>();
                    ODCNode[] oDCNodeArray3 = oDCNode.getNodes(this.odc.vhost);
                    for (int k = 0; k < oDCNodeArray3.length; ++k) {
                        ODCNode oDCNode2 = oDCNodeArray3[k];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "vhost=" + oDCNode2);
                        }
                        object = (String)oDCNode2.getProperty(this.odc.vhostHost);
                        int n = oDCNode2.getIntProperty(this.odc.vhostPort);
                        vHostMatcherImpl.put((String)object, n);
                        arrayList.add(vHostMatcherImpl);
                    }
                    ODCNode[] oDCNodeArray4 = oDCNode.getNodes(this.odc.webModule);
                    for (int k = 0; k < oDCNodeArray4.length; ++k) {
                        object = oDCNodeArray4[k];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "webModule=" + object);
                        }
                        if (set.contains(object.getPath())) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "skipping ... " + object.getPath() + " is disabled");
                            continue;
                        }
                        Object object2 = object.getProperty(this.odc.webModuleRoutingEnabled);
                        if (object2 != null && !((Boolean)object2).booleanValue()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "skip module " + object.getPath() + "; routing is disabled");
                            continue;
                        }
                        String string = (String)object.getProperty(this.odc.webModuleContextRoot);
                        if (string == null) {
                            string = "";
                        }
                        ODCNode[] oDCNodeArray5 = object.getChildren(this.odc.uri);
                        for (int i2 = 0; i2 < oDCNodeArray5.length; ++i2) {
                            ODCNode oDCNode3 = oDCNodeArray5[i2];
                            String string2 = null;
                            string2 = string == null || string.equalsIgnoreCase("null") ? oDCNode3.getName() : string + oDCNode3.getName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "adding " + string2);
                            }
                            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                                VHostMatcherImpl vHostMatcherImpl2 = (VHostMatcherImpl)arrayList.get(i3);
                                Object object3 = uRIMatcherImpl.put(string2, vHostMatcherImpl, oDCNode3);
                                if (object3 == null) continue;
                                set.add(object.getPath());
                                StringBuffer stringBuffer = new StringBuffer();
                                ODCNode oDCNode4 = object.getParent();
                                ODCNode oDCNode5 = oDCNode4.getParent();
                                ODCNode oDCNode6 = ((ODCNode)object3).getParent();
                                ODCNode oDCNode7 = oDCNode6.getParent();
                                ODCNode oDCNode8 = oDCNode7.getParent();
                                Tr.warning(tc, "DWCT0007E", new Object[]{object.getName(), oDCNode4.getName(), oDCNode5.getName(), oDCNode6.getName(), oDCNode7.getName(), oDCNode8.getName()});
                                return false;
                            }
                        }
                    }
                }
            }
            this.uriMatcher = uRIMatcherImpl;
        }
        catch (Exception exception) {
            Tr.warning(tc, "DWCT_Exception", exception);
            this.matcherException = exception;
            this.uriMatcher = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeMatchers", "true");
        }
        return true;
    }

    protected void notifyListeners(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyListeners", stringArray);
        }
        Set set = this.invalidationListeners;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                RequestMapperInvalidationListener requestMapperInvalidationListener = (RequestMapperInvalidationListener)iterator.next();
                if (stringArray[2] == null) continue;
                requestMapperInvalidationListener.invalidate(stringArray[2]);
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Caught exception invoking request mapper invalidation listener; listner=exception=" + throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyListeners");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void callListeners(ODCEvent oDCEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "callListeners", oDCEvent);
        }
        ODCEventType oDCEventType = oDCEvent.getEventType();
        if (oDCEvent instanceof ODCEventNodeChange) {
            ODCEventNodeChange oDCEventNodeChange = (ODCEventNodeChange)oDCEvent;
            ODCNode oDCNode = oDCEventNodeChange.getNode();
            if (oDCEventType != this.odc.vhostHost || oDCEventNodeChange.isAdd()) return;
            ODCNode oDCNode2 = null;
            try {
                oDCNode2 = oDCNode.getParent();
                ODCNode[] oDCNodeArray = oDCNode2.getNodes(this.odc.webModule);
                String[] stringArray = null;
                for (int i = 0; i < oDCNodeArray.length; ++i) {
                    stringArray = this.getDepIdsFromNode(oDCNodeArray[i]);
                    if (stringArray == null) continue;
                    this.notifyListeners(stringArray);
                }
                return;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ODCEventNodeChange failed for node =" + oDCNode.getLongName() + " with message " + exception.getMessage());
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "callListeners", "No dep ids sent to caller.");
                return;
            }
        }
        if (oDCEvent instanceof ODCEventEdgeChange) {
            ODCEventEdgeChange oDCEventEdgeChange = (ODCEventEdgeChange)oDCEvent;
            ODCNode oDCNode = oDCEventEdgeChange.getDstNode();
            ODCNode oDCNode3 = null;
            String[] stringArray = null;
            if (oDCNode.getType() == this.odc.uri) {
                oDCNode3 = oDCEventEdgeChange.getSrcNode();
                stringArray = this.getDepIdsFromNode(oDCNode3);
                if (stringArray == null) return;
                this.notifyListeners(stringArray);
                return;
            }
            if (oDCNode.getType() == this.odc.webModule) {
                oDCNode3 = oDCNode;
                stringArray = this.getDepIdsFromNode(oDCNode3);
                if (stringArray == null) return;
                this.notifyListeners(stringArray);
                return;
            }
            if (oDCNode.getType() != this.odc.vhostGroup) return;
            ODCNode[] oDCNodeArray = null;
            try {
                oDCNodeArray = oDCNode.getNodes(this.odc.webModule);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ODCEventEdgeChange failed for node =" + oDCNode.getLongName() + " with message " + exception.getMessage());
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "callListeners", "No dep ids sent to caller.");
                return;
            }
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                stringArray = this.getDepIdsFromNode(oDCNodeArray[i]);
                if (stringArray == null) continue;
                this.notifyListeners(stringArray);
            }
            return;
        }
        if (oDCEvent instanceof ODCEventSetProperty) {
            ODCEventSetProperty oDCEventSetProperty = (ODCEventSetProperty)oDCEvent;
            ODCNode oDCNode = null;
            String[] stringArray = null;
            try {
                oDCNode = oDCEventSetProperty.getNode();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ODCEventSetProperty failed for node =" + oDCNode.getLongName() + " with message " + exception.getMessage());
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "callListeners", "No dep ids sent to caller.");
                return;
            }
            if (!oDCNode.is(this.odc.webModule) && !oDCNode.is(this.odc.application)) return;
            if (oDCNode.is(this.odc.application)) {
                try {
                    ODCNode[] oDCNodeArray = oDCNode.getChildren(this.odc.webModule);
                    for (int i = 0; i < oDCNodeArray.length; ++i) {
                        stringArray = this.getDepIdsFromNode(oDCNodeArray[i]);
                        if (stringArray == null) continue;
                        this.notifyListeners(stringArray);
                    }
                    return;
                }
                catch (Exception exception) {
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "callListeners", "No dep ids sent to caller because webmodule for application " + oDCNode.getName() + " could not be obtained.");
                    exception.printStackTrace(System.out);
                    return;
                }
            } else {
                stringArray = this.getDepIdsFromNode(oDCNode);
                if (stringArray == null) return;
                this.notifyListeners(stringArray);
            }
            return;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "callListeners", oDCEvent);
    }

    protected String[] getDepIdsFromNode(ODCNode oDCNode) {
        String[] stringArray = new String[5];
        StringBuffer stringBuffer = new StringBuffer(64);
        ODCNode oDCNode2 = null;
        ODCNode oDCNode3 = null;
        try {
            oDCNode2 = oDCNode.getParent();
            oDCNode3 = oDCNode2.getParent();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dependencyIds cannot be built for handle event:" + exception.getMessage());
            }
            return null;
        }
        oDCNode.getTransientProperties().remove("dep_ids");
        String string = oDCNode.getName();
        String string2 = oDCNode2.getName();
        String string3 = oDCNode3.getName();
        stringArray[0] = stringBuffer.append("cell=").append(string3).toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringArray[1] = stringBuffer.append("application=").append(string3).append("/").append(string2).toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringArray[2] = stringBuffer.append("webModule=").append(string3).append("/").append(string2).append("/").append(string).toString();
        stringArray[3] = "workClass=";
        stringArray[4] = "applicationEdition=";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dependencyIds=" + stringArray);
        }
        return stringArray;
    }

    public VHostMatcherImpl createVhostMatcher() {
        return new VHostMatcherImpl();
    }

    public URIMatcherImpl createUriMatcher() {
        return new URIMatcherImpl("");
    }

    public VHostMatcherImpl createVHostMatcher() {
        return new VHostMatcherImpl();
    }

    public VHostMatcherImpl createVHostMatcher(String string) {
        return new VHostMatcherImpl(string);
    }

    protected URIMatcherImpl createURIMatcher(String string) {
        return new URIMatcherImpl(string);
    }

    protected ODCNode convertTargetToODCNode(Object object) {
        return (ODCNode)object;
    }
}

