/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.RoutingDebugRequestContextImpl;
import com.ibm.ws.dwlm.client.URIMatcherImpl;
import com.ibm.ws.dwlm.client.VHostMatcherImpl;
import com.ibm.ws.dwlm.client.mbean.SelectionLevelFactory;
import com.ibm.wsspi.dwlm.client.RoutingDebugRequestContext;
import com.ibm.wsspi.dwlm.client.SelectionLevel;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import java.net.URL;
import java.util.ArrayList;

public class RoutingDebugRequestContextManager {
    private static final RoutingDebugRequestContext[] EMPTY = new RoutingDebugRequestContext[0];
    protected static final TraceComponent tc = Tr.register(RoutingDebugRequestContextManager.class, "DWLMClient", "com.ibm.ws.dwlm.client.nls.Messages");
    protected static VHostMatcherImpl debugVHostMatcher = null;
    private static ArrayList ctxList = new ArrayList();
    private static SelectionLevel selectionLevel;

    public static void setRoutingDebug(String string, String string2) throws Exception {
        RoutingDebugRequestContextImpl routingDebugRequestContextImpl = new RoutingDebugRequestContextImpl();
        debugVHostMatcher = new VHostMatcherImpl();
        StringBuffer stringBuffer = new StringBuffer("\t");
        URL uRL = new URL(string);
        URIMatcherImpl uRIMatcherImpl = debugVHostMatcher.getURIMatcher(uRL.getHost(), uRL.getPort());
        uRIMatcherImpl.put(uRL.getPath(), Boolean.TRUE);
        selectionLevel = SelectionLevelFactory.setSelectionLevel(string2);
        if (routingDebugRequestContextImpl != null) {
            routingDebugRequestContextImpl.setDebugLevel(selectionLevel.getIndex());
            routingDebugRequestContextImpl.setDebugLevelName(selectionLevel.getName());
            routingDebugRequestContextImpl.setDebugSelectionLevel(selectionLevel);
            routingDebugRequestContextImpl.setMessage(stringBuffer);
            routingDebugRequestContextImpl.setHost(uRL.getHost());
            routingDebugRequestContextImpl.setPort(uRL.getPort());
            routingDebugRequestContextImpl.setURI(uRL.getPath());
            ctxList.add(routingDebugRequestContextImpl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "per request routing debug, trace URL set to " + string);
        }
    }

    public static void resetDebugVHostMatcher() {
        debugVHostMatcher = null;
        RoutingDebugRequestContextManager.resetCtxList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "per request routing debug object reset to NULL");
        }
    }

    public static void setMessage(RoutingDebugRequestContext routingDebugRequestContext, String string) {
        if (routingDebugRequestContext != null) {
            StringBuffer stringBuffer = routingDebugRequestContext.getMessage();
            stringBuffer.append(string).append("\n");
            routingDebugRequestContext.setMessage(stringBuffer);
        }
    }

    public static StringBuffer getMessage(RoutingDebugRequestContext routingDebugRequestContext) {
        if (routingDebugRequestContext != null) {
            return routingDebugRequestContext.getMessage();
        }
        return null;
    }

    public static synchronized RoutingDebugRequestContext getMatchRequestContext(HttpRequestMessage httpRequestMessage) {
        if (debugVHostMatcher == null) {
            return null;
        }
        String string = httpRequestMessage.getVirtualHost();
        int n = httpRequestMessage.getVirtualPort();
        String string2 = httpRequestMessage.getRequestURI();
        return RoutingDebugRequestContextManager.getMatchRequestContext(string, n, string2);
    }

    public static synchronized RoutingDebugRequestContext getMatchRequestContext(String string, int n, String string2) {
        if (debugVHostMatcher == null) {
            return null;
        }
        for (int i = 0; i < ctxList.size(); ++i) {
            RoutingDebugRequestContext routingDebugRequestContext = (RoutingDebugRequestContext)ctxList.get(i);
            if (!RoutingDebugRequestContextManager.hostEquals(routingDebugRequestContext, string, n) || !RoutingDebugRequestContextManager.uriEquals(routingDebugRequestContext, string2)) continue;
            return routingDebugRequestContext;
        }
        return null;
    }

    private static void resetCtxList() {
        ctxList.clear();
    }

    private static boolean hostEquals(RoutingDebugRequestContext routingDebugRequestContext, String string, int n) {
        return !(routingDebugRequestContext.getHost() != null && !routingDebugRequestContext.getHost().equals("*") && !routingDebugRequestContext.getHost().equalsIgnoreCase(string) || routingDebugRequestContext.getPort() != -1 && routingDebugRequestContext.getPort() != n);
    }

    private static boolean uriEquals(RoutingDebugRequestContext routingDebugRequestContext, String string) {
        return routingDebugRequestContext.getURI() == null || routingDebugRequestContext.getURI().equalsIgnoreCase(string);
    }
}

