/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.RoutingDebugRequestContextManager;
import com.ibm.ws.dwlm.client.TargetObjectImpl;
import com.ibm.ws.dwlm.client.TargetSelectorImpl;
import com.ibm.ws.dwlm.client.TargetServerApplicationImpl;
import com.ibm.ws.dwlm.client.TargetServerImpl;
import com.ibm.wsspi.dwlm.client.HttpTargetSelectorModule;
import com.ibm.wsspi.dwlm.client.RoutingDebugRequestContext;
import com.ibm.wsspi.dwlm.client.TargetCluster;
import com.ibm.wsspi.dwlm.client.TargetDescriptor;
import com.ibm.wsspi.dwlm.client.TargetServer;
import com.ibm.wsspi.dwlm.client.TargetServerApplication;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.odc.ODCNode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class TargetClusterImpl
extends TargetObjectImpl
implements TargetCluster {
    protected static final TraceComponent tc = Tr.register(TargetClusterImpl.class, "DWLMClient", "com.ibm.ws.dwlm.client.nls.Messages");
    protected static final TargetServerImpl[] NO_SERVERS = new TargetServerImpl[0];
    protected static final TargetServerApplicationImpl[] NO_SAPPS = new TargetServerApplicationImpl[0];
    protected final List sappList = new ArrayList();
    protected TargetServerApplicationImpl[] sapps = NO_SAPPS;
    protected final TargetSelectorImpl selector;
    protected final ODCNode odcNode;
    protected TargetServerImpl[] servers = NO_SERVERS;
    protected int quiesceCount = 0;

    public TargetClusterImpl(String string, ODCNode oDCNode, TargetSelectorImpl targetSelectorImpl) {
        super(string);
        this.odcNode = oDCNode;
        this.selector = targetSelectorImpl;
    }

    public ODCNode getODCNode() {
        return this.odcNode;
    }

    public synchronized void removeServer(TargetServer targetServer) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeServer " + targetServer + " from " + this);
        }
        this.sappList.remove(targetServer);
        ((TargetServerApplicationImpl)targetServer).removeCluster(this);
        this.sapps = this.sappList.toArray(NO_SAPPS);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "servers=" + this.sapps);
        }
    }

    public synchronized TargetServer[] getServers() {
        return this.sapps;
    }

    public synchronized boolean addServer(TargetServer targetServer) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addServer " + targetServer + " to " + this);
        }
        if (this.sappList.contains(targetServer)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, targetServer + " is already a member of " + this);
            }
            return false;
        }
        this.sappList.add(targetServer);
        ((TargetServerApplicationImpl)targetServer).addCluster(this);
        this.sapps = this.sappList.toArray(NO_SAPPS);
        if (tc.isDebugEnabled()) {
            this.print(System.out);
        }
        return true;
    }

    public TargetServer findServer(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findServer", string);
        }
        TargetServerApplicationImpl[] targetServerApplicationImplArray = this.sapps;
        for (int i = 0; i < targetServerApplicationImplArray.length; ++i) {
            TargetServerApplicationImpl targetServerApplicationImpl = targetServerApplicationImplArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverName=", targetServerApplicationImpl.getName());
            }
            if (!targetServerApplicationImpl.getName().equals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findServer", targetServerApplicationImpl);
            }
            return targetServerApplicationImpl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findServer", "null");
        }
        return null;
    }

    public List getSappList() {
        return this.sappList;
    }

    public TargetServer findServerByCloneId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findServerByCloneId", string);
        }
        TargetServerApplicationImpl[] targetServerApplicationImplArray = this.sapps;
        for (int i = 0; i < targetServerApplicationImplArray.length; ++i) {
            TargetServerApplicationImpl targetServerApplicationImpl = targetServerApplicationImplArray[i];
            String string2 = targetServerApplicationImpl.getCloneId();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server=" + targetServerApplicationImpl.getName() + "; cloneId=", string2);
            }
            if (string2 == null || !string2.equals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "findServerByCloneId", targetServerApplicationImpl);
            }
            return targetServerApplicationImpl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findServerByCloneId", "null");
        }
        return null;
    }

    public synchronized void print(PrintStream printStream) {
        printStream.println("CLUSTER=" + this.getName());
        printStream.println("SERVERS:");
        for (int i = 0; i < this.sapps.length; ++i) {
            printStream.println("  " + i + ": " + this.sapps[i] + ": ");
        }
    }

    public synchronized void incrementQuiesceCount(TargetServerApplicationImpl targetServerApplicationImpl) {
        ++this.quiesceCount;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "incrementQuiesceCount of " + this + " to " + this.quiesceCount + " by " + targetServerApplicationImpl);
        }
    }

    public synchronized void decrementQuiesceCount(TargetServerApplicationImpl targetServerApplicationImpl) {
        --this.quiesceCount;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "decrementQuiesceCount of " + this + " to " + this.quiesceCount + " by " + targetServerApplicationImpl);
        }
    }

    public TargetDescriptor selectTargetDescriptor(HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selectTargetDescriptor", httpRequestMessage);
        }
        TargetServerApplicationImpl targetServerApplicationImpl = (TargetServerApplicationImpl)this.select(httpRequestMessage, this.selector.getAllModules());
        TargetDescriptor targetDescriptor = null;
        if (targetServerApplicationImpl != null) {
            targetDescriptor = targetServerApplicationImpl.getTargetDescriptor(httpRequestMessage.getScheme());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selectTargetDescriptor", targetDescriptor);
        }
        return targetDescriptor;
    }

    public TargetDescriptor selectTargetDescriptor(HttpRequestMessage httpRequestMessage, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selectTargetDescriptor", new Object[]{httpRequestMessage, string});
        }
        TargetServerApplicationImpl targetServerApplicationImpl = (TargetServerApplicationImpl)this.select(httpRequestMessage, this.selector.getAllModules());
        TargetDescriptor targetDescriptor = null;
        if (targetServerApplicationImpl != null) {
            targetDescriptor = targetServerApplicationImpl.getTargetDescriptor(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selectTargetDescriptor", targetDescriptor);
        }
        return targetDescriptor;
    }

    public TargetDescriptor affinitySelectTargetDescriptor(HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "affinitySelectTargetDescriptor", httpRequestMessage);
        }
        TargetServerApplicationImpl targetServerApplicationImpl = (TargetServerApplicationImpl)this.select(httpRequestMessage, this.selector.getAffinityModules());
        TargetDescriptor targetDescriptor = null;
        if (targetServerApplicationImpl != null) {
            targetDescriptor = targetServerApplicationImpl.getTargetDescriptor(httpRequestMessage.getScheme());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "affinitySelectTargetDescriptor", targetDescriptor);
        }
        return targetDescriptor;
    }

    public TargetDescriptor balanceSelectTargetDescriptor(HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "balanceSelectTargetDescriptor", httpRequestMessage);
        }
        TargetServerApplicationImpl targetServerApplicationImpl = (TargetServerApplicationImpl)this.select(httpRequestMessage, this.selector.getLoadBalancerModule());
        TargetDescriptor targetDescriptor = null;
        if (targetServerApplicationImpl != null) {
            targetDescriptor = targetServerApplicationImpl.getTargetDescriptor(httpRequestMessage.getScheme());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "balanceSelectTargetDescriptor", targetDescriptor);
        }
        return targetDescriptor;
    }

    protected TargetServerApplication select(HttpRequestMessage httpRequestMessage, HttpTargetSelectorModule[] httpTargetSelectorModuleArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{this, httpRequestMessage, httpTargetSelectorModuleArray});
        }
        if (this.sapps.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "null");
            }
            return null;
        }
        RoutingDebugRequestContext routingDebugRequestContext = RoutingDebugRequestContextManager.getMatchRequestContext(httpRequestMessage);
        for (int i = 0; i < httpTargetSelectorModuleArray.length; ++i) {
            TargetServerApplication targetServerApplication;
            HttpTargetSelectorModule httpTargetSelectorModule = httpTargetSelectorModuleArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module: " + httpTargetSelectorModule.getName());
            }
            if ((targetServerApplication = (TargetServerApplication)((Object)httpTargetSelectorModule.select(this, httpRequestMessage))) == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", targetServerApplication);
            }
            if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                routingDebugRequestContext.getMessage().append(this.getDebugInfo((TargetServerApplicationImpl)targetServerApplication, httpTargetSelectorModule.getName()));
            }
            return targetServerApplication;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", "no server selected");
        }
        return null;
    }

    private String getDebugInfo(TargetServerApplicationImpl targetServerApplicationImpl, String string) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        if (targetServerApplicationImpl.isAvailable()) {
            stringBuffer.append("Available Server: ").append(targetServerApplicationImpl.getName()).append("\n");
            stringBuffer.append("Server Weight   : ").append(targetServerApplicationImpl.getWeight()).append("\n");
            stringBuffer.append("Selection Method: ").append(string).append("\n");
            stringBuffer.append("isQuiescing     : ").append(targetServerApplicationImpl.isQuiescing()).append("\n");
        }
        return stringBuffer.toString();
    }
}

