/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.LoadBalancerModule;
import com.ibm.ws.dwlm.client.RoutingDebugRequestContextManager;
import com.ibm.ws.dwlm.client.TargetClusterImpl;
import com.ibm.ws.dwlm.client.TargetServerApplicationImpl;
import com.ibm.ws.dwlm.client.TargetServerImpl;
import com.ibm.ws.dwlm.client.Util;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.util.ApplicationQuiescer;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.dwlm.client.HttpTargetSelectorModule;
import com.ibm.wsspi.dwlm.client.ProtocolMap;
import com.ibm.wsspi.dwlm.client.RoutingDebugRequestContext;
import com.ibm.wsspi.dwlm.client.TargetCluster;
import com.ibm.wsspi.dwlm.client.TargetDescriptor;
import com.ibm.wsspi.dwlm.client.TargetSelector;
import com.ibm.wsspi.dwlm.client.TargetServer;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventEdgeChange;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCListener;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.Properties;

public class TargetSelectorImpl
implements TargetSelector,
ODCListener {
    protected static final TraceComponent tc = Tr.register(TargetSelectorImpl.class, "DWLMClient", "com.ibm.ws.dwlm.client.nls.Messages");
    protected static final String CLUSTER = "cluster";
    protected static final String SERVER = "server";
    protected static final String SERVER_APP = "serverApplication";
    protected final Properties outboundSSLProps;
    protected final ChannelFramework channelFramework;
    protected final ODCHelper odc;
    protected boolean started;
    protected ODCNode proxyContainer;
    protected ODCEdgeType server2WebModule;
    protected ODCEdgeType server2Transport;
    protected ODCEdgeType transport2ChannelChain;
    protected ODCEdgeType server2ServerApp;
    protected ODCTree targetTree = null;
    protected ODCEventType[] interestEvents;
    protected HttpTargetSelectorModule[] affinityModules = new HttpTargetSelectorModule[0];
    protected HttpTargetSelectorModule[] balancerModule = new HttpTargetSelectorModule[0];
    protected HttpTargetSelectorModule[] allModules = new HttpTargetSelectorModule[0];
    protected boolean sslOnload = false;
    protected boolean sslOffload = false;

    public TargetSelectorImpl(ODCTree oDCTree, Properties properties, ChannelFramework channelFramework) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.targetTree = oDCTree;
        this.outboundSSLProps = properties;
        this.channelFramework = channelFramework;
        this.odc = ODCHelper.getInstance();
        this.started = false;
        if (oDCTree == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "constructor", "disabled");
            }
            return;
        }
        this.proxyContainer = TargetTree.getMyProxyContainer();
        this.server2WebModule = this.odc.mgr.findEdgeType(this.odc.server, this.odc.webModule);
        this.server2Transport = this.odc.mgr.findEdgeType(this.odc.server, this.odc.transport);
        this.transport2ChannelChain = this.odc.mgr.findEdgeType(this.odc.transport, this.odc.channelChain);
        this.server2ServerApp = this.odc.mgr.findEdgeType(this.odc.server, this.odc.serverApplication);
        this.interestEvents = new ODCEventType[]{this.odc.serverWeight, this.odc.transportHost, this.odc.transportPort, this.odc.serverApplicationState, this.odc.transportIsActive, this.server2WebModule, this.server2Transport, this.transport2ChannelChain, this.server2ServerApp};
        ODCNode oDCNode = oDCTree.getRoot();
        Properties properties2 = oDCNode.getTransientProperties();
        Object object = properties2.get("ssl.offload");
        if (object != null) {
            this.sslOffload = (Boolean)object;
        }
        if ((object = properties2.get("ssl.onload")) != null) {
            this.sslOnload = (Boolean)object;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ssloffload=" + this.sslOffload + ", sslonload=" + this.sslOnload);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "already started");
            }
            return;
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "disabled");
            }
            return;
        }
        this.loadHttpTargetSelectorModules(string);
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            this.targetTree.addListener(this);
            this.initWLM();
        }
        this.started = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public synchronized void stop() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (!this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stop", "not started");
            }
            return;
        }
        this.targetTree.removeListener(this);
        this.started = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public HttpTargetSelectorModule[] getAffinityModules() {
        return this.affinityModules;
    }

    public HttpTargetSelectorModule[] getLoadBalancerModule() {
        return this.balancerModule;
    }

    public HttpTargetSelectorModule[] getAllModules() {
        return this.allModules;
    }

    protected void loadHttpTargetSelectorModules(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadHttpTargetSelectorModules", string);
        }
        String[] stringArray = string.split(",");
        ArrayList<HttpTargetSelectorModule> arrayList = new ArrayList<HttpTargetSelectorModule>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loading " + stringArray[i]);
            }
            try {
                HttpTargetSelectorModule httpTargetSelectorModule = (HttpTargetSelectorModule)Util.loadClass(stringArray[i]).newInstance();
                httpTargetSelectorModule.registrationIndex = i;
                arrayList.add(httpTargetSelectorModule);
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "class load failure: " + throwable);
            }
        }
        this.affinityModules = arrayList.toArray(new HttpTargetSelectorModule[0]);
        HttpTargetSelectorModule httpTargetSelectorModule = this.createLoadBalancerModule();
        httpTargetSelectorModule.registrationIndex = stringArray.length;
        this.balancerModule = new HttpTargetSelectorModule[]{httpTargetSelectorModule};
        arrayList.add(httpTargetSelectorModule);
        this.allModules = arrayList.toArray(new HttpTargetSelectorModule[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadHttpTargetSelectorModules");
        }
    }

    protected HttpTargetSelectorModule createLoadBalancerModule() {
        return new LoadBalancerModule();
    }

    public boolean isEnabled() {
        return this.targetTree != null;
    }

    protected TargetDescriptor select(ODCNode oDCNode, HttpRequestMessage httpRequestMessage, HttpTargetSelectorModule[] httpTargetSelectorModuleArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{oDCNode, httpRequestMessage, httpTargetSelectorModuleArray});
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "disabled");
            }
            return null;
        }
        ODCNode oDCNode2 = Util.uriToWebModule(this.targetTree, oDCNode);
        if (oDCNode2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "no webModule");
            }
            return null;
        }
        RoutingDebugRequestContext routingDebugRequestContext = RoutingDebugRequestContextManager.getMatchRequestContext(httpRequestMessage);
        TargetCluster targetCluster = this.getCluster(oDCNode2);
        String string = this.getProtocolMap(oDCNode2).mapProtocol(httpRequestMessage.getScheme());
        for (int i = 0; i < httpTargetSelectorModuleArray.length; ++i) {
            TargetServer targetServer;
            HttpTargetSelectorModule httpTargetSelectorModule = httpTargetSelectorModuleArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module: " + httpTargetSelectorModule.getName());
            }
            if ((targetServer = httpTargetSelectorModule.select(targetCluster, httpRequestMessage)) == null) continue;
            TargetDescriptor targetDescriptor = targetServer.getTargetDescriptor(string);
            if (targetDescriptor == null) {
                Tr.warning(tc, "DWCT_NoProtocolFound", new Object[]{targetServer.getName(), string});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "select", "no endpoint for protocol");
                }
                if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                    routingDebugRequestContext.getMessage().append("no endpoint for protocol").append("\n");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", targetDescriptor);
            }
            if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                routingDebugRequestContext.getMessage().append(targetDescriptor.getDebugInfo());
            }
            return targetDescriptor;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", "no server selected");
        }
        if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
            routingDebugRequestContext.getMessage().append("no server selected").append("\n");
        }
        return null;
    }

    protected TargetDescriptor select(ODCNode oDCNode, HttpRequestMessage httpRequestMessage, HttpTargetSelectorModule[] httpTargetSelectorModuleArray, ODCNode oDCNode2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{oDCNode, httpRequestMessage, httpTargetSelectorModuleArray});
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "disabled");
            }
            return null;
        }
        if (oDCNode2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", "no webModule");
            }
            return null;
        }
        RoutingDebugRequestContext routingDebugRequestContext = RoutingDebugRequestContextManager.getMatchRequestContext(httpRequestMessage);
        TargetCluster targetCluster = this.getCluster(oDCNode2);
        String string = this.getProtocolMap(oDCNode2).mapProtocol(httpRequestMessage.getScheme());
        for (int i = 0; i < httpTargetSelectorModuleArray.length; ++i) {
            TargetServer targetServer;
            HttpTargetSelectorModule httpTargetSelectorModule = httpTargetSelectorModuleArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module: " + httpTargetSelectorModule.getName());
            }
            if ((targetServer = httpTargetSelectorModule.select(targetCluster, httpRequestMessage)) == null) continue;
            TargetDescriptor targetDescriptor = targetServer.getTargetDescriptor(string);
            if (targetDescriptor == null) {
                Tr.warning(tc, "DWCT_NoProtocolFound", new Object[]{targetServer.getName(), string});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "select", "no endpoint for protocol");
                }
                if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                    routingDebugRequestContext.getMessage().append("no endpoint for protocol").append("\n");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "select", targetDescriptor);
            }
            if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
                routingDebugRequestContext.getMessage().append(targetDescriptor.getDebugInfo());
            }
            return targetDescriptor;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", "no server selected");
        }
        if (routingDebugRequestContext != null && (routingDebugRequestContext.getDebugLevel() == 1 || routingDebugRequestContext.getDebugLevel() == 2)) {
            routingDebugRequestContext.getMessage().append("no endpoint for protocol").append("\n");
        }
        return null;
    }

    public ODCEventType[] interestEventTypes() {
        return this.interestEvents;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(ODCEvent oDCEvent) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleEvent", oDCEvent);
        }
        ODCEventType oDCEventType = oDCEvent.getEventType();
        if (oDCEvent instanceof ODCEventEdgeChange) {
            ODCEventEdgeChange oDCEventEdgeChange = (ODCEventEdgeChange)oDCEvent;
            if (oDCEventType == this.server2WebModule) {
                TargetServer targetServer = this.getServer(oDCEventEdgeChange.getSrcNode());
                TargetCluster targetCluster = this.getCluster(oDCEventEdgeChange.getDstNode());
                if (oDCEventEdgeChange.isAdd()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "webmodule " + targetCluster + " started running on server " + targetServer);
                    }
                    this.addServerToCluster(targetServer, targetCluster);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "webmodule " + targetCluster + " stopped running on server " + targetServer);
                    }
                    this.removeServerFromCluster(targetServer, targetCluster);
                }
            } else if (oDCEventType == this.server2Transport) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server2Transport event");
                }
                this.rebuildTargetDescriptors(oDCEventEdgeChange.getSrcNode());
            } else if (oDCEventType == this.transport2ChannelChain) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "transport2ChannelChain event");
                }
                this.rebuildTargetDescriptors(oDCEventEdgeChange.getSrcNode().getParent());
            } else {
                if (oDCEventType != this.server2ServerApp) throw new ODCException("unhandled edge change event: " + oDCEvent);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server2ServerApp event");
                }
                ODCNode oDCNode = oDCEventEdgeChange.getSrcNode();
                ODCNode oDCNode2 = oDCEventEdgeChange.getDstNode();
                TargetServerImpl targetServerImpl = (TargetServerImpl)this.getServer(oDCNode);
                if (oDCEventEdgeChange.isAdd()) {
                    this.getServerApp(oDCNode2, true);
                    if (this.proxyContainer != null) {
                        this.proxyContainer.addNode(oDCNode2);
                    }
                } else {
                    TargetServerApplicationImpl targetServerApplicationImpl = this.getServerApp(oDCNode2, false);
                    if (targetServerApplicationImpl != null) {
                        targetServerImpl.removeServerApplication(targetServerApplicationImpl);
                    }
                }
            }
        } else {
            ODCEventSetProperty oDCEventSetProperty;
            ODCPropertyDescriptor oDCPropertyDescriptor;
            if (!(oDCEvent instanceof ODCEventSetProperty)) throw new ODCException("unknown type of event: " + oDCEvent);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setProperty event");
            }
            if ((oDCPropertyDescriptor = (oDCEventSetProperty = (ODCEventSetProperty)oDCEvent).getPropertyDescriptor()) == this.odc.serverWeight) {
                this.setServerWeight(oDCEventSetProperty);
            } else if (oDCPropertyDescriptor == this.odc.transportHost || oDCPropertyDescriptor == this.odc.transportPort || oDCPropertyDescriptor == this.odc.transportIsActive) {
                this.rebuildTargetDescriptors(oDCEventSetProperty.getNode().getNode(this.odc.server));
            } else {
                if (oDCPropertyDescriptor != this.odc.serverApplicationState) throw new ODCException("unhandled property change event: " + oDCEvent);
                ODCNode oDCNode = oDCEventSetProperty.getNode();
                String string = (String)oDCEventSetProperty.getNewValue();
                TargetServerApplicationImpl targetServerApplicationImpl = this.getServerApp(oDCNode, true);
                if (ApplicationQuiescer.isQuiesceState(string)) {
                    targetServerApplicationImpl.beginQuiescing();
                } else {
                    targetServerApplicationImpl.endQuiescing();
                }
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "handleEvent");
    }

    public void addServerToCluster(TargetServer targetServer, TargetCluster targetCluster) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServerToCluster", new Object[]{targetServer, targetCluster});
        }
        if (targetServer.getWeight() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addServerToCluster", "zero weight");
            }
            return;
        }
        if (this.serverHasNoTransports(targetServer)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addServerToCluster", "no transports");
            }
            return;
        }
        ODCNode oDCNode = this.getServerAppNode(targetServer, targetCluster);
        if (oDCNode == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addServerToCluster", "no server application found for cluster " + targetCluster + " on server " + targetServer);
            }
            return;
        }
        TargetServerApplicationImpl targetServerApplicationImpl = this.getServerApp(oDCNode, true);
        if (((TargetClusterImpl)targetCluster).getSappList().contains(targetServerApplicationImpl)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addServerToCluster", "already a member");
            }
            return;
        }
        targetCluster.addServer(targetServerApplicationImpl);
        for (int i = 0; i < this.allModules.length; ++i) {
            this.allModules[i].serverAddedToCluster(targetCluster, targetServerApplicationImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServerToCluster", "ok");
        }
    }

    public void removeServerFromCluster(TargetServer targetServer, TargetCluster targetCluster) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeServerFromCluster", new Object[]{targetServer, targetCluster});
        }
        if (targetServer instanceof TargetServerImpl) {
            ODCNode oDCNode = this.getServerAppNode(targetServer, targetCluster);
            if (oDCNode == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeServerFromCluster", "no server application found for cluster " + targetCluster + " on server " + targetServer);
                }
                return;
            }
            targetServer = this.getServerApp(oDCNode, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverApp=" + targetServer);
            }
        }
        targetCluster.removeServer(targetServer);
        for (int i = 0; i < this.allModules.length; ++i) {
            this.allModules[i].serverRemovedFromCluster(targetCluster, targetServer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServerFromCluster", new Object[]{targetServer, targetCluster});
        }
    }

    protected void initWLM() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initWLM");
        }
        ODCNode oDCNode = this.targetTree.getRoot();
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.cell);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checking cell " + oDCNodeArray[i]);
            }
            ODCNode[] oDCNodeArray2 = oDCNodeArray[i].getNodes(this.odc.application);
            for (int j = 0; j < oDCNodeArray2.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking application " + oDCNodeArray2[j]);
                }
                ODCNode[] oDCNodeArray3 = oDCNodeArray2[j].getNodes(this.odc.webModule);
                for (int k = 0; k < oDCNodeArray3.length; ++k) {
                    this.initModule(oDCNodeArray3[k]);
                }
            }
            if (this.proxyContainer == null) continue;
            ODCNode[] oDCNodeArray4 = oDCNodeArray[i].getNodes(this.odc.node);
            for (int j = 0; j < oDCNodeArray4.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "checking node " + oDCNodeArray4[j]);
                }
                ODCNode[] oDCNodeArray5 = oDCNodeArray4[j].getNodes(this.odc.server);
                for (int k = 0; k < oDCNodeArray5.length; ++k) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checking server " + oDCNodeArray5[k]);
                    }
                    ODCNode[] oDCNodeArray6 = oDCNodeArray5[k].getNodes(this.odc.serverApplication);
                    for (int i2 = 0; i2 < oDCNodeArray6.length; ++i2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding proxyContainer-to-serverApplication link from  " + this.proxyContainer + " to " + oDCNodeArray6[i2]);
                        }
                        this.proxyContainer.addNode(oDCNodeArray6[i2]);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initWLM");
        }
    }

    protected void initModule(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initModule", oDCNode);
        }
        TargetCluster targetCluster = this.getCluster(oDCNode);
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.server);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            this.getServer(oDCNodeArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initModule");
        }
    }

    protected void rebuildTargetDescriptors(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rebuildTargetDescriptors", oDCNode);
        }
        TargetServerImpl targetServerImpl = (TargetServerImpl)this.getServer(oDCNode);
        targetServerImpl.buildTargetDescriptors();
        targetServerImpl.addToAllClusters();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rebuildTargetDescriptors", oDCNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetServer getServer(ODCNode oDCNode) throws Exception {
        Properties properties;
        TargetServerImpl targetServerImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServer", oDCNode);
        }
        if ((targetServerImpl = (TargetServerImpl)(properties = oDCNode.getTransientProperties()).get(SERVER)) == null) {
            ODCTree oDCTree = this.targetTree;
            synchronized (oDCTree) {
                targetServerImpl = (TargetServerImpl)properties.get(SERVER);
                if (targetServerImpl == null) {
                    int n;
                    targetServerImpl = this.createTargetServer(oDCNode, this.outboundSSLProps, this.channelFramework);
                    properties.put(SERVER, targetServerImpl);
                    targetServerImpl.init();
                    ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.serverApplication);
                    for (n = 0; n < oDCNodeArray.length; ++n) {
                        this.getServerApp(oDCNodeArray[n], true);
                    }
                    for (n = 0; n < this.allModules.length; ++n) {
                        this.allModules[n].serverInitialize(targetServerImpl);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "target server created");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServer", targetServerImpl);
        }
        return targetServerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetServerApplicationImpl getServerApp(ODCNode oDCNode, boolean bl) throws Exception {
        Properties properties;
        TargetServerApplicationImpl targetServerApplicationImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerApp", new Object[]{oDCNode, new Boolean(bl)});
        }
        if ((targetServerApplicationImpl = (TargetServerApplicationImpl)(properties = oDCNode.getTransientProperties()).get(SERVER_APP)) == null && bl) {
            ODCTree oDCTree = this.targetTree;
            synchronized (oDCTree) {
                targetServerApplicationImpl = (TargetServerApplicationImpl)properties.get(SERVER_APP);
                if (targetServerApplicationImpl == null) {
                    ODCNode oDCNode2 = oDCNode.getNode(this.odc.server);
                    TargetServerImpl targetServerImpl = (TargetServerImpl)this.getServer(oDCNode2);
                    targetServerApplicationImpl = this.createTargetServerApplication(targetServerImpl, oDCNode);
                    properties.put(SERVER_APP, targetServerApplicationImpl);
                    targetServerImpl.addServerApplication(targetServerApplicationImpl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "target server application created");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerApp", targetServerApplicationImpl);
        }
        return targetServerApplicationImpl;
    }

    protected void setServerWeight(ODCEventSetProperty oDCEventSetProperty) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServerWeight", oDCEventSetProperty);
        }
        TargetServerImpl targetServerImpl = (TargetServerImpl)this.getServer(oDCEventSetProperty.getNode());
        int n = targetServerImpl.getWeight();
        int n2 = this.getWeight(oDCEventSetProperty.getNewValue());
        targetServerImpl.setWeight(n2);
        TargetServerApplicationImpl[] targetServerApplicationImplArray = targetServerImpl.getServerApplications();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "begin module notification");
        }
        for (int i = 0; i < targetServerApplicationImplArray.length; ++i) {
            TargetServerApplicationImpl targetServerApplicationImpl = targetServerApplicationImplArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setting server weight for " + targetServerApplicationImpl);
            }
            for (int j = 0; j < this.allModules.length; ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "notifying " + this.allModules[j]);
                }
                this.allModules[j].serverWeightChanged(targetServerApplicationImpl, n, n2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServerWeight");
        }
    }

    protected int getWeight(Object object) {
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    protected ProtocolMap getProtocolMap(ODCNode oDCNode) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProtocolMap", oDCNode);
        }
        ProtocolMap protocolMap = (object = oDCNode.getProperty(this.odc.webModuleProtocolMap)) != null ? (ProtocolMap)object : (this.sslOffload ? ProtocolMap.SSL_OFFLOAD : (this.sslOnload ? ProtocolMap.SSL_ONLOAD : ProtocolMap.DIRECT));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProtocolMap", protocolMap);
        }
        return protocolMap;
    }

    protected TargetClusterImpl createTargetCluster(ODCNode oDCNode) throws Exception {
        String string = oDCNode.getParent().getParent().getName();
        String string2 = oDCNode.getParent().getName();
        String string3 = oDCNode.getName();
        String string4 = string + "/" + string2 + "/" + string3;
        return this.createTargetCluster(string4, oDCNode);
    }

    protected TargetClusterImpl createTargetCluster(String string, ODCNode oDCNode) throws Exception {
        return new TargetClusterImpl(string, oDCNode, this);
    }

    protected TargetServerImpl createTargetServer(ODCNode oDCNode, Properties properties, ChannelFramework channelFramework) throws Exception {
        return new TargetServerImpl(oDCNode, properties, this.channelFramework, this);
    }

    protected TargetServerApplicationImpl createTargetServerApplication(TargetServerImpl targetServerImpl, ODCNode oDCNode) throws Exception {
        return new TargetServerApplicationImpl(targetServerImpl, oDCNode, this);
    }

    public TargetDescriptor select(ODCNode oDCNode, HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "select", new Object[]{oDCNode, httpRequestMessage});
        }
        ODCNode oDCNode2 = Util.uriToWebModule(this.targetTree, oDCNode);
        TargetClusterImpl targetClusterImpl = (TargetClusterImpl)this.getTargetCluster(oDCNode2);
        TargetDescriptor targetDescriptor = null;
        if (targetClusterImpl != null) {
            targetDescriptor = targetClusterImpl.selectTargetDescriptor(httpRequestMessage, this.getProtocolMap(oDCNode2).mapProtocol(httpRequestMessage.getScheme()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "select", targetDescriptor);
        }
        return targetDescriptor;
    }

    public TargetDescriptor affinitySelect(ODCNode oDCNode, HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "affinitySelect", new Object[]{oDCNode, httpRequestMessage});
        }
        TargetClusterImpl targetClusterImpl = (TargetClusterImpl)this.getTargetCluster(oDCNode);
        TargetDescriptor targetDescriptor = null;
        if (targetClusterImpl != null) {
            targetDescriptor = targetClusterImpl.affinitySelectTargetDescriptor(httpRequestMessage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "affinitySelect", targetDescriptor);
        }
        return targetDescriptor;
    }

    public TargetDescriptor balanceSelect(ODCNode oDCNode, HttpRequestMessage httpRequestMessage) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "balanceSelect");
        }
        TargetClusterImpl targetClusterImpl = (TargetClusterImpl)this.getTargetCluster(oDCNode);
        TargetDescriptor targetDescriptor = null;
        if (targetClusterImpl != null) {
            targetDescriptor = targetClusterImpl.balanceSelectTargetDescriptor(httpRequestMessage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "balanceSelect");
        }
        return targetDescriptor;
    }

    public TargetCluster getTargetCluster(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargetCluster", oDCNode);
        }
        if (!this.isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTargetCluster", "disabled");
            }
            return null;
        }
        TargetCluster targetCluster = null;
        targetCluster = oDCNode.getType() == this.odc.uri ? this.getCluster(oDCNode.getParent()) : this.getCluster(oDCNode);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTargetCluster", targetCluster);
        }
        return targetCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetCluster getCluster(ODCNode oDCNode) throws Exception {
        Properties properties;
        TargetCluster targetCluster;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCluster", oDCNode);
        }
        if ((targetCluster = (TargetCluster)(properties = oDCNode.getTransientProperties()).get(CLUSTER)) == null) {
            ODCTree oDCTree = this.targetTree;
            synchronized (oDCTree) {
                targetCluster = (TargetCluster)properties.get(CLUSTER);
                if (targetCluster == null) {
                    ODCNode oDCNode2 = oDCNode.getParent();
                    ODCNode oDCNode3 = oDCNode2.getParent();
                    String string = oDCNode3.getName() + "/" + oDCNode2.getName() + "/" + oDCNode.getName();
                    targetCluster = this.createTargetCluster(oDCNode);
                    properties.put(CLUSTER, targetCluster);
                    for (int i = 0; i < this.allModules.length; ++i) {
                        this.allModules[i].clusterInitialize(targetCluster);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cluster created for " + oDCNode);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCluster", targetCluster);
        }
        return targetCluster;
    }

    protected ODCNode getServerAppNode(TargetServer targetServer, TargetCluster targetCluster) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerAppNode", new Object[]{targetServer, targetCluster});
        }
        TargetServerImpl targetServerImpl = (TargetServerImpl)targetServer;
        ODCNode oDCNode = ((TargetClusterImpl)targetCluster).getODCNode();
        String string = oDCNode.getParent().getName();
        ODCNode oDCNode2 = targetServerImpl.getMyODCNode();
        ODCNode oDCNode3 = oDCNode2.getNode(this.odc.serverApplication, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerAppNode", oDCNode3);
        }
        return oDCNode3;
    }

    protected boolean serverHasNoTransports(TargetServer targetServer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverHasNoTransports", targetServer);
        }
        boolean bl = ((TargetServerImpl)targetServer).hasNoDescriptors();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serverHasNoTransports", new Boolean(bl));
        }
        return bl;
    }
}

