/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.VHostMatcherImpl;
import com.ibm.wsspi.dwlm.client.URIMatcher;
import com.ibm.wsspi.dwlm.client.VHostMatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class URIMatcherImpl
implements URIMatcher {
    private static final TraceComponent tc = Tr.register(URIMatcherImpl.class, "DWLMClient", "com.ibm.ws.dwlm.client.nls.Messages");
    private static final boolean DEBUG = Boolean.getBoolean(System.getProperty("com.ibm.ws.dwlm.client.debug", "false"));
    public static final int STAR = 0;
    protected final String name;
    private static final TargetInfo[] EMPTY_TARGET_INFO_ARRAY = new TargetInfo[0];
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    private static final Suffix[] EMPTY_SUFFIX_ARRAY = new Suffix[0];
    protected final Node root;

    public URIMatcherImpl(String string) {
        this.name = string;
        this.root = new Node("");
    }

    public Object put(String string, Object object) throws Exception {
        Object object2 = this.put(string, null, object);
        return object2;
    }

    public Object put(String string, VHostMatcher vHostMatcher, Object object) throws Exception {
        boolean bl;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "put", new Object[]{string, vHostMatcher, object});
        }
        Object object2 = null;
        Object object3 = null;
        Object var6_6 = null;
        String string2 = null;
        String string3 = null;
        if (string.length() != 0 && !string.startsWith("/")) {
            string = "/" + string;
        }
        if ((n = string.indexOf("*")) < 0) {
            object2 = object;
            string2 = string;
        } else if (n == string.length() - 1) {
            if (string.endsWith("/*")) {
                this.put(string.substring(0, string.length() - 2), vHostMatcher, object);
            }
            string2 = string.substring(0, n);
            object3 = object;
        } else if (string.charAt(n + 1) == '.') {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            if (!string2.endsWith("/") && string2.lastIndexOf("/") == 0) {
                string2 = string2 + "/";
                string = string2 + string3;
            }
        }
        if (DEBUG) {
            System.out.println("prefix=" + string2);
        }
        Node node = this.root;
        int n2 = 0;
        do {
            bl = false;
            for (int i = 0; i < node.children.length; ++i) {
                Node node2 = node.children[i];
                int n3 = node2.getMatchLen(string2, n2);
                if (DEBUG) {
                    System.out.println(string2 + ":" + n2 + ",matchTo:" + node2.name + ",matchLen=" + n3);
                }
                if (n3 <= 0) continue;
                if (n3 < node2.chars.length) {
                    node.removeChild(node2);
                    String string4 = string.substring(n2, n2 + n3);
                    Node node3 = this.cloneNode(node, string4);
                    node.addChild(node3);
                    node = node3;
                    String string5 = node2.name.substring(n3);
                    node2.setName(string5);
                    node3.addChild(node2);
                    if (DEBUG) {
                        System.out.println("newParent=" + string4 + ", newChild=" + string5);
                    }
                } else {
                    node = node2;
                    bl = true;
                    if (DEBUG) {
                        System.out.println("search deeper " + node);
                    }
                }
                n2 += n3;
            }
        } while (bl);
        if (DEBUG) {
            System.out.println("matched node = " + node);
        }
        if (n2 < string2.length()) {
            Node node4 = new Node(string2.substring(n2));
            if (object2 != null) {
                node4.exactTargetList.addTarget(new TargetInfo(vHostMatcher, object2));
            } else if (object3 != null) {
                node4.prefixTargetList.addTarget(new TargetInfo(vHostMatcher, object3));
            }
            node.addChild(node4);
            node = node4;
            if (DEBUG) {
                System.out.println("add new child = " + node4);
            }
        }
        TargetInfo targetInfo = new TargetInfo(vHostMatcher, object);
        if (string3 != null) {
            if (DEBUG) {
                System.out.println("add extension");
            }
            node.addSuffix(string3, targetInfo);
        } else if (object2 != null) {
            if (DEBUG) {
                System.out.println("exact target=" + object + " for " + node);
            }
            this.putExactTarget(node, targetInfo);
        } else if (object3 != null) {
            if (DEBUG) {
                System.out.println("longest_path target=" + object + " for " + node);
            }
            this.putPrefixTarget(node, targetInfo);
        } else {
            throw new IllegalStateException("neither exact, longest_path, nor extension");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "put", string);
        }
        return null;
    }

    protected Node cloneNode(Node node, String string) {
        Node node2 = new Node(string);
        node2.exactTargetList.addTargetInfoList(node.exactTargetList);
        node2.prefixTargetList.addTargetInfoList(node.prefixTargetList);
        return node2;
    }

    public Object match(String string, int n, String string2) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "URIMatcherImpl.match", string2);
        }
        int n2 = 0;
        Node[] nodeArray = this.root.children;
        Object object = null;
        Object object2 = null;
        int n3 = string2.length();
        int n4 = n2;
        block0: do {
            bl = false;
            for (int i = 0; i < nodeArray.length; ++i) {
                Object object3;
                Node node = nodeArray[i];
                int n5 = node.getMatchLen(string2, n2);
                if (n5 > n4) {
                    n4 = n5;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "child=" + node + ", matched=" + n5 + ", tomatch=" + node.chars.length);
                }
                if (n5 <= 0) continue;
                if (n5 != node.chars.length) continue block0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matched " + node);
                }
                bl = true;
                if ((n2 += n5) >= n3 && (object3 = node.exactTargetList.getTarget(string, n)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "match", "exact match of " + object3);
                    }
                    return object3;
                }
                if (n4 <= n3 && (object3 = node.prefixTargetList.getTarget(string, n)) != null) {
                    object = object3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "longestPathTarget=" + object);
                    }
                }
                if ((object3 = node.suffixes) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "checking extensions");
                    }
                    for (int j = 0; j < ((Suffix[])object3).length; ++j) {
                        Suffix suffix = object3[j];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "extension=" + suffix);
                        }
                        if (!string2.endsWith(suffix.suffix) || (object2 = suffix.targetList.getTarget(string, n)) == null) continue;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "extension match for " + object2);
                        break;
                    }
                }
                nodeArray = node.children;
                continue block0;
            }
        } while (bl);
        if (object != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "match", "longest_path match of " + object);
            }
            return object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "match", "extension match of " + object2);
        }
        return object2;
    }

    protected void putExactTarget(Node node, TargetInfo targetInfo) throws Exception {
        node.exactTargetList.addTarget(targetInfo);
    }

    protected void putPrefixTarget(Node node, TargetInfo targetInfo) throws Exception {
        node.prefixTargetList.addTarget(targetInfo);
    }

    protected void putSuffixTarget(Suffix suffix, TargetInfo targetInfo) throws Exception {
        suffix.targetList.addTarget(targetInfo);
    }

    public String toString() {
        if (DEBUG) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("BEGIN URIMatcher: ").append(this.name).append(",id=").append(this.hashCode()).append("\n");
            this.toString(this.root, "", stringBuffer);
            stringBuffer.append("END URIMatcher: ").append(this.name);
            return stringBuffer.toString();
        }
        return this.name;
    }

    private void toString(Node node, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string).append(node.toString()).append("\n");
        string = string + "   ";
        for (int i = 0; i < node.children.length; ++i) {
            this.toString(node.children[i], string, stringBuffer);
        }
    }

    public Object match(String string) {
        return this.match(null, -1, string);
    }

    public static void main(String[] stringArray) throws Exception {
        URIMatcherImpl uRIMatcherImpl = new URIMatcherImpl("test");
        String[] stringArray2 = new String[]{"/trade/*", "/trade/*.jsp", "/trade/servlet/PingServlet", "/trade/servlet/PingServlet2Jsp", "/*.jsp", "/StockQuote", "/foo/bar/*", "/A/*", "/trade/servlet/SnoopServlet", "/trade/servlet/*", "/foo/bar/*", "/baz/*", "/catalog", "*.bop"};
        for (int i = 0; i < stringArray2.length; ++i) {
            uRIMatcherImpl.put(stringArray2[i], null, stringArray2[i]);
        }
        System.out.println(uRIMatcherImpl);
        String[] stringArray3 = new String[]{"/", "/foo/bar/index.html", "/StockQuote", "/index.jsp", "/foo/bar/index.jsp", "/A/ping.html", "/trade/servlet/PingServlet", "/trade/servlet/FooServlet", "/trade", "/trade/servlet/SnoopServlet", "/trade/foobar", "/foo/bar/index.html", "/foo/bar/index.bop", "/baz", "/baz/index.html", "/catalog", "/catalog/index.html", "/catalog/racecar.bop", "/index.bop"};
        for (int i = 0; i < stringArray3.length; ++i) {
            System.out.println(stringArray3[i] + " matches " + uRIMatcherImpl.match(stringArray3[i]));
        }
    }

    protected class TargetInfo {
        public VHostMatcher vhostMatcher;
        public Object object;

        public TargetInfo(VHostMatcher vHostMatcher, Object object) {
            this.vhostMatcher = vHostMatcher;
            this.object = object;
        }

        public boolean match(String string, int n) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "match() host is " + string + ", port is " + n + ", vhostMatcher is " + this.vhostMatcher + ", object is " + this.object);
            }
            if (this.vhostMatcher == null) {
                return true;
            }
            return ((VHostMatcherImpl)this.vhostMatcher).match(string, n);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TargetInfo:").append("vhostMatcher=").append(this.vhostMatcher == null ? "Null" : this.vhostMatcher.toString()).append(",Object=").append(this.object.toString());
            return stringBuffer.toString();
        }
    }

    protected class TargetInfoList {
        protected final Set targetList = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                if (((TargetInfo)object).toString().equalsIgnoreCase(((TargetInfo)object2).toString())) {
                    return 0;
                }
                return 1;
            }
        });
        private TargetInfo[] targets = new TargetInfo[0];

        public void addTarget(TargetInfo targetInfo) {
            this.targetList.add(targetInfo);
            this.targets = this.targetList.toArray(EMPTY_TARGET_INFO_ARRAY);
        }

        public void addTargetInfoList(TargetInfoList targetInfoList) {
            this.targetList.addAll(targetInfoList.targetList);
            this.targets = this.targetList.toArray(EMPTY_TARGET_INFO_ARRAY);
        }

        public Object getTarget(String string, int n) {
            for (int i = 0; i < this.targets.length; ++i) {
                TargetInfo targetInfo = this.targets[i];
                if (!targetInfo.match(string, n)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getTarget() returning " + targetInfo.object);
                }
                return targetInfo.object;
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TargetInfoList:");
            for (int i = 0; i < this.targets.length; ++i) {
                stringBuffer.append("targets[").append(i).append("]=").append(this.targets[i].toString());
            }
            return stringBuffer.toString();
        }
    }

    protected class Suffix {
        public final Node node;
        public final String suffix;
        public final TargetInfoList targetList;

        public Suffix(Node node, String string) {
            this.targetList = new TargetInfoList();
            this.node = node;
            this.suffix = string;
        }

        public String toString() {
            return this.suffix;
        }
    }

    protected class Node {
        public String name;
        public char[] chars;
        public final TargetInfoList exactTargetList;
        public final TargetInfoList prefixTargetList;
        public Node[] children;
        private final List childList;
        public Suffix[] suffixes;
        private final List suffixList;

        public Node(String string) {
            this.exactTargetList = new TargetInfoList();
            this.prefixTargetList = new TargetInfoList();
            this.children = EMPTY_NODE_ARRAY;
            this.childList = new ArrayList();
            this.suffixes = null;
            this.suffixList = new ArrayList();
            this.setName(string);
        }

        public void setName(String string) {
            this.name = string;
            this.chars = string.toCharArray();
        }

        public void addExactTarget(TargetInfo targetInfo) {
            this.exactTargetList.addTarget(targetInfo);
        }

        public void addPrefixTarget(TargetInfo targetInfo) {
            this.prefixTargetList.addTarget(targetInfo);
        }

        public int getMatchLen(String string, int n) {
            int n2 = string.length();
            for (int i = 0; i < this.chars.length; ++i) {
                char c;
                if (n >= n2) {
                    return i;
                }
                if ((c = string.charAt(n++)) == this.chars[i]) continue;
                return i;
            }
            return this.chars.length;
        }

        public void addChild(Node node) {
            if (DEBUG) {
                System.out.println("add child " + node + " to " + this);
            }
            this.childList.add(node);
            this.children = this.childList.toArray(EMPTY_NODE_ARRAY);
        }

        public void removeChild(Node node) {
            this.childList.remove(node);
            this.children = this.childList.toArray(EMPTY_NODE_ARRAY);
        }

        public synchronized void addSuffix(String string, Object object) throws Exception {
            Suffix suffix = null;
            boolean bl = true;
            if (this.suffixes != null) {
                for (int i = 0; i < this.suffixes.length; ++i) {
                    if (!this.suffixes[i].equals(string)) continue;
                    suffix = this.suffixes[i];
                    bl = false;
                }
            }
            if (suffix == null) {
                suffix = new Suffix(this, string);
            }
            URIMatcherImpl.this.putSuffixTarget(suffix, (TargetInfo)object);
            if (bl) {
                if (this.isAbsent(this.suffixList, suffix)) {
                    this.suffixList.add(suffix);
                }
                this.suffixes = this.suffixList.toArray(EMPTY_SUFFIX_ARRAY);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name).append(",exact=").append(this.exactTargetList).append(",prefix=").append(this.prefixTargetList).append(",suffixes=(");
            if (this.suffixes != null) {
                for (int i = 0; i < this.suffixes.length; ++i) {
                    stringBuffer.append(this.suffixes[i]);
                    if (i >= this.suffixes.length - 1) continue;
                    stringBuffer.append(",");
                }
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        private boolean isAbsent(List list, Suffix suffix) {
            if (list == null) {
                return true;
            }
            for (int i = 0; i < list.size(); ++i) {
                Suffix suffix2 = (Suffix)list.get(i);
                if (!suffix2.toString().equals(suffix.toString())) continue;
                return false;
            }
            return true;
        }
    }
}

