/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dwlm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dwlm.client.RoutingDebugRequestContextManager;
import com.ibm.ws.dwlm.client.URIMatcherImpl;
import com.ibm.wsspi.dwlm.client.RoutingDebugRequestContext;
import com.ibm.wsspi.dwlm.client.VHostMatcher;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;

public class VHostMatcherImpl
implements VHostMatcher {
    protected static final TraceComponent tc = Tr.register(VHostMatcherImpl.class, "DWLMClient", "com.ibm.ws.dwlm.client.nls.Messages");
    protected static final VHost[] EMPTY_VH_ARRAY = new VHost[0];
    protected static VHostMatcherImpl debugVHostMatcher = null;
    protected final LinkedList vhostList = new LinkedList();
    protected final HashMap vhMap = new HashMap();
    protected VHost[] vhostArray = EMPTY_VH_ARRAY;
    protected MyComparator comparator = new MyComparator();
    protected String name;

    public VHostMatcherImpl() {
        this.name = null;
    }

    public VHostMatcherImpl(String string) {
        this.name = string;
    }

    public VHost put(String string, int n) {
        return this.put(string, n, false);
    }

    public VHost put(String string, int n, boolean bl) {
        VHost vHost = new VHost(string, n, bl);
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "vhost," + vHost + ", added to vhMap");
            }
            this.vhMap.put(string.toLowerCase(), vHost);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "vhost with port=" + n + " added to portsArray");
            }
            this.vhostList.add(vHost);
        }
        this.vhostArray = this.vhostList.toArray(EMPTY_VH_ARRAY);
        Arrays.sort(this.vhostArray, this.comparator);
        return vHost;
    }

    public Object put(String string, int n, String string2, Object object) throws Exception {
        return this.getURIMatcher(string, n).put(string2, object);
    }

    public URIMatcherImpl getURIMatcher(String string, int n) {
        URIMatcherImpl uRIMatcherImpl = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getURIMatcher", new Object[]{string, new Integer(n)});
        }
        for (int i = 0; i < this.vhostArray.length; ++i) {
            VHost vHost = this.vhostArray[i];
            if (!vHost.equals(string, n)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getURIMatcher", "VHost already exists");
            }
            uRIMatcherImpl = vHost.uriMatcher;
            break;
        }
        if (uRIMatcherImpl == null) {
            VHost vHost = null;
            if (string != null && (vHost = (VHost)this.vhMap.get(string.toLowerCase())) != null) {
                uRIMatcherImpl = vHost.uriMatcher;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getURIMatcher", "VHost found in vhMap");
                }
            }
            if (uRIMatcherImpl == null) {
                vHost = this.put(string, n, true);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getURIMatcher", "New VHost created");
                }
                uRIMatcherImpl = vHost.uriMatcher;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUriMatcher rc=" + uRIMatcherImpl);
        }
        return uRIMatcherImpl;
    }

    public boolean match(String string, int n) {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "match", new Object[]{string, new Integer(n)});
        }
        for (n2 = 0; n2 < this.vhostArray.length; ++n2) {
            if (!this.vhostArray[n2].match(string, n)) continue;
            return true;
        }
        n2 = 0;
        if (string != null) {
            VHost vHost = (VHost)this.vhMap.get(string.toLowerCase());
            int n3 = n2 = vHost != null ? 1 : 0;
        }
        if (n2 != 0) {
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "match", "no match");
        }
        return false;
    }

    public Object match(String string, int n, String string2) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "match", new Object[]{string, new Integer(n), string2});
        }
        StringBuffer stringBuffer = new StringBuffer();
        RoutingDebugRequestContext routingDebugRequestContext = RoutingDebugRequestContextManager.getMatchRequestContext(string, n, string2);
        for (int i = 0; i < this.vhostArray.length; ++i) {
            object = this.vhostArray[i].match(string, n, string2, routingDebugRequestContext);
            if (object == null) continue;
            if (routingDebugRequestContext != null && routingDebugRequestContext.getDebugLevel() != 1) {
                stringBuffer.append("host=" + string).append(" port=" + n).append(" uri=" + string2).append("\n");
                RoutingDebugRequestContextManager.setMessage(routingDebugRequestContext, stringBuffer.toString());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "match", object);
            }
            return object;
        }
        if (string != null) {
            VHost vHost = (VHost)this.vhMap.get(string.toLowerCase());
            object = vHost.match(string, n, string2, routingDebugRequestContext);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "match", object);
            }
            return object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "match", null);
        }
        return null;
    }

    protected URIMatcherImpl createURIMatcher(String string) {
        return new URIMatcherImpl(string);
    }

    public static void setDebugURL(String string) throws Exception {
        debugVHostMatcher = new VHostMatcherImpl();
        URL uRL = new URL(string);
        URIMatcherImpl uRIMatcherImpl = debugVHostMatcher.getURIMatcher(uRL.getHost(), uRL.getPort());
        uRIMatcherImpl.put(uRL.getPath(), Boolean.TRUE);
    }

    public static void resetDebugVHostMatcher() {
        debugVHostMatcher = null;
    }

    public String toString() {
        return this.name;
    }

    protected class VHost {
        public final String host;
        public final int port;
        public final URIMatcherImpl uriMatcher;

        public VHost(String string, int n) {
            this(string, n, true);
        }

        public VHost(String string, int n, boolean bl) {
            this.host = string;
            this.port = n;
            this.uriMatcher = bl ? VHostMatcherImpl.this.createURIMatcher(string + ":" + n) : null;
        }

        public Object match(String string, int n, String string2) {
            boolean bl;
            boolean bl2 = bl = this.port == -1 || this.port == n;
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + ":" + n + " does not match " + this);
                }
                return null;
            }
            Object object = this.uriMatcher.match(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + ":" + n + "/" + string2 + " match result is " + object);
            }
            return object;
        }

        public boolean match(String string, int n) {
            boolean bl;
            boolean bl2 = bl = this.port == -1 || this.port == n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + ":" + n + " match result is " + bl);
            }
            return bl;
        }

        public Object match(String string, int n, String string2, RoutingDebugRequestContext routingDebugRequestContext) {
            boolean bl;
            boolean bl2 = bl = this.port == -1 || this.port == n;
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + ":" + n + " does not match " + this);
                }
                if (routingDebugRequestContext != null && routingDebugRequestContext.getDebugLevel() != 1) {
                    StringBuffer stringBuffer = new StringBuffer("\n");
                    stringBuffer.append(string + ":" + n + " does not match ").append(this.toString()).append("\n");
                    RoutingDebugRequestContextManager.setMessage(routingDebugRequestContext, stringBuffer.toString());
                }
                return null;
            }
            Object object = this.uriMatcher.match(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + ":" + n + "/" + string2 + " match result is " + object);
            }
            if (routingDebugRequestContext != null && routingDebugRequestContext.getDebugLevel() != 1) {
                StringBuffer stringBuffer = new StringBuffer("");
                stringBuffer.append(string + ":" + n + "/" + string2 + " match result is ").append(object.toString().substring(0, object.toString().indexOf(60))).append("\n");
                RoutingDebugRequestContextManager.setMessage(routingDebugRequestContext, stringBuffer.toString());
            }
            return object;
        }

        public boolean equals(String string, int n) {
            boolean bl = this.port == n;
            return bl;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }

    protected class MyComparator
    implements Comparator {
        protected MyComparator() {
        }

        public int compare(Object object, Object object2) {
            VHost vHost = (VHost)object;
            VHost vHost2 = (VHost)object2;
            if (vHost.port == vHost2.port) {
                return 0;
            }
            if (vHost.port < vHost2.port) {
                return -1;
            }
            return 1;
        }
    }
}

