/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.cache.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.PMTxInfo;
import com.ibm.ws.ejbpersistence.cache.CacheManager;
import com.ibm.ws.ejbpersistence.cache.DataCacheEntry;
import com.ibm.ws.ejbpersistence.cache.TransactionListenerImpl;
import com.ibm.ws.ejbpersistence.cache.impl.ClassScopedCache;
import com.ibm.ws.ejbpersistence.cache.impl.RemovedDataCacheEntry;
import com.ibm.ws.ejbpersistence.cache.impl.TransactionScopedCache;
import com.ibm.ws.ejbpersistence.cache.impl.TransactionScopedCachePool;
import com.ibm.ws.ejbpersistence.utilpm.BeanGenerationException;
import com.ibm.ws.ejbpersistence.utilpm.ErrorProcessingResultCollectionRow;
import com.ibm.ws.ejbpersistence.utilpm.InvalidAssociationNameException;
import com.ibm.ws.ejbpersistence.utilpm.PMExceptionHandler;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerException;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmcache.GetPolicy;
import com.ibm.ws.pmcache.PMMasterCache;
import com.ibm.ws.pmcache.PMTxCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CacheManagerImpl
implements CacheManager {
    private ClassScopedCache classScopedCache;
    private long lifetimeInCache = 0L;
    private int lifetimeInCacheUsage = 0;
    public static final int Off = 0;
    public static final int ElapsedTime = 1;
    public static final int ClockTime = 2;
    public static final int WeekTime = 3;
    private static TraceComponent mytc = PMLogger.registerTC(CacheManagerImpl.class);
    private int userSetQueryParmLength;

    public CacheManagerImpl() {
        String string = System.getProperty("com.ibm.ws.pm.pmcache.queryCacheLength");
        try {
            this.userSetQueryParmLength = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.userSetQueryParmLength = -1;
        }
    }

    public void cacheForeignKeys(DataCacheEntry dataCacheEntry, String[] stringArray, Object object, PMTxInfo pMTxInfo) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException {
        List list;
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "cacheForeignKeys(entry, completeAssociations, currentPrimaryKey, transaction), transaction=null means ClassScopedCache", new Object[]{dataCacheEntry, stringArray, object, pMTxInfo});
        }
        if (stringArray != null && (list = dataCacheEntry.getForeignKeys(stringArray)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                Tr.debug(mytc, "Found at least one 'complete' foreign key");
            }
            Object var6_6 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                var6_6 = list.get(i);
                if (var6_6 == null) continue;
                this.putAssociateOfObject(stringArray[i], var6_6, pMTxInfo, object);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "cacheForeignKeys(...)");
        }
    }

    public void clearEntryFromCache(Object object, PMTxInfo pMTxInfo) {
        TransactionScopedCache transactionScopedCache;
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "clearEntryFromCache(key, transaction)", new Object[]{object, pMTxInfo});
        }
        if ((transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, false)) != null) {
            transactionScopedCache.removeEntry(object);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "clearEntryFromCache()");
        }
    }

    public Set getAssociatedKeys(String string, Object object, PMTxInfo pMTxInfo) throws InvalidAssociationNameException {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getAssociatedKeys(roleName, foreignKey, transaction)", new Object[]{string, object, pMTxInfo});
        }
        Set set = null;
        TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, false);
        if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
            Tr.debug(mytc, "TransactionScopedCache is {0}", new Object[]{transactionScopedCache});
        }
        if (transactionScopedCache != null && (set = transactionScopedCache.getAssociationsCache().getAssociatesOfObject(string, object)) == null && this.classScopedCache != null) {
            set = this.classScopedCache.getAssociationsCache().getAssociatesOfObject(string, object);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getAssociatedKeys, returning assocSet", new Object[]{set});
        }
        return set;
    }

    public static List getCachesForTransaction(PMTxInfo pMTxInfo) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getCachesForTransaction(transaction)", new Object[]{pMTxInfo});
        }
        TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
        List list = transactionListenerImpl.getTransactionScopedCaches();
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getCachesForTransaction(), returning List of TransactionScopedCaches ");
        }
        return list;
    }

    public DataCacheEntry getEntry(Object object, PMTxInfo pMTxInfo, GetPolicy getPolicy) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getEntry(key, transaction)", new Object[]{object, pMTxInfo});
        }
        TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
        DataCacheEntry dataCacheEntry = transactionListenerImpl.currentCacheEntry;
        if (dataCacheEntry != null && dataCacheEntry.getCacheManager().equals(this) && object.equals(dataCacheEntry.key)) {
            transactionListenerImpl.currentCacheEntry = null;
        } else {
            TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, false);
            dataCacheEntry = transactionScopedCache != null ? transactionScopedCache.getEntry(object, true) : null;
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getEntry, returning entry", new Object[]{dataCacheEntry});
        }
        return dataCacheEntry;
    }

    public DataCacheEntry peekEntry(Object object, PMTxInfo pMTxInfo, boolean bl) {
        TransactionScopedCache transactionScopedCache;
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "peekEntry(key, transaction)", new Object[]{object, pMTxInfo});
        }
        TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
        DataCacheEntry dataCacheEntry = transactionListenerImpl.currentCacheEntry;
        if (!(dataCacheEntry != null && dataCacheEntry.getCacheManager().equals(this) && object.equals(dataCacheEntry.key) || (dataCacheEntry = (transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, false)) != null ? transactionScopedCache.getEntry(object, false) : null) == null || !bl)) {
            transactionListenerImpl.currentCacheEntry = dataCacheEntry;
            dataCacheEntry.key = object;
            dataCacheEntry.setCacheManager(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "peekEntry return ", new Object[]{dataCacheEntry});
        }
        return dataCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionScopedCache getTransactionScopedCache(PMTxInfo pMTxInfo, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getTransactionScopedCache(transaction)", new Object[]{pMTxInfo});
            if (pMTxInfo == null) {
                Tr.debug(mytc, "transaction is null");
            } else if (pMTxInfo.getTxListener() == null) {
                Tr.debug(mytc, "transaction is non-null but TxListener is null");
            }
        }
        TransactionScopedCache transactionScopedCache = null;
        if (this.lifetimeInCacheUsage != 0) {
            transactionScopedCache = this.classScopedCache;
        } else {
            boolean bl2 = false;
            TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
            TransactionScopedCache transactionScopedCache2 = transactionListenerImpl.currentTranCache;
            if (transactionScopedCache2 != null && transactionScopedCache2.getCacheManager() == this) {
                bl2 = true;
            } else {
                List list = transactionListenerImpl.getTransactionScopedCaches();
                for (int i = 0; i < list.size(); ++i) {
                    transactionScopedCache2 = (TransactionScopedCache)list.get(i);
                    if (transactionScopedCache2.getCacheManager() != this) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (bl) {
                        TransactionScopedCachePool transactionScopedCachePool;
                        TransactionScopedCachePool transactionScopedCachePool2 = transactionScopedCachePool = TransactionScopedCachePool.getPool();
                        synchronized (transactionScopedCachePool2) {
                            if (!bl2) {
                                if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                                    Tr.debug(mytc, "Creating a new data cache (first request for this bean type)");
                                }
                                transactionScopedCache2 = transactionScopedCachePool.getResource();
                                transactionScopedCache2.setCacheManager(this);
                                transactionListenerImpl.addTransactionScopedCache(transactionScopedCache2);
                            }
                            transactionListenerImpl.currentTranCache = transactionScopedCache2;
                        }
                    } else {
                        transactionScopedCache2 = null;
                    }
                }
            }
            transactionScopedCache = transactionScopedCache2;
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getTransactionScopedCache(), returning theCache", new Object[]{transactionScopedCache});
        }
        return transactionScopedCache;
    }

    public void putAssociateOfObject(String string, Object object, PMTxInfo pMTxInfo, Object object2) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "putAssociateOfObject(associationName, objectKey, transaction, associateKey), transaction=null means ClassScopedCache", new Object[]{string, object, pMTxInfo, object2});
        }
        TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, true);
        transactionScopedCache.getAssociationsCache().putAssociateOfObject(string, object, object2);
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "putAssociateOfObject");
        }
    }

    public void putAssociatedKeys(Object object, Object object2, PMTxInfo pMTxInfo, Set set) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "putAssociatdKeys(role, foreignKey, transaction, keys), transaction=null means ClassScopedCache", new Object[]{object, object2, pMTxInfo, set});
        }
        TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, true);
        transactionScopedCache.getAssociationsCache().putAssociatesOfObject((String)object, object2, set);
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "putAssociateOfObject");
        }
    }

    public void putEntry(Object object, PMTxInfo pMTxInfo, DataCacheEntry dataCacheEntry, String[] stringArray) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "putEntry(key, transaction, entry, completeAssociations)", new Object[]{object, pMTxInfo, dataCacheEntry, stringArray});
        }
        TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, true);
        dataCacheEntry.setTranThatLoadedMe(pMTxInfo);
        transactionScopedCache.putEntry(object, dataCacheEntry);
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "putEntry");
        }
    }

    public void setLifetimeInCache(long l) {
        this.lifetimeInCache = l;
    }

    public void setLifetimeInCacheUsage(int n) {
        this.lifetimeInCacheUsage = n;
        if (this.lifetimeInCacheUsage != 0) {
            this.classScopedCache = new ClassScopedCache();
        }
    }

    public static void afterCompletion(TransactionListenerImpl transactionListenerImpl) {
    }

    public long calculateEntryLifetime() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        switch (this.lifetimeInCacheUsage) {
            case 0: {
                break;
            }
            case 1: {
                l = l2 + this.lifetimeInCache * 1000L;
                break;
            }
            case 2: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                long l3 = gregorianCalendar.getTime().getTime();
                l = l3 + this.lifetimeInCache * 1000L;
                if (l >= l2) break;
                l += 86400000L;
                break;
            }
            case 3: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(7, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                long l4 = gregorianCalendar.getTime().getTime();
                l = l4 + this.lifetimeInCache * 1000L;
                if (l >= l2) break;
                l += 604800000L;
                break;
            }
        }
        return l;
    }

    public ClassScopedCache getClassScopedCache() {
        return this.classScopedCache;
    }

    public boolean beanWasRemoved(Object object, PMTxInfo pMTxInfo) {
        TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, true);
        return transactionScopedCache.beanWasRemoved(object);
    }

    public void clearAssociationFromCache(Object object, PMTxInfo pMTxInfo) {
        TransactionScopedCache transactionScopedCache;
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "clearAssociationFromCache(key, transaction)", new Object[]{object, pMTxInfo});
        }
        if ((transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, false)) != null) {
            transactionScopedCache.removeAssociation(object);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "clearAssociationFromCache()");
        }
    }

    public void postCreate(Object object, PMTxInfo pMTxInfo) throws PersistenceManagerException {
        TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, true);
        transactionScopedCache.removeEntry(object);
        transactionScopedCache.removeAssociationAndSiblings(object);
        if (this.lifetimeInCacheUsage != 0) {
            this.classScopedCache.removeCustomFinderResultsContainingKey(object);
        }
    }

    public void postRemove(Object object, PMTxInfo pMTxInfo) throws PersistenceManagerException {
        try {
            this.putEntry(object, pMTxInfo, RemovedDataCacheEntry.createRemovedDataCacheEntry(), null);
        }
        catch (PersistenceManagerException persistenceManagerException) {
            FFDCFilter.processException((Throwable)persistenceManagerException, "com.ibm.ws.ejbpersistence.cache.CacheManagerImpl.postRemove", "562", this);
            PMExceptionHandler.logException(mytc, persistenceManagerException);
        }
        if (this.lifetimeInCacheUsage != 0) {
            this.classScopedCache.removeAssociationAndSiblings(object);
            this.classScopedCache.removeCustomFinderResultsContainingKey(object);
        } else {
            this.clearAssociationFromCache(object, pMTxInfo);
        }
    }

    public void postStore(Object object, PMTxInfo pMTxInfo) throws PersistenceManagerException {
        if (this.lifetimeInCacheUsage != 0) {
            this.classScopedCache.removeEntry(object);
            this.classScopedCache.removeAssociationAndSiblings(object);
            this.classScopedCache.removeCustomFinderResultsContainingKey(object);
        }
    }

    public boolean cachesBeansAsReadOnly() {
        return this.lifetimeInCacheUsage != 0;
    }

    public final synchronized void ejbInvalidate(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "ejbInvalidate(pk)", new Object[]{object});
        }
        if (this.classScopedCache == null) {
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5020E: The given bean type has lifetimeInCacheUsage OFF, so there is no cache to invalidate. The invalidate request is ignored.");
            FFDCFilter.processException((Throwable)persistenceManagerException, "com.ibm.ws.ejbpersistence.cache.CacheManagerImpl.ejbInvalidate(Object pk)", "750", this);
            PMExceptionHandler.logException(mytc, persistenceManagerException);
        } else {
            this.classScopedCache.removeEntry(object);
            this.classScopedCache.removeAssociationAndSiblings(object);
            this.classScopedCache.removeCustomFinderResultsContainingKey(object);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "ejbInvalidate(pk)");
        }
    }

    public final synchronized void ejbInvalidate(Collection collection) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "ejbInvalidate(pks)", new Object[]{collection});
        }
        if (this.classScopedCache == null) {
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5020E: The given bean type has lifetimeInCacheUsage OFF, so there is no cache to invalidate. The invalidate request is ignored.");
            FFDCFilter.processException((Throwable)persistenceManagerException, "com.ibm.ws.ejbpersistence.cache.CacheManagerImpl.ejbInvalidate (java.util.Collection pks)", "760", this);
            PMExceptionHandler.logException(mytc, persistenceManagerException);
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                this.classScopedCache.removeEntry(e2);
                this.classScopedCache.removeAssociationAndSiblings(e2);
                this.classScopedCache.removeCustomFinderResultsContainingKey(e2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "ejbInvalidate(pks)");
        }
    }

    public final synchronized void ejbInvalidateAll() {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "ejbInvalidateAll()");
        }
        if (this.classScopedCache == null) {
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5020E: The given bean type has lifetimeInCacheUsage OFF, so there is no cache to invalidate. The invalidate request is ignored.");
            FFDCFilter.processException((Throwable)persistenceManagerException, "com.ibm.ws.ejbpersistence.cache.CacheManagerImpl.ejbInvalidateAll", "770", this);
            PMExceptionHandler.logException(mytc, persistenceManagerException);
        } else {
            this.classScopedCache.clearDataCacheEntries();
            this.classScopedCache.setAssociationCache(null);
            this.classScopedCache.setCustomFinderResultsCache(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "ejbInvalidateAll()");
        }
    }

    public void unInstall() {
        if (this.classScopedCache != null) {
            this.classScopedCache.unInstall();
        }
    }

    public void putResultsOfCustomFinder(String string, Object object, PMTxInfo pMTxInfo, List list) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "putResultsOfCustomFinder(String customFinderName, Object customFinderInputParms, PMTxInfo transaction, List extractedKeys)", new Object[]{string, object, pMTxInfo, list});
        }
        TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, true);
        transactionScopedCache.getCustomFinderResultsCache().putAssociatesOfObject(string, object, list);
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "putResultsOfCustomFinder");
        }
    }

    public List getResultsOfCustomFinder(String string, Object object, PMTxInfo pMTxInfo) throws InvalidAssociationNameException {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getResultsOfCustomFinder(String customFinderName, Object customFinderInputParms, PMTxInfo transaction)", new Object[]{string, object, pMTxInfo});
        }
        Set set = null;
        ArrayList arrayList = null;
        TransactionScopedCache transactionScopedCache = this.getTransactionScopedCache(pMTxInfo, false);
        if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
            Tr.debug(mytc, "TransactionScopedCache is {0}", new Object[]{transactionScopedCache});
        }
        if (transactionScopedCache != null) {
            set = transactionScopedCache.getCustomFinderResultsCache().getAssociatesOfObject(string, object);
            if (set == null && this.classScopedCache != null) {
                set = this.classScopedCache.getCustomFinderResultsCache().getAssociatesOfObject(string, object);
            }
            if (set != null) {
                arrayList = new ArrayList(set);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getResultsOfCustomFinder");
        }
        return arrayList;
    }

    public int getUserSetQueryParmLength() {
        return this.userSetQueryParmLength;
    }

    public PMMasterCache getMasterCache() {
        return null;
    }

    public PMTxCache getTxCache(PMTxInfo pMTxInfo) {
        return null;
    }

    public boolean isPMTxCacheEnabled() {
        return false;
    }
}

