/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.cache.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ejbpersistence.cache.CacheManagerFactory;
import com.ibm.ws.ejbpersistence.cache.DataCacheEntry;
import com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener;
import com.ibm.ws.ejbpersistence.cache.impl.AssociationsCache;
import com.ibm.ws.ejbpersistence.cache.impl.AssociationsCacheSynchedImpl;
import com.ibm.ws.ejbpersistence.cache.impl.TransactionScopedCache;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;

public class ClassScopedCache
extends TransactionScopedCache {
    private static TraceComponent mytc = PMLogger.registerTC(ClassScopedCache.class);

    public ClassScopedCache() {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "ClassScopedCache()");
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "ClassScopedCache()");
        }
    }

    public DataCacheEntry getEntry(Object object, boolean bl) {
        DataCacheEntry dataCacheEntry = super.getEntry(object, false);
        if (dataCacheEntry != null) {
            if (dataCacheEntry.getLifetime() != -1L && dataCacheEntry.getLifetime() < System.currentTimeMillis()) {
                this.removeEntry(object);
                this.removeAssociationAndSiblings(object);
                dataCacheEntry = null;
            } else if (dataCacheEntry.getLoadTimeAccessIntent().getAccessType() == 1) {
                if (mytc.isDebugEnabled()) {
                    Tr.debug(mytc, "ClassScopedCache.getEntry(...) called by potential updater, returning a clone of the entry.");
                }
                dataCacheEntry = (DataCacheEntry)dataCacheEntry.getClone();
            }
        }
        return dataCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCacheEntry removeEntry(Object object) {
        ClassScopedCache classScopedCache = this;
        synchronized (classScopedCache) {
            return super.removeEntry(object);
        }
    }

    public AssociationsCache getAssociationsCache() {
        if (this.associationsCache == null) {
            this.associationsCache = new AssociationsCacheSynchedImpl();
        }
        return this.associationsCache;
    }

    public AssociationsCache getCustomFinderResultsCache() {
        if (this.customFinderResultsCache == null) {
            this.customFinderResultsCache = new AssociationsCacheSynchedImpl();
        }
        return this.customFinderResultsCache;
    }

    public void unInstall() {
    }

    public synchronized boolean beanWasRemoved(Object object) {
        return super.beanWasRemoved(object);
    }

    public synchronized boolean containsKey(Object object) {
        return super.containsKey(object);
    }

    public synchronized void putEntry(Object object, DataCacheEntry dataCacheEntry) {
        if (!CacheManagerFactory.firstUse && CacheManagerFactory.cacheInvalidationEnabled) {
            PMCacheInvalidationMessageListener.setupInvalidationReceiver();
            CacheManagerFactory.firstUse = true;
        }
        super.putEntry(object, dataCacheEntry);
    }

    public synchronized void clearDataCacheEntries() {
        super.clearDataCacheEntries();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\nClassScopedCache: ");
        stringBuffer.append("\n  isCacheInvalidationEnabled = " + CacheManagerFactory.cacheInvalidationEnabled);
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

