/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.dataaccess;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.PMTxInfo;
import com.ibm.ws.ejbpersistence.cache.CacheManager;
import com.ibm.ws.ejbpersistence.dataaccess.EJBExtractor;
import com.ibm.ws.ejbpersistence.dataaccess.RawBeanData;
import com.ibm.ws.ejbpersistence.dataaccess.ResultCollection;
import com.ibm.ws.ejbpersistence.dataaccess.ResultCollectionIteratorImpl;
import com.ibm.ws.ejbpersistence.dataaccess.WholeRowExtractor;
import com.ibm.ws.ejbpersistence.utilpm.BadDataAccessResultType;
import com.ibm.ws.ejbpersistence.utilpm.BeanDeploymentDescriptorException;
import com.ibm.ws.ejbpersistence.utilpm.BeanGenerationException;
import com.ibm.ws.ejbpersistence.utilpm.ErrorProcessingResultCollectionRow;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.resource.cci.Connection;
import javax.resource.cci.Record;

public abstract class AbstractResultCollection
implements ResultCollection {
    protected PMTxInfo currentTransaction;
    protected List extractedKeys = new LinkedList();
    String customFinderName;
    Object customFinderInputParms;
    private WholeRowExtractor wholeRowExtractor;
    protected RawBeanData fieldResultRawData = new RawBeanData();
    private boolean needsFiltering;
    private static TraceComponent mytc = PMLogger.registerTC(AbstractResultCollection.class);

    public boolean add(Object object) {
        throw new UnsupportedOperationException("PMGR6050E: Collection is read-only, since it represents data from a backend data store.");
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("PMGR6050E: Collection is read-only, since it represents data from a backend data store.");
    }

    public void clear() {
        this.wholeRowExtractor = null;
        this.needsFiltering = false;
        this.extractedKeys.clear();
        this.customFinderName = null;
        this.customFinderInputParms = null;
    }

    public void clearData() {
        this.extractedKeys.clear();
        this.fieldResultRawData.clearData();
    }

    public void closeConnection() {
        this.fieldResultRawData.closeConnection();
    }

    public boolean contains(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Object[] objectArray = new Object[]{object};
            Tr.entry(mytc, "contains()", objectArray);
        }
        boolean bl = false;
        if (object != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                bl = true;
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "contains()");
        }
        return bl;
    }

    public boolean containsAll(Collection collection) {
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && (bl = this.contains(iterator.next()))) {
        }
        return bl;
    }

    public boolean duplicatesInOrder() {
        return true;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    protected void finalize() throws Throwable {
        this.closeConnection();
    }

    public Object get(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException, BeanDeploymentDescriptorException {
        Object e2;
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "get(index)", new Object[]{new Integer(n)});
        }
        if (n >= this.extractedKeys.size()) {
            this.processRow(this.wholeRowExtractor, 0);
            e2 = this.extractedKeys.get(n);
        } else {
            e2 = this.extractedKeys.get(n);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "get(), returning key = ", new Object[]{e2});
        }
        return e2;
    }

    public Connection getConnection() {
        return this.fieldResultRawData.getConnection();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean hasNext(int n) throws ErrorProcessingResultCollectionRow {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "hasNext(index)", new Object[]{new Integer(n)});
        }
        boolean bl = false;
        if (this.fieldResultRawData == null) {
            throw new ErrorProcessingResultCollectionRow("PMGR6053E: INTERNAL ERROR: ResultCollection.fieldResultRawData is null");
        }
        bl = n + 1 < this.extractedKeys.size() ? true : this.fieldResultRawData.hasNext();
        if (!bl) {
            this.doneWithResultProcessing();
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "hasNext(index), returning ", new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    protected void doneWithResultProcessing() {
        if (this.customFinderName != null) {
            CacheManager cacheManager = ((EJBExtractor)this.wholeRowExtractor.get(0)).getCacheManager();
            cacheManager.putResultsOfCustomFinder(this.customFinderName, this.customFinderInputParms, this.currentTransaction, this.extractedKeys);
        }
    }

    public boolean isEmpty() {
        return this.fieldResultRawData == null;
    }

    public Iterator iterator() {
        return new ResultCollectionIteratorImpl(this);
    }

    public boolean needsFiltering() {
        return this.needsFiltering;
    }

    public abstract Object processRow(WholeRowExtractor var1, int var2) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException, BeanDeploymentDescriptorException;

    public boolean remove(Object object) {
        throw new UnsupportedOperationException("PMGR6050E: Collection is read-only, since it represents data from a backend data store.");
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("PMGR6050E: Collection is read-only, since it represents data from a backend data store.");
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("PMGR6050E: Collection is read-only, since it represents data from a backend data store.");
    }

    public void setConnection(Connection connection) {
        this.fieldResultRawData.setConnection(connection);
    }

    public void setNeedsFiltering(boolean bl) {
        this.needsFiltering = bl;
    }

    public void setResult(Record record) throws BadDataAccessResultType {
        this.clearData();
        this.fieldResultRawData.setResult(record);
    }

    public void setWholeRowExtractor(WholeRowExtractor wholeRowExtractor) {
        this.wholeRowExtractor = wholeRowExtractor;
    }

    public int size() {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "size()");
        }
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "size()");
        }
        return n;
    }

    public Object[] toArray() {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "toArray()");
        }
        ArrayList arrayList = new ArrayList(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "toArray()");
        }
        return arrayList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        ArrayList arrayList = new ArrayList(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(objectArray);
    }

    public void setCustomFinderKey(String string, Object object) {
        this.customFinderName = string;
        this.customFinderInputParms = object;
    }

    public void setCurrentTransaction(PMTxInfo pMTxInfo) {
        this.currentTransaction = pMTxInfo;
    }
}

