/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.dataaccess;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.ws.ejbpersistence.dataaccess.EJBExtractor;
import com.ibm.ws.ejbpersistence.utilpm.BadDataAccessResultType;
import com.ibm.ws.ejbpersistence.utilpm.ErrorProcessingResultCollectionRow;
import com.ibm.ws.ejbpersistence.utilpm.PMExceptionHandler;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;

public class RawBeanData {
    private Connection connection = null;
    private int currentBeanChunkOffset;
    int weHaveANextRow = -1;
    private ResultSet resultSet;
    private IndexedRecord resultRecord;
    private IndexedRecord currentSubRecord;
    private int resultRecordCursor = -1;
    private int resultRecordLength;
    private boolean lastObjectFetchedFromCurrentSubRecordsWasNull;
    private EJBExtractor currentRowExtractor;
    private static TraceComponent mytc = PMLogger.registerTC(RawBeanData.class);

    public void setResult(Record record) throws BadDataAccessResultType {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "setResult()");
            if (record == null) {
                Tr.debug(mytc, "Record result is null");
            }
        }
        if (record instanceof ResultSet) {
            this.resultSet = (ResultSet)record;
            this.resultRecord = null;
        } else if (record instanceof IndexedRecord) {
            this.resultRecord = (IndexedRecord)record;
            this.resultSet = null;
            this.currentSubRecord = null;
            this.resultRecordLength = this.resultRecord.size();
            this.resultRecordCursor = -1;
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
        } else {
            if (record instanceof MappedRecord) {
                throw new BadDataAccessResultType("PRGM6045 Result is MappedRecord, which is not supported. See ResultCollection doc for Resource Adapter standards on results of type cci.Record", new Object[]{record});
            }
            throw new BadDataAccessResultType("PMGR6046 Result is of an unknown type. See ResultCollection doc for Resource Adapter standards on results of type cci.Record", new Object[]{record});
        }
        this.currentBeanChunkOffset = 0;
        this.weHaveANextRow = -1;
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "setResult()");
        }
    }

    public boolean absolute(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        boolean bl = true;
        if (this.resultSet != null) {
            try {
                bl = this.resultSet.absolute(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.absolute", "153", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"absolute(" + n + ")", this}, sQLException);
            }
        } else if (this.resultRecord != null) {
            if (n > 0) {
                this.resultRecordCursor = n - 1;
            } else if (n < 0) {
                this.resultRecordCursor = n + this.resultRecordLength;
            } else {
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"absolute(" + n + ")", this});
            }
            if (this.resultRecordCursor >= this.resultRecordLength) {
                bl = false;
                this.resultRecordCursor = this.resultRecordLength - 1;
            }
            this.currentSubRecord = (IndexedRecord)this.resultRecord.get(this.resultRecordCursor);
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
        return bl;
    }

    public void afterLast() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.afterLast();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.afterLast", "200", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"afterLast()", this}, sQLException);
            }
        } else if (this.resultRecord != null) {
            this.resultRecordCursor = this.resultRecordLength;
            this.currentSubRecord = null;
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public void beforeFirst() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.beforeFirst();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.beforeFirst", "231", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"beforeFirst()", this}, sQLException);
            }
        } else if (this.resultRecord != null) {
            this.resultRecordCursor = -1;
            this.currentSubRecord = null;
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public void clearData() {
        this.resultSet = null;
        this.resultRecord = null;
    }

    public void clearWarnings() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.clearWarnings();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.clearWarnings", "260", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"clearWarnings()", this}, sQLException);
            }
        } else if (this.resultRecord == null) {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public void close() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.close", "295", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"close()", this}, sQLException);
            }
        } else if (this.resultRecord == null) {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public boolean first() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.first();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.first", "324", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"first()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.absolute(0);
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Array getArray(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getArray(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getArray", "356", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "array", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Array array = (Array)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = array == null;
            return array;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public InputStream getAsciiStream(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getAsciiStream(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getAsciiStream", "405", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "AsciiStream", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            InputStream inputStream = (InputStream)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = inputStream == null;
            return inputStream;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public BigDecimal getBigDecimal(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBigDecimal(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBigDecimal", "445", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "BigDecimal", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            BigDecimal bigDecimal = (BigDecimal)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = bigDecimal == null;
            return bigDecimal;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public InputStream getBinaryStream(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBinaryStream(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBinaryStream", "493", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "BinaryStream", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            InputStream inputStream = (InputStream)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = inputStream == null;
            return inputStream;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Blob getBlob(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBlob(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBlob", "531", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Blob", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Blob blob = (Blob)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = blob == null;
            return blob;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean getBoolean(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBoolean(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBoolean", "567", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "boolean", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Boolean bl = (Boolean)this.currentSubRecord.get(n - 1);
            if (bl == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return false;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return bl;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public byte getByte(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getByte(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getByte", "604", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "byte", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Byte by = (Byte)this.currentSubRecord.get(n - 1);
            if (by == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return by;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public byte[] getBytes(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getBytes(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBytes", "641", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "byte[]", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            byte[] byArray = (byte[])this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = byArray == null;
            return byArray;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public char getChar(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                String string = this.resultSet.getString(n);
                return string.charAt(0);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getChar", "680", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "char", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            String string = (String)this.currentSubRecord.get(n - 1);
            if (string == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return '\u0000';
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return string.charAt(0);
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Reader getCharacterStream(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getCharacterStream(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getCharacterStream", "716", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "CharacterStream", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Reader reader = (Reader)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = reader == null;
            return reader;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Clob getClob(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getClob(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getClob", "754", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Clob", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Clob clob = (Clob)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = clob == null;
            return clob;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getConcurrency() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getConcurrency();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getConcurrency", "790", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getConcurrency()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return 1007;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getCurrentBeanChunkOffset() {
        return this.currentBeanChunkOffset;
    }

    public String getCursorName() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getCursorName();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getCursorName", "841", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getCursorName()", this}, sQLException);
            }
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Date getDate(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getDate(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getDate", "871", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Date", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Date date = (Date)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = date == null;
            return date;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Date getDate(int n, Calendar calendar) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getDate(n, calendar);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getDate", "913", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Date in Calendar", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Date date = (Date)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = date == null;
            return date;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public double getDouble(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getDouble(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getDouble", "950", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "double", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Double d = (Double)this.currentSubRecord.get(n - 1);
            if (d == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0.0;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return d;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getFetchDirection() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getFetchDirection();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getFetchDirection", "986", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getFetchDirection()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return 1000;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getFetchSize() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getFetchSize();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getFetchSize", "1015", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getFetchSize()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return 100;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public float getFloat(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getFloat(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getFloat", "1045", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "float", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Float f = (Float)this.currentSubRecord.get(n - 1);
            if (f == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0.0f;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return f.floatValue();
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getInt(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getInt(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getInt", "1082", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "int", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Integer n2 = (Integer)this.currentSubRecord.get(n - 1);
            if (n2 == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return n2;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public long getLong(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getLong(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getLong", "1118", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "long", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Long l = (Long)this.currentSubRecord.get(n - 1);
            if (l == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0L;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return l;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public ResultSetMetaData getMetaData() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getMetaData();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getMetaData", "1152", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getMetaData()", this}, sQLException);
            }
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Object getObject(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getObject(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getObject", "1181", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Object", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Object object = this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = object == null;
            return object;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Object getObject(int n, Map map) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getObject(n, map);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getObject", "1224", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Object with Map", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Object object = this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = object == null;
            return object;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Ref getRef(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getRef(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getRef", "1261", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Ref", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Ref ref = (Ref)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = ref == null;
            return ref;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getRow() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getRow();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getRow", "1297", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getRow()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor + 1;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public short getShort(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getShort(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getShort", "1327", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "short", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Short s = (Short)this.currentSubRecord.get(n - 1);
            if (s == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                return 0;
            }
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
            return s;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Statement getStatement() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getStatement();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getStatement", "1366", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getStatement()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return null;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public String getString(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getString(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getString", "1395", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "String", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            String string = (String)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = string == null;
            return string;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Time getTime(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getTime(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getTime", "1432", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Time", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Time time = (Time)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = time == null;
            return time;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Time getTime(int n, Calendar calendar) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getTime(n, calendar);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getTime", "1472", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Time in Calendar", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Time time = (Time)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = time == null;
            return time;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Timestamp getTimestamp(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getTimestamp(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getTimestamp", "1508", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Timestamp", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Timestamp timestamp = (Timestamp)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = timestamp == null;
            return timestamp;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getTimestamp(n, calendar);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getTimestamp", "1548", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "Timestamp in Calendar", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            Timestamp timestamp = (Timestamp)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = timestamp == null;
            return timestamp;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public int getType() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getType();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getType", "1585", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getType()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return 1004;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public SQLWarning getWarnings() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.getWarnings();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getWarnings", "1622", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"getWarnings()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return null;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean hasNext() throws ErrorProcessingResultCollectionRow {
        if (this.weHaveANextRow != -1) {
            return this.weHaveANextRow >= 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "hasNext()");
        }
        if (this.resultSet != null) {
            try {
                boolean bl = this.resultSet.next();
                if (bl) {
                    this.weHaveANextRow = 1;
                }
                this.weHaveANextRow = 0;
            }
            catch (ObjectClosedException objectClosedException) {
                FFDCFilter.processException((Throwable)objectClosedException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.hasNext", "1665", this);
                ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6040 resultSet was found to be closed on first call to resultSet.next(). ResultSet is: {0}", new Object[]{this}, objectClosedException);
                PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                throw errorProcessingResultCollectionRow;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.hasNext", "1669", this);
                if (sQLException.getErrorCode() == 2 && sQLException.getSQLState().equals("57033")) {
                    ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6023E: Possible conflict between this transaction and another while accessing the same data, probably due to application design.", sQLException);
                    PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                    throw errorProcessingResultCollectionRow;
                }
                ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6041 SQLException on first call to resultSet.next(). ResultSet is: {0}", new Object[]{this}, sQLException);
                PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                throw errorProcessingResultCollectionRow;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.hasNext", "1673", this);
                ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6042 Non-SQL error on first call to resultSet.next(). ResultSet is: {0}", new Object[]{this}, throwable);
                PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
                throw errorProcessingResultCollectionRow;
            }
        } else if (this.resultRecord != null) {
            this.weHaveANextRow = this.resultRecordLength > this.resultRecordCursor + 1 ? 1 : 0;
        } else {
            ErrorProcessingResultCollectionRow errorProcessingResultCollectionRow = new ErrorProcessingResultCollectionRow("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
            PMExceptionHandler.logException(mytc, errorProcessingResultCollectionRow);
            throw errorProcessingResultCollectionRow;
        }
        if (this.weHaveANextRow == 0) {
            this.closeConnection();
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "hasNext(), returning {0}", new Object[]{new Boolean(this.weHaveANextRow == 1)});
        }
        return this.weHaveANextRow == 1;
    }

    public boolean isAfterLast() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.isAfterLast();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.isAfterLast", "1709", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"isAfterLast()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor >= this.resultRecordLength;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean isBeforeFirst() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.isBeforeFirst();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.isBeforeFirst", "1743", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"isBeforeFirst()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor < 0;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean isFirst() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.isFirst();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.isFirst", "1775", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"isFirst()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor == 0;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean isLast() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.isLast();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.isLast", "1811", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"isLast()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.resultRecordCursor == this.resultRecordLength - 1;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean last() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.last();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.last", "1845", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"last()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            if (this.resultRecordLength == 0) {
                return false;
            }
            this.resultRecordCursor = this.resultRecordLength - 1;
            return true;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public void moveToCurrentRow() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.moveToCurrentRow();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.moveToCurrentRow", "1882", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"moveToCurrentRow()", this}, sQLException);
            }
        } else if (this.resultRecord == null) {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public boolean next() throws ErrorProcessingResultCollectionRow {
        if (this.weHaveANextRow == -1) {
            this.hasNext();
        }
        if (this.weHaveANextRow == 0) {
            return false;
        }
        if (this.weHaveANextRow == 2) {
            this.weHaveANextRow = -1;
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "next()");
        }
        this.weHaveANextRow = -1;
        this.currentBeanChunkOffset = 0;
        if (this.resultRecord != null) {
            ++this.resultRecordCursor;
            this.currentSubRecord = (IndexedRecord)this.resultRecord.get(this.resultRecordCursor);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "next(), returning {0}", new Object[]{new Boolean(true)});
        }
        return true;
    }

    public boolean previous() throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.previous();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.previous", "1976", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"previous()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.absolute(this.resultRecordCursor - 1);
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public boolean relative(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                return this.resultSet.relative(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.relative", "2016", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"relative(" + n + ")", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.absolute(this.resultRecordCursor + n);
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public void setCurrentBeanChunkOffset(int n) {
        this.currentBeanChunkOffset = n;
    }

    public void setFetchDirection(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.setFetchDirection(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.setFetchDirection", "2060", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"setFetchDirection(" + n + ")", this}, sQLException);
            }
        } else if (this.resultRecord != null) {
            if (n != 1000) {
                throw new ErrorProcessingResultCollectionRow("PMGR6055 Function not supported.");
            }
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public void setFetchSize(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (this.resultSet != null) {
            try {
                this.resultSet.setFetchSize(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.setFetchSize", "2100", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"setFetchSize(" + n + ")", this}, sQLException);
            }
        } else {
            if (this.resultRecord != null) {
                return;
            }
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n currentBeanChunkOffset = " + this.currentBeanChunkOffset);
        if (this.resultSet != null) {
            stringBuffer.append("\n Result data is a ResultSet. /n " + this.resultSet.toString());
        }
        if (this.resultRecord != null) {
            stringBuffer.append("\n Result data is a cci.IndexedRecord. \n " + this.resultRecord.toString());
        }
        if (this.resultSet == null && this.resultRecord == null) {
            stringBuffer.append("\n Result data **** BAD **** both resultSet and resultRecord are null.\n ");
        }
        return stringBuffer.toString();
    }

    public boolean wasNull() throws PersistenceManagerInternalError, ErrorProcessingResultCollectionRow {
        if (this.resultSet != null) {
            try {
                return this.resultSet.wasNull();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.wasNull", "2156", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6032 SQLException when trying to perform {0}: {1}", new Object[]{"wasNull()", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            return this.lastObjectFetchedFromCurrentSubRecordsWasNull;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public void closeConnection() {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "closeConnection(), connection = ", new Object[]{this.connection});
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "closeConnection()");
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public byte[] getBlobAsByteArray(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getBlobAsByteArray(int columnIndex)", new Object[]{new Integer(n)});
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                int n2;
                InputStream inputStream = this.resultSet.getBinaryStream(n);
                if (inputStream == null || this.resultSet.wasNull()) {
                    byArray = null;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n2 = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getBlobAsByteArray", "2308", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "byte[]", this}, exception);
            }
        } else if (this.resultRecord != null) {
            byte[] byArray2 = (byte[])this.currentSubRecord.get(n - 1);
            if (byArray2 == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                byArray = null;
            } else {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
                byArray = byArray2;
            }
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getBlobAsByteArray(int columnIndex)", byArray);
        }
        return byArray;
    }

    public byte[] getClobAsByteArray(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getClobAsByteArray(int columnIndex)", new Object[]{new Integer(n)});
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byArray = null;
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                int n2;
                InputStream inputStream = this.resultSet.getAsciiStream(n);
                if (inputStream == null || this.resultSet.wasNull()) {
                    byArray = null;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n2 = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getClobAsByteArray", "2327", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "byte[]", this}, exception);
            }
        } else if (this.resultRecord != null) {
            byte[] byArray2 = (byte[])this.currentSubRecord.get(n - 1);
            if (byArray2 == null) {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = true;
                byArray = null;
            } else {
                this.lastObjectFetchedFromCurrentSubRecordsWasNull = false;
                byArray = byArray2;
            }
        } else {
            throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getClobAsByteArray(int columnIndex)", byArray);
        }
        return byArray;
    }

    public final EJBExtractor getCurrentRowExtractor() {
        return this.currentRowExtractor;
    }

    public final void setCurrentRowExtractor(EJBExtractor eJBExtractor) {
        this.currentRowExtractor = eJBExtractor;
    }

    public InputStream getUnicodeStream(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getUnicodeStream(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getUnicodeStream", "1327", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "UnicodeStream", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            InputStream inputStream = (InputStream)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = inputStream == null;
            return inputStream;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }

    public URL getURL(int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError {
        n += this.currentBeanChunkOffset;
        if (this.resultSet != null) {
            try {
                return this.resultSet.getURL(n);
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.ejbpersistence.dataaccess.RawBeanData.getURL", "1327", this);
                throw new ErrorProcessingResultCollectionRow("PMGR6031 SQLException when trying to get resultSet column {0} as a {1}. RawBeanData={2}", new Object[]{new Integer(n), "URL", this}, sQLException);
            }
        }
        if (this.resultRecord != null) {
            URL uRL = (URL)this.currentSubRecord.get(n - 1);
            this.lastObjectFetchedFromCurrentSubRecordsWasNull = uRL == null;
            return uRL;
        }
        throw new PersistenceManagerInternalError("PMGR6038 In RawBeanData, both resultRecord and resultSet were null. This should never happen, internal logic error.");
    }
}

