/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.dataaccess;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.cpmi.PMFinderResults;
import com.ibm.ws.ejbpersistence.cache.CacheManager;
import com.ibm.ws.ejbpersistence.cache.DataCacheEntry;
import com.ibm.ws.ejbpersistence.cache.TransactionListenerImpl;
import com.ibm.ws.ejbpersistence.dataaccess.AbstractResultCollection;
import com.ibm.ws.ejbpersistence.dataaccess.DataAccessSpec;
import com.ibm.ws.ejbpersistence.dataaccess.EJBExtractor;
import com.ibm.ws.ejbpersistence.dataaccess.ResultCollectionPool;
import com.ibm.ws.ejbpersistence.dataaccess.WholeRowExtractor;
import com.ibm.ws.ejbpersistence.utilpm.BadDataAccessResultType;
import com.ibm.ws.ejbpersistence.utilpm.BeanDeploymentDescriptorException;
import com.ibm.ws.ejbpersistence.utilpm.BeanGenerationException;
import com.ibm.ws.ejbpersistence.utilpm.ErrorProcessingResultCollectionRow;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.pmcache.PMTxCache;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.resource.cci.Record;

public class ResultCollectionImpl
extends AbstractResultCollection
implements PMFinderResults {
    private static TraceComponent mytc = PMLogger.registerTC(ResultCollectionImpl.class);
    static boolean avoidPeek = false;
    protected List firstRowPKs;
    private List currentRowPKs;
    private DataAccessSpec daSpec;
    private PMTxCache[] pmTxCache;
    private int loadIntent = 1;
    private AccessIntent loadTimeAccessIntent;
    private String[][] completeAssociationList;
    private CacheManager[][] counterCacheManagerList;
    private String[][] counterRoleNameList;
    private CacheManager cacheFinderCacheManager;
    private HashMap associationRoleMap = new HashMap();

    protected ResultCollectionImpl() {
    }

    public static ResultCollectionImpl createResultCollection() {
        return ResultCollectionPool.getPool().getResource();
    }

    public void initialize() {
        this.currentTransaction = null;
        this.firstRowPKs = null;
        this.currentRowPKs = null;
        this.daSpec = null;
        this.loadTimeAccessIntent = null;
        this.completeAssociationList = null;
        this.counterCacheManagerList = null;
        this.counterRoleNameList = null;
        this.associationRoleMap.clear();
        this.cacheFinderCacheManager = null;
        super.clear();
    }

    public void setDataAccessSpec(DataAccessSpec dataAccessSpec) throws BeanGenerationException {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "setDataAccessSpec(aDASpec)", new Object[]{dataAccessSpec});
        }
        this.daSpec = dataAccessSpec;
        WholeRowExtractor wholeRowExtractor = (WholeRowExtractor)this.daSpec.getExtractor();
        int n = wholeRowExtractor.size();
        this.firstRowPKs = new ArrayList(n);
        this.currentRowPKs = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.firstRowPKs.add(null);
            this.currentRowPKs.add(null);
        }
        wholeRowExtractor.prepareForAssociationsCaching(n, this.daSpec);
        this.counterRoleNameList = wholeRowExtractor.getCounterRoleNameList();
        this.counterCacheManagerList = wholeRowExtractor.getCounterCacheManagerList();
        this.completeAssociationList = wholeRowExtractor.getCompleteAssociationList();
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.debug(mytc, "  numberOfChunksInaRow = " + n + ", firstRowPKs = " + this.firstRowPKs + ", currentRowPKs = " + this.currentRowPKs);
            Tr.exit(mytc, "setDataAccessSpec(aDASpec)");
        }
    }

    private String[] getCompleteAssociationSubList(int n) {
        if (this.completeAssociationList == null) {
            return null;
        }
        return this.completeAssociationList[n];
    }

    public Object processRow(WholeRowExtractor wholeRowExtractor, int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException, BeanDeploymentDescriptorException {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "processRow(wholeRowExtractor, extractorIndex)", new Object[]{wholeRowExtractor, new Integer(n)});
            if (wholeRowExtractor == null) {
                Tr.debug(mytc, "wholeRowExtractor is null");
                if (wholeRowExtractor.size() == 0) {
                    Tr.debug(mytc, "wholeRowExtractor is empty");
                }
            }
        }
        this.fieldResultRawData.next();
        boolean bl = false;
        EJBExtractor eJBExtractor = (EJBExtractor)wholeRowExtractor.get(n);
        this.processSingleRow(this.firstRowPKs, wholeRowExtractor, n);
        Object e2 = this.firstRowPKs.get(0);
        this.extractedKeys.add(e2);
        if (this.daSpec.getReadAheadHint() == null && (!this.daSpec.containsDuplicates() || this.daSpec.allowDuplicates())) {
            if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
                Tr.exit(mytc, "processRow(...) exit w/o more row process.");
            }
            return e2;
        }
        while (this.fieldResultRawData.next()) {
            Object object = eJBExtractor.extractPrimaryKey(this.fieldResultRawData);
            if (object != null && e2 != null && object.equals(e2)) {
                if (bl) continue;
                this.processSingleRow(this.currentRowPKs, wholeRowExtractor, n);
                if (!this.daSpec.containsDuplicates() || !((Object)this.currentRowPKs).equals(this.firstRowPKs)) continue;
                bl = true;
                if (!this.daSpec.allowDuplicates()) continue;
                this.extractedKeys.add(e2);
                break;
            }
            this.fieldResultRawData.weHaveANextRow = 2;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "processRow(...)");
        }
        return e2;
    }

    public void processSingleRow(List list, WholeRowExtractor wholeRowExtractor, int n) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException, BeanDeploymentDescriptorException {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "processSingleRow(rowPKs, wholeRowExtractor, extractorIndex)", new Object[]{list, wholeRowExtractor, new Integer(n)});
        }
        EJBExtractor eJBExtractor = (EJBExtractor)wholeRowExtractor.get(n);
        CacheManager cacheManager = eJBExtractor.getCacheManager();
        String[] stringArray = this.getCompleteAssociationSubList(n);
        Object object = eJBExtractor.extractPrimaryKey(this.fieldResultRawData);
        if (object != null && this.isAnyPrimaryKeyFieldNull(object)) {
            object = null;
            if (mytc.isDebugEnabled()) {
                Tr.debug(mytc, "set currentPrimaryKey to null");
            }
        }
        list.set(n, object);
        if (object != null) {
            TransactionListenerImpl transactionListenerImpl;
            DataCacheEntry dataCacheEntry = null;
            if (!avoidPeek) {
                if (this.pmTxCache[n] == null) {
                    dataCacheEntry = cacheManager.peekEntry(object, this.currentTransaction, n == 0);
                } else {
                    dataCacheEntry = (DataCacheEntry)this.pmTxCache[n].getDataEntry(object, null);
                    if (n == 0 && dataCacheEntry != null) {
                        transactionListenerImpl = (TransactionListenerImpl)this.currentTransaction.getTxListener();
                        dataCacheEntry.key = object;
                        dataCacheEntry.setCacheManager(cacheManager);
                        transactionListenerImpl.currentCacheEntry = dataCacheEntry;
                    }
                }
            }
            if (dataCacheEntry == null && this.loadIntent == 2 && !cacheManager.cachesBeansAsReadOnly()) {
                if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                    Tr.debug(mytc, "processSingleRow(...), skip extract data due to PMFinderResults.LOAD_NEVER ");
                }
                if (n == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                        Tr.debug(mytc, "processSingleRow(...), need to extract home for first trunck. ");
                    }
                    if ((dataCacheEntry = eJBExtractor.createDataCacheEntry()) == null) {
                        dataCacheEntry = eJBExtractor.extractData(this.fieldResultRawData);
                    }
                    dataCacheEntry.setHome(eJBExtractor.getHome(this.fieldResultRawData));
                    transactionListenerImpl = (TransactionListenerImpl)this.currentTransaction.getTxListener();
                    dataCacheEntry.key = object;
                    dataCacheEntry.setCacheManager(cacheManager);
                    transactionListenerImpl.currentCacheEntry = dataCacheEntry;
                }
            }
            if (dataCacheEntry == null) {
                dataCacheEntry = eJBExtractor.extractData(this.fieldResultRawData);
                if (dataCacheEntry == null) {
                    throw new ErrorProcessingResultCollectionRow("PMGR6034E: An error occured while extracting data from a row of finder results (for example, the value found in a discrimination column was not recognized by the Extractor processing it).");
                }
                dataCacheEntry.setHome(eJBExtractor.getHome(this.fieldResultRawData));
                dataCacheEntry.setLifetime(cacheManager.calculateEntryLifetime());
                dataCacheEntry.setLoadTimeAccessIntent(this.loadTimeAccessIntent);
                dataCacheEntry.setCacheManager(cacheManager);
                if (this.counterRoleNameList != null && this.counterRoleNameList[n] != null) {
                    for (int i = 0; i < this.counterRoleNameList[n].length; ++i) {
                        this.counterCacheManagerList[n][i].putAssociatedKeys(this.counterRoleNameList[n][i], object, this.currentTransaction, null);
                    }
                }
                if (n == 0 && (this.loadIntent == 0 || this.daSpec.isSingleResult())) {
                    TransactionListenerImpl transactionListenerImpl2 = (TransactionListenerImpl)this.currentTransaction.getTxListener();
                    dataCacheEntry.key = object;
                    transactionListenerImpl2.currentCacheEntry = dataCacheEntry;
                    if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                        Tr.debug(mytc, "Cache in lookaside." + transactionListenerImpl2);
                    }
                }
                if (n != 0 || this.loadIntent != 0 || dataCacheEntry.getLifetime() != 0L) {
                    if (this.pmTxCache[n] != null) {
                        dataCacheEntry.setTranThatLoadedMe(this.currentTransaction);
                        this.pmTxCache[n].putDataEntry(object, dataCacheEntry);
                    } else {
                        cacheManager.putEntry(object, this.currentTransaction, dataCacheEntry, stringArray);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                        Tr.debug(mytc, "Cache in cache." + cacheManager);
                    }
                }
            }
            if (stringArray != null) {
                this.cacheFinderCacheManager = cacheManager;
                this.buildAssociationSet(dataCacheEntry, stringArray, object);
            }
        }
        if (++n < wholeRowExtractor.size()) {
            int n2 = this.fieldResultRawData.getCurrentBeanChunkOffset();
            int n3 = eJBExtractor.getChunkLength(this.fieldResultRawData);
            this.fieldResultRawData.setCurrentBeanChunkOffset(n2 + n3);
            if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                Tr.debug(mytc, "...recursing...");
            }
            this.processSingleRow(list, wholeRowExtractor, n);
            if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                Tr.debug(mytc, "...unwinding recursion...");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "processSingleRow(...), with modified rowPKs", list);
        }
    }

    private void buildAssociationSet(DataCacheEntry dataCacheEntry, String[] stringArray, Object object) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException {
        List list;
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "buildAssociationSet(entry, completeAssociations, currentPrimaryKey)", new Object[]{dataCacheEntry, stringArray, object});
        }
        if ((list = dataCacheEntry.getForeignKeys(stringArray)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
                Tr.debug(mytc, "Found at least one 'complete' foreign key");
            }
            Object var5_5 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                var5_5 = list.get(i);
                if (var5_5 == null) continue;
                this.putAssociateOfObject(stringArray[i], var5_5, object);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "buildAssociationSet(...)");
        }
    }

    public void putAssociateOfObject(String string, Object object, Object object2) {
        HashSet<Object> hashSet;
        HashMap hashMap = (HashMap)this.associationRoleMap.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.associationRoleMap.put(string, hashMap);
        }
        if ((hashSet = (HashSet<Object>)hashMap.get(object)) == null) {
            hashSet = new HashSet<Object>();
        }
        hashMap.put(object, hashSet);
        hashSet.add(object2);
    }

    protected void doneWithResultProcessing() {
        super.doneWithResultProcessing();
        Iterator iterator = this.associationRoleMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            HashMap hashMap = (HashMap)this.associationRoleMap.get(k);
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                Object k2 = iterator2.next();
                this.cacheFinderCacheManager.putAssociatedKeys(k, k2, this.currentTransaction, (Set)hashMap.get(k2));
            }
        }
    }

    public AccessIntent getLoadTimeAccessIntent() {
        return this.loadTimeAccessIntent;
    }

    public void setLoadTimeAccessIntent(AccessIntent accessIntent) {
        this.loadTimeAccessIntent = accessIntent;
    }

    public void beginResultsProcessing(int n) {
        this.loadIntent = n;
    }

    public void endResultsProcessing() {
        this.loadIntent = 1;
    }

    public void setResult(Record record) throws BadDataAccessResultType {
        super.setResult(record);
        WholeRowExtractor wholeRowExtractor = (WholeRowExtractor)this.daSpec.getExtractor();
        this.pmTxCache = new PMTxCache[wholeRowExtractor.size()];
        for (int i = 0; i < wholeRowExtractor.size(); ++i) {
            EJBExtractor eJBExtractor = (EJBExtractor)wholeRowExtractor.get(i);
            CacheManager cacheManager = eJBExtractor.getCacheManager();
            if (!cacheManager.isPMTxCacheEnabled()) continue;
            this.pmTxCache[i] = cacheManager.getTxCache(this.currentTransaction);
        }
    }

    public boolean isAnyPrimaryKeyFieldNull(Object object) throws SecurityException {
        boolean bl;
        block12: {
            if (mytc.isEntryEnabled()) {
                Tr.entry(mytc, "ResultCollectionImpl.isAnyPrimaryKeyFieldNull");
            }
            bl = false;
            try {
                int n = object.hashCode();
            }
            catch (Throwable throwable) {
                if (throwable instanceof NullPointerException) {
                    if (mytc.isDebugEnabled()) {
                        Tr.debug(mytc, "ResultCollectionImpl.isAnyPrimaryKeyFieldNull. Caught NPE in hashCode");
                    }
                    bl = true;
                    return bl;
                }
                Tr.error(mytc, "ResultCollectionImpl.isAnyPrimaryKeyFieldNull. Caught exception: " + throwable);
                if (mytc.isDebugEnabled()) {
                    Tr.debug(mytc, "Dump stack trace: " + this.convertExceptionToString(throwable));
                }
                try {
                    Class<?> clazz = object.getClass();
                    Field[] fieldArray = clazz.getFields();
                    if (fieldArray != null && fieldArray.length != 0) {
                        for (int i = 0; i < fieldArray.length; ++i) {
                            Object object2;
                            Field field = fieldArray[i];
                            int n = field.getModifiers();
                            if (!Modifier.isPublic(n) || (object2 = field.get(object)) != null) continue;
                            if (mytc.isDebugEnabled()) {
                                Tr.debug(mytc, "ResultCollectionImpl.isPrimaryKeyFieldNull. The persistent attribute: " + field + " contains a null value.");
                            }
                            bl = true;
                            return bl;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    Tr.error(mytc, "Caught exception: " + throwable2);
                    if (!mytc.isDebugEnabled()) break block12;
                    Tr.debug(mytc, "Dump stack trace: " + this.convertExceptionToString(throwable2));
                }
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "ResultCollectionImpl.isAnyPrimaryKeyFieldNull : " + bl);
        }
        return bl;
    }

    public String convertExceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    static {
        avoidPeek = new Boolean(System.getProperty("com.ibm.ws.pm.avoidpeek"));
        if (TraceComponent.isAnyTracingEnabled() && mytc.isDebugEnabled()) {
            Tr.debug(mytc, "Property com.ibm.ws.pm.avoidpeek:" + avoidPeek);
        }
    }
}

