/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.pluggablecache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.PMTxInfo;
import com.ibm.ws.ejbpersistence.cache.CacheManager;
import com.ibm.ws.ejbpersistence.cache.DataCacheEntry;
import com.ibm.ws.ejbpersistence.cache.TransactionListenerImpl;
import com.ibm.ws.ejbpersistence.pluggablecache.impl.PluggableMasterCache;
import com.ibm.ws.ejbpersistence.utilpm.BeanGenerationException;
import com.ibm.ws.ejbpersistence.utilpm.ErrorProcessingResultCollectionRow;
import com.ibm.ws.ejbpersistence.utilpm.InvalidAssociationNameException;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerException;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.pmcache.ExpirePolicy;
import com.ibm.ws.pmcache.GetPolicy;
import com.ibm.ws.pmcache.PMCacheFactory;
import com.ibm.ws.pmcache.PMMasterCache;
import com.ibm.ws.pmcache.PMTxCache;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;

public final class CacheManagerImpl
implements CacheManager,
ExpirePolicy {
    private long lifetimeInCache = 0L;
    private int lifetimeInCacheUsage = 0;
    public static final int Off = 0;
    public static final int ElapsedTime = 1;
    public static final int ClockTime = 2;
    public static final int WeekTime = 3;
    private static TraceComponent mytc = PMLogger.registerTC(CacheManagerImpl.class);
    private PMMasterCache masterCache = null;

    public CacheManagerImpl(long l, int n, PMCacheFactory pMCacheFactory, J2EEName j2EEName) {
        this.lifetimeInCache = l;
        this.lifetimeInCacheUsage = n;
        this.masterCache = new PluggableMasterCache(pMCacheFactory, j2EEName);
        this.masterCache.setExpirePolicy(this);
    }

    public void cacheForeignKeys(DataCacheEntry dataCacheEntry, String[] stringArray, Object object, PMTxInfo pMTxInfo) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException {
    }

    public void clearEntryFromCache(Object object, PMTxInfo pMTxInfo) {
    }

    public Set getAssociatedKeys(String string, Object object, PMTxInfo pMTxInfo) throws InvalidAssociationNameException {
        Set set = null;
        set = this.masterCache.getTxCache(pMTxInfo).getAssociatedKeys(string, object);
        return set;
    }

    public static List getCachesForTransaction(PMTxInfo pMTxInfo) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getCachesForTransaction(transaction)", new Object[]{pMTxInfo});
        }
        TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
        List list = transactionListenerImpl.getTransactionScopedCaches();
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getCachesForTransaction(), returning List of TransactionScopedCaches ");
        }
        return list;
    }

    public DataCacheEntry getEntry(Object object, PMTxInfo pMTxInfo, GetPolicy getPolicy) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getEntry(key, transaction)", new Object[]{object, pMTxInfo});
        }
        TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
        DataCacheEntry dataCacheEntry = transactionListenerImpl.currentCacheEntry;
        if (dataCacheEntry != null && dataCacheEntry.getCacheManager().equals(this) && object.equals(dataCacheEntry.key)) {
            transactionListenerImpl.currentCacheEntry = null;
        } else {
            dataCacheEntry = (DataCacheEntry)this.masterCache.getTxCache(pMTxInfo).getDataEntry(object, getPolicy);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getEntry, returning entry", new Object[]{dataCacheEntry});
        }
        return dataCacheEntry;
    }

    public DataCacheEntry peekEntry(Object object, PMTxInfo pMTxInfo, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "peekEntry(key, transaction)", new Object[]{object, pMTxInfo});
        }
        TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
        DataCacheEntry dataCacheEntry = transactionListenerImpl.currentCacheEntry;
        if (!(dataCacheEntry != null && dataCacheEntry.getCacheManager().equals(this) && object.equals(dataCacheEntry.key) || (dataCacheEntry = (DataCacheEntry)this.masterCache.getTxCache(pMTxInfo).getDataEntry(object, null)) == null || !bl)) {
            transactionListenerImpl.currentCacheEntry = dataCacheEntry;
            dataCacheEntry.key = object;
            dataCacheEntry.setCacheManager(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "peekEntry, returning home for entry", new Object[]{dataCacheEntry});
        }
        return dataCacheEntry;
    }

    public void putAssociateOfObject(String string, Object object, PMTxInfo pMTxInfo, Object object2) {
    }

    public void putAssociatedKeys(Object object, Object object2, PMTxInfo pMTxInfo, Set set) {
        this.masterCache.getTxCache(pMTxInfo).putAssociatedKeys(object, object2, set);
    }

    public void putEntry(Object object, PMTxInfo pMTxInfo, DataCacheEntry dataCacheEntry, String[] stringArray) throws ErrorProcessingResultCollectionRow, PersistenceManagerInternalError, BeanGenerationException {
        dataCacheEntry.setTranThatLoadedMe(pMTxInfo);
        this.masterCache.getTxCache(pMTxInfo).putDataEntry(object, dataCacheEntry);
    }

    public static void afterCompletion(TransactionListenerImpl transactionListenerImpl) {
    }

    public long calculateEntryLifetime() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        switch (this.lifetimeInCacheUsage) {
            case 0: {
                break;
            }
            case 1: {
                l = l2 + this.lifetimeInCache * 1000L;
                break;
            }
            case 2: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                long l3 = gregorianCalendar.getTime().getTime();
                l = l3 + this.lifetimeInCache * 1000L;
                if (l >= l2) break;
                l += 86400000L;
                break;
            }
            case 3: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(7, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                long l4 = gregorianCalendar.getTime().getTime();
                l = l4 + this.lifetimeInCache * 1000L;
                if (l >= l2) break;
                l += 604800000L;
                break;
            }
        }
        return l;
    }

    public boolean beanWasRemoved(Object object, PMTxInfo pMTxInfo) {
        return this.masterCache.getTxCache(pMTxInfo).isRemoved(object);
    }

    public void clearAssociationFromCache(Object object, PMTxInfo pMTxInfo) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "clearAssociationFromCache(key, transaction)", new Object[]{object, pMTxInfo});
        }
        this.masterCache.getTxCache(pMTxInfo).invalidateAssociation();
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "clearAssociationFromCache()");
        }
    }

    public void postCreate(Object object, PMTxInfo pMTxInfo) throws PersistenceManagerException {
        this.masterCache.getTxCache(pMTxInfo).invalidateDataEntry(object);
        this.masterCache.getTxCache(pMTxInfo).invalidateAssociation();
        this.masterCache.getTxCache(pMTxInfo).invalidateQuery();
    }

    public void postRemove(Object object, PMTxInfo pMTxInfo) throws PersistenceManagerException {
        this.masterCache.getTxCache(pMTxInfo).removeDataEntry(object);
        this.masterCache.getTxCache(pMTxInfo).invalidateAssociation();
        this.masterCache.getTxCache(pMTxInfo).invalidateQuery();
    }

    public void postStore(Object object, PMTxInfo pMTxInfo) throws PersistenceManagerException {
        this.masterCache.getTxCache(pMTxInfo).invalidateDataEntry(object);
        this.masterCache.getTxCache(pMTxInfo).invalidateAssociation();
        this.masterCache.getTxCache(pMTxInfo).invalidateQuery();
    }

    public boolean cachesBeansAsReadOnly() {
        return this.lifetimeInCacheUsage != 0;
    }

    public final synchronized void ejbInvalidate(Object object) {
    }

    public final synchronized void ejbInvalidate(Collection collection) {
    }

    public final synchronized void ejbInvalidateAll() {
    }

    public void unInstall() {
    }

    public void putResultsOfCustomFinder(String string, Object object, PMTxInfo pMTxInfo, List list) {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "putResultsOfCustomFinder(String customFinderName, Object customFinderInputParms, PMTxInfo transaction, List extractedKeys)", new Object[]{string, object, pMTxInfo, list});
        }
        this.masterCache.getTxCache(pMTxInfo).putQuery(string, object, list);
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "putResultsOfCustomFinder");
        }
    }

    public List getResultsOfCustomFinder(String string, Object object, PMTxInfo pMTxInfo) throws InvalidAssociationNameException {
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getResultsOfCustomFinder(String customFinderName, Object customFinderInputParms, PMTxInfo transaction)", new Object[]{string, object, pMTxInfo});
        }
        List list = null;
        list = this.masterCache.getTxCache(pMTxInfo).getQuery(string, object);
        if (TraceComponent.isAnyTracingEnabled() && mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getResultsOfCustomFinder");
        }
        return list;
    }

    public int getUserSetQueryParmLength() {
        return -1;
    }

    public PMMasterCache getMasterCache() {
        return this.masterCache;
    }

    public long getSize() {
        return -1L;
    }

    public boolean keepInvalidated() {
        return false;
    }

    public boolean keepRemoved() {
        return false;
    }

    public boolean isLifeTimeEnabled() {
        return this.lifetimeInCacheUsage != 0;
    }

    public PMTxCache getTxCache(PMTxInfo pMTxInfo) {
        return this.masterCache.getTxCache(pMTxInfo);
    }

    public boolean isPMTxCacheEnabled() {
        return !this.isLifeTimeEnabled();
    }
}

