/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.pmcache.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.PMTxInfo;
import com.ibm.ws.ejbpersistence.PMCacheRelationshipHelper;
import com.ibm.ws.ejbpersistence.cache.CacheManagerFactory;
import com.ibm.ws.ejbpersistence.cache.TransactionListenerImpl;
import com.ibm.ws.ejbpersistence.pmcache.impl.AssociationsCache;
import com.ibm.ws.ejbpersistence.pmcache.impl.AssociationsCacheSynchedImpl;
import com.ibm.ws.ejbpersistence.pmcache.impl.InvalidDataCacheEntry;
import com.ibm.ws.ejbpersistence.pmcache.impl.RemovedDataCacheEntry;
import com.ibm.ws.ejbpersistence.pmcache.impl.TransactionCache;
import com.ibm.ws.ejbpersistence.pmcache.impl.TransactionCachePool;
import com.ibm.ws.ejbpersistence.utilpm.InvalidAssociationNameException;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.TwoFacedHashMap;
import com.ibm.ws.pmcache.DataEntry;
import com.ibm.ws.pmcache.ExpirePolicy;
import com.ibm.ws.pmcache.GetPolicy;
import com.ibm.ws.pmcache.PMMasterCache;
import com.ibm.ws.pmcache.PMTxCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class MasterCache
implements PMMasterCache {
    private static TraceComponent mytc = PMLogger.registerTC(MasterCache.class);
    private J2EEName cacheID;
    protected TwoFacedHashMap dataCacheEntries;
    protected ExpirePolicy expirePolicy;
    protected AssociationsCacheSynchedImpl associationsCache = null;
    protected AssociationsCacheSynchedImpl queryCache = null;
    protected boolean isLifeTimeInCache = false;

    public MasterCache() {
    }

    public MasterCache(Object object) {
        this.cacheID = (J2EEName)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PMTxCache getTxCache(Object object) {
        PMTxInfo pMTxInfo = (PMTxInfo)object;
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getTxCache(transaction)", new Object[]{pMTxInfo});
            if (pMTxInfo == null) {
                Tr.debug(mytc, "transaction is null");
            } else if (pMTxInfo.getTxListener() == null) {
                Tr.debug(mytc, "transaction is non-null but TxListener is null");
            }
        }
        TransactionListenerImpl transactionListenerImpl = (TransactionListenerImpl)pMTxInfo.getTxListener();
        TransactionCache transactionCache = transactionListenerImpl.currentTransactionCache;
        if (transactionCache == null || transactionCache.getMasterCache() != this) {
            transactionCache = (TransactionCache)transactionListenerImpl.getTransactionCache(this);
            if (transactionCache == null) {
                TransactionCachePool transactionCachePool;
                TransactionCachePool transactionCachePool2 = transactionCachePool = TransactionCachePool.getPool();
                synchronized (transactionCachePool2) {
                    if (mytc.isDebugEnabled()) {
                        Tr.debug(mytc, "Creating a new data cache (first request for this bean type)");
                    }
                    transactionCache = transactionCachePool.getResource();
                }
                transactionCache.setTxId(pMTxInfo);
                transactionCache.setMasterCache(this);
                transactionListenerImpl.addTransactionCache(this, transactionCache);
            }
            transactionListenerImpl.currentTransactionCache = transactionCache;
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getTransactionCache(), returning theCache", new Object[]{transactionCache});
        }
        return transactionCache;
    }

    public void setExpirePolicy(ExpirePolicy expirePolicy) {
        this.expirePolicy = expirePolicy;
        this.isLifeTimeInCache = expirePolicy.isLifeTimeEnabled();
        this.initTwoFacedHashMap();
    }

    private void initTwoFacedHashMap() {
        this.dataCacheEntries = new TwoFacedHashMap(new Long(this.expirePolicy.getSize()).intValue());
    }

    public List getQuery(Object object, Object object2) {
        ArrayList arrayList = null;
        try {
            Set set = this.getQueryCache().getAssociatesOfObject((String)object, object2);
            if (set != null) {
                arrayList = new ArrayList(set);
            }
        }
        catch (InvalidAssociationNameException invalidAssociationNameException) {
            return null;
        }
        return arrayList;
    }

    public void putQuery(Object object, Object object2, List list) {
        this.getQueryCache().putAssociatesOfObject((String)object, object2, list);
    }

    public Set getQueryIdSet() {
        return this.getQueryCache().getRoleSet();
    }

    public Set getQueryInput(Object object) {
        return this.getQueryCache().getAssociationForeignKeySet(object);
    }

    public boolean contain(Object object, Object object2) {
        return false;
    }

    private AssociationsCache getAssociationsCache() {
        if (this.associationsCache == null) {
            this.associationsCache = new AssociationsCacheSynchedImpl();
        }
        return this.associationsCache;
    }

    private AssociationsCache getQueryCache() {
        if (this.associationsCache == null) {
            this.associationsCache = new AssociationsCacheSynchedImpl();
        }
        return this.associationsCache;
    }

    public Set getAssociatedKeys(Object object, Object object2) {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getAssociatedKeys(role, foreignKey)", new Object[]{object, object2});
        }
        Set set = null;
        try {
            set = this.getAssociationsCache().getAssociatesOfObject((String)object, object2);
        }
        catch (InvalidAssociationNameException invalidAssociationNameException) {
            return null;
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getAssociatedKeys, returning assocSet", new Object[]{set});
        }
        return set;
    }

    public void putAssociatedKeys(Object object, Object object2, Set set) {
        this.getAssociationsCache().putAssociatesOfObject((String)object, object2, set);
    }

    public Set getAssociationRoleSet() {
        return this.getAssociationsCache().getRoleSet();
    }

    public Set getAssociationForeignKeySet(Object object) {
        return this.getAssociationsCache().getAssociationForeignKeySet(object);
    }

    public Object getDataEntry(Object object, GetPolicy getPolicy) {
        Object object2;
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getDataEntry(key)", new Object[]{object});
        }
        if ((object2 = this.dataCacheEntries.get(object)) != null) {
            if (object2 == RemovedDataCacheEntry.getRemovedDataCacheEntry() || object2 == InvalidDataCacheEntry.getInvalidDataCacheEntry()) {
                object2 = null;
            } else if (((DataEntry)object2).isExpired()) {
                this.invalidateDataEntry(object);
                this.invalidateAssociation();
                this.invalidateQuery();
                object2 = null;
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getDataEntry, returning home for entry", new Object[]{object2});
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDataEntry(Object object, DataEntry dataEntry) {
        TwoFacedHashMap twoFacedHashMap = this.dataCacheEntries;
        synchronized (twoFacedHashMap) {
            this.dataCacheEntries.put(object, dataEntry);
        }
    }

    public Set getDataEntryKeySet() {
        return new HashSet(this.dataCacheEntries.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataEntry(Object object) {
        TwoFacedHashMap twoFacedHashMap = this.dataCacheEntries;
        synchronized (twoFacedHashMap) {
            if (this.dataCacheEntries.get(object) != null) {
                if (this.expirePolicy.keepRemoved()) {
                    this.dataCacheEntries.put(object, RemovedDataCacheEntry.getRemovedDataCacheEntry());
                } else {
                    this.dataCacheEntries.remove(object);
                }
            }
        }
    }

    public boolean isInvalidated(Object object) {
        Object object2 = this.dataCacheEntries.get(object);
        if (object2 != null && this.expirePolicy.keepInvalidated()) {
            return object2 == InvalidDataCacheEntry.getInvalidDataCacheEntry();
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.getDataEntry(object, null) != null;
    }

    public boolean isRemoved(Object object) {
        Object object2 = this.dataCacheEntries.get(object);
        if (object2 != null && this.expirePolicy.keepRemoved()) {
            return object2 == RemovedDataCacheEntry.getRemovedDataCacheEntry();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateDataEntry(Object object) {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "invalidateDataEntry(pkey)", new Object[]{object});
        }
        TwoFacedHashMap twoFacedHashMap = this.dataCacheEntries;
        synchronized (twoFacedHashMap) {
            if (this.expirePolicy.keepInvalidated()) {
                this.dataCacheEntries.put(object, InvalidDataCacheEntry.getInvalidDataCacheEntry());
            } else {
                this.dataCacheEntries.remove(object);
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "invalidateDataEntry ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateDataEntry() {
        TwoFacedHashMap twoFacedHashMap = this.dataCacheEntries;
        synchronized (twoFacedHashMap) {
            if (this.expirePolicy.keepInvalidated()) {
                Iterator iterator = this.dataCacheEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    this.dataCacheEntries.put(iterator.next(), InvalidDataCacheEntry.getInvalidDataCacheEntry());
                }
            } else {
                this.initTwoFacedHashMap();
            }
        }
    }

    public void invalidateQuery(Object object) {
        this.getQueryCache().removeAssociation((String)object);
    }

    public void invalidateQuery() {
        this.getQueryCache().removeAll();
    }

    public void invalidateAssociation(Object object) {
        this.getAssociationsCache().removeAssociation((String)object);
    }

    public void invalidateAssociation() {
        this.getAssociationsCache().removeAll();
    }

    public PMCacheRelationshipHelper getAsscoiationHelper() {
        return null;
    }

    public void setAssociationHelper(PMCacheRelationshipHelper pMCacheRelationshipHelper) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\nMasterCache: ");
        stringBuffer.append(",\n\tcacheID: ");
        stringBuffer.append(this.cacheID);
        stringBuffer.append("\n  isCacheInvalidationEnabled = " + CacheManagerFactory.cacheInvalidationEnabled);
        stringBuffer.append(",\n\tdataCacheEntries: ");
        stringBuffer.append(this.dataCacheEntries);
        stringBuffer.append(",\n\tassociationsCache: ");
        stringBuffer.append(this.associationsCache);
        stringBuffer.append(",\n\tqueryCache: ");
        stringBuffer.append(this.queryCache);
        return stringBuffer.toString();
    }
}

