/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.pmcache.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.PMTxInfo;
import com.ibm.ws.ejbpersistence.pmcache.impl.AssociationsCache;
import com.ibm.ws.ejbpersistence.pmcache.impl.AssociationsCacheEntry;
import com.ibm.ws.ejbpersistence.pmcache.impl.AssociationsCacheImpl;
import com.ibm.ws.ejbpersistence.pmcache.impl.InvalidDataCacheEntry;
import com.ibm.ws.ejbpersistence.pmcache.impl.MasterCache;
import com.ibm.ws.ejbpersistence.pmcache.impl.RemovedDataCacheEntry;
import com.ibm.ws.ejbpersistence.utilpm.InvalidAssociationNameException;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.TwoFacedHashMap;
import com.ibm.ws.pmcache.DataEntry;
import com.ibm.ws.pmcache.GetPolicy;
import com.ibm.ws.pmcache.PMTxCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TransactionCache
implements PMTxCache {
    private MasterCache mCache = null;
    private PMTxInfo txId = null;
    private HashMap dataCacheEntries = new HashMap();
    private static TraceComponent mytc = PMLogger.registerTC(TransactionCache.class);
    private AssociationsCacheImpl associationsCache = null;
    private AssociationsCacheImpl queryCache = null;
    private boolean invalidateAllAssociations = false;
    private boolean invalidateAllQueries = false;
    private ArrayList invalidatedAssociations = new ArrayList();
    private ArrayList invalidatedQueries = new ArrayList();

    protected void setTxId(PMTxInfo pMTxInfo) {
        this.txId = pMTxInfo;
    }

    protected void setMasterCache(MasterCache masterCache) {
        this.mCache = masterCache;
    }

    protected MasterCache getMasterCache() {
        return this.mCache;
    }

    public Object getTxId() {
        return this.txId;
    }

    public void commit(boolean bl) {
        if (bl && this.mCache.isLifeTimeInCache) {
            this.promoteCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteCache() {
        Iterator iterator = this.dataCacheEntries.keySet().iterator();
        TwoFacedHashMap twoFacedHashMap = this.mCache.dataCacheEntries;
        synchronized (twoFacedHashMap) {
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = this.dataCacheEntries.get(k);
                if (v == InvalidDataCacheEntry.getInvalidDataCacheEntry()) {
                    if (this.mCache.expirePolicy.keepInvalidated()) {
                        this.mCache.dataCacheEntries.put(k, InvalidDataCacheEntry.getInvalidDataCacheEntry());
                        continue;
                    }
                    this.mCache.dataCacheEntries.remove(k);
                    continue;
                }
                if (v == RemovedDataCacheEntry.getRemovedDataCacheEntry()) {
                    if (this.mCache.expirePolicy.keepRemoved()) {
                        this.mCache.dataCacheEntries.put(k, RemovedDataCacheEntry.getRemovedDataCacheEntry());
                        continue;
                    }
                    this.mCache.dataCacheEntries.remove(k);
                    continue;
                }
                this.mCache.dataCacheEntries.put(k, v);
            }
        }
        this.promoteAssociations();
        this.promoteQueries();
    }

    private void promoteAssociations() {
        Object object;
        if (this.invalidateAllAssociations) {
            this.mCache.associationsCache.removeAll();
        } else {
            object = this.invalidatedAssociations.iterator();
            while (object.hasNext()) {
                this.mCache.associationsCache.removeAssociation((String)object.next());
            }
        }
        object = (HashMap)this.getAssociationsCache().getAssociationCacheEntryMap();
        Iterator iterator = ((HashMap)object).keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.mCache.associationsCache.putAssociateofRole((String)k, (AssociationsCacheEntry)((HashMap)object).get(k));
        }
    }

    private void promoteQueries() {
        Object object;
        if (this.invalidateAllQueries) {
            this.mCache.queryCache.removeAll();
        } else {
            object = this.invalidatedQueries.iterator();
            while (object.hasNext()) {
                this.mCache.queryCache.removeAssociation((String)object.next());
            }
        }
        object = (HashMap)this.getQueryCache().getAssociationCacheEntryMap();
        Iterator iterator = ((HashMap)object).keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.mCache.queryCache.putAssociateofRole((String)k, (AssociationsCacheEntry)((HashMap)object).get(k));
        }
    }

    public void setCacheLoader(int n) {
    }

    public void setProperty(Map map) {
    }

    public Map getProperty() {
        return null;
    }

    public List getQuery(Object object, Object object2) {
        List list = null;
        try {
            Set set = this.getQueryCache().getAssociatesOfObject((String)object, object2);
            if (set == null) {
                if (this.mCache.isLifeTimeInCache) {
                    list = this.mCache.getQuery((String)object, object2);
                }
            } else {
                list = new ArrayList(set);
            }
        }
        catch (InvalidAssociationNameException invalidAssociationNameException) {
            return null;
        }
        return list;
    }

    public void putQuery(Object object, Object object2, List list) {
        this.getQueryCache().putAssociatesOfObject((String)object, object2, list);
    }

    public Set getQueryIdSet() {
        return this.getQueryCache().getRoleSet();
    }

    public Set getQueryInput(Object object) {
        return this.getQueryCache().getAssociationForeignKeySet(object);
    }

    public boolean contain(Object object, Object object2) {
        return false;
    }

    private AssociationsCache getAssociationsCache() {
        if (this.associationsCache == null) {
            this.associationsCache = new AssociationsCacheImpl();
        }
        return this.associationsCache;
    }

    private AssociationsCache getQueryCache() {
        if (this.queryCache == null) {
            this.queryCache = new AssociationsCacheImpl();
        }
        return this.queryCache;
    }

    public Set getAssociatedKeys(Object object, Object object2) {
        Set set = null;
        try {
            set = this.getAssociationsCache().getAssociatesOfObject((String)object, object2);
            if (set == null && this.mCache.isLifeTimeInCache) {
                set = this.mCache.getAssociatedKeys((String)object, object2);
            }
        }
        catch (InvalidAssociationNameException invalidAssociationNameException) {
            return null;
        }
        return set;
    }

    public void putAssociatedKeys(Object object, Object object2, Set set) {
        this.getAssociationsCache().putAssociatesOfObject((String)object, object2, set);
    }

    public Set getAssociationRoleSet() {
        return this.getAssociationsCache().getRoleSet();
    }

    public Set getAssociationForeignKeySet(Object object) {
        return this.getAssociationsCache().getAssociationForeignKeySet(object);
    }

    public Object getDataEntry(Object object, GetPolicy getPolicy) {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "getDataEntry(key,policy)", new Object[]{object, getPolicy});
        }
        Object object2 = null;
        object2 = getPolicy != null ? (Object)this.dataCacheEntries.remove(object) : (Object)this.dataCacheEntries.get(object);
        if (object2 != null) {
            if (object2 == RemovedDataCacheEntry.getRemovedDataCacheEntry() || object2 == InvalidDataCacheEntry.getInvalidDataCacheEntry()) {
                object2 = null;
            }
        } else if (this.mCache.isLifeTimeInCache && (object2 = this.mCache.getDataEntry(object, null)) != null && getPolicy != null && getPolicy.forUpdate() && !getPolicy.forPessimistic() && getPolicy.byValue()) {
            object2 = ((DataEntry)object2).getClone();
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "getDataEntry, returning home for entry", new Object[]{object2});
        }
        return object2;
    }

    public void putDataEntry(Object object, DataEntry dataEntry) {
        this.dataCacheEntries.put(object, dataEntry);
    }

    public boolean contains(Object object) {
        return this.getDataEntry(object, null) != null;
    }

    public boolean isRemoved(Object object) {
        Object v = this.dataCacheEntries.get(object);
        if (v != null) {
            return v == RemovedDataCacheEntry.getRemovedDataCacheEntry();
        }
        if (this.mCache.isLifeTimeInCache) {
            return this.mCache.isRemoved(object);
        }
        return false;
    }

    public Set getDataEntryKeySet() {
        Set set = this.dataCacheEntries.keySet();
        if ((set == null || set.isEmpty()) && this.mCache.isLifeTimeInCache) {
            set = this.mCache.getDataEntryKeySet();
        }
        return set;
    }

    public void removeDataEntry(Object object) {
        this.dataCacheEntries.put(object, RemovedDataCacheEntry.getRemovedDataCacheEntry());
    }

    public boolean isInvalidated(Object object) {
        Object v = this.dataCacheEntries.get(object);
        if (v != null) {
            return v == InvalidDataCacheEntry.getInvalidDataCacheEntry();
        }
        if (this.mCache.isLifeTimeInCache) {
            return this.mCache.isInvalidated(object);
        }
        return false;
    }

    public void invalidateDataEntry(Object object) {
        this.dataCacheEntries.put(object, InvalidDataCacheEntry.getInvalidDataCacheEntry());
    }

    public void invalidateDataEntry() {
        Set set = this.dataCacheEntries.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.dataCacheEntries.put(iterator.next(), InvalidDataCacheEntry.getInvalidDataCacheEntry());
        }
    }

    public void invalidateQuery(Object object) {
        this.getQueryCache().removeAssociation((String)object);
        if (!this.invalidateAllQueries) {
            this.invalidatedQueries.add(object);
        }
    }

    public void invalidateQuery() {
        this.getQueryCache().removeAll();
        this.invalidateAllQueries = true;
    }

    public void invalidateAssociation(Object object) {
        this.getAssociationsCache().removeAssociation((String)object);
        if (!this.invalidateAllAssociations) {
            this.invalidatedAssociations.add(object);
        }
    }

    public void invalidateAssociation() {
        this.getAssociationsCache().removeAll();
        this.invalidateAllAssociations = true;
    }

    public void initialize() {
        this.mCache = null;
        this.dataCacheEntries.clear();
        this.associationsCache = null;
        this.queryCache = null;
        this.txId = null;
        this.invalidateAllAssociations = false;
        this.invalidateAllQueries = false;
        this.invalidatedAssociations.clear();
        this.invalidatedQueries.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\nTransactionCache: ");
        stringBuffer.append(",\n\tdataCacheEntries: ");
        stringBuffer.append(this.dataCacheEntries);
        stringBuffer.append(",\n\tassociationsCache: ");
        stringBuffer.append(this.associationsCache);
        stringBuffer.append(",\n   mCache: ");
        stringBuffer.append(this.mCache);
        stringBuffer.append(",\n   txId: ");
        stringBuffer.append(this.txId);
        stringBuffer.append(",\n\tqueryCache: ");
        stringBuffer.append(this.queryCache);
        stringBuffer.append(",\n invalidateAllAssociations: ");
        stringBuffer.append(this.invalidateAllAssociations);
        stringBuffer.append(",\n invalidateAllQueries: ");
        stringBuffer.append(this.invalidateAllQueries);
        stringBuffer.append(",\n invalidatedAssociations: ");
        stringBuffer.append(this.invalidatedAssociations);
        stringBuffer.append(",\n invalidatedQueries: ");
        stringBuffer.append(this.invalidatedQueries);
        return stringBuffer.toString();
    }
}

