/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.esi.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.esi.channel.ESIChannelLink;
import com.ibm.ws.esi.channel.ESIDiscriminator;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundApplicationChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;

public class ESIChannel
extends InboundApplicationChannel {
    private static TraceComponent tc = Tr.register(ESIChannel.class, "ESIChannel", "com.ibm.ws.webcontainer.channel");
    private Class devSideInterface = null;
    private Discriminator disc = null;
    private ObjectPool linkPool = null;
    private int bufferSize = 32768;
    private boolean trusted = true;
    private static final String LINK_KEY = "ESIChannelLink";

    public ESIChannel(ChannelData channelData) {
        super(channelData);
        this.disc = new ESIDiscriminator(this, channelData.getDiscriminatorWeight());
        this.devSideInterface = HttpInboundServiceContext.class;
        this.linkPool = new ObjectPool("ESIC Channel Links", 100);
        Integer n = (Integer)channelData.getPropertyBag().get("buffersize");
        if (n != null) {
            this.bufferSize = n;
            Tr.debug(tc, "WebContainer channel buffer size is " + this.bufferSize);
        }
    }

    public Discriminator getDiscriminator() {
        return this.disc;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionLink", new Object[]{virtualConnection, this});
        }
        try {
            ESIChannelLink eSIChannelLink = (ESIChannelLink)((Object)virtualConnection.getStateMap().get(LINK_KEY));
            if (eSIChannelLink == null) {
                eSIChannelLink = (ESIChannelLink)((Object)this.linkPool.remove());
                if (eSIChannelLink == null) {
                    eSIChannelLink = new ESIChannelLink(virtualConnection, this);
                }
                virtualConnection.getStateMap().put(LINK_KEY, eSIChannelLink);
            }
            return eSIChannelLink;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught an exception in getConnectionLink", exception.toString());
            }
            return null;
        }
    }

    public void addLinkToPool(ESIChannelLink eSIChannelLink) {
        this.linkPool.add((Object)eSIChannelLink);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public Class getDeviceInterface() {
        return this.devSideInterface;
    }

    public void start() throws ChannelException {
    }

    public void stop(long l) throws ChannelException {
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }

    public void update(ChannelData channelData) {
    }
}

