/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.esi.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.esi.channel.ESIChannelConstants;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ESIChannelComponentImpl
extends WsComponentImpl {
    private static final TraceComponent tc = Tr.register(ESIChannelComponentImpl.class, "ESIChannelComponentImpl", "com.ibm.ws.esi.channel");

    public void start() throws RuntimeError, RuntimeWarning {
        ChannelFrameworkService channelFrameworkService = null;
        try {
            channelFrameworkService = (ChannelFrameworkService)WsServiceRegistry.getService((Object)this, (Class)ChannelFrameworkService.class);
        }
        catch (Exception exception) {
            throw new RuntimeError("Trying to get the CFWService, the ESI Service intialization throw an exception", exception);
        }
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", channelFrameworkService);
        }
        try {
            channelFrameworkService.addChannel("ESI_IN", ESIChannelConstants.ESIFactoryClass, new HashMap(), 0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "added ESI Channel with weight of 0");
            }
        }
        catch (Exception exception) {
            throw new RuntimeError("The ESI Service intialization throw an exception", exception);
        }
        ChainGroupData chainGroupData = channelFrameworkService.getChainGroup("com.ibm.ws.runtime.WebContainerImpl");
        if (chainGroupData != null) {
            List<ChainData> list = Arrays.asList(chainGroupData.getChains());
            Iterator<ChainData> iterator = list.iterator();
            while (iterator.hasNext()) {
                ChainData chainData = iterator.next();
                if (chainData.getType() == FlowType.OUTBOUND) continue;
                String string = chainData.getName();
                List<ChannelData> list2 = Arrays.asList(chainData.getChannelList());
                ArrayList<String> arrayList = new ArrayList<String>(list2.size());
                Iterator<ChannelData> iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    ChannelData channelData = iterator2.next();
                    Class clazz = channelData.getFactoryType();
                    if (clazz == ESIChannelConstants.httpInboundFactoryClass) {
                        arrayList.add(channelData.getName());
                        arrayList.add("ESI_IN");
                        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                        try {
                            channelFrameworkService.addChain(string + "_" + "ESI_Inbound", FlowType.INBOUND, stringArray, "com.ibm.ws.runtime.WebContainerImpl");
                            break;
                        }
                        catch (Exception exception) {
                            throw new RuntimeError("Trying to start the chain, the ESI Service intialization throw an exception", exception);
                        }
                    }
                    arrayList.add(channelData.getName());
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Updating chain " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }
}

