/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.esi.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.esi.channel.ESIChannel;
import com.ibm.ws.esi.channel.ESIChannelComponentImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.base.ApplicationChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class ESIChannelFactory
extends ApplicationChannelFactory
implements WSChannelFactory {
    private static TraceComponent tc = Tr.register(ESIChannelFactory.class, "ESIChannelFactory", "com.ibm.ws.esi.channel");
    private Class[] devSideInterfaces = new Class[]{HttpInboundServiceContext.class};

    protected Channel createChannel(ChannelData channelData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createChannel", new Object[]{channelData, this});
        }
        ESIChannel eSIChannel = null;
        try {
            eSIChannel = new ESIChannel(channelData);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ESI channel created");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.esi.channel.ESIChannelFactory", "57", this);
            Tr.debug(tc, "Exception creating channel: " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createChannel", (Object)eSIChannel);
        }
        return eSIChannel;
    }

    public Class[] getDeviceInterface() {
        return this.devSideInterfaces;
    }

    public void destroy() {
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return ESIChannelComponentImpl.class.getName();
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        return null;
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) {
        WebContainerInboundChannel webContainerInboundChannel = (WebContainerInboundChannel)transportChannel;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Integer n = new Integer(webContainerInboundChannel.getWriteBufferSize());
        hashMap.put("buffersize", n);
        EList eList = webContainerInboundChannel.getProperties();
        if (null != eList) {
            Iterator iterator = eList.iterator();
            Property property = null;
            while (iterator.hasNext()) {
                property = (Property)iterator.next();
                hashMap.put(property.getName().toLowerCase(), property.getValue());
            }
        }
        return hashMap;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return null;
    }

    public void init(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
    }
}

