/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.esi.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.esi.channel.ESIChannel;
import com.ibm.ws.esi.channel.KMP;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ESIChannelLink
extends InboundApplicationLink
implements InterChannelCallback {
    private static TraceComponent tc = Tr.register(ESIChannelLink.class, "ESIChannelLink", "com.ibm.ws.esi.channel");
    private HttpInboundServiceContext isc = null;
    private Class esiServiceClass = null;
    private Method addConnMethod = null;
    private Class[] parameters = null;
    private String serverName = null;
    private int serverPort = -1;
    private WsByteBufferPoolManagerImpl buffMgr = null;
    private static final byte[] MSG_END_1 = new byte[]{0, 0, 0, 6, 0, 0, 0, 6};
    private static final byte[] MSG_END_2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 6};

    public ESIChannelLink(VirtualConnection virtualConnection, ESIChannel eSIChannel) {
    }

    public void init(VirtualConnection virtualConnection) {
        block6: {
            block5: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Init --> " + virtualConnection.toString());
                }
                this.isc = (HttpInboundServiceContext)this.getDeviceLink().getChannelAccessor();
                super.init(virtualConnection);
                this.buffMgr = (WsByteBufferPoolManagerImpl)WsByteBufferPoolManagerImpl.getRef();
                this.parameters = new Class[1];
                this.parameters[0] = ESIChannelLink.class;
                try {
                    this.esiServiceClass = Class.forName("com.ibm.ws.cache.esi.ESIInvalidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "could not find ESIInvalidator Class");
                }
            }
            try {
                this.addConnMethod = this.esiServiceClass.getMethod("addConnection", this.parameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "addConnection method was not found");
            }
        }
    }

    public void complete(VirtualConnection virtualConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "complete called on " + this.vc.toString());
        }
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "error called on " + this.vc.toString() + " " + throwable.getMessage());
        }
    }

    public void ready(VirtualConnection virtualConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Ready --> " + virtualConnection.toString());
        }
        this.init(virtualConnection);
        Object[] objectArray = new Object[]{this};
        try {
            this.addConnMethod.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Method addConnection invocation failed: " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("Method addConnection invocation failed: " + invocationTargetException);
        }
    }

    public void sendMessageHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendMessageHeaders");
        }
        try {
            this.isc.sendResponseHeaders();
        }
        catch (IOException iOException) {
            Tr.debug(tc, "Error1 in sendMessageHeaders " + iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (MessageSentException messageSentException) {
            Tr.debug(tc, "Error2 in sendMessageHeaders " + messageSentException.getMessage());
            messageSentException.printStackTrace();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendMessageHeaders");
        }
    }

    public void sendIt(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendIt", new Object[]{byArray});
        }
        WsByteBuffer wsByteBuffer = this.buffMgr.wrap(byArray);
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{wsByteBuffer};
        try {
            this.isc.sendResponseBody(wsByteBufferArray);
        }
        catch (IOException iOException) {
            Tr.debug(tc, "Error1 in sendIt " + iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (MessageSentException messageSentException) {
            Tr.debug(tc, "Error2 in sendIt " + messageSentException.getMessage());
            messageSentException.printStackTrace();
        }
        wsByteBuffer.release();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendIt");
        }
    }

    public byte[] sendItAndGetReply(byte[] byArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendItAndGetReply", new Object[]{byArray, bl});
        }
        WsByteBuffer wsByteBuffer = this.buffMgr.wrap(byArray);
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{wsByteBuffer};
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "data wrapped, sending data");
            }
            this.isc.sendResponseBody(wsByteBufferArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sending data complete");
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Error while calling sendItAndGetReply");
            exception.printStackTrace();
        }
        byte[] byArray2 = this.getReply(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendItAndGetReply");
        }
        return byArray2;
    }

    private byte[] expandArray(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        if (null != byArray) {
            byArray3 = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "expanded array length: " + byArray3.length);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NO array expansion: ");
            }
            byArray3 = byArray2;
        }
        return byArray3;
    }

    public byte[] getReply(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getReply", bl);
        }
        boolean bl2 = false;
        byte[] byArray = this.getOneBuffer();
        if (bl && null != byArray) {
            while (!this.parseMessageForMsgEnd(byArray, bl2)) {
                bl2 = true;
                byte[] byArray2 = this.getOneBuffer();
                byArray = this.expandArray(byArray2, byArray);
                if (null != byArray2) continue;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "We are just spinning wheels at this point. Nothing more to recv from plugin");
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getReply", byArray);
        }
        return byArray;
    }

    public byte[] getOneBuffer() {
        WsByteBuffer wsByteBuffer;
        block7: {
            wsByteBuffer = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting a reply");
                }
                wsByteBuffer = this.isc.getRequestBodyBuffer();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "read a reply...will release when done " + wsByteBuffer);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, exception.getMessage());
                exception.printStackTrace();
            }
        }
        byte[] byArray = null;
        if (null != wsByteBuffer) {
            byArray = new byte[wsByteBuffer.capacity()];
            wsByteBuffer.get(byArray);
            wsByteBuffer.release();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "replyData", byArray + " replyData length -> " + byArray.length);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneBuffer");
        }
        return byArray;
    }

    private boolean parseMessageForMsgEnd(byte[] byArray, boolean bl) {
        KMP kMP;
        boolean bl2;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "parseMessageForMsgEnd");
        }
        if (!(bl2 = (kMP = new KMP(byArray, MSG_END_1)).match()) && !bl) {
            KMP kMP2 = new KMP(byArray, MSG_END_2);
            kMP2.setStartPoint(byArray.length - MSG_END_2.length);
            if (kMP2.match()) {
                bl2 = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "parseMessageForMsgEnd", bl2);
        }
        return bl2;
    }

    private int convertCharToLength(int n, int n2) {
        int n3 = 0;
        if (48 <= n && 57 >= n) {
            n3 = n - 48;
        } else if (97 <= n && 102 >= n) {
            n3 = n - 97 + 10;
        } else if (65 <= n && 70 >= n) {
            n3 = n - 65 + 10;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Client sent a bad chunk: " + n);
        }
        n2 <<= 4;
        return n2 += n3;
    }

    public String getRequestURI() {
        try {
            return new String(this.isc.getRequest().getRequestURI());
        }
        catch (Exception exception) {
            return this.isc.getRequest().getRequestURI();
        }
    }

    public String getServerName() {
        if (this.serverName == null) {
            if (this.isc.getRequest().containsHeader(HttpConstants.HDR_$WSSN)) {
                this.serverName = this.isc.getRequest().getHeaderAsString(HttpConstants.HDR_$WSSN);
                if (this.serverName != null && this.serverName.length() > 0) {
                    return this.serverName;
                }
            }
            this.serverName = this.isc.getRequest().getVirtualHost();
            if (this.serverName == null) {
                this.serverName = new String("localhost");
            }
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (this.serverPort == -1) {
            this.serverPort = this.isc.getRemotePort();
            if (this.serverPort == -1) {
                this.serverPort = 80;
            }
        }
        return this.serverPort;
    }

    public String getRequestURIAsByteArray() {
        try {
            return new String(this.isc.getRequest().getRequestURIAsByteArray());
        }
        catch (Exception exception) {
            return this.isc.getRequest().getRequestURI();
        }
    }
}

