/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.esi.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

class KMP {
    private byte[] x;
    private byte[] y;
    private int[] kmpNext;
    int startPoint = 0;
    int matchPoint = -1;
    int m = -1;
    int n = -1;
    private static TraceComponent tc = Tr.register(KMP.class, "ESIChannelLink", "com.ibm.ws.esi.channel");

    public KMP(byte[] byArray, byte[] byArray2) {
        this.x = byArray;
        this.n = this.x.length;
        this.y = byArray2;
        this.m = this.y.length;
        this.kmpNext = new int[this.m + 1];
    }

    public boolean match() {
        if (this.x.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "string " + this.x.length + " pattern " + this.y.length);
            }
            return false;
        }
        boolean bl = false;
        this.preProcess();
        int n = 0;
        for (int i = 0; i < this.n; ++i) {
            while (n >= 0 && this.x[i] != this.y[n]) {
                n = this.kmpNext[n];
            }
            if (++n != this.m) continue;
            this.matchPoint = i - n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Matched pattern " + String.valueOf(this.y) + " at " + this.matchPoint);
            }
            bl = true;
            break;
        }
        return bl;
    }

    private void preProcess() {
        int n;
        int n2 = 0;
        this.kmpNext[n2] = n = -1;
        while (n2 < this.m) {
            while (n >= 0 && this.y[n2] != this.y[n]) {
                n = this.kmpNext[n];
            }
            this.kmpNext[++n2] = ++n;
        }
    }

    public int getMatchPoint() {
        return this.matchPoint;
    }

    public void setStartPoint(int n) {
        if (n < 0 || n >= this.x.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "startPoint NOT SET. passed in " + n);
            }
            return;
        }
        this.startPoint = n;
        this.x = this.copyOfRange(this.x, n, this.x.length);
        this.n = this.x.length;
    }

    private byte[] copyOfRange(byte[] byArray, int n, int n2) {
        if (n <= n2) {
            if (byArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, byArray.length - n);
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n, byArray2, 0, n4);
                return byArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }
}

