/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extensionhelper.db.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.extensionhelper.exception.UnableToInitializeException;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import java.util.Map;
import java.util.Properties;

final class DBData
implements FFDCSelfIntrospectable {
    private static final TraceComponent TC = Tr.register(DBData.class.getName(), "", "HAManager");
    private String userName;
    private String passWord;
    private String tablePrefix;
    private String statementsFile;
    private Map replaceMap;
    private String dataSourceJNDIName;
    private String dataSourceClassName = null;
    private String dataSourceClasspath = null;
    private Properties dataSourceProps = null;

    public DBData(Map map) throws UnableToInitializeException {
        if (!map.containsKey("dbhelper.jndi.name")) {
            throw new UnableToInitializeException("All required keys were not found");
        }
        this.userName = (String)map.get("dbhelper.username");
        this.passWord = (String)map.get("dbhelper.password");
        this.tablePrefix = (String)map.get("dbhelper.table.prefix");
        this.replaceMap = (Map)map.get("dbhelper.replacement.map");
        this.statementsFile = (String)map.get("dbhelper.statements.file");
        this.dataSourceJNDIName = (String)map.get("dbhelper.jndi.name");
        this.dataSourceClassName = (String)map.get("dbhelper.datasource.classname");
        this.dataSourceClasspath = (String)map.get("dbhelper.datasource.classpath");
        this.dataSourceProps = (Properties)map.get("dbhelper.datasource.properties");
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "DBData()", new Object[]{this.userName, "******", this.tablePrefix, this.statementsFile, this.replaceMap, this.dataSourceJNDIName});
        }
    }

    public String getPassWord() {
        return this.passWord;
    }

    public Map getReplaceMap() {
        return this.replaceMap;
    }

    public String getStatementsFile() {
        return this.statementsFile;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDataSourceJNDIName() {
        return this.dataSourceJNDIName;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public String getDataSourceClasspath() {
        return this.dataSourceClasspath;
    }

    public Properties getDataSourceProps() {
        return this.dataSourceProps;
    }

    public String[] introspectSelf() {
        return new String[]{this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)), "User name = " + this.userName, "Password = ******", "Table prefix = " + this.tablePrefix, "DataSource JNDI name = " + this.dataSourceJNDIName, "DataSource class name = " + this.dataSourceClassName, "DataSource class path = " + this.dataSourceClasspath, "DataSource properties = " + this.dataSourceProps, "StatementsFile = " + this.statementsFile, "ReplaceMap = " + this.replaceMap};
    }
}

