/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extensionhelper.db.impl;

import com.ibm.ejs.cm.portability.PortableDataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.JDBCConnectionSpec;
import com.ibm.websphere.rsadapter.WSDataSource;
import com.ibm.websphere.rsadapter.WSRRAFactory;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.extensionhelper.InternalDatabaseHelper;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.extensionhelper.db.impl.DBConnectionWrapper;
import com.ibm.ws.extensionhelper.db.impl.DBData;
import com.ibm.ws.extensionhelper.db.impl.ExtensionComponentMetaData;
import com.ibm.ws.extensionhelper.exception.InconsistentTransactionException;
import com.ibm.ws.extensionhelper.exception.UnableToInitializeException;
import com.ibm.ws.extensionhelper.exception.UnknownDatabaseException;
import com.ibm.ws.extensionhelper.tran.impl.TxHandleDBImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaData;
import com.ibm.ws.runtime.metadata.CustomContainerComponentMetaDataImpl;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;

public class DatabaseHelperImpl
implements InternalDatabaseHelper {
    private static final TraceComponent TC = Tr.register(DatabaseHelperImpl.class, "ExtHelper", "com.ibm.ws.extensionhelper.tran.impl.ExtensionHelperMessages");
    private static final ComponentMetaDataAccessorImpl metadataAccessor = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    protected String dbVendor = null;
    protected Properties props = null;
    protected DSWrapper dsWrapper = null;
    protected DBData dataBaseData = null;
    private int resourceAuthentication = 1;
    private int resourceSharing = 0;
    private int resourceIsolation = 2;
    protected int totalConnections = 0;
    protected TransactionControl tranControl = null;
    protected UOWCurrent uowCurrent = null;
    static Properties empty_props = new Properties();
    protected String databaseVendor = null;
    protected String databaseProductVersion = null;
    protected String driverName = null;
    protected String driverVersion = null;
    protected boolean dataSourceDirect = false;
    protected boolean supportsReadUncommitted = false;
    protected boolean supportsReadCommitted = false;
    protected boolean supportsRepeatableRead = false;
    protected boolean supportsSerializable = false;
    protected boolean supportsSnapshot = false;
    protected boolean supportsSSSnapshot = false;
    protected JDBCConnectionSpec connSpecReadUncommitted;
    protected JDBCConnectionSpec connSpecReadCommitted;
    protected JDBCConnectionSpec connSpecRepeatableRead;
    protected JDBCConnectionSpec connSpecSerializable;
    protected JDBCConnectionSpec connSpecSnapshot;
    protected JDBCConnectionSpec connSpecSSSnapshot;

    protected DatabaseHelperImpl() {
    }

    public DatabaseHelperImpl(TransactionControl transactionControl, Map map) throws UnableToInitializeException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "<init>", new Object[]{transactionControl, DatabaseHelperImpl.hidePassword(map)});
        }
        if (map == null || map.size() < 1) {
            throw new IllegalArgumentException("param SchedulerConfiguration should be non-null");
        }
        this.setup(transactionControl, map);
        this.initialize(map);
        this.supportsTranIsoLevel();
        this.connSpecReadUncommitted = WSRRAFactory.createJDBCConnectionSpec();
        this.connSpecReadUncommitted.setTransactionIsolation(1);
        this.connSpecReadUncommitted.setUserName(this.dataBaseData.getUserName());
        this.connSpecReadUncommitted.setPassword(this.dataBaseData.getPassWord());
        this.connSpecReadCommitted = WSRRAFactory.createJDBCConnectionSpec();
        this.connSpecReadCommitted.setTransactionIsolation(2);
        this.connSpecReadCommitted.setUserName(this.dataBaseData.getUserName());
        this.connSpecReadCommitted.setPassword(this.dataBaseData.getPassWord());
        this.connSpecRepeatableRead = WSRRAFactory.createJDBCConnectionSpec();
        this.connSpecRepeatableRead.setTransactionIsolation(4);
        this.connSpecRepeatableRead.setUserName(this.dataBaseData.getUserName());
        this.connSpecRepeatableRead.setPassword(this.dataBaseData.getPassWord());
        this.connSpecSerializable = WSRRAFactory.createJDBCConnectionSpec();
        this.connSpecSerializable.setTransactionIsolation(8);
        this.connSpecSerializable.setUserName(this.dataBaseData.getUserName());
        this.connSpecSerializable.setPassword(this.dataBaseData.getPassWord());
        this.connSpecSnapshot = WSRRAFactory.createJDBCConnectionSpec();
        this.connSpecSnapshot.setTransactionIsolation(16);
        this.connSpecSnapshot.setUserName(this.dataBaseData.getUserName());
        this.connSpecSnapshot.setPassword(this.dataBaseData.getPassWord());
        this.connSpecSSSnapshot = WSRRAFactory.createJDBCConnectionSpec();
        this.connSpecSSSnapshot.setTransactionIsolation(4096);
        this.connSpecSSSnapshot.setUserName(this.dataBaseData.getUserName());
        this.connSpecSSSnapshot.setPassword(this.dataBaseData.getPassWord());
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "<init>");
        }
    }

    private void beginContext() {
        CustomContainerComponentMetaDataImpl customContainerComponentMetaDataImpl = new CustomContainerComponentMetaDataImpl(metadataAccessor.getComponentMetaData());
        CustomContainerComponentMetaData.CustomLocalTranCfg customLocalTranCfg = customContainerComponentMetaDataImpl.getCustomLocalTranConfigData();
        customLocalTranCfg.setValueBoundary(0);
        customLocalTranCfg.setValueResolver(0);
        customLocalTranCfg.setValueUnresolvedAction(0);
        CustomContainerComponentMetaData.CustomResRefList customResRefList = customContainerComponentMetaDataImpl.getCustomResourceRefList();
        customResRefList.addResRef("Extension Helper Custom JDBC Res-Ref", this.dataBaseData.getDataSourceJNDIName(), this.dataBaseData.getDataSourceJNDIName(), "javax.resource.cci.ConnectionFactory", this.resourceAuthentication, this.resourceSharing, this.resourceIsolation);
        metadataAccessor.beginContext(customContainerComponentMetaDataImpl);
    }

    private static Map hidePassword(Map hashMap) {
        if (hashMap != null) {
            if ((hashMap = new HashMap<String, String>(hashMap)).containsKey("dbhelper.password")) {
                hashMap.put("dbhelper.password", "******");
            }
            if (hashMap.containsKey("password")) {
                hashMap.put("password", "******");
            }
        }
        return hashMap;
    }

    protected void setup(TransactionControl transactionControl, Map map) throws UnableToInitializeException {
        this.tranControl = transactionControl;
        this.uowCurrent = TransactionManagerFactory.getUOWCurrent();
        this.dataBaseData = new DBData(map);
        this.props = new Properties();
        Map map2 = this.dataBaseData.getReplaceMap();
        if (this.dataBaseData.getStatementsFile() != null && this.dataBaseData.getStatementsFile().length() > 0) {
            Object object;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Loading statements file: " + this.dataBaseData.getStatementsFile());
            }
            try {
                object = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.dataBaseData.getStatementsFile());
                if (object != null) {
                    this.props.load(new BufferedInputStream((InputStream)object));
                } else if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Unable to load statements file: " + this.dataBaseData.getStatementsFile());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.DatabaseHelperImpl", "144", this);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Exception loading statements file: " + exception.getMessage(), exception);
                }
                throw new UnableToInitializeException(exception);
            }
            object = this.props.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = this.props.getProperty(string);
                string2.trim();
                string2 = this.replaceString(string2, "<table_prefix>", this.dataBaseData.getTablePrefix());
                if (map2 != null) {
                    Iterator iterator = map2.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        String string4 = (String)map2.get(string3);
                        string2 = this.replaceString(string2, string3, string4);
                    }
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Replacing property: " + string + "=" + string2);
                }
                this.props.setProperty(string, string2);
            }
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "No statements file specified.");
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "Statement Properties: ", this.props);
        }
    }

    private void initialize(Map map) throws UnableToInitializeException {
        ComponentMetaDataAccessorImpl componentMetaDataAccessorImpl = null;
        boolean bl = false;
        String string = this.dataBaseData.getDataSourceJNDIName();
        String string2 = this.dataBaseData.getDataSourceClassName();
        try {
            Object object;
            if (map != null) {
                object = this.props.get("com.ibm.ws.extension-helper.AUTHORIZATION");
                if (object != null) {
                    this.resourceAuthentication = Integer.parseInt(object.toString());
                }
                if ((object = this.props.get("com.ibm.ws.extension-helper.SHARING")) != null) {
                    this.resourceSharing = Integer.parseInt(object.toString());
                }
                if ((object = this.props.get("com.ibm.ws.extension-helper.TRANSACTION")) != null) {
                    this.resourceIsolation = Integer.parseInt(object.toString());
                }
            }
            componentMetaDataAccessorImpl = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            componentMetaDataAccessorImpl.beginContext(new ExtensionComponentMetaData(map));
            bl = true;
            if (DatabaseHelperImpl.isDirectDBAccess(string2)) {
                this.dataSourceDirect = true;
                this.dsWrapper = new DSWrapper(string2, this.dataBaseData.getUserName(), this.dataBaseData.getPassWord(), this.dataBaseData.getDataSourceProps());
            } else {
                object = new InitialContext();
                DataSource dataSource = (DataSource)((InitialContext)object).lookup(string);
                this.dsWrapper = new DSWrapper(dataSource, this.dataBaseData.getUserName(), this.dataBaseData.getPassWord());
            }
            this.connect();
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "353", this);
            throw new UnableToInitializeException(namingException);
        }
        catch (UnableToInitializeException unableToInitializeException) {
            throw unableToInitializeException;
        }
        catch (Throwable throwable) {
            throw new UnableToInitializeException(throwable);
        }
        finally {
            if (bl) {
                componentMetaDataAccessorImpl.endContext();
            }
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "<init>");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void connect() throws UnableToInitializeException {
        boolean bl = TC.isDebugEnabled();
        Connection connection = null;
        TxHandle txHandle = null;
        try {
            block40: {
                txHandle = this.tranControl.preinvoke();
                connection = this.getConnection(txHandle);
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                this.databaseVendor = databaseMetaData.getDatabaseProductName();
                this.databaseProductVersion = databaseMetaData.getDatabaseProductVersion();
                this.driverName = databaseMetaData.getDriverName();
                this.driverVersion = databaseMetaData.getDriverVersion();
                if (bl) {
                    Tr.debug(TC, "DataSource Class: " + this.dsWrapper.getRealDataSource().getClass().getName());
                    Tr.debug(TC, "Database product: " + this.databaseVendor);
                    Tr.debug(TC, "Database version: " + this.databaseProductVersion);
                    Tr.debug(TC, "Driver name:      " + this.driverName);
                    Tr.debug(TC, "Driver version:   " + this.driverVersion);
                }
                if (this.databaseVendor.startsWith("QSQ") || this.databaseVendor.lastIndexOf("AS/400") != -1 || this.databaseVendor.equals("AS")) {
                    this.dbVendor = "DB2ISERIES";
                } else if (this.databaseVendor.startsWith("DSN")) {
                    this.dbVendor = "DB2ZSERIES";
                } else if (this.databaseVendor.lastIndexOf("DB2") != -1 || this.databaseVendor.startsWith("SQL")) {
                    this.dbVendor = "DB2";
                } else if (this.databaseVendor.lastIndexOf("Derby") != -1) {
                    this.dbVendor = "DERBY";
                } else if (this.databaseVendor.lastIndexOf("db2j") != -1 || this.databaseVendor.lastIndexOf("Cloudscape") != -1) {
                    this.dbVendor = "DB2j";
                } else if (this.databaseVendor.lastIndexOf("Oracle") != -1) {
                    this.dbVendor = this.isOracleThick(databaseMetaData) ? "ORACLETHICK" : "ORACLE";
                } else if (this.databaseVendor.lastIndexOf("sqlany") != -1 || this.databaseVendor.lastIndexOf("Sybase") != -1 || this.databaseVendor.lastIndexOf("Adaptive Server") != -1) {
                    this.dbVendor = "SYBASE";
                } else {
                    if (this.databaseVendor.lastIndexOf("ifx") != -1 || this.databaseVendor.lastIndexOf("Informix") != -1 || this.databaseVendor.lastIndexOf("INFORMIX") != -1) {
                        int n = 9;
                        String string = null;
                        try {
                            String string2 = databaseMetaData.getDatabaseProductVersion();
                            if (string2 != null && string2.length() > 1) {
                                int n2 = string2.indexOf(".");
                                string = string2.substring(0, n2);
                                n = Integer.parseInt(string);
                            }
                            if (n == 7) {
                                this.dbVendor = "INFORMIX7";
                                break block40;
                            }
                            this.dbVendor = "INFORMIX";
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "309", this);
                            if (bl) {
                                Tr.debug(TC, "Caught exception determing database version: ", new Object[]{string, throwable});
                            }
                            break block40;
                        }
                    }
                    if (this.databaseVendor.lastIndexOf("mssql") == -1) {
                        if (this.databaseVendor.lastIndexOf("Microsoft SQL") == -1) throw new UnknownDatabaseException("Could not detect database vendor. Vendor string was " + this.databaseVendor);
                    }
                    this.dbVendor = this.databaseProductVersion.lastIndexOf("Microsoft SQL Server  7.00") != -1 || this.databaseProductVersion.lastIndexOf("07.00.") != -1 ? "MSSQL7" : "MSSQL";
                }
            }
            if (bl) {
                Tr.debug(TC, "Detected DatabaseType:   " + this.dbVendor);
            }
            if (txHandle != null) {
                this.tranControl.postinvoke(txHandle);
            }
            txHandle = null;
        }
        catch (NotSupportedException notSupportedException) {
            try {
                FFDCFilter.processException((Throwable)notSupportedException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "358", this);
                throw new UnableToInitializeException(notSupportedException);
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "363", this);
                    throw new UnableToInitializeException(systemException);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "368", this);
                    throw new UnableToInitializeException(sQLException);
                }
                catch (InvalidTransactionException invalidTransactionException) {
                    FFDCFilter.processException((Throwable)invalidTransactionException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "373", this);
                    throw new UnableToInitializeException(invalidTransactionException);
                }
                catch (InconsistentTransactionException inconsistentTransactionException) {
                    FFDCFilter.processException((Throwable)inconsistentTransactionException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "378", this);
                    throw new UnableToInitializeException(inconsistentTransactionException);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.returnConnection(connection);
                    connection = null;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "391", this);
                }
                if (txHandle == null) throw throwable;
                try {
                    this.tranControl.handleException(txHandle);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (!TC.isDebugEnabled()) throw throwable;
                    Tr.debug(TC, "Exception from postinvoke", throwable2);
                }
                throw throwable;
            }
        }
        try {
            this.returnConnection(connection);
            connection = null;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.initialize", "391", this);
        }
        if (txHandle == null) return;
        try {
            this.tranControl.handleException(txHandle);
            return;
        }
        catch (Throwable throwable) {
            if (!TC.isDebugEnabled()) return;
            Tr.debug(TC, "Exception from postinvoke", throwable);
            return;
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection = null;
        try {
            connection = this.dsWrapper.getConnection();
            if (this.uowCurrent.getUOWType() != 2) {
                connection.setAutoCommit(false);
            }
            this.incConnections();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Retrieved connection for " + this.dataBaseData.getUserName() + ".  Total=" + this.totalConnections + ". ISOLEVEL=" + connection.getTransactionIsolation());
            }
        }
        catch (ResourceException resourceException) {
            Throwable throwable = resourceException.getCause();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            FFDCFilter.processException((Throwable)resourceException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.getConnection", "527", this);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Resource Exception detected", (Object)resourceException);
            }
            throw new SQLException("ResourceException " + resourceException.getMessage());
        }
        return connection;
    }

    public synchronized void returnConnection(Connection connection) throws SQLException {
        if (connection != null) {
            connection.close();
            --this.totalConnections;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Returned connection for " + this.dataBaseData.getUserName() + ".  Total=" + this.totalConnections);
            }
        }
    }

    public String getRealTableName(String string) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getRealTableName()", this.dataBaseData.getTablePrefix() + string);
        }
        return this.dataBaseData.getTablePrefix() + string;
    }

    public void dumpSQLExceptionInfo(Throwable throwable) {
        if (throwable != null && throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "SQLException Info: Vendor Error Code=" + sQLException.getErrorCode() + ", ANSI-92 SQL State=" + sQLException.getSQLState() + ", Message:" + sQLException.getMessage());
                this.dumpNestedSQLException(sQLException);
            }
        }
    }

    public void dumpNestedSQLException(SQLException sQLException) {
        SQLException sQLException2 = sQLException.getNextException();
        if (sQLException2 != null) {
            if (sQLException2 instanceof SQLException) {
                SQLException sQLException3 = sQLException2;
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "SQLException Info: Vendor Error Code=" + sQLException3.getErrorCode() + ", ANSI 92 SQL State=" + sQLException3.getSQLState() + ", Message:" + sQLException3.getMessage());
                    this.dumpNestedSQLException(sQLException3);
                }
            } else if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Nested SQLException Info: " + new Object[]{sQLException2});
            }
        }
    }

    public String getTablePrefixName() {
        return this.dataBaseData.getTablePrefix();
    }

    public DataSource getDataSource() {
        return this.dsWrapper.getDataSource();
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.dsWrapper.directDS == null ? Thread.currentThread().getContextClassLoader() : this.dsWrapper.directDS.getClass().getClassLoader();
        return Class.forName(string, false, classLoader);
    }

    protected boolean isOracleThick(DatabaseMetaData databaseMetaData) {
        boolean bl = false;
        if (databaseMetaData != null) {
            try {
                String string = databaseMetaData.getURL();
                if (string != null && string.toLowerCase().indexOf("oracle:oci") > 1) {
                    bl = true;
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Oracle URL is: " + string + ".  isThickDriver=" + bl);
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.isOracleThick", "599", this);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Exception caught while getting Oracle DataSource URL  Defaulting to Thin driver: ", sQLException);
                }
                this.dumpSQLExceptionInfo(sQLException);
            }
        }
        return bl;
    }

    public String getDatabaseType() {
        return this.dbVendor;
    }

    public String getSQLStatement(String string, String string2) {
        String string3;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getSQLStatement", new Object[]{string, string2});
        }
        if ((string3 = this.getSQLStatement(string, string2, this.dbVendor)) == null) {
            string3 = this.getSQLStatement(string, string2, "DEFAULT");
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getSQLStatement", string3);
        }
        return string3;
    }

    public String getSQLStatement(String string, String string2, String string3) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getSQLStatement", new Object[]{string, string2, string3});
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "Looking for property " + string2 + "_" + string3 + "_" + string);
        }
        String string4 = this.props.getProperty(string2 + "_" + string3 + "_" + string);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getSQLStatement", string4);
        }
        return string4;
    }

    protected String replaceString(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public boolean existsTable(String string) {
        return this.existsTable(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean existsTable(String string, Connection connection) {
        boolean bl;
        block80: {
            boolean bl2;
            TxHandle txHandle;
            ResultSet resultSet;
            boolean bl3;
            block77: {
                block78: {
                    block76: {
                        SQLException sQLException3222;
                        block74: {
                            block73: {
                                DatabaseMetaData databaseMetaData;
                                if (TC.isEntryEnabled()) {
                                    Tr.entry(TC, "existsTable()", string);
                                }
                                bl3 = TC.isDebugEnabled();
                                resultSet = null;
                                txHandle = null;
                                bl = true;
                                bl2 = connection == null;
                                String[] stringArray = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM"};
                                if (bl2) {
                                    this.beginContext();
                                    txHandle = this.tranControl.preinvoke(true, false);
                                    connection = this.getConnection(txHandle);
                                }
                                String[] stringArray2 = this.getTableParts(string);
                                if (bl3) {
                                    Tr.debug(TC, "TableParts: CATALOG=" + stringArray2[0] + ", SCHEMA=" + stringArray2[1] + ", TABLE=" + stringArray2[2]);
                                }
                                String string2 = stringArray2[2];
                                String string3 = stringArray2[1];
                                String string4 = stringArray2[0];
                                if (string3 == null) {
                                    if (bl3) {
                                        Tr.debug(TC, "Skipping getTables because schemaName is unspecified.");
                                    }
                                    bl = this.existsTableByQuery(string, connection);
                                    break block73;
                                }
                                if (string4 == null) {
                                    try {
                                        string4 = connection.getCatalog();
                                    }
                                    catch (SQLException sQLException2) {
                                        // empty catch block
                                    }
                                }
                                if ((resultSet = (databaseMetaData = connection.getMetaData()).getTables(string4, string3, string2, stringArray)).next()) break block73;
                                if (bl3) {
                                    Tr.debug(TC, "getTables returned no data.");
                                }
                                if (this.dbVendor.equals("DB2j") || this.dbVendor.equals("DERBY")) {
                                    if (bl3) {
                                        Tr.debug(TC, "Unable to find case-sensitive table for Cloudscape (or Derby).  Trying upper-case table.");
                                    }
                                    resultSet = databaseMetaData.getTables(string4 == null ? null : string4.toUpperCase(), string3 == null ? null : string3.toUpperCase(), string2 == null ? null : string2.toUpperCase(), stringArray);
                                }
                                if (resultSet.next()) break block73;
                                if (bl3) {
                                    Tr.debug(TC, "No table found");
                                }
                                bl = false;
                            }
                            Object var15_16 = null;
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (SQLException sQLException3222) {
                                    FFDCFilter.processException((Throwable)sQLException3222, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "800", this);
                                    if (!TC.isDebugEnabled()) break block74;
                                    Tr.debug(TC, "Caught unexpected exception: " + sQLException3222.getMessage(), sQLException3222);
                                }
                            }
                        }
                        if (bl2) {
                            block75: {
                                try {
                                    connection.commit();
                                }
                                catch (SQLException sQLException3222) {
                                    FFDCFilter.processException((Throwable)sQLException3222, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "805", this);
                                    if (!TC.isDebugEnabled()) break block75;
                                    Tr.debug(TC, "Caught unexpected exception while committing the local connection: " + sQLException3222.getMessage(), sQLException3222);
                                }
                            }
                            try {
                                this.returnConnection(connection);
                            }
                            catch (SQLException sQLException3222) {
                                FFDCFilter.processException((Throwable)sQLException3222, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "813", this);
                                if (!TC.isDebugEnabled()) break block76;
                                Tr.debug(TC, "Caught unexpected exception: " + sQLException3222.getMessage(), sQLException3222);
                            }
                        }
                    }
                    Object var18_25 = null;
                    if (txHandle == null) break block77;
                    try {
                        this.tranControl.postinvoke(txHandle);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                        if (!TC.isDebugEnabled()) break block78;
                        Tr.debug(TC, "Caught unexpected exception: " + throwable.getMessage(), throwable);
                    }
                }
                metadataAccessor.endContext();
            }
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "existsTable", new Boolean(bl));
            }
            break block80;
            {
                catch (RuntimeException runtimeException2) {
                    FFDCFilter.processException((Throwable)runtimeException2, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "822", this);
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "Caught unexpected exception: " + runtimeException2.getMessage(), runtimeException2);
                    }
                    Object var18_26 = null;
                    if (txHandle != null) {
                        block79: {
                            try {
                                this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                                if (!TC.isDebugEnabled()) break block79;
                                Tr.debug(TC, "Caught unexpected exception: " + throwable.getMessage(), throwable);
                            }
                        }
                        metadataAccessor.endContext();
                    }
                    if (TC.isEntryEnabled()) {
                        Tr.exit(TC, "existsTable", new Boolean(bl));
                    }
                    break block80;
                }
            }
            catch (Throwable throwable) {
                Object var18_27 = null;
                if (txHandle != null) {
                    block81: {
                        try {
                            this.tranControl.postinvoke(txHandle);
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException(throwable2, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                            if (!TC.isDebugEnabled()) break block81;
                            Tr.debug(TC, "Caught unexpected exception: " + throwable2.getMessage(), throwable2);
                        }
                    }
                    metadataAccessor.endContext();
                }
                if (TC.isEntryEnabled()) {
                    Tr.exit(TC, "existsTable", new Boolean(bl));
                }
                throw throwable;
            }
            {
                catch (Throwable throwable) {
                    block85: {
                        block86: {
                            block84: {
                                SQLException sQLException4222;
                                block82: {
                                    if (bl3) {
                                        Tr.debug(TC, "Exception occurred trying to see if table exists. Attempting alternate method.", throwable);
                                    }
                                    if (!(bl = this.existsTableByQuery(string, connection))) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "777", this);
                                        if (TC.isDebugEnabled()) {
                                            Tr.debug(TC, "Caught unexpected exception: " + throwable.getMessage(), throwable);
                                        }
                                    }
                                    Object var15_17 = null;
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (SQLException sQLException4222) {
                                            FFDCFilter.processException((Throwable)sQLException4222, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "800", this);
                                            if (!TC.isDebugEnabled()) break block82;
                                            Tr.debug(TC, "Caught unexpected exception: " + sQLException4222.getMessage(), sQLException4222);
                                        }
                                    }
                                }
                                if (bl2) {
                                    block83: {
                                        try {
                                            connection.commit();
                                        }
                                        catch (SQLException sQLException4222) {
                                            FFDCFilter.processException((Throwable)sQLException4222, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "805", this);
                                            if (!TC.isDebugEnabled()) break block83;
                                            Tr.debug(TC, "Caught unexpected exception while committing the local connection: " + sQLException4222.getMessage(), sQLException4222);
                                        }
                                    }
                                    try {
                                        this.returnConnection(connection);
                                    }
                                    catch (SQLException sQLException4222) {
                                        FFDCFilter.processException((Throwable)sQLException4222, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "813", this);
                                        if (!TC.isDebugEnabled()) break block84;
                                        Tr.debug(TC, "Caught unexpected exception: " + sQLException4222.getMessage(), sQLException4222);
                                    }
                                }
                            }
                            Object var18_28 = null;
                            if (txHandle == null) break block85;
                            try {
                                this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable3) {
                                FFDCFilter.processException(throwable3, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                                if (!TC.isDebugEnabled()) break block86;
                                Tr.debug(TC, "Caught unexpected exception: " + throwable3.getMessage(), throwable3);
                            }
                        }
                        metadataAccessor.endContext();
                    }
                    if (TC.isEntryEnabled()) {
                        Tr.exit(TC, "existsTable", new Boolean(bl));
                    }
                    break block80;
                    {
                        catch (RuntimeException runtimeException) {
                            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "822", this);
                            if (TC.isDebugEnabled()) {
                                Tr.debug(TC, "Caught unexpected exception: " + runtimeException.getMessage(), runtimeException);
                            }
                            Object var18_29 = null;
                            if (txHandle != null) {
                                block87: {
                                    try {
                                        this.tranControl.postinvoke(txHandle);
                                    }
                                    catch (Throwable throwable4) {
                                        FFDCFilter.processException(throwable4, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                                        if (!TC.isDebugEnabled()) break block87;
                                        Tr.debug(TC, "Caught unexpected exception: " + throwable4.getMessage(), throwable4);
                                    }
                                }
                                metadataAccessor.endContext();
                            }
                            if (TC.isEntryEnabled()) {
                                Tr.exit(TC, "existsTable", new Boolean(bl));
                            }
                            break block80;
                        }
                    }
                    catch (Throwable throwable5) {
                        Object var18_30 = null;
                        if (txHandle != null) {
                            block88: {
                                try {
                                    this.tranControl.postinvoke(txHandle);
                                }
                                catch (Throwable throwable6) {
                                    FFDCFilter.processException(throwable6, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                                    if (!TC.isDebugEnabled()) break block88;
                                    Tr.debug(TC, "Caught unexpected exception: " + throwable6.getMessage(), throwable6);
                                }
                            }
                            metadataAccessor.endContext();
                        }
                        if (TC.isEntryEnabled()) {
                            Tr.exit(TC, "existsTable", new Boolean(bl));
                        }
                        throw throwable5;
                    }
                }
            }
            catch (Throwable throwable) {
                block96: {
                    block92: {
                        block93: {
                            block91: {
                                SQLException sQLException522;
                                block89: {
                                    Object var15_18 = null;
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (SQLException sQLException522) {
                                            FFDCFilter.processException((Throwable)sQLException522, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "800", this);
                                            if (!TC.isDebugEnabled()) break block89;
                                            Tr.debug(TC, "Caught unexpected exception: " + sQLException522.getMessage(), sQLException522);
                                        }
                                    }
                                }
                                if (bl2) {
                                    block90: {
                                        try {
                                            connection.commit();
                                        }
                                        catch (SQLException sQLException522) {
                                            FFDCFilter.processException((Throwable)sQLException522, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "805", this);
                                            if (!TC.isDebugEnabled()) break block90;
                                            Tr.debug(TC, "Caught unexpected exception while committing the local connection: " + sQLException522.getMessage(), sQLException522);
                                        }
                                    }
                                    try {
                                        this.returnConnection(connection);
                                    }
                                    catch (SQLException sQLException522) {
                                        FFDCFilter.processException((Throwable)sQLException522, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "813", this);
                                        if (!TC.isDebugEnabled()) break block91;
                                        Tr.debug(TC, "Caught unexpected exception: " + sQLException522.getMessage(), sQLException522);
                                    }
                                }
                            }
                            Object var18_31 = null;
                            if (txHandle == null) break block92;
                            try {
                                this.tranControl.postinvoke(txHandle);
                            }
                            catch (Throwable throwable7) {
                                FFDCFilter.processException(throwable7, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                                if (!TC.isDebugEnabled()) break block93;
                                Tr.debug(TC, "Caught unexpected exception: " + throwable7.getMessage(), throwable7);
                            }
                        }
                        metadataAccessor.endContext();
                    }
                    if (TC.isEntryEnabled()) {
                        Tr.exit(TC, "existsTable", new Boolean(bl));
                    }
                    break block96;
                    {
                        catch (RuntimeException runtimeException) {
                            FFDCFilter.processException((Throwable)runtimeException, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "822", this);
                            if (TC.isDebugEnabled()) {
                                Tr.debug(TC, "Caught unexpected exception: " + runtimeException.getMessage(), runtimeException);
                            }
                            Object var18_32 = null;
                            if (txHandle != null) {
                                block94: {
                                    try {
                                        this.tranControl.postinvoke(txHandle);
                                    }
                                    catch (Throwable throwable8) {
                                        FFDCFilter.processException(throwable8, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                                        if (!TC.isDebugEnabled()) break block94;
                                        Tr.debug(TC, "Caught unexpected exception: " + throwable8.getMessage(), throwable8);
                                    }
                                }
                                metadataAccessor.endContext();
                            }
                            if (TC.isEntryEnabled()) {
                                Tr.exit(TC, "existsTable", new Boolean(bl));
                            }
                        }
                    }
                    catch (Throwable throwable9) {
                        Object var18_33 = null;
                        if (txHandle != null) {
                            block95: {
                                try {
                                    this.tranControl.postinvoke(txHandle);
                                }
                                catch (Throwable throwable10) {
                                    FFDCFilter.processException(throwable10, "com.ibm.ws.extensionhelper.db.impl.DatabaseHelperImpl.existsTable", "837", this);
                                    if (!TC.isDebugEnabled()) break block95;
                                    Tr.debug(TC, "Caught unexpected exception: " + throwable10.getMessage(), throwable10);
                                }
                            }
                            metadataAccessor.endContext();
                        }
                        if (TC.isEntryEnabled()) {
                            Tr.exit(TC, "existsTable", new Boolean(bl));
                        }
                        throw throwable9;
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    private boolean existsTableByQuery(String string, Connection connection) {
        boolean bl;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block10: {
            String string2 = "SELECT 1 FROM " + string + " WHERE 1=1";
            if (TC.isEntryEnabled()) {
                Tr.entry(TC, "existsTableByQuery", string2);
            }
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(string2);
                resultSet = preparedStatement.executeQuery();
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
                if (!TC.isDebugEnabled()) break block10;
                Tr.debug(TC, "Unable to find table", throwable);
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "existsTableByQuery", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    private String[] getTableParts(String string) {
        String[] stringArray = new String[]{null, null, null};
        if (string == null) {
            return stringArray;
        }
        stringArray[2] = string;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            stringArray[2] = string.substring(n + 1);
            stringArray[1] = string.substring(0, n);
            int n2 = string.lastIndexOf(46, n - 1);
            if (n2 != -1) {
                stringArray[1] = string.substring(n2 + 1, n);
                stringArray[0] = string.substring(0, n2);
            }
        }
        return stringArray;
    }

    public Connection getConnection(TxHandle txHandle) throws SQLException {
        Connection connection = this.getConnection();
        if (txHandle instanceof TxHandleDBImpl) {
            ((TxHandleDBImpl)txHandle).setConnection(connection);
        }
        return connection;
    }

    public Connection getConnectionWithTxIso(TxHandle txHandle, int n) throws SQLException {
        boolean bl = TC.isEntryEnabled();
        if (bl) {
            Tr.entry(TC, "getConnectionWithTxIso", new Object[]{txHandle, new Integer(n)});
        }
        Connection connection = null;
        try {
            if (!this.isDataSource40() && this.supportsTransactionIsolationLevel(n) && !this.isDataSourceDirect()) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Retrieving connection with a JDBCConnectionSpec");
                }
                JDBCConnectionSpec jDBCConnectionSpec = null;
                switch (n) {
                    case 1: {
                        jDBCConnectionSpec = this.connSpecReadUncommitted;
                        break;
                    }
                    case 2: {
                        jDBCConnectionSpec = this.connSpecReadCommitted;
                        break;
                    }
                    case 4: {
                        jDBCConnectionSpec = this.connSpecRepeatableRead;
                        break;
                    }
                    case 8: {
                        jDBCConnectionSpec = this.connSpecSerializable;
                        break;
                    }
                    case 16: {
                        jDBCConnectionSpec = this.connSpecSnapshot;
                        break;
                    }
                    case 4096: {
                        jDBCConnectionSpec = this.connSpecSSSnapshot;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid TransactionIsolation value: " + n);
                    }
                }
                connection = ((WSDataSource)this.getDataSource()).getConnection(jDBCConnectionSpec);
                if (this.uowCurrent.getUOWType() != 2) {
                    connection.setAutoCommit(false);
                }
                this.incConnections();
            } else {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Retrieving a default connection.");
                }
                connection = txHandle == null ? this.getConnection() : this.getConnection(txHandle);
                this.setTransactionIsolation(connection, n);
            }
            if (bl) {
                Tr.exit(TC, "getConnectionWithTxIso", connection);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            if (bl) {
                Tr.exit(TC, "getConnectionWithTxIso", sQLException);
            }
            throw sQLException;
        }
    }

    public static boolean isDirectDBAccess(Map map) {
        return DatabaseHelperImpl.isDirectDBAccess((String)map.get("dbhelper.datasource.classname"));
    }

    public TransactionControl getTransactionControl() {
        return this.tranControl;
    }

    private static boolean isDirectDBAccess(String string) {
        return string != null && string.length() > 0;
    }

    private static HashMap setupPermissions(String string) {
        String string2 = string.indexOf(92) >= 0 || string.indexOf(59) >= 0 ? ";" : File.pathSeparator;
        HashMap<String, Object> hashMap = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        int n = arrayList.size();
        String string3 = DatabaseHelperImpl.processType();
        if (string3.equals("DeploymentManager") || string3.equals("NodeAgent")) {
            hashMap = new HashMap<String, Object>(2);
            hashMap.put("type", "spi");
            hashMap.put("classpath", arrayList.toArray(new String[n]));
            DynamicPolicy dynamicPolicy = DynamicPolicyFactory.getInstance();
            if (dynamicPolicy != null) {
                dynamicPolicy.setupPolicy(hashMap);
            }
        }
        return hashMap;
    }

    private static String processType() {
        ObjectName objectName = AdminServiceFactory.getAdminService().getLocalServer();
        return objectName.getKeyProperty("processType");
    }

    public String getDatabaseVendor() {
        return this.databaseVendor;
    }

    public String getDbVendor() {
        return this.dbVendor;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public boolean isDataSource2Phase() {
        return this.dsWrapper.isDataSource2Phase();
    }

    public boolean isDataSource40() {
        return this.dsWrapper.getRealDataSource() instanceof PortableDataSource;
    }

    public boolean isDataSourceDirect() {
        return this.dataSourceDirect;
    }

    protected void setTransactionIsolation(Connection connection, int n) {
        block8: {
            if (TC.isEntryEnabled()) {
                Tr.entry(TC, "setTransactionIsolation", new Object[]{connection, new Integer(n)});
            }
            try {
                if (connection != null) {
                    int n2 = connection.getTransactionIsolation();
                    if (this.supportsTransactionIsolationLevel(n)) {
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "Attempting to change the transaction: " + n2 + "->" + n);
                        }
                        connection.setTransactionIsolation(n);
                    }
                }
                if (TC.isEntryEnabled()) {
                    Tr.exit(TC, "setTransactionIsolation");
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, "com.ibm.ws.scheduler.DBHelperImpl.getConnection", "276", this);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Error occurred while attempting to setTransactionIsolation: " + sQLException);
                    this.dumpSQLExceptionInfo(sQLException);
                }
                if (!TC.isEntryEnabled()) break block8;
                Tr.exit(TC, "setTransactionIsolation", sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void supportsTranIsoLevel() {
        block32: {
            Connection connection;
            TxHandle txHandle;
            boolean bl;
            block31: {
                Throwable throwable4222;
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                bl = TC.isDebugEnabled();
                                txHandle = null;
                                connection = null;
                                this.beginContext();
                                txHandle = this.getTransactionControl().preinvoke(true, false);
                                connection = this.getConnection();
                                this.supportsReadCommitted = connection.getMetaData().supportsTransactionIsolationLevel(2);
                                this.supportsReadUncommitted = connection.getMetaData().supportsTransactionIsolationLevel(1);
                                this.supportsRepeatableRead = connection.getMetaData().supportsTransactionIsolationLevel(4);
                                this.supportsSerializable = connection.getMetaData().supportsTransactionIsolationLevel(8);
                                try {
                                    this.supportsSnapshot = connection.getMetaData().supportsTransactionIsolationLevel(16);
                                }
                                catch (Throwable throwable2) {
                                    if (!bl) break block27;
                                    Tr.debug(TC, "Snapshot isolation (Connect) not supported:", throwable2.getMessage());
                                }
                            }
                            try {
                                this.supportsSSSnapshot = connection.getMetaData().supportsTransactionIsolationLevel(4096);
                            }
                            catch (Throwable throwable3) {
                                if (!bl) break block28;
                                Tr.debug(TC, "Snapshot isolation (Microsoft) not supported:", throwable3.getMessage());
                            }
                        }
                        Object var6_7 = null;
                        try {
                            connection.commit();
                        }
                        catch (Throwable throwable4222) {
                            FFDCFilter.processException(throwable4222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "351", this);
                            if (!bl) break block29;
                            Tr.debug(TC, "Exception during connection commit: " + throwable4222);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Throwable throwable4222) {
                        FFDCFilter.processException(throwable4222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "363", this);
                        if (!bl) break block30;
                        Tr.debug(TC, "Exception during connection close: " + throwable4222);
                    }
                }
                try {
                    if (txHandle != null) {
                        this.getTransactionControl().postinvoke(txHandle);
                    }
                }
                catch (Throwable throwable4222) {
                    FFDCFilter.processException(throwable4222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "375", this);
                    if (!bl) break block31;
                    Tr.debug(TC, "Exception during tran commit: " + throwable4222);
                }
            }
            metadataAccessor.endContext();
            {
                break block32;
                catch (Throwable throwable) {
                    block35: {
                        Throwable throwable52222;
                        block34: {
                            block33: {
                                FFDCFilter.processException(throwable, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "339", this);
                                if (bl) {
                                    Tr.debug(TC, "Exception during metadata operation: ", throwable);
                                }
                                Object var6_8 = null;
                                try {
                                    connection.commit();
                                }
                                catch (Throwable throwable52222) {
                                    FFDCFilter.processException(throwable52222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "351", this);
                                    if (!bl) break block33;
                                    Tr.debug(TC, "Exception during connection commit: " + throwable52222);
                                }
                            }
                            try {
                                if (connection != null) {
                                    connection.close();
                                }
                            }
                            catch (Throwable throwable52222) {
                                FFDCFilter.processException(throwable52222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "363", this);
                                if (!bl) break block34;
                                Tr.debug(TC, "Exception during connection close: " + throwable52222);
                            }
                        }
                        try {
                            if (txHandle != null) {
                                this.getTransactionControl().postinvoke(txHandle);
                            }
                        }
                        catch (Throwable throwable52222) {
                            FFDCFilter.processException(throwable52222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "375", this);
                            if (!bl) break block35;
                            Tr.debug(TC, "Exception during tran commit: " + throwable52222);
                        }
                    }
                    metadataAccessor.endContext();
                }
            }
            catch (Throwable throwable) {
                block38: {
                    Throwable throwable62222;
                    block37: {
                        block36: {
                            Object var6_9 = null;
                            try {
                                connection.commit();
                            }
                            catch (Throwable throwable62222) {
                                FFDCFilter.processException(throwable62222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "351", this);
                                if (!bl) break block36;
                                Tr.debug(TC, "Exception during connection commit: " + throwable62222);
                            }
                        }
                        try {
                            if (connection != null) {
                                connection.close();
                            }
                        }
                        catch (Throwable throwable62222) {
                            FFDCFilter.processException(throwable62222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "363", this);
                            if (!bl) break block37;
                            Tr.debug(TC, "Exception during connection close: " + throwable62222);
                        }
                    }
                    try {
                        if (txHandle != null) {
                            this.getTransactionControl().postinvoke(txHandle);
                        }
                    }
                    catch (Throwable throwable62222) {
                        FFDCFilter.processException(throwable62222, "com.ibm.ws.scheduler.DBHelperImpl.supportsTranIsoLevel", "375", this);
                        if (!bl) break block38;
                        Tr.debug(TC, "Exception during tran commit: " + throwable62222);
                    }
                }
                metadataAccessor.endContext();
                throw throwable;
            }
        }
    }

    public boolean supportsTransactionIsolationLevel(int n) {
        return n == 2 && this.supportsReadCommitted || n == 1 && this.supportsReadUncommitted || n == 4 && this.supportsRepeatableRead || n == 8 && this.supportsSerializable || n == 4096 && this.supportsSSSnapshot || n == 16 && this.supportsSnapshot;
    }

    private synchronized int incConnections() {
        return ++this.totalConnections;
    }

    private class DSWrapper
    implements FFDCSelfIntrospectable {
        DataSource ds;
        Object directDS;
        String username;
        String password;
        Properties props;
        protected DataStoreHelper dataStoreHelper = null;
        boolean is2Phase = false;

        public DSWrapper(DataSource dataSource, String string, String string2) {
            this.ds = dataSource;
            this.username = string;
            this.password = string2;
            if (dataSource instanceof WSDataSource) {
                this.is2Phase = ((WSDataSource)dataSource).isXADataSource();
            }
        }

        public DSWrapper(String string, String string2, String string3, Properties properties) throws ResourceException, ClassNotFoundException, IllegalAccessException, InstantiationException {
            this.username = string2;
            this.password = string3;
            this.props = properties;
            if (this.props == null) {
                this.props = empty_props;
            }
            this.loadDataSource();
        }

        public Connection getConnection() throws ResourceException, SQLException {
            if (TC.isDebugEnabled()) {
                if (this.username == null) {
                    Tr.debug(TC, "No connection user/password defined in property map.");
                } else {
                    Tr.debug(TC, "Connection user=" + DatabaseHelperImpl.this.dataBaseData.getUserName());
                    Tr.debug(TC, "Connection password=XXXXXX");
                }
            }
            if (this.ds != null) {
                return this.username == null ? this.ds.getConnection() : this.ds.getConnection(this.username, this.password);
            }
            this.is2Phase = DSConfigurationHelper.is2PhaseEnabled(this.props, this.directDS);
            PooledConnection pooledConnection = DSConfigurationHelper.getPooledConnection(this.directDS, this.username, this.password, this.is2Phase);
            return new DBConnectionWrapper(pooledConnection, this.dataStoreHelper);
        }

        public Object getRealDataSource() {
            return this.ds != null ? this.ds : this.directDS;
        }

        public DataSource getDataSource() {
            return this.ds;
        }

        public String[] introspectSelf() {
            return new String[]{this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)), "User name = " + this.username, "Password = ******", "DataStoreHelper = " + this.dataStoreHelper, "WebSphere Data Source = " + this.ds, "Direct-Access Data Source = " + this.directDS, "Data Source Properties = " + DatabaseHelperImpl.hidePassword(this.props)};
        }

        private void loadDataSource() throws ResourceException, ClassNotFoundException, IllegalAccessException, InstantiationException {
            Object object;
            Class clazz = DSConfigurationHelper.loadDataSourceClass(DatabaseHelperImpl.this.dataBaseData.getDataSourceClassName(), DatabaseHelperImpl.this.dataBaseData.getDataSourceClasspath());
            Object object2 = DSConfigurationHelper.createDataSource(clazz);
            Properties properties = (Properties)DatabaseHelperImpl.this.dataBaseData.getDataSourceProps().clone();
            String string = (String)properties.remove("dataStoreHelperClass");
            if (string == null) {
                object = properties.getProperty("driverType");
                string = DSConfigurationHelper.getDataStoreHelperClassName(DatabaseHelperImpl.this.dataBaseData.getDataSourceClassName(), object);
            }
            this.dataStoreHelper = DSConfigurationHelper.createDataStoreHelper(string, properties);
            object = DSConfigurationHelper.setDataSourceProperties(object2, properties);
            if (!((ArrayList)object).isEmpty()) {
                this.logWarnings((ArrayList)object);
            }
            DatabaseHelperImpl.setupPermissions(DatabaseHelperImpl.this.dataBaseData.getDataSourceClasspath());
            this.directDS = object2;
        }

        private void logWarnings(ArrayList arrayList) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Tr.info(TC, (String)iterator.next());
            }
        }

        public boolean isDataSource2Phase() {
            return this.is2Phase;
        }
    }
}

