/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.extensionhelper.tran.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.extensionhelper.exception.InconsistentTransactionException;
import com.ibm.ws.extensionhelper.tran.impl.TxHandleDBImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;

public class TransactionControlDBImpl
implements TransactionControl {
    private static final TraceComponent tc = Tr.register(TransactionControlDBImpl.class, "ExtHelper", "com.ibm.ws.extensionhelper.tran.impl.ExtensionHelperMessages");

    public TxHandle preinvoke() throws NotSupportedException, SystemException {
        return this.preinvoke(false, false);
    }

    public TxHandle preinvoke(boolean bl, boolean bl2) throws NotSupportedException, SystemException {
        return new TxHandleDBImpl();
    }

    public void postinvoke(TxHandle txHandle) throws InvalidTransactionException, InconsistentTransactionException, SystemException {
        Connection connection = this.validateHandle(txHandle);
        try {
            if (!connection.isClosed()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            throw new SystemException(sQLException.getMessage());
        }
    }

    public void handleException(TxHandle txHandle) {
        block3: {
            try {
                Connection connection = this.validateHandle(txHandle);
                if (!connection.isClosed()) {
                    connection.rollback();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.extensionhelper.tran.impl.TransactionControlDBImpl.handleException", "97", this);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "handleException: Local connection was not rolled-back.", new Object[]{throwable});
            }
        }
    }

    private Connection validateHandle(TxHandle txHandle) throws InvalidTransactionException {
        if (txHandle != null) {
            if (txHandle instanceof TxHandleDBImpl) {
                Connection connection = ((TxHandleDBImpl)txHandle).getConnection();
                if (connection != null) {
                    return connection;
                }
                throw new InvalidTransactionException("Connection object has not been set.");
            }
            throw new InvalidTransactionException("The TxHandle is not the correct type.");
        }
        throw new InvalidTransactionException("The TxHandle is null.");
    }
}

