/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.etools.analysis.engine.Directive;
import com.ibm.etools.analysis.engine.Incident;
import com.ibm.etools.analysis.engine.Solution;
import com.ibm.etools.analysis.engine.engines.FFDCAnalysisEngine;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.FFDCHelper;
import com.ibm.ws.ffdc.WrappingFileOutputStream;
import java.io.File;
import java.io.PrintStream;

class AnalysisEngineWrapper {
    private static FFDCAnalysisEngine analysisEngine = null;
    private static boolean commandLineCall = false;
    private static String databaseName = "ffdcdb.xml";
    private static Object fileGuard = new Object();

    AnalysisEngineWrapper() {
    }

    private static synchronized FFDCAnalysisEngine getAnalysisEngine() {
        String string = null;
        if (analysisEngine == null) {
            try {
                string = commandLineCall ? databaseName : FFDCHelper.getQualifiedDatabaseName(databaseName);
            }
            catch (Throwable throwable) {
                return null;
            }
            analysisEngine = FFDCAnalysisEngine.getInstance(string);
        }
        return analysisEngine;
    }

    static void setUpForCommandLineCall(String string) {
        commandLineCall = true;
        if (string != null) {
            databaseName = string;
        }
    }

    static String[] checkKnowledgeBase(String string, String[] stringArray, String string2, int n, int n2) {
        return AnalysisEngineWrapper.checkKnowledgeBase(string, stringArray, string2, null, n, n2);
    }

    static synchronized String[] checkKnowledgeBase(String string, String[] stringArray, String string2, String string3, int n, int n2) {
        int n3;
        Directive[] directiveArray;
        int n4;
        FFDCAnalysisEngine fFDCAnalysisEngine = null;
        Object var8_7 = null;
        String[] stringArray2 = null;
        int n5 = 0;
        String string4 = null;
        Incident incident = new Incident(null);
        fFDCAnalysisEngine = AnalysisEngineWrapper.getAnalysisEngine();
        if (fFDCAnalysisEngine == null) {
            return null;
        }
        incident.setMessageId(string);
        incident.setRawData(stringArray);
        Solution[] solutionArray = fFDCAnalysisEngine.analyzeForSolutions(incident);
        if (commandLineCall && solutionArray.length == 0) {
            String string5 = "NOT FOUND -- See attached call stack for more details about the problem.";
            string5 = string5 + string2 + '\n' + string3;
            if (stringArray.length == 0) {
                string5 = string5 + " -- Call Stack was not set to anything";
            }
            AnalysisEngineWrapper.printSolution("****** " + string5 + " ******", string, string2, 1, 1, n, n2);
        }
        for (n4 = 0; n4 < solutionArray.length; ++n4) {
            directiveArray = solutionArray[n4].getDirectives();
            if (directiveArray != null) {
                for (n3 = 0; n3 < directiveArray.length; ++n3) {
                    if (++n5 != 1) continue;
                    string4 = directiveArray[n3].getDirectiveString();
                }
            }
            if (solutionArray[n4].getDescription() == null) continue;
            AnalysisEngineWrapper.printSolution(solutionArray[n4].getDescription(), string, string2, n4 + 1, solutionArray.length, n, n2);
        }
        if (n5 > 1) {
            stringArray2 = new String[n5];
            n4 = 0;
            for (n3 = 0; n3 < solutionArray.length; ++n3) {
                directiveArray = solutionArray[n3].getDirectives();
                if (directiveArray == null) continue;
                for (int i = 0; i < directiveArray.length; ++i) {
                    stringArray2[n4] = directiveArray[i].getDirectiveString();
                    ++n4;
                }
            }
        } else if (n5 == 1) {
            stringArray2 = new String[]{string4};
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSolution(String string, String string2, String string3, int n, int n2, int n3, int n4) {
        PrintStream printStream = null;
        if (commandLineCall) {
            System.out.println("----------------------------------------------------------------------");
            System.out.println("Key Value : " + string3);
            if (n2 > 1) {
                System.out.println("Multiple entries found for symptom, entry " + n + " of " + n2);
            }
            System.out.println("Exception Name : " + string2);
            System.out.println("Solution : " + string);
            System.out.println("----------------------------------------------------------------------");
            return;
        }
        Object object = fileGuard;
        synchronized (object) {
            try {
                printStream = AnalysisEngineWrapper.openFile(n3, n4);
                if (printStream == null) {
                    return;
                }
                printStream.println("----------------------------------------------------------------------");
                printStream.println("Key Value : " + string3);
                printStream.println("Exception Name : " + string2);
                printStream.println("Solution : " + string);
                printStream.println("----------------------------------------------------------------------");
                printStream.close();
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    private static PrintStream openFile(int n, int n2) {
        PrintStream printStream = null;
        String string = null;
        int n3 = 0;
        if (n > 0x100000) {
            n = 0x100000;
        }
        if ((n3 = n * 1024) < 0) {
            n3 = 0x100000;
        }
        try {
            string = AnalysisEngineWrapper.getFileName();
            if (string == null) {
                return null;
            }
            WrappingFileOutputStream wrappingFileOutputStream = new WrappingFileOutputStream(string, n3, n2);
            printStream = new PrintStream(wrappingFileOutputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        return printStream;
    }

    private static String getFileName() {
        String string = "solution";
        String string2 = null;
        string2 = FFDCHelper.getServerName();
        if (string2 == null || string2.length() == 0) {
            string2 = "serverName";
        }
        try {
            String string3 = FFDCHelper.getDefaultLoggingDirectory();
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(string3);
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(string2);
            stringBuffer.append('_');
            stringBuffer.append(string);
            stringBuffer.append(FFDC.getExceptionIndexFileNameExtension());
            return new String(stringBuffer);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

