/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.Configure;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.FFDCExceptionFileFilter;
import com.ibm.ws.ffdc.FFDCHelper;
import java.io.File;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

class FFDCJanitor {
    private static FFDCJanitor instance = new FFDCJanitor();
    private long timeOfTheDayForCleanup;
    private int daysBetweenCleanups;
    private long timeOfNextCleanup;
    private long maximumFileAge;
    private Object synchronizationGuard = new Object();
    private Logger logger;
    private String classname = this.getClass().getName();
    private boolean configured = false;

    private FFDCJanitor() {
        this.logger = Logger.getLogger(this.classname, "com.ibm.ws.ffdc.resources.FFDCMessages");
    }

    public static FFDCJanitor getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupIfNeeded() {
        if (!this.configured) {
            return;
        }
        boolean bl = false;
        long l = System.currentTimeMillis();
        File[] fileArray = this.synchronizationGuard;
        synchronized (this.synchronizationGuard) {
            if (this.timeOfNextCleanup <= l) {
                bl = true;
                this.setNextCleanupTime(l);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl) {
                bl = false;
                fileArray = null;
                File[] fileArray2 = null;
                FFDCExceptionFileFilter fFDCExceptionFileFilter = new FFDCExceptionFileFilter();
                fFDCExceptionFileFilter.setFileSelectionAttributes(null, null, FFDC.getExceptionFileExtension(), null, -1L, l - this.maximumFileAge);
                try {
                    fileArray = FFDCHelper.listFiles(new File(FFDCHelper.getDefaultLoggingDirectory()), fFDCExceptionFileFilter);
                    fFDCExceptionFileFilter.setFileSelectionAttributes(null, null, ".log", null, -1L, l - this.maximumFileAge);
                    fileArray2 = FFDCHelper.listFiles(new File(FFDCHelper.getDefaultLoggingDirectory()), fFDCExceptionFileFilter);
                }
                catch (WsException wsException) {
                    fileArray = null;
                    fileArray2 = null;
                    this.logger.logp(Level.WARNING, this.classname, "doCleanupIfNeeded", "MSG_FFDCJANITOR_FAILED_TO_GET_EXCEPTION_FILES_LIST", wsException);
                }
                File[] fileArray3 = null;
                if (fileArray == null && fileArray2 == null) {
                    fileArray3 = null;
                } else if (fileArray == null) {
                    fileArray3 = fileArray2;
                } else if (fileArray2 == null) {
                    fileArray3 = fileArray;
                } else {
                    fileArray3 = new File[fileArray.length + fileArray2.length];
                    System.arraycopy(fileArray, 0, fileArray3, 0, fileArray.length);
                    System.arraycopy(fileArray2, 0, fileArray3, fileArray.length, fileArray2.length);
                }
                this.logger.logp(Level.FINE, this.classname, "doCleanupIfNeeded", "IncidentFiles: " + (fileArray == null ? 0 : fileArray.length) + "SummaryFiles: " + (fileArray2 == null ? 0 : fileArray2.length) + " to delete");
                if (fileArray3 != null && fileArray3.length > 0) {
                    int n = 0;
                    for (int i = 0; i < fileArray3.length; ++i) {
                        this.logger.logp(Level.FINE, this.classname, "doCleanupIfNeeded", "Attempting to delete file " + fileArray3[i].getName());
                        if (FFDCHelper.deleteFile(fileArray3[i])) {
                            ++n;
                            this.logger.logp(Level.FINE, this.classname, "doCleanupIfNeeded", "Deleted file " + fileArray3[i].getName());
                            continue;
                        }
                        if (!fileArray3[i].exists()) continue;
                        this.logger.logp(Level.INFO, this.classname, "doCleanupIfNeeded", "FFDCJANITOR_FAILED_TO_DELETE_FILE", new Object[]{fileArray3[i].getName()});
                    }
                    this.logger.logp(Level.INFO, this.classname, "doCleanupIfNeeded", "FFDCJANITOR_DELETED_FILES", new Object[]{new Integer(n), new Integer(fileArray3.length)});
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeForCleanup(long l) {
        this.timeOfTheDayForCleanup = l >= 0L && l < 86400000L ? l : 0L;
        long l2 = System.currentTimeMillis();
        Object object = this.synchronizationGuard;
        synchronized (object) {
            this.setNextCleanupTime(l2);
        }
        this.configured = true;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, this.classname, "setTimeForCleanup", "Configured to do cleanup every " + this.daysBetweenCleanups + " day(s), at " + l / 3600000L + ":" + (l - 3600000L * (l / 3600000L)) / 60000L + ", when files reach " + this.maximumFileAge + "ms of age.");
        }
    }

    void configure(Configure configure) {
        this.daysBetweenCleanups = configure.daysBetweenExceptionFilesCleanup;
        this.maximumFileAge = configure.exceptionFileMaximumAge;
        if (configure.timeOfTheDayForCleanup > 0L) {
            this.setTimeForCleanup(configure.timeOfTheDayForCleanup);
        } else if (!this.configured) {
            Random random = new Random();
            this.setTimeForCleanup(random.nextInt(1440) * 60 * 1000);
        }
    }

    private void setNextCleanupTime(long l) {
        int n = TimeZone.getDefault().getOffset(l);
        this.timeOfNextCleanup = ((l + (long)n) / 86400000L + (long)(this.configured ? this.daysBetweenCleanups : 0)) * 86400000L + this.timeOfTheDayForCleanup - (long)n;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, this.classname, "setNextCleanupTime", "Next clean up set for " + new Date(this.timeOfNextCleanup).toString());
        }
    }
}

