/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

public abstract class ResizableObjectPool {
    private Object[] ivPool;
    private int ivPoolIndex;

    public ResizableObjectPool(int n) {
        this.ivPool = new Object[n];
        this.ivPoolIndex = 0;
    }

    public synchronized void setSize(int n) {
        int n2 = this.ivPool.length;
        if (n2 == n) {
            return;
        }
        Object[] objectArray = new Object[n];
        if (this.ivPoolIndex > 0) {
            if (this.ivPoolIndex > n) {
                this.ivPoolIndex = n;
            }
            System.arraycopy(this.ivPool, 0, objectArray, 0, this.ivPoolIndex);
        }
        this.ivPool = objectArray;
    }

    public synchronized boolean add(Object object) {
        if (this.ivPoolIndex < this.ivPool.length) {
            this.ivPool[this.ivPoolIndex++] = object;
            return true;
        }
        return false;
    }

    public synchronized Object remove() {
        if (this.ivPoolIndex > 0) {
            Object object = this.ivPool[--this.ivPoolIndex];
            this.ivPool[this.ivPoolIndex] = null;
            return object;
        }
        return this.createObject();
    }

    protected abstract Object createObject();
}

