/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BinaryHeaderNode;
import com.ibm.wsspi.genericbnf.GenericKeys;

public abstract class QuickGenericMatcher {
    private static final TraceComponent tc = Tr.register(QuickGenericMatcher.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    protected static final byte UPPER_BYTE_A = 65;
    protected static final byte UPPER_BYTE_Z = 90;
    protected static final byte LOWER_BYTE_A = 97;
    protected static final byte LOWER_BYTE_Z = 122;
    protected static final int OFFSET = 32;

    public boolean add(GenericKeys genericKeys) {
        BinaryHeaderNode binaryHeaderNode = this.getNode(genericKeys);
        if (null == binaryHeaderNode) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error, key " + genericKeys + " is invalid");
            }
            return false;
        }
        return binaryHeaderNode.add(genericKeys);
    }

    public boolean add(String string, Object object) {
        BinaryHeaderNode binaryHeaderNode = this.getNode(string);
        if (null == binaryHeaderNode) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error, key " + string + " is invalid");
            }
            return false;
        }
        return binaryHeaderNode.add(string, object);
    }

    public abstract BinaryHeaderNode getNode(GenericKeys var1);

    public abstract BinaryHeaderNode getNode(String var1);

    public abstract void init();

    public Object match(char[] cArray) {
        return this.match(cArray, 0, cArray.length);
    }

    public abstract Object match(char[] var1, int var2, int var3);

    public Object match(String string) {
        return this.match(string.toCharArray());
    }

    public Object match(StringBuffer stringBuffer) {
        char[] cArray = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        return this.match(cArray);
    }

    public Object match(byte[] byArray) {
        return this.match(byArray, 0, byArray.length);
    }

    public abstract Object match(byte[] var1, int var2, int var3);

    protected static boolean isUpper(byte by) {
        return by >= 65 && by <= 90;
    }

    protected static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    protected static boolean isLower(byte by) {
        return by >= 97 && by <= 122;
    }

    protected static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    protected static boolean isUpper(int n) {
        return n >= 65 && n <= 90;
    }

    protected static boolean isLower(int n) {
        return n >= 97 && n <= 122;
    }

    protected static byte normalizeToLower(byte by) {
        return QuickGenericMatcher.isUpper(by) ? (byte)(by + 32) : by;
    }

    protected static int normalizeToLower(int n) {
        return QuickGenericMatcher.isUpper(n) ? n + 32 : n;
    }

    protected static int normalizeToUpper(int n) {
        return QuickGenericMatcher.isUpper(n) ? n - 32 : n;
    }

    protected static char normalizeToLower(char c) {
        return QuickGenericMatcher.isUpper(c) ? (char)(c + 32) : c;
    }
}

