/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Map;

public class Version {
    static final TraceComponent TC = Tr.register(Version.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    public static final int DCS_600 = 0;
    public static final int DCS_610 = 10;
    public static final int HAM_600 = 0;
    public static final int HAM_602_9 = 1;
    public static final int HAM_602_31 = 5;
    private static final int svHAMDefault = 0;
    private static final int svDCSDefault = 0;
    private static Version svInstance;
    private int ivDcsVersion;
    private int ivHamVersion;

    public static Version getDefaultInstance() {
        return svInstance;
    }

    private static int getHAMProtocolVersionMapping(String string) {
        if (string == null) {
            return 0;
        }
        if ("6.0.0".equals(string)) {
            return 0;
        }
        if ("6.0.2.9".equals(string)) {
            return 1;
        }
        if ("6.1.0".equals(string)) {
            return 1;
        }
        if ("6.0.2.31".equals(string)) {
            return 5;
        }
        Tr.error(TC, "HMGR0224", new Object[]{"IBM_CS_HAM_PROTOCOL_VERSION", string});
        return 0;
    }

    public static int getDCSProtocolVersionMapping(String string) {
        if (string == null) {
            return 0;
        }
        if ("6.0.0".equals(string)) {
            return 0;
        }
        if ("6.0.2.9".equals(string)) {
            return 0;
        }
        if ("6.1.0".equals(string)) {
            return 10;
        }
        Tr.error(TC, "HMGR0224", new Object[]{"IBM_CS_WIRE_FORMAT_VERSION", string});
        return 0;
    }

    public Version(boolean bl, Map map) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "Version ctor", map);
        }
        this.ivDcsVersion = Version.getDCSProtocolVersionMapping((String)map.get("DCS_PROTOCOL"));
        String string = (String)map.get("HAM_PROTOCOL");
        this.ivHamVersion = Version.getHAMProtocolVersionMapping(string);
        if (this.ivHamVersion != 0) {
            Tr.info(TC, "HMGR0226", new Object[]{"IBM_CS_HAM_PROTOCOL_VERSION", string});
        }
        if (bl) {
            svInstance = this;
        }
    }

    public synchronized boolean updateProtocolVersions(Map map) {
        int n = this.ivDcsVersion;
        String string = (String)map.get("DCS_PROTOCOL");
        if (string != null) {
            this.ivDcsVersion = Version.getDCSProtocolVersionMapping(string);
            if (n != this.ivDcsVersion) {
                Tr.info(TC, "HMGR0226", new Object[]{"IBM_CS_WIRE_FORMAT_VERSION", string});
            }
        }
        boolean bl = false;
        n = this.ivHamVersion;
        String string2 = (String)map.get("HAM_PROTOCOL");
        if (string2 != null) {
            this.ivHamVersion = Version.getHAMProtocolVersionMapping(string2);
            if (n != this.ivHamVersion) {
                Tr.info(TC, "HMGR0226", new Object[]{"IBM_CS_HAM_PROTOCOL_VERSION", string2});
                bl = true;
                if (n > this.ivHamVersion) {
                    String string3 = "old version is " + n + ", new version is " + string2;
                    Tr.error(TC, "HMGR0108", new Object[]{"Version", "updateProtocolVersions", string3});
                }
            }
        }
        return bl;
    }

    public synchronized int getHAMProtocolVersion() {
        return this.ivHamVersion;
    }

    public synchronized int getDCSProtocolVersion() {
        return this.ivDcsVersion;
    }
}

