/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.admin.CoreGroupConfigHelper;
import com.ibm.wsspi.configarchive.ConfigArchiveCommand;
import com.ibm.wsspi.configarchive.ImportStep;
import javax.management.ObjectName;

public class CoreGroupAddNodeExt
extends ImportStep {
    private static TraceComponent TC = Tr.register(CoreGroupAddNodeExt.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");

    public CoreGroupAddNodeExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public CoreGroupAddNodeExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    public void validate() throws CommandValidationException {
    }

    protected void executeStep() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            return;
        }
        try {
            ManagedObjectMetadataHelper managedObjectMetadataHelper;
            String string = (String)this.taskCmd.getParameter("nodeName");
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "nodeName", string);
            }
            if ("5".equals((managedObjectMetadataHelper = ((ConfigArchiveCommand)this.taskCmd).getConfigArchiveMetadataHelper()).getNodeMajorVersion(string))) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Node is a V5 node, exiting", string);
                }
                return;
            }
            Session session = this.getConfigSession();
            String string2 = (String)this.getParameter("coregroupName");
            if (string2 == null) {
                string2 = CoreGroupConfigHelper.getDefaultCoreGroupName(session);
            }
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Node", string);
            ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
            objectName = ConfigServiceHelper.createObjectName(null, "Server");
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName3 = objectNameArray[i];
                String string3 = ConfigServiceHelper.getDisplayName(objectName3);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "serverName", new Object[]{string, objectName3, string3});
                }
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("getServerType");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("serverName", string3);
                adminCommand.setParameter("nodeName", string);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    String string4 = (String)commandResult.getResult();
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "server type", string4);
                    }
                    if (!string4.equals("APPLICATION_SERVER") && !string4.equals("DEPLOYMENT_MANAGER") && !string4.equals("NODE_AGENT") && !string4.equals("PROXY_SERVER") && !string4.equals("ONDEMAND_ROUTER")) continue;
                    CoreGroupConfigHelper.addServerToCoreGroup(session, string2, string, string3);
                    continue;
                }
                throw commandResult.getException();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.admin.CoreGroupAddNodeExt.executeStep", "113", this);
            taskCommandResultImpl.setException(throwable);
        }
    }
}

