/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.admin;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.admin.CoreGroupRuntimeHelper;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.StringUtils;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class CoreGroupConfigHelper {
    private static ConfigService svConfigService = null;
    private static final String svDefaultCoreGroupName = "DefaultCoreGroup";
    private static final String svCGS = "coregroups";
    private static final String svCoreGroupConfigFile = "coregroup.xml";
    private static TraceNLS ivBundle = TraceNLS.getTraceNLS("com.ibm.ws.hamanager.nls.HAManagerMessages");

    static String getCoreGroupRepositoryURI(String string, String string2) {
        String string3 = "coregroups/" + string2 + "/" + svCoreGroupConfigFile;
        return string3;
    }

    static String getDefaultCoreGroupName(Session session) throws Exception {
        CoreGroupConfigHelper.checkSession(session);
        return svDefaultCoreGroupName;
    }

    static String[] getAllCoreGroupNames(Session session) throws Exception {
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "CoreGroup", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        int n = objectNameArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            ObjectName objectName2 = objectNameArray[i];
            stringArray[i] = (String)configService.getAttribute(session, objectName2, "name");
        }
        return stringArray;
    }

    static boolean doesCoreGroupExist(Session session, String string) throws Exception {
        if (string == null || string.equals("")) {
            Object[] objectArray = new Object[]{"core group name", string};
            String string2 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid core group name");
            throw new Exception(string2);
        }
        CoreGroupConfigHelper.checkSession(session);
        String[] stringArray = CoreGroupConfigHelper.getAllCoreGroupNames(session);
        if (stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    static ObjectName createCoreGroup(Session session, String string) throws Exception {
        if (string == null || string.equals("")) {
            Object[] objectArray = new Object[]{"core group name", string};
            String string2 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid core group name");
            throw new Exception(string2);
        }
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        boolean bl = CoreGroupConfigHelper.doesCoreGroupExist(session, string);
        if (bl) {
            Object[] objectArray = new Object[]{string};
            String string3 = ivBundle.getFormattedMessage("HMGR3601", objectArray, "core group exists");
            throw new Exception(string3);
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        if (objectNameArray.length < 1) {
            throw new Exception("Cell not found");
        }
        ObjectName objectName2 = objectNameArray[0];
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue(attributeList, "name", string);
        UID uID = new UID();
        ConfigServiceHelper.setAttributeValue(attributeList, "coreGroupUID", uID.toString());
        ObjectName objectName3 = configService.createConfigData(session, objectName2, "CoreGroup", "CoreGroup", attributeList);
        return objectName3;
    }

    static void deleteCoreGroup(Session session, String string) throws Exception {
        if (string == null || string.equals("")) {
            Object[] objectArray = new Object[]{"core group name", string};
            String string2 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid core group name");
            throw new Exception(string2);
        }
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        if (string.equals(svDefaultCoreGroupName)) {
            String string3 = ivBundle.getString("HMGR3602");
            throw new Exception(string3);
        }
        boolean bl = CoreGroupConfigHelper.doesCoreGroupExist(session, string);
        if (!bl) {
            Object[] objectArray = new Object[]{string};
            String string4 = ivBundle.getFormattedMessage("HMGR3603", objectArray, "core group does not exist");
            throw new Exception(string4);
        }
        boolean bl2 = CoreGroupConfigHelper.isCoreGroupEmpty(configService, session, string);
        if (!bl2) {
            Object[] objectArray = new Object[]{string};
            String string5 = ivBundle.getFormattedMessage("HMGR3604", objectArray, "core group is not empty");
            throw new Exception(string5);
        }
        ObjectName objectName = CoreGroupConfigHelper.getCoreGroupObjectName(configService, session, string);
        configService.deleteConfigData(session, objectName);
    }

    static String getCoreGroupForServer(Session session, String string, String string2) throws Exception {
        if (string == null || string.equals("")) {
            Object[] objectArray = new Object[]{"node name", string};
            String string3 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid node name");
            throw new Exception(string3);
        }
        if (string2 == null || string2.equals("")) {
            Object[] objectArray = new Object[]{"server name", string2};
            String string4 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid server name");
            throw new Exception(string4);
        }
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        String[] stringArray = CoreGroupConfigHelper.getAllCoreGroupNames(session);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string5 = stringArray[i];
            if (!CoreGroupConfigHelper.isServerInCoreGroup(configService, session, string5, string, string2)) continue;
            return string5;
        }
        return null;
    }

    static void moveServerToCoreGroup(Session session, String string, String string2, String string3, String string4) throws Exception {
        if (string3 == null) {
            Object[] objectArray = new Object[]{"node name", string3};
            String string5 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid node name");
            throw new Exception(string5);
        }
        if (string4 == null) {
            Object[] objectArray = new Object[]{"server name", string4};
            String string6 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid server name");
            throw new Exception(string6);
        }
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        boolean bl = CoreGroupConfigHelper.doesCoreGroupExist(session, string);
        if (!bl) {
            Object[] objectArray = new Object[]{string};
            String string7 = ivBundle.getFormattedMessage("HMGR3603", objectArray, "core group does not exist");
            throw new Exception(string7);
        }
        bl = CoreGroupConfigHelper.doesCoreGroupExist(session, string2);
        if (!bl) {
            Object[] objectArray = new Object[]{string2};
            String string8 = ivBundle.getFormattedMessage("HMGR3603", objectArray, "core group does not exist");
            throw new Exception(string8);
        }
        boolean bl2 = CoreGroupConfigHelper.isServerInCoreGroup(configService, session, string, string3, string4);
        if (!bl2) {
            Object[] objectArray = new Object[]{string4, string3, string};
            String string9 = ivBundle.getFormattedMessage("HMGR3605", objectArray, "server not in core group");
            throw new Exception(string9);
        }
        bl2 = CoreGroupConfigHelper.isServerClusterMember(configService, session, string3, string4);
        if (bl2) {
            Object[] objectArray = new Object[]{string4, string3};
            String string10 = ivBundle.getFormattedMessage("HMGR3606", objectArray, "server in a cluster");
            throw new Exception(string10);
        }
        String string11 = CoreGroupConfigHelper.getCellName(session);
        bl2 = CoreGroupRuntimeHelper.isServerRunning(string11, string3, string4);
        if (bl2) {
            Object[] objectArray = new Object[]{string4, string3};
            String string12 = ivBundle.getFormattedMessage("HMGR3612", objectArray, "Server " + string4 + " on node " + string3 + " is running. The core group member cannot be moved while it is running.");
            throw new Exception(string12);
        }
        CoreGroupConfigHelper.doRemoveServerFromCoreGroup(configService, session, string, string3, string4);
        CoreGroupConfigHelper.doAddServerToCoreGroup(configService, session, string2, string3, string4);
    }

    static void moveClusterToCoreGroup(Session session, String string, String string2, String string3, boolean bl) throws Exception {
        int n;
        Object object;
        Object object2;
        List<Object> list;
        if (string3 == null) {
            Object[] objectArray = new Object[]{"cluster name", string3};
            String string4 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid cluster name");
            throw new Exception(string4);
        }
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        boolean bl2 = CoreGroupConfigHelper.doesCoreGroupExist(session, string);
        if (!bl2) {
            Object[] objectArray = new Object[]{string};
            String string5 = ivBundle.getFormattedMessage("HMGR3603", objectArray, "core group does not exist");
            throw new Exception(string5);
        }
        bl2 = CoreGroupConfigHelper.doesCoreGroupExist(session, string2);
        if (!bl2) {
            Object[] objectArray = new Object[]{string2};
            String string6 = ivBundle.getFormattedMessage("HMGR3603", objectArray, "core group does not exist");
            throw new Exception(string6);
        }
        ArrayList arrayList = CoreGroupConfigHelper.getServersInCluster(configService, session, string3);
        if (arrayList == null) {
            Object[] objectArray = new Object[]{string3};
            String string7 = ivBundle.getFormattedMessage("HMGR3608", objectArray, "cluster does not exist");
            throw new Exception(string7);
        }
        ArrayList<AttributeList> arrayList2 = new ArrayList<AttributeList>();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            list = (AttributeList)arrayList.get(i);
            object2 = (String)ConfigServiceHelper.getAttributeValue(list, "memberName");
            object = (String)ConfigServiceHelper.getAttributeValue(list, "nodeName");
            n = CoreGroupConfigHelper.isServerInCoreGroup(configService, session, string, (String)object, (String)object2);
            if (n == 1) {
                arrayList2.add((AttributeList)list);
                continue;
            }
            if (!bl) continue;
            Object[] objectArray = new Object[]{object2, object, string};
            String string8 = ivBundle.getFormattedMessage("HMGR3605", objectArray, "server not in core group");
            throw new Exception(string8);
        }
        String string9 = CoreGroupConfigHelper.getCellName(session);
        list = CoreGroupConfigHelper.convertClusterListToFQServerNameList(string9, arrayList2);
        object2 = CoreGroupConfigHelper.getCoreGroupServersFQ(configService, session, string);
        object = CoreGroupRuntimeHelper.getRunningServers(string, (List)object2, list);
        if (object.size() > 0) {
            String[] stringArray = object.toArray(new String[object.size()]);
            String string10 = StringUtils.convertStringArrayToString(stringArray);
            Object[] objectArray = new Object[]{string3, string10};
            String string11 = ivBundle.getFormattedMessage("HMGR3613", objectArray, "Cluster " + string3 + " contains running members. Core group members cannot be moved while they are running.  The current running members are:" + string10);
            throw new Exception(string11);
        }
        n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            AttributeList attributeList = (AttributeList)arrayList2.get(n);
            String string12 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
            String string13 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
            CoreGroupConfigHelper.doRemoveServerFromCoreGroup(configService, session, string, string13, string12);
            CoreGroupConfigHelper.doAddServerToCoreGroup(configService, session, string2, string13, string12);
        }
    }

    static void addServerToCoreGroup(Session session, String string, String string2, String string3) throws Exception {
        if (string == null) {
            string = svDefaultCoreGroupName;
        }
        if (string2 == null) {
            Object[] objectArray = new Object[]{"node name", string2};
            String string4 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid node name");
            throw new Exception(string4);
        }
        if (string3 == null) {
            Object[] objectArray = new Object[]{"server name", string3};
            String string5 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid server name");
            throw new Exception(string5);
        }
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        boolean bl = CoreGroupConfigHelper.doesCoreGroupExist(session, string);
        if (!bl) {
            Object[] objectArray = new Object[]{string};
            String string6 = ivBundle.getFormattedMessage("HMGR3603", objectArray, "core group does not exist");
            throw new Exception(string6);
        }
        bl = CoreGroupConfigHelper.isServerInCoreGroup(configService, session, string, string2, string3);
        if (bl) {
            Object[] objectArray = new Object[]{string3, string2};
            String string7 = ivBundle.getFormattedMessage("HMGR3607", objectArray, "server already in a core group");
            throw new Exception(string7);
        }
        CoreGroupConfigHelper.doAddServerToCoreGroup(configService, session, string, string2, string3);
    }

    static void removeServerFromCoreGroup(Session session, String string, String string2, String string3) throws Exception {
        if (string == null) {
            string = svDefaultCoreGroupName;
        }
        if (string2 == null) {
            Object[] objectArray = new Object[]{"node name", string2};
            String string4 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid node name");
            throw new Exception(string4);
        }
        if (string3 == null) {
            Object[] objectArray = new Object[]{"server name", string3};
            String string5 = ivBundle.getFormattedMessage("HMGR3600", objectArray, "invalid server name");
            throw new Exception(string5);
        }
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        boolean bl = CoreGroupConfigHelper.doesCoreGroupExist(session, string);
        if (!bl) {
            Object[] objectArray = new Object[]{string};
            String string6 = ivBundle.getFormattedMessage("HMGR3603", objectArray, "core group does not exist");
            throw new Exception(string6);
        }
        bl = CoreGroupConfigHelper.isServerInCoreGroup(configService, session, string, string2, string3);
        if (!bl) {
            Object[] objectArray = new Object[]{string3, string2, string};
            String string7 = ivBundle.getFormattedMessage("HMGR3605", objectArray, "server not in core group");
            throw new Exception(string7);
        }
        CoreGroupConfigHelper.doRemoveServerFromCoreGroup(configService, session, string, string2, string3);
    }

    static ObjectName getCoreGroupBridgeSettings(Session session) throws Exception {
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "CoreGroupBridgeSettings", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        if (objectNameArray == null) {
            throw new Exception("No CoreGroupBridgeSettings object");
        }
        if (objectNameArray.length > 1) {
            throw new Exception("More than one CoreGroupBridgeSettings objects found");
        }
        return objectNameArray[0];
    }

    private static ConfigService getConfigService() throws Exception {
        if (svConfigService != null) {
            return svConfigService;
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        if (configService != null) {
            return configService;
        }
        Properties properties = new Properties();
        properties.put("location", "local");
        configService = ConfigServiceFactory.createConfigService(true, properties);
        return configService;
    }

    private static String getCellName(Session session) throws Exception {
        CoreGroupConfigHelper.checkSession(session);
        ConfigService configService = CoreGroupConfigHelper.getConfigService();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        ObjectName objectName2 = objectNameArray[0];
        String string = (String)configService.getAttribute(session, objectName2, "name");
        return string;
    }

    private static boolean isCoreGroupEmpty(ConfigService configService, Session session, String string) throws Exception {
        ObjectName objectName = CoreGroupConfigHelper.getCoreGroupObjectName(configService, session, string);
        ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "coreGroupServers");
        return arrayList == null || arrayList.size() == 0;
    }

    private static boolean isServerInCoreGroup(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        AttributeList attributeList = CoreGroupConfigHelper.findCoreGroupServer(configService, session, string, string2, string3);
        return attributeList != null;
    }

    private static boolean isServerClusterMember(ConfigService configService, Session session, String string, String string2) throws Exception {
        ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=" + string2);
        if (objectNameArray.length > 1) {
            Object[] objectArray = new Object[]{string, string2};
            String string3 = ivBundle.getFormattedMessage("HMGR3610", objectArray, "configuration is inconsistent");
            throw new Exception(string3);
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Server", null);
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[0], objectName, null);
        if (objectNameArray2.length != 1) {
            Object[] objectArray = new Object[]{string2, string};
            String string4 = ivBundle.getFormattedMessage("HMGR3611", objectArray, "server not found");
            throw new Exception(string4);
        }
        ObjectName objectName2 = objectNameArray2[0];
        String string5 = (String)configService.getAttribute(session, objectName2, "clusterName");
        return string5 != null;
    }

    private static void doAddServerToCoreGroup(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        ObjectName objectName = CoreGroupConfigHelper.getCoreGroupObjectName(configService, session, string);
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("nodeName", string2));
        attributeList.add(new Attribute("serverName", string3));
        configService.createConfigData(session, objectName, "coreGroupServers", "CoreGroupServer", attributeList);
        CoreGroupConfigHelper.updateHAServiceCoreGroupName(configService, session, string, string2, string3);
    }

    private static void doRemoveServerFromCoreGroup(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        AttributeList attributeList = CoreGroupConfigHelper.findCoreGroupServer(configService, session, string, string2, string3);
        ObjectName objectName = ConfigServiceHelper.createObjectName(attributeList);
        configService.deleteConfigData(session, objectName);
        try {
            ObjectName objectName2 = CoreGroupConfigHelper.getCoreGroupBridgeSettings(session);
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("removeCoreGroupBridgeInterface");
            adminCommand.setConfigSession(session);
            adminCommand.setTargetObject(objectName2);
            adminCommand.setParameter("coreGroupName", string);
            adminCommand.setParameter("nodeName", string2);
            adminCommand.setParameter("serverName", string3);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                throw commandResult.getException();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.admin.CoreGroupConfigHelper.doRemoveServerFromCoreGroup", "791");
            throw new Exception("Unexpected error encountered while attempting to remove server " + string2 + "/" + string3 + " from potential occurences in coregroupbridge configuration documents.", throwable);
        }
    }

    private static ObjectName getCoreGroupObjectName(ConfigService configService, Session session, String string) throws Exception {
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "CoreGroup", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        int n = objectNameArray.length;
        for (int i = 0; i < n; ++i) {
            ObjectName objectName2 = objectNameArray[i];
            String string2 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string.equals(string2)) continue;
            return objectName2;
        }
        throw new Exception("ObjectName for core group " + string + " not found");
    }

    private static ObjectName getHAManagerServiceObjectName(ConfigService configService, Session session, String string, String string2) throws Exception {
        ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=" + string2);
        if (objectNameArray == null || objectNameArray.length == 0) {
            return null;
        }
        if (objectNameArray.length > 1) {
            throw new Exception("Multiple servers found with the same name: node " + string + ", server " + string2);
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "HAManagerService", null);
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[0], objectName, null);
        if (objectNameArray2.length != 1) {
            throw new Exception("HAManagerService Object not found for node/server " + string + "," + string2);
        }
        ObjectName objectName2 = objectNameArray2[0];
        return objectName2;
    }

    private static AttributeList findCoreGroupServer(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        ObjectName objectName = CoreGroupConfigHelper.getCoreGroupObjectName(configService, session, string);
        ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "coreGroupServers");
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        AttributeList attributeList = null;
        for (int i = 0; i < n; ++i) {
            String string4;
            AttributeList attributeList2 = (AttributeList)arrayList.get(i);
            String string5 = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "serverName");
            if (!string3.equals(string5) || !string2.equals(string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "nodeName"))) continue;
            attributeList = attributeList2;
            break;
        }
        return attributeList;
    }

    private static void updateHAServiceCoreGroupName(ConfigService configService, Session session, String string, String string2, String string3) throws Exception {
        ObjectName objectName = CoreGroupConfigHelper.getHAManagerServiceObjectName(configService, session, string2, string3);
        if (objectName == null) {
            throw new Exception("The HAManagerService for node " + string2 + ", server " + string3 + " doesn't exist");
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("coreGroupName", string));
        configService.setAttributes(session, objectName, attributeList);
    }

    private static ArrayList getServersInCluster(ConfigService configService, Session session, String string) throws Exception {
        if (string == null) {
            return null;
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "ServerCluster", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        if (objectNameArray == null || objectNameArray.length == 0) {
            return null;
        }
        int n = objectNameArray.length;
        for (int i = 0; i < n; ++i) {
            ObjectName objectName2 = objectNameArray[i];
            String string2 = (String)configService.getAttribute(session, objectName2, "name");
            if (!string.equals(string2)) continue;
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "members");
            return arrayList;
        }
        return null;
    }

    private static List getCoreGroupServers(ConfigService configService, Session session, String string) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (string == null) {
            return arrayList;
        }
        ObjectName objectName = CoreGroupConfigHelper.getCoreGroupObjectName(configService, session, string);
        ArrayList arrayList2 = (ArrayList)configService.getAttribute(session, objectName, "coreGroupServers");
        if (arrayList2 == null) {
            arrayList2 = arrayList;
        }
        return arrayList2;
    }

    private static List getCoreGroupServersFQ(ConfigService configService, Session session, String string) throws Exception {
        List list = CoreGroupConfigHelper.getCoreGroupServers(configService, session, string);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = CoreGroupConfigHelper.getCellName(session);
        for (int i = 0; i < list.size(); ++i) {
            AttributeList attributeList = (AttributeList)list.get(i);
            String string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
            String string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "serverName");
            arrayList.add(HAMUtil.createFullyQualifiedServerName(string2, string3, string4));
        }
        return arrayList;
    }

    private static List convertClusterListToFQServerNameList(String string, List list) throws AttributeNotFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            AttributeList attributeList = (AttributeList)list.get(i);
            String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
            String string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
            arrayList.add(HAMUtil.createFullyQualifiedServerName(string, string2, string3));
        }
        return arrayList;
    }

    private static void checkSession(Session session) throws Exception {
        if (session == null) {
            throw new Exception("A non-null Session is required");
        }
    }
}

