/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.admin.CoreGroupConfigHelper;
import javax.management.ObjectName;

public class CoreGroupConfigProvider
extends SimpleCommandProvider {
    private static final TraceComponent TC = Tr.register(CoreGroupConfigProvider.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");

    public String getDefaultCoreGroupName(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Session session = abstractAdminCommand.getConfigSession();
        return CoreGroupConfigHelper.getDefaultCoreGroupName(session);
    }

    public String[] getAllCoreGroupNames(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Session session = abstractAdminCommand.getConfigSession();
        return CoreGroupConfigHelper.getAllCoreGroupNames(session);
    }

    public boolean doesCoreGroupExist(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("coreGroupName");
        return CoreGroupConfigHelper.doesCoreGroupExist(session, string);
    }

    public ObjectName createCoreGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("coreGroupName");
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "createCoreGroup", string);
        }
        ObjectName objectName = CoreGroupConfigHelper.createCoreGroup(session, string);
        try {
            ObjectName objectName2 = CoreGroupConfigHelper.getCoreGroupBridgeSettings(session);
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("createCoreGroupAccessPoint");
            adminCommand.setConfigSession(session);
            adminCommand.setTargetObject(objectName2);
            adminCommand.setParameter("coreGroupName", string);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (commandResult.isSuccessful()) {
                return objectName;
            }
            throw commandResult.getException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.admin.CoreGroupConfigProvider.createCoreGroup", "114", this);
            throw new Exception("command failed", throwable);
        }
    }

    public void deleteCoreGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("coreGroupName");
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "deleteCoreGroup", string);
        }
        CoreGroupConfigHelper.deleteCoreGroup(session, string);
        try {
            ObjectName objectName = CoreGroupConfigHelper.getCoreGroupBridgeSettings(session);
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("deleteCoreGroupAccessPoints");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("coreGroupName", string);
            adminCommand.setTargetObject(objectName);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (commandResult.isSuccessful()) {
                return;
            }
            throw commandResult.getException();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.admin.CoreGroupConfigProvider.deleteCoreGroup", "154", this);
            throw new Exception("command failed", throwable);
        }
    }

    public void moveServerToCoreGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("source");
        String string2 = (String)abstractAdminCommand.getParameter("target");
        String string3 = (String)abstractAdminCommand.getParameter("nodeName");
        String string4 = (String)abstractAdminCommand.getParameter("serverName");
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, string2, string3, string4};
            Tr.debug(TC, "moveServerToCoreGroup", objectArray);
        }
        CoreGroupConfigHelper.moveServerToCoreGroup(session, string, string2, string3, string4);
    }

    public void moveClusterToCoreGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("source");
        String string2 = (String)abstractAdminCommand.getParameter("target");
        String string3 = (String)abstractAdminCommand.getParameter("clusterName");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("checkConfig");
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, string2, string3, bl};
            Tr.debug(TC, "moveClusterToCoreGroup", objectArray);
        }
        CoreGroupConfigHelper.moveClusterToCoreGroup(session, string, string2, string3, bl);
    }

    public String getCoreGroupNameForServer(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Session session = abstractAdminCommand.getConfigSession();
        String string = (String)abstractAdminCommand.getParameter("nodeName");
        String string2 = (String)abstractAdminCommand.getParameter("serverName");
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getCoreGroupNameForServer", new Object[]{string, string2});
        }
        return CoreGroupConfigHelper.getCoreGroupForServer(session, string, string2);
    }
}

