/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.admin;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.admin.CoreGroupConfigHelper;
import java.util.Properties;

public class CoreGroupDeleteServerExt
extends AbstractCommandStep {
    private static final TraceComponent TC = Tr.register(CoreGroupDeleteServerExt.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");

    public CoreGroupDeleteServerExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public CoreGroupDeleteServerExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    public void validate() throws CommandValidationException {
    }

    protected void executeStep() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            Session session = this.getConfigSession();
            string2 = (String)this.taskCmd.getParameter("nodeName");
            string3 = (String)this.taskCmd.getParameter("serverName");
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Delete core group server", new Object[]{string2, string3});
            }
            Properties properties = new Properties();
            properties.setProperty("CONFIG_SESSION", session.toString());
            ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(properties);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
            if ("5".equals(managedObjectMetadataHelper.getNodeMajorVersion(string2))) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Node is a V5 node, exiting", string2);
                }
                return;
            }
            string = CoreGroupConfigHelper.getCoreGroupForServer(session, string2, string3);
            if (string == null) {
                return;
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "Delete core group server", new Object[]{string, string2, string3});
            }
            CoreGroupConfigHelper.removeServerFromCoreGroup(session, string, string2, string3);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.admin.CoreGroupDeleteServerExt.executeStep", "93", this);
            Tr.error(TC, "HMGR3001", new Object[]{string3, string2, string, throwable});
            taskCommandResultImpl.setException(throwable);
        }
    }
}

