/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.agent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.agent.AgentClassImpl;
import com.ibm.ws.hamanager.impl.GroupManagerImpl;
import com.ibm.ws.hamanager.impl.HAManagerImpl;
import com.ibm.ws.hamanager.utils.DebugUtils;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.agent.AgentClass;
import com.ibm.wsspi.hamanager.agent.AgentClassAlreadyRegisteredException;
import com.ibm.wsspi.hamanager.agent.AgentClassEvents;
import com.ibm.wsspi.hamanager.agent.AgentClassFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AgentClassFactoryImpl
implements AgentClassFactory {
    private static final TraceComponent svTc = Tr.register(AgentClassFactoryImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private HAManagerImpl ivHam;
    private GroupManagerImpl ivGroupManager;
    private Map ivClassMap;

    public AgentClassFactoryImpl(HAManagerImpl hAManagerImpl, GroupManagerImpl groupManagerImpl) {
        this.ivHam = hAManagerImpl;
        this.ivGroupManager = groupManagerImpl;
        this.ivClassMap = new HashMap();
    }

    public synchronized AgentClass registerClass(Map map, Map map2, AgentClassEvents agentClassEvents, int n, boolean bl, String string) throws HAException {
        Object object;
        if (svTc.isEntryEnabled()) {
            object = new Object[]{string, DebugUtils.dumpMap("class", map), DebugUtils.dumpMap("instance", map2)};
            Tr.entry(svTc, "AgentClass:registerClass", object);
        }
        if (map == null) {
            throw new HAParameterRejectedException("null agentClassId was passed");
        }
        if (map2 == null) {
            throw new HAParameterRejectedException("null instanceId was passed");
        }
        if (agentClassEvents == null) {
            throw new HAParameterRejectedException("null callback was passed");
        }
        if (string == null) {
            throw new HAParameterRejectedException("null channelName was passed");
        }
        MapUtils.validateUserMap(map, "agentClassId");
        MapUtils.validateUserMap(map2, "instanceId");
        map.put("policy", "DefaultNOOPPolicy");
        if (this.ivClassMap.containsKey(map)) {
            throw new AgentClassAlreadyRegisteredException("The AgentClass is already registered");
        }
        try {
            object = new AgentClassImpl(this, this.ivHam, map, map2, agentClassEvents, n, bl, string);
            Map map3 = ((AgentClassImpl)object).getClassIdentifier();
            this.ivClassMap.put(map3, object);
            if (svTc.isEntryEnabled()) {
                Tr.exit(svTc, "AgentClass:registerClass", object);
            }
            return object;
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, "com.ibm.ws.hamanager.agent.AgentClassFactoryImpl.registerClass", "120", this);
            Tr.error(svTc, "HMGR1012", new Object[]{DebugUtils.dumpMap("AgentClassId", map), hAException});
            throw hAException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.hamanager.agent.AgentClassFactoryImpl.registerClass", "125", this);
            Tr.error(svTc, "HMGR1012", new Object[]{DebugUtils.dumpMap("AgentClassId", map), throwable});
            throw new HAException("unknown exception", throwable);
        }
    }

    synchronized void unregisterClass(Map map) {
        this.ivClassMap.remove(map);
    }

    synchronized void shutdown() {
        Iterator iterator = this.ivClassMap.keySet().iterator();
        while (iterator.hasNext()) {
            AgentClassImpl agentClassImpl = (AgentClassImpl)iterator.next();
            try {
                agentClassImpl.shutdown();
            }
            catch (HAException hAException) {
                FFDCFilter.processException((Throwable)hAException, "com.ibm.ws.hamanager.agent.AgentClassFactoryImpl.shutdown", "149", this);
            }
        }
    }

    GroupName getGroupName(Map map) throws HAException {
        return this.ivGroupManager.createGroupNameInternal(map);
    }
}

