/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.agent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.agent.AgentClassFactoryImpl;
import com.ibm.ws.hamanager.agent.AgentImpl;
import com.ibm.ws.hamanager.agent.GrowAgentRequest;
import com.ibm.ws.hamanager.agent.msg.GrowAgentMsg;
import com.ibm.ws.hamanager.datastack.DataStack;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.ws.hamanager.impl.HAManagerImpl;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.utils.DebugUtils;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.MapUtils;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.agent.Agent;
import com.ibm.wsspi.hamanager.agent.AgentClass;
import com.ibm.wsspi.hamanager.agent.AgentClassDestroyedException;
import com.ibm.wsspi.hamanager.agent.AgentClassEvents;
import com.ibm.wsspi.hamanager.agent.AgentDestroyedException;
import com.ibm.wsspi.hamanager.datastack.DataStackEvent;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import com.ibm.wsspi.hamanager.quorum.CoreStackPropertyProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AgentClassImpl
implements AgentClass,
HAGroupCallback,
DataStackCallback {
    private static final TraceComponent svTc = Tr.register(AgentClassImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = AgentClassImpl.class.getName();
    private static final int CREATED = 10;
    private static final int DESTROYING = 20;
    private static final int DESTROYED = 30;
    static final int svAgentDestroyed = 0;
    static final int svDataStackTerminated = 10;
    static final int svDataStackMsgReceived = 11;
    static final int svDataStackMembershipChanged = 12;
    static final int svDataStackEvent = 13;
    private HAGroupImpl ivGroup;
    private GroupMemberId[] ivClassMembers;
    private AgentClassEvents ivEvents;
    private HAManagerImpl ivHam;
    private int ivNumBackups;
    private boolean ivAutoFailover;
    private ArrayList ivPendingRequests;
    private ArrayList ivGrowRequests;
    private int ivNextCandidate;
    private String ivClassName;
    private AgentClassFactoryImpl ivAgentClassFactory;
    private DataStack ivDataStack;
    private String ivChannelName;
    private String[] ivTargets;
    private Map ivAgents;
    private int ivState = 10;
    private GroupMemberId[] ivPreviousDataStackMembership;

    AgentClassImpl(AgentClassFactoryImpl agentClassFactoryImpl, HAManagerImpl hAManagerImpl, Map map, Map map2, AgentClassEvents agentClassEvents, int n, boolean bl, String string) throws HAException {
        this.ivHam = hAManagerImpl;
        this.ivClassName = DebugUtils.dumpMap("AgentClass", map);
        GroupName groupName = agentClassFactoryImpl.getGroupName(map);
        this.ivAgentClassFactory = agentClassFactoryImpl;
        this.ivEvents = agentClassEvents;
        this.ivNumBackups = n;
        this.ivGrowRequests = new ArrayList();
        this.ivPendingRequests = new ArrayList();
        this.ivNextCandidate = 0;
        this.ivAutoFailover = bl;
        this.ivAgents = new HashMap();
        this.ivChannelName = string;
        this.ivGroup = (HAGroupImpl)this.ivHam.joinGroup(groupName, map2, this);
        this.ivDataStack = this.ivGroup.createDataStack(this.ivChannelName, true, this);
        GroupMemberId groupMemberId = this.ivGroup.getMemberName();
        ACCallback aCCallback = new ACCallback(12, new GroupMemberId[]{groupMemberId});
        UserCallbacks.executeCallback(aCCallback);
    }

    public Map getClassIdentifier() {
        return this.ivGroup.getGroupName().getGroupProperties();
    }

    public Map getInstanceIdentifier() throws HAException {
        try {
            return this.ivGroup.getMemberName().getMemberProperties();
        }
        catch (HAGroupLeftException hAGroupLeftException) {
            throw new AgentClassDestroyedException("The AgentClass on this process has been removed.", hAGroupLeftException);
        }
    }

    public HAGroup getHAGroup() {
        return this.ivGroup;
    }

    public GroupMemberId getMemberName() throws HAException {
        GroupMemberId groupMemberId;
        try {
            groupMemberId = this.ivGroup.getMemberName();
        }
        catch (HAGroupLeftException hAGroupLeftException) {
            throw new AgentClassDestroyedException("The AgentClass on this process has been removed.", hAGroupLeftException);
        }
        return groupMemberId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent createInstance(Map map, String string) throws HAException {
        if (map == null) {
            throw new HAParameterRejectedException("null instanceId was passed");
        }
        if (string == null) {
            throw new HAParameterRejectedException("null channel name was passed");
        }
        MapUtils.validateUserMap(map, "agentId");
        try {
            AgentImpl agentImpl = new AgentImpl(this.ivAgentClassFactory, this, map, string);
            AgentClassImpl agentClassImpl = this;
            synchronized (agentClassImpl) {
                this.ivAgents.put(string, agentImpl);
            }
            return agentImpl;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "162", this);
            String string2 = DebugUtils.dumpMap("AgentId", map);
            Tr.error(svTc, "HMGR1000", new Object[]{string2, this.ivClassName, throwable});
            throw new HAException("failure creating agent ", throwable);
        }
    }

    public GroupMemberId[] getClassMembers() {
        return this.ivClassMembers;
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId groupMemberId, byte[] byArray) throws DataStackException, HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (groupMemberId == null) {
            throw new HAParameterRejectedException("A null destination is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        String[] stringArray = new String[]{groupMemberId.getServerName()};
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "send Message point-to-point", new Object[]{this.ivChannelName, stringArray, msgQoS, byArray});
        }
        this.sendMuxedMessage(msgQoS, stringArray, this.ivChannelName, byArray);
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId[] groupMemberIdArray, byte[] byArray) throws DataStackException, HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (groupMemberIdArray == null) {
            throw new HAParameterRejectedException("A null destinations is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "send Message subgroup", new Object[]{this.ivChannelName, msgQoS, byArray});
            Tr.debug(svTc, "destinations ", groupMemberIdArray);
        }
        String[] stringArray = HAMUtil.getServerNames(groupMemberIdArray);
        this.sendMuxedMessage(msgQoS, stringArray, this.ivChannelName, byArray);
    }

    public void sendMessage(MsgQoS msgQoS, byte[] byArray) throws DataStackException, HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "send Message multicast", new Object[]{this.ivChannelName, msgQoS, byArray});
        }
        this.sendMuxedMessage(msgQoS, this.ivTargets, this.ivChannelName, byArray);
    }

    public synchronized void remove() throws HAException {
        this.checkDestroyed();
        if (!this.ivAgents.isEmpty()) {
            throw new HAException("Remove of this AgentClass is not allowed.  Agent instances still exist.");
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "remove requested for", this.ivClassName);
        }
        this.ivState = 20;
        this.ivDataStack.terminateDataStack();
    }

    public boolean isAlive(GroupName groupName) {
        return true;
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        Tr.service(svTc, "HMGR1003", new Object[]{"memberDeactivate", this.ivClassName, new Exception("stack")});
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        Tr.service(svTc, "HMGR1003", new Object[]{"memberIsActivated", this.ivClassName, new Exception("stack")});
    }

    public void memberMayActivate(GroupName groupName) {
        Tr.service(svTc, "HMGR1003", new Object[]{"memberMayActivate", this.ivClassName, new Exception("stack")});
    }

    public void memberMayActivateCancelled(GroupName groupName) {
        Tr.service(svTc, "HMGR1003", new Object[]{"memberMayActivateCancelled", this.ivClassName, new Exception("stack")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "AgentClassImpl:onMessage", "processing growAgent request");
        }
        GrowAgentMsg growAgentMsg = null;
        try {
            growAgentMsg = (GrowAgentMsg)HAMUtil.toObject(byArray);
            Map map = growAgentMsg.getAgentInstanceId();
            long l = growAgentMsg.getSequenceNbr();
            String string = growAgentMsg.getChannelName();
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "processing growAgent request", new Object[]{groupMemberId, growAgentMsg});
            }
            AgentImpl agentImpl = new AgentImpl(this.ivAgentClassFactory, this, map, groupMemberId, l, string);
            AgentClassImpl agentClassImpl = this;
            synchronized (agentClassImpl) {
                this.ivAgents.put(string, agentImpl);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "253", this);
            String string = null;
            if (growAgentMsg != null) {
                string = DebugUtils.dumpMap("Agent : ", growAgentMsg.getAgentInstanceId());
            }
            Tr.warning(svTc, "HMGR1001", new Object[]{"GrowAgentRequest", string, this.ivClassName, throwable});
        }
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "AgentClassImpl:HAGroupMembershipChanged", groupName);
            Tr.entry(svTc, "AgentClassImpl:HAGroupMembershipChanged", groupMemberIdArray);
        }
    }

    public void dataStackMessageReceived(GroupMemberId groupMemberId, String string, byte[] byArray) {
        ACCallback aCCallback = new ACCallback(11, groupMemberId, string, byArray);
        UserCallbacks.executeCallback(aCCallback);
    }

    public void dataStackMembershipChanged(GroupMemberId[] groupMemberIdArray) {
        if (this.ivPreviousDataStackMembership != null && HAMUtil.compareGroupMemberIdArrays(groupMemberIdArray, this.ivPreviousDataStackMembership)) {
            return;
        }
        this.ivPreviousDataStackMembership = groupMemberIdArray;
        ACCallback aCCallback = new ACCallback(12, groupMemberIdArray);
        UserCallbacks.executeCallback(aCCallback);
    }

    public void dataStackTerminated() {
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "data stack terminated for AgentClass=", this.ivClassName);
        }
        if (this.ivState == 20) {
            try {
                this.ivGroup.leave();
                this.ivAgentClassFactory.unregisterClass(this.getClassIdentifier());
                this.ivState = 30;
            }
            catch (HAException hAException) {
                FFDCFilter.processException((Throwable)hAException, svClassName, "537", this);
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "leave group failed for", this.ivClassName);
                }
                Tr.error(svTc, "HMGR0108", new Object[]{svClassName, "dataStackTerminated()", hAException});
            }
        } else {
            ACCallback aCCallback = new ACCallback(10);
            UserCallbacks.executeCallback(aCCallback);
        }
    }

    public void dataStackEvent(DataStackEvent dataStackEvent) {
        ACCallback aCCallback = new ACCallback(13, dataStackEvent);
        UserCallbacks.executeCallback(aCCallback);
    }

    public void dataStackViewAboutToChange() {
    }

    HAManagerImpl getHAManager() {
        return this.ivHam;
    }

    int getNumBackups() {
        return this.ivNumBackups;
    }

    void shutdown() throws HAException {
        this.checkDestroyed();
        this.ivDataStack.terminateDataStack();
    }

    void sendMuxedMessage(MsgQoS msgQoS, String[] stringArray, String string, byte[] byArray) throws DataStackException, HAException {
        this.checkDestroyed();
        this.ivDataStack.sendMessage(stringArray, msgQoS, string, byArray);
    }

    synchronized void growAgent(AgentImpl agentImpl, GrowAgentRequest growAgentRequest) {
        GroupMemberId groupMemberId;
        if (svTc.isEntryEnabled()) {
            Tr.entry(svTc, "AgentClassImpl:growAgent", new Object[]{agentImpl, growAgentRequest});
        }
        if ((groupMemberId = this.findBestServerForAgent(agentImpl)) == null) {
            this.ivPendingRequests.add(growAgentRequest);
            return;
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "dispatching growAgent request", groupMemberId);
        }
        try {
            byte[] byArray = HAMUtil.toByteArray(growAgentRequest.getGrowAgentMsg());
            this.ivGroup.sendMessage(MsgQoS.NORMAL, groupMemberId, byArray);
            growAgentRequest.setCandidate(groupMemberId);
            this.ivGrowRequests.add(growAgentRequest);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, svClassName, "360", this);
            Tr.error(svTc, "HMGR1005", new Object[]{"GrowAgentRequest", agentImpl, iOException});
            agentImpl.growFailed(growAgentRequest);
        }
        catch (DataStackMemberException dataStackMemberException) {
            FFDCFilter.processException((Throwable)dataStackMemberException, svClassName, "366", this);
            Tr.info(svTc, "HMGR1017", new Object[]{agentImpl});
            this.ivPendingRequests.add(growAgentRequest);
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "372", this);
            Tr.warning(svTc, "HMGR1006", new Object[]{"GrowAgentRequest", agentImpl, dataStackException});
            this.ivPendingRequests.add(growAgentRequest);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "378", this);
            Tr.error(svTc, "HMGR1007", new Object[]{"GrowAgentRequest", agentImpl, throwable});
            agentImpl.growFailed(growAgentRequest);
        }
    }

    synchronized void growCompleted(GrowAgentRequest growAgentRequest) {
        if (this.ivGrowRequests.contains(growAgentRequest)) {
            this.ivGrowRequests.remove(growAgentRequest);
        } else {
            Tr.service(svTc, "HMGR1002", new Object[]{this.ivClassName, growAgentRequest.getAgent(), new Exception("stack")});
        }
    }

    void agentCreated(Agent agent) {
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getCanonicalName() + ".created()");
        }
        this.ivEvents.created(this, agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void agentDestroyed(AgentImpl agentImpl) {
        String string = agentImpl.getChannelName();
        AgentClassImpl agentClassImpl = this;
        synchronized (agentClassImpl) {
            this.ivAgents.remove(string);
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getCanonicalName() + ".destroyed()");
        }
        this.ivEvents.destroyed(this, agentImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void secondaryAgentDestroyed(AgentImpl agentImpl) {
        String string = agentImpl.getChannelName();
        Object object = this;
        synchronized (object) {
            this.ivAgents.remove(string);
        }
        object = new ACCallback(0, agentImpl);
        UserCallbacks.executeCallback((UserCallback)object);
    }

    void agentMembershipChanged(Agent agent) {
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getCanonicalName() + ".instanceMembershipChanged()");
        }
        this.ivEvents.instanceMembershipChanged(this, agent);
    }

    synchronized boolean cancelGrowRequest(Agent agent, GrowAgentRequest growAgentRequest) {
        if (this.ivPendingRequests.contains(growAgentRequest)) {
            this.ivPendingRequests.remove(growAgentRequest);
            return true;
        }
        return false;
    }

    boolean isAutoFailover() {
        return this.ivAutoFailover;
    }

    private GroupMemberId findBestServerForAgent(Agent agent) {
        int n;
        GroupMemberId[] groupMemberIdArray = this.getEligibleServerList(agent);
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "eligible server list", groupMemberIdArray);
        }
        if (groupMemberIdArray.length == 0) {
            return null;
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getCanonicalName() + ".findBestBackupMember()");
        }
        if ((n = this.ivEvents.findBestBackupMember(this, agent, groupMemberIdArray)) >= 0 && n < groupMemberIdArray.length) {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "selected member", groupMemberIdArray[n]);
            }
            return groupMemberIdArray[n];
        }
        if (n == -2) {
            return null;
        }
        if (n == -1) {
            if (groupMemberIdArray.length == 1) {
                return groupMemberIdArray[0];
            }
            n = this.ivNextCandidate++ % groupMemberIdArray.length;
            return groupMemberIdArray[n];
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "invalid user selection", new Integer(n));
        }
        return null;
    }

    private GroupMemberId[] getEligibleServerList(Agent agent) {
        GroupMemberId[] groupMemberIdArray;
        if (this.ivClassMembers == null) {
            return new GroupMemberId[0];
        }
        GroupMemberId[] groupMemberIdArray2 = null;
        try {
            groupMemberIdArray2 = agent.getMembers();
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "536", this);
            Tr.error(svTc, "HMGR1016", new Object[]{this.ivClassName, hAException});
        }
        if (groupMemberIdArray2 == null) {
            return new GroupMemberId[0];
        }
        ArrayList<GroupMemberId> arrayList = null;
        arrayList = this.findServersInDifferentDUs(agent);
        if (arrayList == null) {
            int n = this.ivClassMembers.length;
            arrayList = new ArrayList<GroupMemberId>(n);
            for (int i = 0; i < n; ++i) {
                if (this.isServerInList(this.ivClassMembers[i], groupMemberIdArray2)) continue;
                arrayList.add(this.ivClassMembers[i]);
            }
        }
        if ((groupMemberIdArray = new GroupMemberId[arrayList.size()]).length != 0) {
            arrayList.toArray(groupMemberIdArray);
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "eligible server list", DebugUtils.dumpGroupMemberList(groupMemberIdArray));
        }
        return groupMemberIdArray;
    }

    private ArrayList findServersInDifferentDUs(Agent agent) {
        String string;
        int n;
        ArrayList<GroupMemberId> arrayList = new ArrayList<GroupMemberId>(10);
        GroupMemberId[] groupMemberIdArray = null;
        try {
            groupMemberIdArray = agent.getMembers();
        }
        catch (AgentDestroyedException agentDestroyedException) {
            FFDCFilter.processException((Throwable)agentDestroyedException, svClassName, "586", this);
            Tr.error(svTc, "HMGR1016", new Object[]{this.ivClassName, agentDestroyedException});
        }
        HashSet<String> hashSet = new HashSet<String>();
        CoreStackPropertyProvider coreStackPropertyProvider = this.ivHam.getCoordinator().getCoreStackPropertyProvider();
        for (n = 0; n < groupMemberIdArray.length; ++n) {
            string = coreStackPropertyProvider.getServerProperty(groupMemberIdArray[n].getServerName(), "IBM_DISASTER_UNIT");
            if (string == null) {
                return null;
            }
            hashSet.add(string);
        }
        for (n = 0; n < this.ivClassMembers.length; ++n) {
            string = coreStackPropertyProvider.getServerProperty(this.ivClassMembers[n].getServerName(), "IBM_DISASTER_UNIT");
            if (string != null) {
                if (hashSet.contains(string)) continue;
                arrayList.add(this.ivClassMembers[n]);
                continue;
            }
            return null;
        }
        return arrayList;
    }

    private boolean isServerInList(GroupMemberId groupMemberId, GroupMemberId[] groupMemberIdArray) {
        String string = groupMemberId.getServerName();
        int n = groupMemberIdArray.length;
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "isServerInList", new Object[]{groupMemberId, DebugUtils.dumpGroupMemberList(groupMemberIdArray)});
        }
        for (int i = 0; i < n; ++i) {
            if (!string.equals(groupMemberIdArray[i].getServerName())) continue;
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "isServerInList", "match found");
            }
            return true;
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "isServerInList", "no match");
        }
        return false;
    }

    private void scrubGrowRequestList() {
        int n;
        if (svTc.isDebugEnabled()) {
            this.dumpGrowList("enter scrubGrowRequestList - dump pending list", this.ivPendingRequests);
            this.dumpGrowList("enter scrubGrowRequestList - dump grow request list", this.ivGrowRequests);
        }
        if ((n = this.ivGrowRequests.size()) > 0) {
            ArrayList arrayList = this.ivGrowRequests;
            this.ivGrowRequests = new ArrayList();
            for (int i = 0; i < n; ++i) {
                GrowAgentRequest growAgentRequest = (GrowAgentRequest)arrayList.get(i);
                GroupMemberId groupMemberId = growAgentRequest.getCandidate();
                if (this.isServerInList(groupMemberId, this.ivClassMembers)) {
                    this.ivGrowRequests.add(growAgentRequest);
                    continue;
                }
                growAgentRequest.setCandidate(null);
                this.ivPendingRequests.add(growAgentRequest);
            }
        }
        if (svTc.isDebugEnabled()) {
            this.dumpGrowList("exit scrubGrowRequestList - dump pending list", this.ivPendingRequests);
            this.dumpGrowList("exit scrubGrowRequestList - dump grow request list", this.ivGrowRequests);
        }
    }

    private void processPendingRequests() {
        int n;
        if (svTc.isDebugEnabled()) {
            this.dumpGrowList("enter processPendingRequests - dump pending list", this.ivPendingRequests);
            this.dumpGrowList("enter processPendingRequests - dump grow list", this.ivGrowRequests);
        }
        if ((n = this.ivPendingRequests.size()) > 0) {
            ArrayList arrayList = this.ivPendingRequests;
            this.ivPendingRequests = new ArrayList();
            for (int i = 0; i < n; ++i) {
                GrowAgentRequest growAgentRequest = (GrowAgentRequest)arrayList.get(i);
                AgentImpl agentImpl = growAgentRequest.getAgent();
                Object v = this.ivAgents.get(agentImpl.getChannelName());
                if (v == null) continue;
                this.growAgent(agentImpl, growAgentRequest);
            }
        }
        if (svTc.isDebugEnabled()) {
            this.dumpGrowList("exit processPendingRequests - dump pending list", this.ivPendingRequests);
            this.dumpGrowList("exit processPendingRequests - dump grow list", this.ivGrowRequests);
        }
    }

    private void checkDestroyed() throws AgentClassDestroyedException {
        if (this.ivState == 20 || this.ivState == 30) {
            throw new AgentClassDestroyedException("This operation cannot be performed. The AgentClass has been removed.");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("AgentClass: GroupName = ");
            stringBuffer.append(this.ivGroup.getGroupName().toString());
            stringBuffer.append(" number of secondaries " + this.ivNumBackups);
            stringBuffer.append(" channel " + this.ivChannelName);
            stringBuffer.append(" current group members :" + DebugUtils.dumpGroupMemberList(this.ivClassMembers));
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "731", this);
            stringBuffer.append("..error encountered");
            return stringBuffer.toString();
        }
    }

    private void dumpGrowList(String string, ArrayList arrayList) {
        int n = arrayList.size();
        if (n < 1) {
            Tr.debug(svTc, string, "List is empty");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            GrowAgentRequest growAgentRequest = (GrowAgentRequest)arrayList.get(i);
            stringBuffer.append(" : ");
            stringBuffer.append(growAgentRequest.toString());
        }
        Tr.debug(svTc, string, stringBuffer.toString());
    }

    void doAgentDestroyed(Agent agent) {
        try {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getCanonicalName() + ".destroyed()");
            }
            this.ivEvents.destroyed(this, agent);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1112", this);
            Tr.error(svTc, "HMGR0142", throwable);
        }
    }

    void doAgentClassTerminated() {
        try {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getCanonicalName() + ".terminated()");
            }
            this.ivEvents.terminated(this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1133", this);
            Tr.error(svTc, "HMGR0142", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doDataStackMessageReceived(GroupMemberId groupMemberId, String string, byte[] byArray) {
        try {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "doDataStackMessageReceived", new Object[]{string, groupMemberId, byArray});
            }
            if (this.ivChannelName.equals(string)) {
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getName() + ".agentClassMessageReceived()");
                }
                this.ivEvents.agentClassMessageReceived((AgentClass)this, groupMemberId, byArray);
                return;
            }
            Agent agent = null;
            Object[] objectArray = this;
            synchronized (this) {
                agent = (Agent)this.ivAgents.get(string);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                if (agent == null) {
                    objectArray = new Object[]{string, groupMemberId, this.ivChannelName, this.ivAgents.keySet()};
                    Tr.warning(svTc, "HMGR1019", objectArray);
                    return;
                } else {
                    if (svTc.isDebugEnabled()) {
                        Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getName() + ".agentMessageReceived()");
                    }
                    this.ivEvents.agentMessageReceived((AgentClass)this, agent, groupMemberId, byArray);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1133", (Object)this);
            Tr.error(svTc, "HMGR0142", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDataStackMembershipChanged(GroupMemberId[] groupMemberIdArray) {
        try {
            if (svTc.isEntryEnabled()) {
                Tr.entry(svTc, "AgentClassImpl:membershipChanged", this.ivGroup.getGroupName());
                Tr.entry(svTc, "AgentClassImpl:membershipChanged", groupMemberIdArray);
            }
            AgentClassImpl agentClassImpl = this;
            synchronized (agentClassImpl) {
                this.ivClassMembers = groupMemberIdArray;
                this.ivTargets = HAMUtil.getServerNames(this.ivClassMembers);
                this.scrubGrowRequestList();
                this.processPendingRequests();
            }
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getName() + ".classMembershipChanged()");
            }
            this.ivEvents.classMembershipChanged(this);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "294", this);
            Tr.error(svTc, "HMGR1014", new Object[]{this.ivClassName, throwable});
        }
    }

    void doDataStackEvent(DataStackEvent dataStackEvent) {
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "doCallback - " + this.ivEvents.getClass().getName() + ".congestionEvent()");
        }
        this.ivEvents.congestionEvent(this, dataStackEvent);
    }

    private class ACCallback
    implements UserCallback {
        private AgentClassImpl ivAC;
        private int ivOperation;
        private String ivUserCallbackName;
        private Agent ivAgent;
        private GroupMemberId ivSender;
        private String ivChannel;
        private byte[] ivMessage;
        private GroupMemberId[] ivMembers;
        private DataStackEvent ivEvent;

        ACCallback(int n, Agent agent) {
            this.ivAC = AgentClassImpl.this;
            this.ivOperation = n;
            this.ivAgent = agent;
            this.ivUserCallbackName = AgentClassImpl.this.ivEvents.getClass().getName();
        }

        ACCallback(int n) {
            this.ivAC = AgentClassImpl.this;
            this.ivOperation = n;
            this.ivUserCallbackName = AgentClassImpl.this.ivEvents.getClass().getName();
        }

        ACCallback(int n, GroupMemberId groupMemberId, String string, byte[] byArray) {
            this.ivAC = AgentClassImpl.this;
            this.ivOperation = n;
            this.ivSender = groupMemberId;
            this.ivChannel = string;
            this.ivMessage = byArray;
            this.ivUserCallbackName = AgentClassImpl.this.ivEvents.getClass().getName();
        }

        ACCallback(int n, GroupMemberId[] groupMemberIdArray) {
            this.ivAC = AgentClassImpl.this;
            this.ivOperation = n;
            this.ivMembers = groupMemberIdArray;
            this.ivUserCallbackName = AgentClassImpl.this.ivEvents.getClass().getName();
        }

        ACCallback(int n, DataStackEvent dataStackEvent) {
            this.ivAC = AgentClassImpl.this;
            this.ivOperation = n;
            this.ivEvent = dataStackEvent;
            this.ivUserCallbackName = AgentClassImpl.this.ivEvents.getClass().getName();
        }

        public void doCallback() {
            switch (this.ivOperation) {
                case 0: {
                    this.ivAC.doAgentDestroyed(this.ivAgent);
                    break;
                }
                case 11: {
                    this.ivAC.doDataStackMessageReceived(this.ivSender, this.ivChannel, this.ivMessage);
                    break;
                }
                case 12: {
                    this.ivAC.doDataStackMembershipChanged(this.ivMembers);
                    break;
                }
                case 13: {
                    this.ivAC.doDataStackEvent(this.ivEvent);
                    break;
                }
                case 10: {
                    this.ivAC.doAgentClassTerminated();
                }
            }
        }

        public int getQueue(int n) {
            int n2 = Math.abs(this.ivAC.hashCode());
            if (n2 < 0) {
                n2 = 0;
            }
            int n3 = n2 % n;
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "getQueue() - AgentClass hashcode=" + n2 + ", number of queues=" + n + ", hc % numberOfQueues=" + n3);
            }
            return n3;
        }

        public String getUserClassName() {
            return this.ivUserCallbackName;
        }
    }
}

