/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.agent;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.agent.AgentClassFactoryImpl;
import com.ibm.ws.hamanager.agent.AgentClassImpl;
import com.ibm.ws.hamanager.agent.GrowAgentRequest;
import com.ibm.ws.hamanager.agent.msg.DestroyAgentMsg;
import com.ibm.ws.hamanager.utils.DebugUtils;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.agent.Agent;
import com.ibm.wsspi.hamanager.agent.AgentClass;
import com.ibm.wsspi.hamanager.agent.AgentDestroyedException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.DataStackMemberException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.io.IOException;
import java.util.Map;

public class AgentImpl
implements Agent,
HAGroupCallback {
    static final String SEQ_ATTR = "ibm_agent.seq";
    private static final int CREATING = 0;
    private static final int CREATED = 1;
    private static final int DESTROYING = 2;
    private static final int DESTROYED = 3;
    private static final TraceComponent svTc = Tr.register(AgentImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = AgentImpl.class.getName();
    private AgentClassImpl ivAgentClass;
    private Map ivInstanceId;
    private Map ivGrowMap;
    private HAGroup ivGroup = null;
    private GroupMemberId[] ivMembers = null;
    private GroupMemberId ivPrimaryGmId;
    private boolean ivPrimary = false;
    private long ivSequence;
    private long ivLastSecondary;
    private GrowAgentRequest ivGrowRequest = null;
    private int ivState = 0;
    private String ivAgentName;
    private String ivChannelName;
    private String[] ivTargets;

    AgentImpl(AgentClassFactoryImpl agentClassFactoryImpl, AgentClassImpl agentClassImpl, Map map, String string) throws Exception {
        this.ivAgentClass = agentClassImpl;
        this.ivPrimary = true;
        this.ivSequence = 1L;
        this.ivLastSecondary = 1L;
        this.ivChannelName = string;
        Map map2 = HAMUtil.copyHashMap(map);
        map2.put("policy", "DefaultNOOPPolicy");
        GroupName groupName = agentClassFactoryImpl.getGroupName(map2);
        this.ivGrowMap = HAMUtil.copyHashMap(map);
        map.put(SEQ_ATTR, Long.toString(this.ivSequence));
        this.ivGroup = this.ivAgentClass.getHAManager().joinGroup(groupName, map, this);
        this.ivInstanceId = this.ivGroup.getMemberName().getMemberProperties();
        this.ivPrimaryGmId = this.ivGroup.getMemberName();
        this.ivTargets = new String[]{this.ivPrimaryGmId.getServerName()};
        this.ivAgentName = DebugUtils.dumpMap("Agent : ", this.ivInstanceId);
    }

    AgentImpl(AgentClassFactoryImpl agentClassFactoryImpl, AgentClassImpl agentClassImpl, Map map, GroupMemberId groupMemberId, long l, String string) throws Exception {
        this.ivAgentClass = agentClassImpl;
        this.ivPrimaryGmId = groupMemberId;
        this.ivPrimary = false;
        this.ivSequence = l;
        this.ivChannelName = string;
        Map map2 = HAMUtil.copyHashMap(map);
        map2.put("policy", "DefaultNOOPPolicy");
        GroupName groupName = agentClassFactoryImpl.getGroupName(map2);
        this.ivGrowMap = HAMUtil.copyHashMap(map);
        map.put(SEQ_ATTR, Long.toString(this.ivSequence));
        this.ivGroup = this.ivAgentClass.getHAManager().joinGroup(groupName, map, this);
        this.ivInstanceId = this.ivGroup.getMemberName().getMemberProperties();
        this.ivAgentName = DebugUtils.dumpMap("Agent : ", this.ivInstanceId);
    }

    public AgentClass getAgentClass() {
        return this.ivAgentClass;
    }

    public Map getInstanceId() {
        return this.ivInstanceId;
    }

    public GroupMemberId getPrimaryId() {
        return this.ivPrimaryGmId;
    }

    public HAGroup getHAGroup() {
        return this.ivGroup;
    }

    public GroupMemberId getMemberName() throws HAException {
        GroupMemberId groupMemberId;
        try {
            groupMemberId = this.ivGroup.getMemberName();
        }
        catch (HAGroupLeftException hAGroupLeftException) {
            throw new AgentDestroyedException("The Agent instance is being destroyed.", hAGroupLeftException);
        }
        return groupMemberId;
    }

    public boolean isPrimary() throws AgentDestroyedException {
        this.checkDestroyed();
        return this.ivPrimary;
    }

    public synchronized void destroy() throws HAException {
        if (!this.ivPrimary) {
            throw new HAException("Calling destroy is not allowed on a secondary Agent");
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "destroy()", new Object[]{this, new Long(this.ivSequence), this.ivGrowRequest});
        }
        this.ivState = 2;
        if (this.ivGrowRequest != null) {
            boolean bl = this.ivAgentClass.cancelGrowRequest(this, this.ivGrowRequest);
            if (bl) {
                this.ivGrowRequest = null;
            } else {
                Tr.info(svTc, "HMGR1018", this);
            }
        }
        DestroyAgentMsg destroyAgentMsg = new DestroyAgentMsg(this.ivSequence);
        try {
            byte[] byArray = HAMUtil.toByteArray(destroyAgentMsg);
            this.ivGroup.sendMessage(MsgQoS.NORMAL, this.ivMembers, byArray);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, svClassName, "219", this);
            Tr.error(svTc, "HMGR1005", new Object[]{"DestroyAgentMessage", this.ivAgentName, iOException});
            throw new HAException("failure encountered serializing message", iOException);
        }
        catch (DataStackMemberException dataStackMemberException) {
            FFDCFilter.processException((Throwable)dataStackMemberException, svClassName, "225", this);
            Tr.info(svTc, "HMGR1017", new Object[]{"DestroyAgentMessge", this});
        }
        catch (DataStackException dataStackException) {
            FFDCFilter.processException((Throwable)dataStackException, svClassName, "230", this);
            Tr.warning(svTc, "HMGR1006", new Object[]{"DestroyAgentMessage", this.ivAgentName, dataStackException});
            throw new HAException("communication failure", dataStackException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "236", this);
            Tr.error(svTc, "HMGR1007", new Object[]{"DestroyAgentMessage", this.ivAgentName, throwable});
            throw new HAException("failure encountered during destroy of Agent", throwable);
        }
    }

    public synchronized void destroySecondary() throws HAException {
        this.checkDestroyed();
        if (this.ivPrimary) {
            throw new HAException("Calling destroySecondary is not allowed on a primary Agent");
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "destorySecondary() : Instance ID=", this.ivInstanceId);
        }
        this.ivState = 2;
        this.ivGroup.leave();
        this.ivAgentClass.secondaryAgentDestroyed(this);
        this.ivState = 3;
    }

    public GroupMemberId[] getMembers() throws AgentDestroyedException {
        this.checkDestroyed();
        return this.ivMembers;
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId groupMemberId, byte[] byArray) throws DataStackException, HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (groupMemberId == null) {
            throw new HAParameterRejectedException("A null destinations is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "send Message point-to-point", new Object[]{this.ivChannelName, groupMemberId, msgQoS, byArray});
        }
        String[] stringArray = new String[]{groupMemberId.getServerName()};
        this.ivAgentClass.sendMuxedMessage(msgQoS, stringArray, this.ivChannelName, byArray);
    }

    public void sendMessage(MsgQoS msgQoS, GroupMemberId[] groupMemberIdArray, byte[] byArray) throws DataStackException, HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (groupMemberIdArray == null) {
            throw new HAParameterRejectedException("A null destinations is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "send Message subgroup", new Object[]{this.ivChannelName, msgQoS, byArray});
            Tr.debug(svTc, "destinations", groupMemberIdArray);
        }
        String[] stringArray = HAMUtil.getServerNames(groupMemberIdArray);
        this.ivAgentClass.sendMuxedMessage(msgQoS, stringArray, this.ivChannelName, byArray);
    }

    public void sendMessage(MsgQoS msgQoS, byte[] byArray) throws DataStackException, HAException {
        if (msgQoS == null) {
            throw new HAParameterRejectedException("A null qos is not allowed");
        }
        if (msgQoS.equals(MsgQoS.VS_CURRENT)) {
            throw new HAParameterRejectedException("A VS MsgQoS is not allowed");
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("A null message is not allowed");
        }
        if (svTc.isDebugEnabled()) {
            Tr.debug(svTc, "send Message multicast", new Object[]{this.ivChannelName, msgQoS, byArray});
        }
        this.ivAgentClass.sendMuxedMessage(msgQoS, this.ivTargets, this.ivChannelName, byArray);
    }

    public boolean isAlive(GroupName groupName) {
        return true;
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        Tr.service(svTc, "HMGR1004", new Object[]{"memberDeactivate", this.ivAgentName, new Exception("stack")});
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        Tr.service(svTc, "HMGR1004", new Object[]{"memberIsActivated", this.ivAgentName, new Exception("stack")});
    }

    public void memberMayActivate(GroupName groupName) {
        Tr.service(svTc, "HMGR1004", new Object[]{"memberMayActivate", this.ivAgentName, new Exception("stack")});
    }

    public void memberMayActivateCancelled(GroupName groupName) {
        Tr.service(svTc, "HMGR1004", new Object[]{"memberMayActivateCancelled", this.ivAgentName, new Exception("stack")});
    }

    public synchronized void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (this.ivState == 3) {
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "AgentImpl:onMessage", new Object[]{"Agent=" + this.ivAgentName, "Ignoring destroy message", "state=" + String.valueOf(this.ivState)});
            }
            return;
        }
        DestroyAgentMsg destroyAgentMsg = null;
        try {
            destroyAgentMsg = (DestroyAgentMsg)HAMUtil.toObject(byArray);
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "onMessage processing DestroyAgentMsg", destroyAgentMsg);
            }
            this.ivState = 2;
            this.ivGroup.leave();
            this.ivAgentClass.agentDestroyed(this);
            this.ivState = 3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "329", this);
            if (this.ivPrimary) {
                Tr.error(svTc, "HMGR1008", new Object[]{this.ivAgentName, throwable});
            }
            Tr.error(svTc, "HMGR1009", new Object[]{this.ivAgentName, throwable});
        }
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        try {
            int n;
            int n2;
            long l;
            long l2;
            if (svTc.isEntryEnabled()) {
                Tr.entry(svTc, "AgentImpl:membershipChanged-currentMembers", this.ivMembers);
                Tr.entry(svTc, "AgentImpl:membershipChanged-newMembers", groupMemberIdArray);
            }
            if (this.ivState == 2 || this.ivState == 3) {
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "AgentImpl:membershipChanged", new Object[]{groupName, new Integer(this.ivState)});
                }
                return;
            }
            GroupMemberId[] groupMemberIdArray2 = this.validateAgentMembership(groupMemberIdArray);
            boolean bl = HAMUtil.compareGroupMemberIdArrays(groupMemberIdArray2, this.ivMembers);
            if (bl) {
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "AgentImpl:membershipChanged - no change of members.");
                }
                return;
            }
            this.ivMembers = groupMemberIdArray2;
            this.ivTargets = HAMUtil.getServerNames(this.ivMembers);
            GroupMemberId groupMemberId = null;
            boolean bl2 = this.ivPrimary;
            if (this.ivMembers.length == 1) {
                l2 = this.ivSequence;
                l = this.ivSequence;
                groupMemberId = this.ivMembers[0];
            } else {
                l2 = 1L;
                l = Long.MAX_VALUE;
                n2 = this.ivMembers.length;
                for (n = 0; n < n2; ++n) {
                    GroupMemberId groupMemberId2 = this.ivMembers[n];
                    Map map = groupMemberId2.getMemberProperties();
                    long l3 = Long.parseLong((String)map.get(SEQ_ATTR));
                    if (l3 == 1L) {
                        l = 1L;
                        groupMemberId = groupMemberId2;
                        continue;
                    }
                    l2 = Math.max(l2, l3);
                    long l4 = Math.min(l, l3);
                    if (l4 >= l) continue;
                    l = l4;
                    groupMemberId = groupMemberId2;
                }
            }
            this.ivPrimaryGmId = groupMemberId;
            if (!this.ivPrimary && this.ivAgentClass.isAutoFailover()) {
                boolean bl3 = this.ivPrimary = l == this.ivSequence;
            }
            if (this.ivState == 0) {
                this.ivState = 1;
                this.ivAgentClass.agentCreated(this);
            } else {
                this.ivAgentClass.agentMembershipChanged(this);
            }
            if (!this.ivPrimary) {
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "membership change detected, this Agent is not the primary");
                }
                return;
            }
            if (this.ivState == 2 || this.ivState == 3) {
                if (svTc.isDebugEnabled()) {
                    Tr.debug(svTc, "AgentImpl:membershipChanged", new Object[]{groupName, new Integer(this.ivState)});
                }
                return;
            }
            n2 = this.ivAgentClass.getNumBackups() - (this.ivMembers.length - 1);
            if (!bl2) {
                if (svTc.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{new Long(this.ivSequence), new Integer(n2), new Long(l2)};
                    Tr.debug(svTc, "Agent has become primary, create new secondary", objectArray);
                }
                this.ivLastSecondary = l2;
                ++this.ivLastSecondary;
                this.sendGrowRequest();
            } else {
                if (this.ivLastSecondary < l2) {
                    this.ivLastSecondary = l2;
                }
                if (svTc.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{new Long(this.ivSequence), new Integer(n2), new Long(l2)};
                    Tr.debug(svTc, "Primary unchanged", objectArray);
                }
                if (this.ivGrowRequest == null) {
                    if (n2 > 0) {
                        this.sendGrowRequest();
                    }
                } else {
                    n = 0;
                    if (l2 == this.ivLastSecondary) {
                        n = 1;
                    }
                    if (n == 0) {
                        if (svTc.isDebugEnabled()) {
                            Tr.debug(svTc, "Outstanding grow request has not completed");
                        }
                    } else {
                        this.ivAgentClass.growCompleted(this.ivGrowRequest);
                        this.ivGrowRequest = null;
                        if (svTc.isDebugEnabled()) {
                            Tr.debug(svTc, "Outstanding grow request has completed", new Integer(n2));
                        }
                        if (n2 > 0) {
                            this.sendGrowRequest();
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "495", this);
            Tr.error(svTc, "HMGR1013", new Object[]{this.ivAgentName, throwable});
        }
    }

    long getSequence() {
        return this.ivSequence;
    }

    String getChannelName() {
        return this.ivChannelName;
    }

    void growFailed(GrowAgentRequest growAgentRequest) {
        this.ivGrowRequest = null;
    }

    private void sendGrowRequest() {
        try {
            ++this.ivLastSecondary;
            this.ivGrowRequest = new GrowAgentRequest(this, this.ivGrowMap, this.ivLastSecondary, this.ivChannelName);
            if (svTc.isDebugEnabled()) {
                Tr.debug(svTc, "Sending grow request to AgentClass", this.ivGrowRequest);
            }
            this.ivAgentClass.growAgent(this, this.ivGrowRequest);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "552", this);
            Tr.error(svTc, "HMGR1015", new Object[]{this.ivAgentName, throwable});
        }
    }

    private void checkDestroyed() throws AgentDestroyedException {
        if (this.ivState == 2 || this.ivState == 3) {
            throw new AgentDestroyedException("This operation cannot be performed. The Agent has been destroyed.");
        }
    }

    private GroupMemberId[] validateAgentMembership(GroupMemberId[] groupMemberIdArray) {
        GroupMemberId[] groupMemberIdArray2 = HAMUtil.getIntersectingMemberList(groupMemberIdArray, this.ivAgentClass.getClassMembers());
        boolean bl = HAMUtil.compareGroupMemberIdArrays(groupMemberIdArray2, groupMemberIdArray);
        if (bl) {
            return groupMemberIdArray;
        }
        String string = DebugUtils.dumpGroupMemberList(groupMemberIdArray);
        String string2 = DebugUtils.dumpGroupMemberList(this.ivAgentClass.getClassMembers());
        String string3 = "\nAgent members=" + string + "\nAgentClass members=" + string2;
        HAException hAException = new HAException("Agent and AgentClass - membership mismatch" + string3);
        FFDCFilter.processException((Throwable)hAException, svClassName, "816", this);
        return groupMemberIdArray2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.ivAgentName);
            stringBuffer.append(" sequence = " + this.ivSequence);
            stringBuffer.append(" primary = " + this.ivPrimary + " ");
            stringBuffer.append(" channel = " + this.ivChannelName + " ");
            stringBuffer.append(" internal state = " + this.ivState);
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            stringBuffer.append("...error");
            return stringBuffer.toString();
        }
    }
}

