/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.ws.hamanager.bboard.SubjectSubscriptionImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;

public class BBUserMonitor {
    private static final String svClassName = "BBUserMonitor";
    private static final TraceComponent TC_BBSTATS = Tr.register("BB_STATS", null, "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private HashMap ivStatsMap = new HashMap();
    private boolean ivIsReporterRunning = false;
    private BBReporter ivReporter;
    private String ivCoreGroupName;
    static /* synthetic */ Class class$com$ibm$ws$hamanager$bboard$BBUserMonitor$BBReporter;

    BBUserMonitor(String string) {
        this.ivCoreGroupName = string;
        this.transitionReporter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callbackCompleted(SubjectSubscriptionImpl subjectSubscriptionImpl, SubjectValue[] subjectValueArray, long l) {
        if (this.doCalculateFinest()) {
            BBUserMonitor bBUserMonitor = this;
            synchronized (bBUserMonitor) {
                try {
                    SubjectStats subjectStats = this.getStats((SubjectInfoImpl)subjectSubscriptionImpl.getSubject());
                    if (subjectSubscriptionImpl.isBridgeSubscription()) {
                        subjectStats.proxyCallbackComplete(l, subjectValueArray);
                    } else {
                        subjectStats.callbackComplete(l, subjectValueArray);
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, svClassName, "65", this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPost(SubjectInfoImpl subjectInfoImpl) {
        if (this.doCalculateFine()) {
            BBUserMonitor bBUserMonitor = this;
            synchronized (bBUserMonitor) {
                SubjectStats subjectStats = this.getStats(subjectInfoImpl);
                subjectStats.create();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createProxyPost(SubjectInfoImpl subjectInfoImpl, byte[] byArray) {
        if (this.doCalculateFine()) {
            BBUserMonitor bBUserMonitor = this;
            synchronized (bBUserMonitor) {
                SubjectStats subjectStats = this.getStats(subjectInfoImpl);
                subjectStats.createProxy(byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(SubjectInfoImpl subjectInfoImpl) {
        if (this.doCalculateFine()) {
            BBUserMonitor bBUserMonitor = this;
            synchronized (bBUserMonitor) {
                SubjectStats subjectStats = this.getStats(subjectInfoImpl);
                subjectStats.subscribe(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeProxy(SubjectInfoImpl subjectInfoImpl) {
        if (this.doCalculateFine()) {
            BBUserMonitor bBUserMonitor = this;
            synchronized (bBUserMonitor) {
                SubjectStats subjectStats = this.getStats(subjectInfoImpl);
                subjectStats.subscribe(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(SubjectInfoImpl subjectInfoImpl) {
        if (this.doCalculateFine()) {
            BBUserMonitor bBUserMonitor = this;
            synchronized (bBUserMonitor) {
                SubjectStats subjectStats = this.getStats(subjectInfoImpl);
                subjectStats.unsubscribe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePost(SubjectInfoImpl subjectInfoImpl, byte[] byArray, boolean bl) {
        if (this.doCalculateFine()) {
            BBUserMonitor bBUserMonitor = this;
            synchronized (bBUserMonitor) {
                SubjectStats subjectStats = this.getStats(subjectInfoImpl);
                subjectStats.update(byArray, bl);
            }
        }
    }

    protected boolean doCalculateFine() {
        boolean bl = TC_BBSTATS.isEventEnabled();
        if (this.ivIsReporterRunning != bl) {
            this.transitionReporter();
        }
        return bl;
    }

    protected boolean doCalculateFinest() {
        boolean bl = TC_BBSTATS.isEntryEnabled();
        boolean bl2 = TC_BBSTATS.isEventEnabled();
        if (this.ivIsReporterRunning != bl2) {
            this.transitionReporter();
        }
        return bl;
    }

    private synchronized void transitionReporter() {
        boolean bl = TC_BBSTATS.isEventEnabled();
        if (bl && !this.ivIsReporterRunning) {
            this.ivReporter = new BBReporter(this);
            this.ivReporter.setDaemon(true);
            this.ivReporter.start();
            this.ivIsReporterRunning = true;
        } else if (!bl && this.ivIsReporterRunning) {
            this.ivReporter.stopReporting();
            this.ivReporter = null;
            this.ivIsReporterRunning = false;
        }
    }

    private synchronized SubjectStats getStats(SubjectInfoImpl subjectInfoImpl) {
        SubjectStats subjectStats = (SubjectStats)this.ivStatsMap.get(subjectInfoImpl.getSubjectName());
        if (subjectStats == null) {
            subjectStats = new SubjectStats(subjectInfoImpl);
            this.ivStatsMap.put(subjectInfoImpl.getSubjectName(), subjectStats);
        }
        return subjectStats;
    }

    private synchronized void dump() {
        Object[] objectArray = null;
        objectArray = this.ivStatsMap.values().toArray(new SubjectStats[0]);
        if (objectArray == null) {
            Tr.event(TC_BBSTATS, "BB DUMP", "Something unexpected happened BBUserMonitor:1682");
            return;
        }
        if (objectArray.length == 0) {
            return;
        }
        Arrays.sort(objectArray);
        String[] stringArray = new String[objectArray.length + 5];
        stringArray[0] = "--------------------------------------------------------------------------------------------------------------------";
        stringArray[1] = "LocalBulletinBoard Statistics for " + this.ivCoreGroupName;
        stringArray[2] = "###--------------------------------------------------------------------------------------------------------------------";
        stringArray[3] = "name,lastUpdateSize,maxUpdateSize,totalUpdateSize,lastProxyUpdateSize,maxProxyUpdateSize,totalProxyUpdateSize,updatesNormal,updatesProxy,subscribeNormal,subscribeProxy,unsubscribe,totalCallbackTime,numCallbacks,allPostedData,maxAllPostedData,postingServersArray";
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[4 + i] = ((SubjectStats)objectArray[i]).toString();
        }
        stringArray[objectArray.length + 4] = "###--------------------------------------------------------------------------------------------------------------------";
        Tr.event(TC_BBSTATS, "BB DUMP", stringArray);
    }

    private static class SubjectStats
    implements Comparable {
        private String ivSubjectName;
        private long ivLastUpdateSize = 0L;
        private long ivMaxUpdateSize = 0L;
        private long ivTotalUpdatesSize = 0L;
        private long ivLastProxyUpdateSize = 0L;
        private long ivMaxProxyUpdateSize = 0L;
        private long ivTotalProxyUpdatesSize = 0L;
        private long ivCreatedNormal = 0L;
        private long ivCreatedProxy = 0L;
        private long ivUpdatedNormal = 0L;
        private long ivUpdatedProxy = 0L;
        private long ivSubscribeNormal = 0L;
        private long ivSubscribeProxy = 0L;
        private long ivUnsubscribe = 0L;
        private long ivTotalCallbackTime = -1L;
        private long ivNumCallbacks = -1L;
        private long ivAllDataPostedSize = -1L;
        private long ivMaxAllDataPostedSize = -1L;
        private long ivTotalProxyCallbackTime = -1L;
        private long ivNumProxyCallbacks = -1L;
        private long ivAllDataProxyPostedSize = -1L;
        private long ivMaxAllDataProxyPostedSize = -1L;
        private HashMap ivPostingServers;

        SubjectStats(SubjectInfoImpl subjectInfoImpl) {
            this.ivSubjectName = subjectInfoImpl.toString();
            this.ivPostingServers = new HashMap();
        }

        String getName() {
            return this.ivSubjectName;
        }

        void create() {
            ++this.ivCreatedNormal;
        }

        void createProxy(byte[] byArray) {
            ++this.ivCreatedProxy;
            this.updateSizeProxy(byArray);
        }

        void update(byte[] byArray, boolean bl) {
            if (bl) {
                ++this.ivUpdatedProxy;
                this.updateSizeProxy(byArray);
            } else {
                ++this.ivUpdatedNormal;
                this.updateSize(byArray);
            }
        }

        void subscribe(boolean bl) {
            if (bl) {
                ++this.ivSubscribeProxy;
            } else {
                ++this.ivSubscribeNormal;
            }
        }

        void unsubscribe() {
            ++this.ivUnsubscribe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void callbackComplete(long l, SubjectValue[] subjectValueArray) {
            if (this.ivNumCallbacks == -1L) {
                this.ivNumCallbacks = 0L;
            }
            if (this.ivTotalCallbackTime == -1L) {
                this.ivTotalCallbackTime = 0L;
            }
            long l2 = 0L;
            for (int i = 0; i < subjectValueArray.length; ++i) {
                l2 += (long)subjectValueArray[i].getValues().length;
                PostingServer postingServer = null;
                HashMap hashMap = this.ivPostingServers;
                synchronized (hashMap) {
                    postingServer = (PostingServer)this.ivPostingServers.get(subjectValueArray[i].getServerName());
                    if (postingServer == null) {
                        postingServer = new PostingServer(subjectValueArray[i].getServerName());
                        this.ivPostingServers.put(subjectValueArray[i].getServerName(), postingServer);
                    }
                }
                postingServer.updateReceived(subjectValueArray[i].getVersion());
            }
            this.ivTotalCallbackTime += l;
            ++this.ivNumCallbacks;
            this.ivAllDataPostedSize = l2;
            if (this.ivAllDataPostedSize > this.ivMaxAllDataPostedSize) {
                this.ivMaxAllDataPostedSize = this.ivAllDataPostedSize;
            }
        }

        void proxyCallbackComplete(long l, SubjectValue[] subjectValueArray) {
            if (this.ivNumProxyCallbacks == -1L) {
                this.ivNumProxyCallbacks = 0L;
            }
            if (this.ivTotalProxyCallbackTime == -1L) {
                this.ivTotalProxyCallbackTime = 0L;
            }
            long l2 = 0L;
            for (int i = 0; i < subjectValueArray.length; ++i) {
                l2 += (long)subjectValueArray[i].getValues().length;
            }
            this.ivTotalProxyCallbackTime += l;
            ++this.ivNumProxyCallbacks;
            this.ivAllDataProxyPostedSize = l2;
            if (this.ivAllDataProxyPostedSize > this.ivMaxAllDataProxyPostedSize) {
                this.ivMaxAllDataProxyPostedSize = this.ivAllDataProxyPostedSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String string = "[";
            PostingServer[] postingServerArray = null;
            HashMap hashMap = this.ivPostingServers;
            synchronized (hashMap) {
                postingServerArray = this.ivPostingServers.values().toArray(new PostingServer[0]);
            }
            for (int i = 0; i < postingServerArray.length; ++i) {
                string = string + postingServerArray[i].toString();
                if (i == postingServerArray.length - 1) continue;
                string = string + " ";
            }
            string = string + "]";
            return this.ivSubjectName + "," + this.ivLastUpdateSize + "," + this.ivMaxUpdateSize + "," + this.ivTotalUpdatesSize + "," + this.ivLastProxyUpdateSize + "," + this.ivMaxProxyUpdateSize + "," + this.ivTotalProxyUpdatesSize + "," + this.ivCreatedNormal + "," + this.ivCreatedProxy + "," + this.ivUpdatedNormal + "," + this.ivUpdatedProxy + "," + this.ivSubscribeNormal + "," + this.ivSubscribeProxy + "," + this.ivUnsubscribe + "," + this.ivTotalCallbackTime + "," + this.ivNumCallbacks + "," + this.ivAllDataPostedSize + "," + this.ivMaxAllDataPostedSize + "," + this.ivTotalProxyCallbackTime + "," + this.ivNumProxyCallbacks + "," + this.ivAllDataProxyPostedSize + "," + this.ivMaxAllDataProxyPostedSize + "," + string;
        }

        private void updateSize(byte[] byArray) {
            long l = 0L;
            if (byArray != null) {
                l = byArray.length;
            }
            this.ivLastUpdateSize = l;
            if (l > this.ivMaxUpdateSize) {
                this.ivMaxUpdateSize = l;
            }
            this.ivTotalUpdatesSize += l;
        }

        private void updateSizeProxy(byte[] byArray) {
            long l = 0L;
            if (byArray != null) {
                l = byArray.length;
            }
            this.ivLastProxyUpdateSize = l;
            if (l > this.ivMaxProxyUpdateSize) {
                this.ivMaxProxyUpdateSize = l;
            }
            this.ivTotalProxyUpdatesSize += l;
        }

        public int compareTo(Object object) {
            return this.ivSubjectName.compareTo(((SubjectStats)object).getName());
        }

        class PostingServer {
            private String ivServerName;
            private long ivNumUpdates;
            private long ivLastPostedVersion;

            public PostingServer(String string) {
                this.ivServerName = string;
                this.ivNumUpdates = 0L;
                this.ivLastPostedVersion = -1L;
            }

            public void updateReceived(long l) {
                if (l != this.ivLastPostedVersion) {
                    this.ivLastPostedVersion = l;
                    ++this.ivNumUpdates;
                }
            }

            public String toString() {
                return this.ivServerName + ";" + this.ivNumUpdates + ";" + this.ivLastPostedVersion;
            }
        }
    }

    private class BBReporter
    extends Thread {
        boolean ivContinue = true;
        BBUserMonitor ivBulletinboard = null;
        long ivSleepTime = 600000L;

        public BBReporter(BBUserMonitor bBUserMonitor2) {
            this.ivBulletinboard = bBUserMonitor2;
            Tr.info(TC_BBSTATS, "BBReporter started for " + BBUserMonitor.this.ivCoreGroupName + ".");
            try {
                String string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty("ha.bbdump.time");
                    }
                });
                if (string != null) {
                    try {
                        this.ivSleepTime = Long.parseLong(string);
                        Tr.event(TC_BBSTATS, "BBReporter: Using non default sleep time:" + this.ivSleepTime);
                    }
                    catch (NumberFormatException numberFormatException) {
                        FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.hamanager.bboard.BBUserMonitor.BBReporter", "312", this);
                        Tr.event(TC_BBSTATS, "BBReporter: Bad sleep time passed into JVM [ " + string + " ]. Using default of " + this.ivSleepTime);
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, (class$com$ibm$ws$hamanager$bboard$BBUserMonitor$BBReporter == null ? (class$com$ibm$ws$hamanager$bboard$BBUserMonitor$BBReporter = BBUserMonitor.class$("com.ibm.ws.hamanager.bboard.BBUserMonitor$BBReporter")) : class$com$ibm$ws$hamanager$bboard$BBUserMonitor$BBReporter).getName(), "254", this);
            }
        }

        public void stopReporting() {
            this.ivContinue = false;
            Tr.info(TC_BBSTATS, "BBReporter stopped.");
        }

        public void run() {
            this.sleep();
            while (this.ivContinue) {
                this.ivBulletinboard.dump();
                this.sleep();
            }
        }

        private void sleep() {
            try {
                Thread.sleep(this.ivSleepTime);
                if (!BBUserMonitor.this.doCalculateFine()) {
                    this.ivContinue = false;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, BBUserMonitor.svClassName, "280", this);
                this.ivContinue = false;
            }
        }
    }
}

