/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class BoardSubscriptions
implements SubjectSubscriptionEvents {
    BulletinBoard board;
    Map subjects;
    Map subscriptions;

    BoardSubscriptions(BulletinBoardFactory bulletinBoardFactory, String string) throws HAParameterRejectedException {
        this.board = bulletinBoardFactory.findBulletinBoard(string);
        this.subjects = new HashMap();
        this.subscriptions = new HashMap();
    }

    boolean isEmpty() {
        return this.subjects.isEmpty();
    }

    void subscribe(SubjectInfo subjectInfo) throws HAParameterRejectedException {
        if (!this.subjects.containsKey(subjectInfo)) {
            SubjectSubscription subjectSubscription = this.board.subscribe(subjectInfo, this);
            this.subscriptions.put(subjectInfo, subjectSubscription);
        }
    }

    void unsubscribe(SubjectInfo subjectInfo) throws SubjectSubscriptionClosedException {
        if (this.subscriptions.containsKey(subjectInfo)) {
            SubjectSubscription subjectSubscription = (SubjectSubscription)this.subscriptions.get(subjectInfo);
            subjectSubscription.close();
            this.subscriptions.remove(subjectInfo);
        }
        if (this.subjects.containsKey(subjectInfo)) {
            this.subjects.remove(subjectInfo);
        }
    }

    String getSubjectValue(SubjectInfo subjectInfo) throws SubjectSubscriptionClosedException {
        if (this.subjects.containsKey(subjectInfo)) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            SubjectValue[] subjectValueArray = (SubjectValue[])this.subjects.get(subjectInfo);
            printWriter.println("<SUBJECT id='" + subjectInfo + "'>");
            for (int i = 0; i < subjectValueArray.length; ++i) {
                SubjectValue subjectValue = subjectValueArray[i];
                byte[] byArray = subjectValue.getValues();
                printWriter.println("  <SERVERPOST server='" + subjectValue.getServerName() + "'>");
                printWriter.print("    <VALUE>");
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    Object object = objectInputStream.readObject();
                    printWriter.print(object.toString());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.hamanager.bboard.BoardSubscriptions.getSubjectValue", "127", this);
                    printWriter.print(byArray.toString());
                }
                printWriter.println("    </VALUE>");
                printWriter.println("  </SERVERPOST>");
            }
            printWriter.println("</SUBJECT>");
            return stringWriter.toString();
        }
        return "<BADSUBJECT/>";
    }

    public void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray) {
        try {
            this.subjects.put(subjectSubscription.getSubject(), subjectValueArray);
        }
        catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
            FFDCFilter.processException((Throwable)subjectSubscriptionClosedException, "com.ibm.ws.hamanager.bboard.BoardSubscriptions.updated", "151", this);
        }
    }

    public SubjectInfo[] getSubjects() {
        SubjectInfo[] subjectInfoArray = new SubjectInfo[this.subjects.size()];
        this.subjects.keySet().toArray(subjectInfoArray);
        return subjectInfoArray;
    }
}

