/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.hamanager.bboard.BridgeStateManager;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import java.util.Arrays;
import java.util.Set;

public class BridgeStateController {
    private static final TraceComponent TC = Tr.register(BridgeStateController.class.getName(), "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private String[] ivBridgesInHAMCoreStackView = new String[0];
    private String[] ivBridgesInCGBCoreStackView = new String[0];
    private CrossCoreStackStateMachine ivStateMachine;
    private boolean ivIsBridge = false;
    private boolean ivBridgeRebuildInProgress = false;
    private Set ivConfiguredBridges;

    public BridgeStateController(BridgeStateManager bridgeStateManager, Set set, String string) throws HAInternalStateException, DataStackException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "Initializing with configured bridges: ", new Object[]{set});
        }
        if (set.contains(string)) {
            this.ivIsBridge = true;
            this.ivBridgesInHAMCoreStackView = new String[]{string};
        }
        this.ivStateMachine = new CrossCoreStackStateMachine(bridgeStateManager, set.size());
        this.ivConfiguredBridges = set;
    }

    public void bridgeStateSynchronized() throws HAException {
        if (!this.ivBridgeRebuildInProgress) {
            Tr.error(TC, "HMGR0165");
            throw new HAException("No previous bridgeStateUnsynchronized");
        }
        CrossCoreStackEvent crossCoreStackEvent = new CrossCoreStackEvent(4, false);
        this.ivStateMachine.processEvent(crossCoreStackEvent);
        this.ivBridgeRebuildInProgress = false;
    }

    public synchronized void bridgeStateUnsynchronized(Set set) throws HAException {
        String[] stringArray = new String[set.size()];
        if (set.size() > 0) {
            set.toArray(stringArray);
        }
        if (set.size() == 0) {
            this.ivStateMachine.initializeStateMachine(this.ivConfiguredBridges.size());
            Tr.error(TC, "HMGR0164");
            throw new HAException("Illegal bridgeStateUnsynchronized callback, callback contains zero active bridges.");
        }
        if (this.ivBridgesInCGBCoreStackView.length == set.size() && !this.bridgeMembersInViewHasChanged(this.ivBridgesInCGBCoreStackView, stringArray)) {
            this.ivStateMachine.initializeStateMachine(this.ivConfiguredBridges.size());
            Tr.error(TC, "HMGR0163", new Object[]{set});
            throw new HAException("Illegal bridgeStateUnsynchronized callback, a change in bridge membership is required from previous callback. Previous set of active bridges was: " + Arrays.asList(this.ivBridgesInCGBCoreStackView) + ":: Active bridges passed on this call: " + set);
        }
        this.ivBridgeRebuildInProgress = true;
        this.ivBridgesInCGBCoreStackView = stringArray;
        if (set.size() > 0) {
            set.toArray(this.ivBridgesInCGBCoreStackView);
        }
        CrossCoreStackEvent crossCoreStackEvent = this.membershipsInAgreement() ? new CrossCoreStackEvent(2, false) : new CrossCoreStackEvent(3, false);
        this.ivStateMachine.processEvent(crossCoreStackEvent);
    }

    public synchronized void installNewView(String[] stringArray, boolean bl, Set set) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "installNewView", new Object[]{Arrays.asList(stringArray), new Boolean(bl), set});
        }
        String[] stringArray2 = new String[set.size()];
        if (set.size() > 0) {
            set.toArray(stringArray2);
        }
        if (this.bridgeMembersInViewHasChanged(stringArray2, this.ivBridgesInHAMCoreStackView)) {
            this.ivBridgesInHAMCoreStackView = stringArray2;
            CrossCoreStackEvent crossCoreStackEvent = this.membershipsInAgreement() ? new CrossCoreStackEvent(0, bl) : new CrossCoreStackEvent(1, bl);
            this.ivStateMachine.processEvent(crossCoreStackEvent);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "installNewView");
        }
    }

    private boolean bridgeMembersInViewHasChanged(String[] stringArray, String[] stringArray2) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "bridgeMembersInViewHasChanged", new Object[]{Arrays.asList(stringArray), Arrays.asList(stringArray2)});
        }
        boolean bl = false;
        if (stringArray.length != stringArray2.length) {
            bl = true;
        } else {
            int n = 0;
            block0: for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!string.equals(stringArray2[j])) continue;
                    ++n;
                    continue block0;
                }
            }
            if (n != stringArray2.length) {
                bl = true;
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "bridgeMembersInViewHasChanged", new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    private boolean membershipsInAgreement() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "membershipsInAgreement", new Object[]{Arrays.asList(this.ivBridgesInHAMCoreStackView), Arrays.asList(this.ivBridgesInCGBCoreStackView)});
        }
        boolean bl = false;
        if (this.ivBridgesInHAMCoreStackView.length != this.ivBridgesInCGBCoreStackView.length) {
            bl = false;
        } else {
            int n = 0;
            block0: for (int i = 0; i < this.ivBridgesInHAMCoreStackView.length; ++i) {
                for (int j = 0; j < this.ivBridgesInCGBCoreStackView.length; ++j) {
                    if (!this.ivBridgesInHAMCoreStackView[i].equalsIgnoreCase(this.ivBridgesInCGBCoreStackView[j])) continue;
                    ++n;
                    continue block0;
                }
            }
            bl = this.ivBridgesInHAMCoreStackView.length == n;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "membershipsInAgreement", new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    private class CrossCoreStackStateMachine {
        public static final int HAM_CORESTACK_VIEW_CHANGE_INTO_SYNC = 0;
        public static final int HAM_CORESTACK_VIEW_CHANGE_OUTOF_SYNC = 1;
        public static final int FOREIGN_STATE_UNSYNCHRONONIZED_INTO_SYNC = 2;
        public static final int FOREIGN_STATE_UNSYNCHRONONIZED_OUTOF_SYNC = 3;
        public static final int FOREIGN_STATE_SYNCHRONIZED = 4;
        public static final int INITIALIZE_NONBRIDGED_PROCESS = 5;
        public static final int INITIALIZE_BRIDGED_PROCESS_IN_SINGLE_MEMBER_APG = 6;
        public static final int INITIALIZE_BRIDGED_PROCESS_IN_MULTI_MEMBER_APG = 7;
        private final String[] EVENTS = new String[]{"HAM_CORESTACK_VIEW_CHANGE_INTO_SYNC", "HAM_CORESTACK_VIEW_CHANGE_OUTOF_SYNC", "FOREIGN_STATE_UNSYNCHRONONIZED_INTO_SYNC", "FOREIGN_STATE_UNSYNCHRONONIZED_OUTOF_SYNC", "FOREIGN_STATE_SYNCHRONIZED", "INITIALIZE_NONBRIDGED_PROCESS", "INITIALIZE_BRIDGED_PROCESS_IN_SINGLE_MEMBER_APG", "INITIALIZE_BRIDGED_PROCESS_IN_MULTI_MEMBER_APG"};
        private static final int SYNCED = 0;
        private static final int SYNCING = 1;
        private static final int UNSYNCED_VIA_HAM_VIEWCHANGE = 2;
        private static final int UNSYNCED_VIA_CGB_VIEWCHANGE = 3;
        private static final int INTERRUPTED_SYNCING = 4;
        private static final int UNSYNCABLE = 5;
        private static final int UNSYNCABLE_SINGLETON = 6;
        private static final int SYNCABLE = 7;
        private final String[] STATES = new String[]{"SYNCED", "SYNCING", "UNSYNCED_VIA_HAM_VIEWCHANGE", "UNSYNCED_VIA_CGB_VIEWCHANGE", "INTERRUPTED_SYNCING", "UNSYNCABLE", "UNSYNCABLE_SINGLETON", "SYNCABLE"};
        private int ivCurrentState;
        private int ivPreviousState;
        private BridgeStateManager ivStateObserver;

        public CrossCoreStackStateMachine(BridgeStateManager bridgeStateManager, int n) throws HAInternalStateException, DataStackException {
            this.ivStateObserver = bridgeStateManager;
            this.initializeStateMachine(n);
        }

        public void initializeStateMachine(int n) {
            CrossCoreStackEvent crossCoreStackEvent = BridgeStateController.this.ivIsBridge ? (n == 1 ? new CrossCoreStackEvent(6, false) : new CrossCoreStackEvent(7, false)) : new CrossCoreStackEvent(5, false);
            this.processEvent(crossCoreStackEvent);
        }

        public void processEvent(CrossCoreStackEvent crossCoreStackEvent) {
            int n = crossCoreStackEvent.getEventIndex();
            if (TC.isEventEnabled()) {
                Tr.event(TC, "processEvent", new Object[]{this.EVENTS[n], this.STATES[this.ivPreviousState], this.STATES[this.ivCurrentState]});
            }
            block0 : switch (n) {
                case 5: {
                    this.transitionToState(crossCoreStackEvent, 5);
                    break;
                }
                case 6: {
                    this.transitionToState(crossCoreStackEvent, 6);
                    break;
                }
                case 7: {
                    this.transitionToState(crossCoreStackEvent, 7);
                    break;
                }
                case 0: {
                    switch (this.ivCurrentState) {
                        case 0: 
                        case 1: {
                            this.transitionToState(crossCoreStackEvent, 0);
                            break;
                        }
                        case 2: {
                            this.transitionToState(crossCoreStackEvent, 0);
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.transitionToState(crossCoreStackEvent, 1);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.ivCurrentState) {
                        case 1: {
                            this.transitionToState(crossCoreStackEvent, 4);
                            break;
                        }
                        case 0: {
                            this.transitionToState(crossCoreStackEvent, 2);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.ivCurrentState) {
                        case 2: 
                        case 4: 
                        case 7: {
                            this.transitionToState(crossCoreStackEvent, 1);
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.transitionToState(crossCoreStackEvent, 3);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.ivCurrentState) {
                        case 0: 
                        case 4: 
                        case 7: {
                            this.transitionToState(crossCoreStackEvent, 3);
                            break;
                        }
                        case 1: {
                            this.transitionToState(crossCoreStackEvent, 4);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.ivCurrentState) {
                        case 0: 
                        case 1: {
                            this.transitionToState(crossCoreStackEvent, 0);
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 3: {
                            switch (this.ivPreviousState) {
                                case 0: 
                                case 4: 
                                case 7: {
                                    this.transitionToState(crossCoreStackEvent, 1);
                                    break block0;
                                }
                                case 1: 
                                case 3: {
                                    this.transitionToState(crossCoreStackEvent, 0);
                                }
                            }
                        }
                    }
                }
            }
        }

        private void transitionToState(CrossCoreStackEvent crossCoreStackEvent, int n) {
            this.ivPreviousState = this.ivCurrentState;
            this.ivCurrentState = n;
            if (TC.isEventEnabled()) {
                Tr.event(TC, "transitionToState", new Object[]{this.STATES[this.ivPreviousState], this.STATES[this.ivCurrentState]});
            }
            if (this.ivPreviousState == 1 && this.ivCurrentState == 0 || this.ivPreviousState == 3 && this.ivCurrentState == 0 || this.ivPreviousState == 7 && this.ivCurrentState == 0 || this.ivCurrentState == 6) {
                this.ivStateObserver.resumeBridgeUpdates();
                return;
            }
            if (this.ivPreviousState == 0 && this.ivCurrentState == 3 || this.ivPreviousState == 0 && this.ivCurrentState == 2 || this.ivCurrentState == 7) {
                this.ivStateObserver.suspendBridgeUpdates();
                return;
            }
        }
    }

    public class CrossCoreStackEvent {
        private int ivEvent;
        private boolean ivIsHamGSRViewChange;

        public CrossCoreStackEvent(int n, boolean bl) {
            this.ivEvent = n;
            this.ivIsHamGSRViewChange = bl;
        }

        public int getEventIndex() {
            return this.ivEvent;
        }

        public boolean isLocalViewChangeEvent() {
            switch (this.ivEvent) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return false;
                }
            }
            return false;
        }

        public boolean isGSRViewChange() {
            return this.ivIsHamGSRViewChange;
        }
    }
}

