/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.bboard.LocalBulletinBoardStateManager;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.ws.hamanager.bboard.SubjectPostImpl;
import com.ibm.wsspi.hamanager.HAIllegalRequestException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.DuplicatePostException;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectPostClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectProxySubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionProxyEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class BulletinBoardImpl
implements BulletinBoard {
    String bulletinBoardName;
    boolean closed = false;
    LocalBulletinBoardStateManager dirStateManager;
    private ArrayList postsCreatedByThisBBoard = new ArrayList();
    private ArrayList subscriptionsCreatedByThisBBoard = new ArrayList();

    BulletinBoardImpl(String string, LocalBulletinBoardStateManager localBulletinBoardStateManager) {
        this.bulletinBoardName = string;
        this.dirStateManager = localBulletinBoardStateManager;
    }

    public synchronized void close() {
        if (!this.closed) {
            Object object;
            WeakReference weakReference;
            int n;
            for (n = 0; n < this.postsCreatedByThisBBoard.size(); ++n) {
                try {
                    weakReference = (WeakReference)this.postsCreatedByThisBBoard.get(n);
                    object = (SubjectPost)weakReference.get();
                    if (object == null) continue;
                    object.close();
                    continue;
                }
                catch (SubjectPostClosedException subjectPostClosedException) {
                    FFDCFilter.processException((Throwable)subjectPostClosedException, "com.ibm.ws.hamanager.bboard.BulletinBoardImpl.close", "92", this);
                }
            }
            this.postsCreatedByThisBBoard.clear();
            for (n = 0; n < this.subscriptionsCreatedByThisBBoard.size(); ++n) {
                try {
                    weakReference = (WeakReference)this.subscriptionsCreatedByThisBBoard.get(n);
                    object = (SubjectSubscription)weakReference.get();
                    if (object == null) continue;
                    object.close();
                    continue;
                }
                catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                    FFDCFilter.processException((Throwable)subjectSubscriptionClosedException, "com.ibm.ws.hamanager.bboard.BulletinBoardImpl.close", "107", this);
                }
            }
            this.subscriptionsCreatedByThisBBoard.clear();
            this.closed = true;
        }
    }

    public synchronized SubjectSubscription subscribe(SubjectInfo subjectInfo, SubjectSubscriptionEvents subjectSubscriptionEvents) throws HAParameterRejectedException {
        if (subjectInfo == null) {
            throw new HAParameterRejectedException("Null subjectKey parameter is not allowed");
        }
        if (subjectSubscriptionEvents == null) {
            throw new HAParameterRejectedException("Null event parameter is not allowed");
        }
        this.check();
        SubjectSubscription subjectSubscription = this.dirStateManager.subscribe((SubjectInfoImpl)subjectInfo, subjectSubscriptionEvents);
        this.subscriptionsCreatedByThisBBoard.add(new WeakReference<SubjectSubscription>(subjectSubscription));
        return subjectSubscription;
    }

    public synchronized SubjectProxySubscription subscribeProxy(SubjectInfo subjectInfo, SubjectSubscriptionProxyEvents subjectSubscriptionProxyEvents) throws HAParameterRejectedException, HAIllegalRequestException {
        if (subjectInfo == null) {
            throw new HAParameterRejectedException("Null subjectKey parameter is not allowed");
        }
        if (subjectSubscriptionProxyEvents == null) {
            throw new HAParameterRejectedException("Null event parameter is not allowed");
        }
        this.check();
        SubjectProxySubscription subjectProxySubscription = this.dirStateManager.subscribeProxy((SubjectInfoImpl)subjectInfo, subjectSubscriptionProxyEvents);
        this.subscriptionsCreatedByThisBBoard.add(new WeakReference<SubjectProxySubscription>(subjectProxySubscription));
        return subjectProxySubscription;
    }

    public SubjectInfo createSubject(BulletinBoardScope bulletinBoardScope, String string) throws HAParameterRejectedException, IllegalArgumentException {
        if (bulletinBoardScope == null) {
            throw new HAParameterRejectedException("Null qualifier is not allowed");
        }
        if (string == null) {
            throw new HAParameterRejectedException("Null subjectName is not allowed");
        }
        this.check();
        return new SubjectInfoImpl(this.bulletinBoardName, bulletinBoardScope, string);
    }

    public synchronized SubjectPost createPost(SubjectInfo subjectInfo) throws HAParameterRejectedException, DuplicatePostException {
        if (subjectInfo == null) {
            throw new HAParameterRejectedException("Null subject parameter is not allowed");
        }
        this.check();
        SubjectPostImpl subjectPostImpl = this.dirStateManager.createPost((SubjectInfoImpl)subjectInfo);
        this.postsCreatedByThisBBoard.add(new WeakReference<SubjectPostImpl>(subjectPostImpl));
        return subjectPostImpl;
    }

    public synchronized SubjectPost createPost(SubjectInfo subjectInfo, SubjectValue subjectValue) throws HAParameterRejectedException, DuplicatePostException, HAIllegalRequestException {
        if (subjectInfo == null) {
            throw new HAParameterRejectedException("Null subject parameter is not allowed");
        }
        if (subjectValue == null) {
            throw new HAParameterRejectedException("Null proxyPost parameter is not allowed");
        }
        this.check();
        SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)subjectInfo;
        String string = subjectValue.getServerName();
        byte[] byArray = subjectValue.getValues();
        long l = subjectValue.getVersion();
        SubjectPostImpl subjectPostImpl = this.dirStateManager.createProxyPost(subjectInfoImpl, string, byArray, l);
        this.postsCreatedByThisBBoard.add(new WeakReference<SubjectPostImpl>(subjectPostImpl));
        return subjectPostImpl;
    }

    public int hashCode() {
        return this.bulletinBoardName.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        try {
            BulletinBoardImpl bulletinBoardImpl = (BulletinBoardImpl)object;
            if (!this.bulletinBoardName.equals(bulletinBoardImpl.bulletinBoardName)) {
                return false;
            }
            return this.closed == bulletinBoardImpl.closed;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private void check() throws HAParameterRejectedException {
        if (this.closed) {
            throw new HAParameterRejectedException("BulletinBoard is closed");
        }
    }
}

