/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.ws.hamanager.utils.DebugUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class BulletinBoardServerPosts
implements Externalizable {
    private static final long serialVersionUID = 3519698068109305074L;
    private static final int svVersion = 1;
    private Map ivPosts = new HashMap();

    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        BulletinBoardPost bulletinBoardPost;
        objectOutput.writeInt(1);
        Iterator iterator = this.ivPosts.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            bulletinBoardPost = (BulletinBoardPost)iterator.next();
            if (bulletinBoardPost.getValue() == null) continue;
            ++n;
        }
        objectOutput.writeInt(n);
        iterator = this.ivPosts.values().iterator();
        while (iterator.hasNext()) {
            bulletinBoardPost = (BulletinBoardPost)iterator.next();
            if (bulletinBoardPost.getValue() == null) continue;
            objectOutput.writeObject(bulletinBoardPost);
        }
    }

    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        this.ivPosts = new HashMap();
        for (int i = 0; i < n2; ++i) {
            BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)objectInput.readObject();
            this.ivPosts.put(bulletinBoardPost.getOriginalServer(), bulletinBoardPost);
        }
    }

    synchronized boolean containsPostForServer(String string) {
        return this.ivPosts.containsKey(string);
    }

    synchronized BulletinBoardPost get(String string) {
        return (BulletinBoardPost)this.ivPosts.get(string);
    }

    synchronized boolean containsData(String string) {
        if (this.ivPosts.isEmpty()) {
            return false;
        }
        if (this.ivPosts.size() > 1) {
            return true;
        }
        BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)this.ivPosts.get(string);
        if (bulletinBoardPost == null) {
            return true;
        }
        byte[] byArray = bulletinBoardPost.getValue();
        return byArray != null;
    }

    public synchronized boolean isEmpty() {
        return this.ivPosts.isEmpty();
    }

    public synchronized BulletinBoardPost put(String string, BulletinBoardPost bulletinBoardPost) {
        return this.ivPosts.put(string, bulletinBoardPost);
    }

    public synchronized BulletinBoardPost remove(String string) {
        return (BulletinBoardPost)this.ivPosts.remove(string);
    }

    public Map getAndOwnEntries() {
        return this.ivPosts;
    }

    public synchronized Collection values() {
        HashSet<BulletinBoardPost> hashSet = new HashSet<BulletinBoardPost>();
        Iterator iterator = this.ivPosts.values().iterator();
        while (iterator.hasNext()) {
            BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)iterator.next();
            hashSet.add(bulletinBoardPost);
        }
        return hashSet;
    }

    public synchronized String toString() {
        Object object;
        int n = this.ivPosts.size();
        if (n == 0) {
            return "BulletinBoardServerPosts: contains no BulletinBoardPosts";
        }
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.ivPosts.values().iterator();
        while (iterator.hasNext()) {
            object = (BulletinBoardPost)iterator.next();
            byte[] byArray = ((BulletinBoardPost)object).getValue();
            if (byArray == null) {
                ++n3;
                continue;
            }
            n2 += byArray.length;
        }
        object = "BulletinBoardServerPosts: " + n + " entries, " + n3 + " empty posts, data size = " + n2 + " bytes";
        if (n < 6) {
            return DebugUtils.dumpMap((String)object, this.ivPosts);
        }
        return (String)object + ", Too many Posts to dump.....";
    }
}

