/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Version;
import com.ibm.ws.hamanager.bboard.BBUserMonitor;
import com.ibm.ws.hamanager.bboard.BridgeStateController;
import com.ibm.ws.hamanager.bboard.BridgeStateManager;
import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.ws.hamanager.bboard.BulletinBoardServerPosts;
import com.ibm.ws.hamanager.bboard.IndirectSubjectToPostMap;
import com.ibm.ws.hamanager.bboard.SubjectDataMap;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.ws.hamanager.bboard.SubjectPostImpl;
import com.ibm.ws.hamanager.bboard.SubjectProxySubscriptionImpl;
import com.ibm.ws.hamanager.bboard.SubjectSubscriptionImpl;
import com.ibm.ws.hamanager.bboard.SubjectValueImpl;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.MessageCache;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportClusterProcessStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.bboard.BulletinBoardSubscriberUpdateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.bboard.SubscriberUpdateMsg;
import com.ibm.ws.hamanager.impl.UserCallback;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.pmi.HAManagerPerf;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAIllegalRequestException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.DuplicatePostException;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectProxySubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionProxyEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LocalBulletinBoardStateManager
implements BridgeStateManager {
    private static final TraceComponent TC = Tr.register(LocalBulletinBoardStateManager.class.getName(), "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "LocalBulletinBoardStateManager";
    private static final Boolean svSubscribe = new Boolean(true);
    private static final Boolean svUnsubscribe = new Boolean(false);
    private SubjectDataMap ivSubjectData = new SubjectDataMap();
    private Map ivLocalPosts = new HashMap();
    private IndirectSubjectToPostMap ivProxyPosts = new IndirectSubjectToPostMap();
    private Map ivSubscribers = new TreeMap();
    private Set ivUninitializedSubjects = new HashSet();
    private CoordinatorImpl ivCoordinator;
    private MessageCache ivMessageCache;
    private Version ivProtocolVersion;
    private int ivCurrentProtocol;
    private String ivDCSMemberName;
    private Set ivCoreGroupMembers;
    private Map ivClosedPostVersions;
    private Map ivClosedPostVersionsAged;
    private long ivCleanCachePeriod = 600000L;
    private HAManagerPerf ivPmi = null;
    private int ivPmiNumSubjects = 0;
    private int ivPmiNumSubscriptions = 0;
    private Set ivBridgeMembers = new HashSet();
    private boolean ivBridgeUpdatesSuspended = false;
    private BridgeStateController ivBridgeUpdateController = null;
    private Set ivSubjectsOwnedByBridge = new HashSet();
    private HashSet ivCurrentViewMembers = new HashSet();
    private BBUserMonitor ivStatsMgr;

    public LocalBulletinBoardStateManager(CoordinatorImpl coordinatorImpl, String string, MessageCache messageCache, Set set, Version version, Set set2) throws HAInternalStateException, DataStackException {
        this.ivCoordinator = coordinatorImpl;
        this.ivMessageCache = messageCache;
        this.ivDCSMemberName = string;
        this.ivProtocolVersion = version;
        this.ivBridgeMembers = set2;
        this.ivCoreGroupMembers = set;
        this.ivBridgeUpdateController = new BridgeStateController(this, set2, this.ivDCSMemberName);
        this.ivCurrentProtocol = this.ivProtocolVersion.getHAMProtocolVersion();
        this.ivPmi = this.ivCoordinator.getPMI();
        this.ivPmiNumSubjects = 0;
        this.ivPmiNumSubscriptions = 0;
        this.ivStatsMgr = new BBUserMonitor(this.ivCoordinator.getCoreGroupName());
    }

    public synchronized void updateCoreGroupMembership(Set set) {
        this.ivCoreGroupMembers = set;
    }

    public synchronized void installNewView(String[] stringArray, boolean bl, boolean bl2, Set set) {
        if (bl2) {
            this.removeAllProxyPosts();
        }
        this.ivCurrentViewMembers = new HashSet<String>(Arrays.asList(stringArray));
        this.ivBridgeUpdateController.installNewView(stringArray, bl, set);
    }

    public synchronized void bridgeStateUnsynchronized(Set set) throws HAException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "bridgeStateUnsynchronized", new Object[]{set});
        }
        this.ivBridgeUpdateController.bridgeStateUnsynchronized(set);
    }

    public synchronized void bridgeStateSynchronized(Set set) throws HAException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "bridgeStateSynchronized", new Object[]{set});
        }
        this.ivSubjectsOwnedByBridge = set;
        this.ivBridgeUpdateController.bridgeStateSynchronized();
        this.checkForeignStateForOrphanedSubjects(set);
    }

    public void suspendBridgeUpdates() {
        this.ivMessageCache.clearBridgeState();
        this.ivBridgeUpdatesSuspended = true;
    }

    public synchronized void resumeBridgeUpdates() {
        this.ivBridgeUpdatesSuspended = false;
        this.ivMessageCache.bridgeRebuildComplete(this.ivProxyPosts, this.ivSubjectsOwnedByBridge);
    }

    public synchronized SubjectValue[] requestCurrentSubjectState(SubjectSubscriptionImpl subjectSubscriptionImpl) throws SubjectSubscriptionClosedException {
        SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)subjectSubscriptionImpl.getSubject();
        SubscriberList subscriberList = (SubscriberList)this.ivSubscribers.get(subjectInfoImpl);
        SubjectValue[] subjectValueArray = subscriberList.getCurrentSubjectValues();
        if (subjectValueArray.length == 0 || !subjectSubscriptionImpl.isBridgeSubscription()) {
            return subjectValueArray;
        }
        return this.calculateChangedLocalSubjectValues(subjectValueArray, this.ivCoreGroupMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SubjectPostImpl createProxyPost(SubjectInfoImpl subjectInfoImpl, String string, byte[] byArray, long l) throws HAParameterRejectedException, DuplicatePostException, HAIllegalRequestException {
        if (subjectInfoImpl == null) {
            throw new HAParameterRejectedException("null subjectName passed. This is not allowed");
        }
        if (subjectInfoImpl.getBoardName() == null) {
            throw new HAParameterRejectedException("null bulletinBoardName passed. This is not allowed");
        }
        if (this.ivCoreGroupMembers.contains(string)) {
            String string2 = "Cannot create a proxy post because " + string + " is a member of the local core group";
            HAParameterRejectedException hAParameterRejectedException = new HAParameterRejectedException(string2);
            Tr.error(TC, "HMGR0166", string);
            throw hAParameterRejectedException;
        }
        if (byArray == null) {
            throw new HAParameterRejectedException("null byte[] value passed. This is not allowed");
        }
        BulletinBoardPost bulletinBoardPost = new BulletinBoardPost(string, byArray, l);
        SubjectPostImpl subjectPostImpl = new SubjectPostImpl(subjectInfoImpl, bulletinBoardPost, this, true);
        MessageCache messageCache = this.ivMessageCache;
        synchronized (messageCache) {
            if (this.ivCurrentProtocol < 5) {
                if (this.ivSubjectData.postPreviouslyCreatedByServer(string, subjectInfoImpl)) {
                    throw new DuplicatePostException("Subject/Server already has handle");
                }
                BulletinBoardServerPosts bulletinBoardServerPosts = this.ivSubjectData.put(subjectInfoImpl, bulletinBoardPost);
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "createProxyPostOld", new Object[]{subjectInfoImpl, bulletinBoardPost, bulletinBoardServerPosts});
                }
                if (byArray != null) {
                    if (this.ivCurrentProtocol < 1) {
                        this.ivMessageCache.sendPostUpdate((SubjectInfo)subjectInfoImpl, bulletinBoardServerPosts);
                    } else {
                        this.ivMessageCache.sendPostUpdate((SubjectInfo)subjectInfoImpl, bulletinBoardPost);
                    }
                }
            } else {
                if (!this.ivBridgeMembers.contains(this.ivDCSMemberName)) {
                    throw new HAIllegalRequestException("proxy post creation only allowed on bridge processes.");
                }
                if (this.ivProxyPosts.postPreviouslyCreatedByServer(string, subjectInfoImpl)) {
                    throw new DuplicatePostException("Subject/Server already has handle");
                }
                Map map = this.ivProxyPosts.put(subjectInfoImpl, bulletinBoardPost);
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "createProxyPostNew", new Object[]{subjectInfoImpl, bulletinBoardPost, map});
                }
                if (!this.ivBridgeUpdatesSuspended && byArray != null) {
                    this.ivMessageCache.sendProxyPostUpdate(subjectInfoImpl, bulletinBoardPost);
                }
            }
        }
        ++this.ivPmiNumSubjects;
        if (this.ivPmi == null) {
            this.ivPmi = this.ivCoordinator.getPMI();
        }
        if (this.ivPmi != null) {
            this.ivPmi.bbLocalReportSubjects(this.ivPmiNumSubjects);
        }
        this.ivStatsMgr.createProxyPost(subjectInfoImpl, byArray);
        return subjectPostImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SubjectPostImpl createPost(SubjectInfoImpl subjectInfoImpl) throws HAParameterRejectedException, DuplicatePostException {
        SubjectPostImpl subjectPostImpl = null;
        if (subjectInfoImpl == null) {
            throw new HAParameterRejectedException("null subjectName passed. This is not allowed");
        }
        if (subjectInfoImpl.getBoardName() == null) {
            throw new HAParameterRejectedException("null bulletinBoardName passed. This is not allowed");
        }
        long l = 0L;
        Long l2 = this.getCachedClosedPostVersion(subjectInfoImpl);
        if (l2 != null) {
            l = l2;
        }
        BulletinBoardPost bulletinBoardPost = new BulletinBoardPost(this.ivDCSMemberName, null, l);
        subjectPostImpl = new SubjectPostImpl(subjectInfoImpl, bulletinBoardPost, this, false);
        MessageCache messageCache = this.ivMessageCache;
        synchronized (messageCache) {
            if (this.ivCurrentProtocol < 5) {
                if (this.ivSubjectData.postPreviouslyCreatedByServer(this.ivDCSMemberName, subjectInfoImpl)) {
                    throw new DuplicatePostException("Subject/Server already has handle");
                }
                BulletinBoardServerPosts bulletinBoardServerPosts = this.ivSubjectData.put(subjectInfoImpl, bulletinBoardPost);
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "createPostOld", new Object[]{subjectInfoImpl, bulletinBoardPost, bulletinBoardServerPosts});
                }
            } else {
                BulletinBoardPost bulletinBoardPost2 = this.ivLocalPosts.put(subjectInfoImpl, bulletinBoardPost);
                if (bulletinBoardPost2 != null) {
                    this.ivLocalPosts.put(subjectInfoImpl, bulletinBoardPost2);
                    throw new DuplicatePostException("Subject/Server already has handle");
                }
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "createPostNew", new Object[]{subjectInfoImpl, bulletinBoardPost, bulletinBoardPost2});
                }
            }
        }
        ++this.ivPmiNumSubjects;
        if (this.ivPmi == null) {
            this.ivPmi = this.ivCoordinator.getPMI();
        }
        if (this.ivPmi != null) {
            this.ivPmi.bbLocalReportSubjects(this.ivPmiNumSubjects);
        }
        this.ivStatsMgr.createPost(subjectInfoImpl);
        return subjectPostImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void updatePost(SubjectPostImpl subjectPostImpl, BulletinBoardPost bulletinBoardPost, SubjectInfoImpl subjectInfoImpl, byte[] byArray, boolean bl) {
        MessageCache messageCache = this.ivMessageCache;
        synchronized (messageCache) {
            bulletinBoardPost.setValue(byArray);
            if (TC.isEventEnabled()) {
                if (bl) {
                    Tr.event(TC, "updateProxyPost() - updating ->[subject, post]", new Object[]{subjectInfoImpl, bulletinBoardPost});
                } else {
                    Tr.event(TC, "updatePost() - updating ->[subject, post]", new Object[]{subjectInfoImpl, bulletinBoardPost});
                }
            }
            if (this.ivCurrentProtocol < 5) {
                if (this.ivCurrentProtocol < 1) {
                    BulletinBoardServerPosts bulletinBoardServerPosts = this.ivSubjectData.get(subjectInfoImpl);
                    this.ivMessageCache.sendPostUpdate((SubjectInfo)subjectInfoImpl, bulletinBoardServerPosts);
                } else {
                    this.ivMessageCache.sendPostUpdate((SubjectInfo)subjectInfoImpl, bulletinBoardPost);
                }
            } else if (bl) {
                if (!this.ivBridgeUpdatesSuspended) {
                    this.ivMessageCache.sendProxyPostUpdate(subjectInfoImpl, bulletinBoardPost);
                }
            } else {
                this.ivMessageCache.sendLocalPostUpdate(subjectInfoImpl, bulletinBoardPost);
            }
        }
        this.ivStatsMgr.updatePost(subjectInfoImpl, byArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closePost(SubjectPostImpl subjectPostImpl, SubjectInfoImpl subjectInfoImpl, BulletinBoardPost bulletinBoardPost, boolean bl) {
        if (!bl) {
            this.cacheClosedPostVersion(subjectInfoImpl, bulletinBoardPost);
        }
        MessageCache messageCache = this.ivMessageCache;
        synchronized (messageCache) {
            if (this.ivCurrentProtocol < 5) {
                BulletinBoardServerPosts bulletinBoardServerPosts = this.ivSubjectData.clearPost(subjectInfoImpl, bulletinBoardPost.getOriginalServer());
                if (TC.isEventEnabled()) {
                    if (bl) {
                        Tr.event(TC, "closeProxyPostOld() - closing ->[subject, post]", new Object[]{subjectInfoImpl, bulletinBoardPost, bulletinBoardServerPosts});
                    } else {
                        Tr.event(TC, "closePostOld() - closing ->[subject, post]", new Object[]{subjectInfoImpl, bulletinBoardPost, bulletinBoardServerPosts});
                    }
                }
                if (this.ivCurrentProtocol < 1) {
                    this.ivMessageCache.sendPostUpdate((SubjectInfo)subjectInfoImpl, bulletinBoardServerPosts);
                } else {
                    bulletinBoardPost.setValue(bulletinBoardPost.getValue(), -1L);
                    this.ivMessageCache.sendPostUpdate((SubjectInfo)subjectInfoImpl, bulletinBoardPost);
                }
            } else if (bl) {
                this.ivProxyPosts.clearPost(subjectInfoImpl, bulletinBoardPost.getOriginalServer());
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "closeProxyPostNew() - closing ->[subject, post]", new Object[]{subjectInfoImpl, bulletinBoardPost, new Boolean(this.ivBridgeUpdatesSuspended)});
                }
                if (!this.ivBridgeUpdatesSuspended) {
                    bulletinBoardPost.setValue(bulletinBoardPost.getValue(), -1L);
                    this.ivMessageCache.sendProxyPostUpdate(subjectInfoImpl, bulletinBoardPost);
                }
            } else {
                this.ivLocalPosts.remove(subjectInfoImpl);
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "closePostNew() - closing ->[subject, post]", new Object[]{subjectInfoImpl, bulletinBoardPost});
                }
                bulletinBoardPost.setValue(bulletinBoardPost.getValue(), -1L);
                this.ivMessageCache.sendLocalPostUpdate(subjectInfoImpl, bulletinBoardPost);
            }
        }
        --this.ivPmiNumSubjects;
        if (this.ivPmi == null) {
            this.ivPmi = this.ivCoordinator.getPMI();
        }
        if (this.ivPmi != null) {
            this.ivPmi.bbLocalReportSubjects(this.ivPmiNumSubjects);
        }
    }

    synchronized SubjectSubscription subscribe(SubjectInfoImpl subjectInfoImpl, SubjectSubscriptionEvents subjectSubscriptionEvents) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "subscribe(normal)", new Object[]{subjectInfoImpl, subjectSubscriptionEvents});
        }
        SubjectSubscriptionImpl subjectSubscriptionImpl = null;
        SubscriberList subscriberList = (SubscriberList)this.ivSubscribers.get(subjectInfoImpl);
        if (subscriberList == null) {
            subjectSubscriptionImpl = new SubjectSubscriptionImpl(subjectInfoImpl, subjectSubscriptionEvents, this);
            subscriberList = new SubscriberList(subjectInfoImpl);
            this.ivSubscribers.put(subjectInfoImpl, subscriberList);
            subscriberList.addSubscriber(subjectSubscriptionImpl);
            if (this.ivCurrentProtocol < 5) {
                this.ivMessageCache.sendSubscriptionUpdate(subjectInfoImpl, svSubscribe);
            } else {
                this.ivMessageCache.sendLocalSubscriptionUpdate(subjectInfoImpl, svSubscribe);
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "subscribe(normal) - new", new Integer(subscriberList.size()));
            }
        } else {
            if (this.ivCurrentProtocol >= 5 && !subscriberList.normalSubscribersExist()) {
                this.ivMessageCache.sendLocalSubscriptionUpdate(subjectInfoImpl, svSubscribe);
            }
            SubjectValue[] subjectValueArray = subscriberList.getCurrentSubjectValues();
            subjectSubscriptionImpl = new SubjectSubscriptionImpl(subjectInfoImpl, subjectSubscriptionEvents, this, subjectValueArray);
            subscriberList.addSubscriber(subjectSubscriptionImpl);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "subscribe(normal) - existing", subjectValueArray);
            }
        }
        ++this.ivPmiNumSubscriptions;
        if (this.ivPmi == null) {
            this.ivPmi = this.ivCoordinator.getPMI();
        }
        if (this.ivPmi != null) {
            this.ivPmi.bbLocalReportSubscriptions(this.ivPmiNumSubscriptions);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "subscribe(normal)");
        }
        this.ivStatsMgr.subscribe(subjectInfoImpl);
        return subjectSubscriptionImpl;
    }

    synchronized SubjectProxySubscription subscribeProxy(SubjectInfoImpl subjectInfoImpl, SubjectSubscriptionProxyEvents subjectSubscriptionProxyEvents) throws HAIllegalRequestException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "subscribeProxy", new Object[]{subjectInfoImpl, subjectSubscriptionProxyEvents});
        }
        if (this.ivCurrentProtocol >= 5 && !this.ivBridgeMembers.contains(this.ivDCSMemberName)) {
            throw new HAIllegalRequestException("proxySubscribes not allowed on non-bridge processes.");
        }
        SubjectProxySubscriptionImpl subjectProxySubscriptionImpl = null;
        SubscriberList subscriberList = (SubscriberList)this.ivSubscribers.get(subjectInfoImpl);
        if (subscriberList == null) {
            subjectProxySubscriptionImpl = new SubjectProxySubscriptionImpl(subjectInfoImpl, subjectSubscriptionProxyEvents, this);
            subscriberList = new SubscriberList(subjectInfoImpl);
            this.ivSubscribers.put(subjectInfoImpl, subscriberList);
            if (this.ivCurrentProtocol < 5) {
                subscriberList.addSubscriber(subjectProxySubscriptionImpl);
                this.ivMessageCache.sendSubscriptionUpdate(subjectInfoImpl, svSubscribe);
            } else {
                this.ivUninitializedSubjects.add(subjectInfoImpl);
                subscriberList.addSubscriber(subjectProxySubscriptionImpl);
                this.ivMessageCache.sendProxySubscriptionUpdate(subjectInfoImpl, svSubscribe);
            }
        } else {
            if (this.ivCurrentProtocol >= 5 && !subscriberList.proxySubscribersExist()) {
                this.ivMessageCache.sendProxySubscriptionUpdate(subjectInfoImpl, svSubscribe);
            }
            SubjectValue[] subjectValueArray = subscriberList.getCurrentSubjectValues();
            subjectProxySubscriptionImpl = new SubjectProxySubscriptionImpl(subjectInfoImpl, subjectSubscriptionProxyEvents, this, subjectValueArray);
            subscriberList.addSubscriber(subjectProxySubscriptionImpl);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "subscribeProxy - existing", subjectValueArray);
            }
        }
        ++this.ivPmiNumSubscriptions;
        if (this.ivPmi == null) {
            this.ivPmi = this.ivCoordinator.getPMI();
        }
        if (this.ivPmi != null) {
            this.ivPmi.bbLocalReportSubscriptions(this.ivPmiNumSubscriptions);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "subscribeProxy()");
        }
        this.ivStatsMgr.subscribeProxy(subjectInfoImpl);
        return subjectProxySubscriptionImpl;
    }

    synchronized void unsubscribe(SubjectInfoImpl subjectInfoImpl, SubjectSubscription subjectSubscription) {
        Object[] objectArray;
        if (TC.isEntryEnabled()) {
            objectArray = new Object[]{subjectInfoImpl, subjectSubscription};
            Tr.entry(TC, "unsubscribe()", objectArray);
        }
        objectArray = (Object[])subjectSubscription;
        boolean bl = objectArray.isBridgeSubscription();
        boolean bl2 = true;
        SubscriberList subscriberList = (SubscriberList)this.ivSubscribers.get(subjectInfoImpl);
        if (subscriberList != null) {
            subscriberList.removeSubscriber(subjectSubscription);
            bl2 = subscriberList.isEmpty();
            if (bl2) {
                this.ivSubscribers.remove(subjectInfoImpl);
                if (this.ivCurrentProtocol >= 5) {
                    if (bl) {
                        this.ivUninitializedSubjects.remove(subjectInfoImpl);
                        this.ivMessageCache.sendProxySubscriptionUpdate(subjectInfoImpl, svUnsubscribe);
                    } else {
                        this.ivMessageCache.sendLocalSubscriptionUpdate(subjectInfoImpl, svUnsubscribe);
                    }
                } else {
                    this.ivMessageCache.sendSubscriptionUpdate(subjectInfoImpl, svUnsubscribe);
                }
            } else if (this.ivCurrentProtocol >= 5) {
                if (bl) {
                    if (!subscriberList.proxySubscribersExist()) {
                        this.ivUninitializedSubjects.remove(subjectInfoImpl);
                        this.ivMessageCache.sendProxySubscriptionUpdate(subjectInfoImpl, svUnsubscribe);
                    }
                } else if (!subscriberList.normalSubscribersExist()) {
                    this.ivMessageCache.sendLocalSubscriptionUpdate(subjectInfoImpl, svUnsubscribe);
                }
            }
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "unSubscribe()  - no existing subscribers");
        }
        --this.ivPmiNumSubscriptions;
        if (this.ivPmi == null) {
            this.ivPmi = this.ivCoordinator.getPMI();
        }
        if (this.ivPmi != null) {
            this.ivPmi.bbLocalReportSubscriptions(this.ivPmiNumSubscriptions);
        }
        this.ivStatsMgr.unsubscribe(subjectInfoImpl);
        if (TC.isEntryEnabled()) {
            Object[] objectArray2 = new Object[]{subjectInfoImpl, subjectSubscription, new Integer(this.ivCurrentProtocol), new Boolean(bl2), new Boolean(bl)};
            Tr.exit(TC, "unsubscribe()", objectArray2);
        }
    }

    public void getAllState(ReportClusterProcessStateMsg[] reportClusterProcessStateMsgArray) {
        int n;
        Externalizable externalizable;
        Object object;
        Object object2;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getAllStateRCPSM");
        }
        this.setWireProtocol();
        int n2 = reportClusterProcessStateMsgArray.length;
        if (this.ivSubjectData.size() > 0) {
            object2 = this.ivSubjectData.keySet().iterator();
            while (object2.hasNext()) {
                object = (SubjectInfoImpl)object2.next();
                externalizable = this.ivSubjectData.get((SubjectInfoImpl)object);
                if (externalizable == null || !((BulletinBoardServerPosts)externalizable).containsData(this.ivDCSMemberName)) {
                    if (!TC.isEventEnabled()) continue;
                    Tr.event(TC, "getAllStateRCPSM - ignoring post", new Object[]{object, externalizable});
                    continue;
                }
                n = ((SubjectInfoImpl)object).getActiveCoordinatorIndex(n2);
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "getAllStateRCPSM - adding post", new Object[]{object, externalizable, new Integer(n)});
                }
                reportClusterProcessStateMsgArray[n].getBulletinBoardValues().put(object, externalizable);
            }
        }
        if (this.ivSubscribers.size() > 0) {
            object2 = new Boolean(true);
            object = this.ivSubscribers.keySet().iterator();
            while (object.hasNext()) {
                externalizable = (SubjectInfoImpl)object.next();
                n = ((SubjectInfoImpl)externalizable).getActiveCoordinatorIndex(n2);
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "Active Co-ordinator for BulletinBoard Subscribe KeyName" + externalizable + " is " + n);
                }
                reportClusterProcessStateMsgArray[n].getSubscribers().put(externalizable, object2);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getAllStateRCPSM");
        }
    }

    public void getAllState(ReportStateMsg[] reportStateMsgArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getAllStateRSM");
        }
        int n = reportStateMsgArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.ivBridgeMembers.contains(this.ivDCSMemberName)) {
                reportStateMsgArray[i].setBulletinBoardLocalMode(2);
                reportStateMsgArray[i].setBridgeConfigurationData(this.ivBridgeMembers);
                if (this.ivBridgeUpdatesSuspended) {
                    reportStateMsgArray[i].setBulletinBoardProxyMode(4);
                    continue;
                }
                reportStateMsgArray[i].setBulletinBoardProxyMode(2);
                continue;
            }
            reportStateMsgArray[i].setBulletinBoardLocalMode(2);
        }
        this.setWireProtocol();
        this.getLocalPosts(reportStateMsgArray);
        this.getProxyPosts(reportStateMsgArray);
        this.getSubscribers(reportStateMsgArray);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getAllStateRSM");
        }
    }

    public synchronized void processGlobalStateRebuildMsg(BulletinBoardSubscriberUpdateMsg bulletinBoardSubscriberUpdateMsg, int n, int n2) throws HAInternalStateException {
        Object[] objectArray;
        if (TC.isEntryEnabled()) {
            objectArray = new Object[]{new Integer(n), new Integer(n2)};
            Tr.entry(TC, "processGlobalStateRebuildMsgBBSUM", objectArray);
        }
        objectArray = bulletinBoardSubscriberUpdateMsg.getData().keySet();
        this.removeDeadSubjects((Set)objectArray, n, n2, false);
        this.processSubjectUpdates(bulletinBoardSubscriberUpdateMsg, true);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "processGlobalStateRebuildMsgBBSUM");
        }
    }

    public synchronized void processGlobalStateRebuildMsg(SubscriberUpdateMsg subscriberUpdateMsg, int n, int n2, boolean bl) throws HAInternalStateException {
        Object[] objectArray;
        if (TC.isEntryEnabled()) {
            objectArray = new Object[]{new Integer(n), new Integer(n2)};
            Tr.entry(TC, "processGlobalStateRebuildMsgSUM", objectArray);
        }
        objectArray = subscriberUpdateMsg.getData().keySet();
        this.removeDeadSubjects((Set)objectArray, n, n2, bl);
        this.processSubjectUpdates(subscriberUpdateMsg);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "processGlobalStateRebuildMsgSUM");
        }
    }

    public synchronized void processBridgeRebuildMsg(SubscriberUpdateMsg subscriberUpdateMsg, int n, int n2) throws HAInternalStateException {
        Object[] objectArray;
        if (TC.isEntryEnabled()) {
            objectArray = new Object[]{new Integer(n), new Integer(n2)};
            Tr.entry(TC, "processBridgeRebuildMsg", objectArray);
        }
        objectArray = subscriberUpdateMsg.getData().keySet();
        this.removeDeadProxyPosts((Set)objectArray, n, n2);
        this.processSubjectUpdates(subscriberUpdateMsg);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "processBridgeRebuildMsg");
        }
    }

    public synchronized void processSubjectUpdates(BulletinBoardSubscriberUpdateMsg bulletinBoardSubscriberUpdateMsg, boolean bl) throws HAInternalStateException {
        Map map = bulletinBoardSubscriberUpdateMsg.getData();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            SubscriberList subscriberList;
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)iterator.next();
            Map map2 = (Map)map.get(subjectInfoImpl);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "processSubjectUpdatesBBSUM - updating subject", subjectInfoImpl);
            }
            if ((subscriberList = (SubscriberList)this.ivSubscribers.get(subjectInfoImpl)) != null) {
                subscriberList.updateSubjectAndNotify(map2, bl);
                continue;
            }
            if (!TC.isDebugEnabled()) continue;
            Tr.debug(TC, "processSubjectUpdates(BBSUM) - no subscribers", subjectInfoImpl);
        }
    }

    public synchronized void processSubjectUpdates(SubscriberUpdateMsg subscriberUpdateMsg) throws HAInternalStateException {
        this.processEmptySubjects(subscriberUpdateMsg);
        Map map = subscriberUpdateMsg.getData();
        int n = subscriberUpdateMsg.getLocalMode();
        int n2 = subscriberUpdateMsg.getProxyMode();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            SubscriberList subscriberList;
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)iterator.next();
            Map map2 = (Map)map.get(subjectInfoImpl);
            if (map2 == null) {
                Tr.error(TC, "HMGR0167", "null Map");
                continue;
            }
            if (n2 != 1 && map2.isEmpty()) {
                Tr.error(TC, "HMGR0167", "empty Map");
                continue;
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "processSubjectUpdatesSUM - updating subject", subjectInfoImpl);
            }
            if ((subscriberList = (SubscriberList)this.ivSubscribers.get(subjectInfoImpl)) != null) {
                subscriberList.updateSubjectAndNotify(map2, n, n2);
                continue;
            }
            if (!TC.isDebugEnabled()) continue;
            Tr.debug(TC, "processSubjectUpdates(SUM) - no subscribers", subjectInfoImpl);
        }
    }

    private void setWireProtocol() {
        int n = this.ivCurrentProtocol;
        this.ivCurrentProtocol = this.ivProtocolVersion.getHAMProtocolVersion();
        if (n < 5 && this.ivCurrentProtocol >= 5) {
            this.convertToTransparentBridges();
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "setWireProtocol", new Object[]{new Integer(n), new Integer(this.ivCurrentProtocol)});
        }
    }

    private void cacheClosedPostVersion(SubjectInfoImpl subjectInfoImpl, BulletinBoardPost bulletinBoardPost) {
        if (this.ivClosedPostVersions == null) {
            this.ivClosedPostVersions = new HashMap();
            if (this.ivClosedPostVersionsAged == null) {
                AlarmManager.createNonDeferrable(this.ivCleanCachePeriod, new PostVersionCacheCleaner());
            }
        }
        this.ivClosedPostVersions.put(subjectInfoImpl, new Long(bulletinBoardPost.getVersion()));
    }

    private Long getCachedClosedPostVersion(SubjectInfoImpl subjectInfoImpl) {
        Long l;
        if (this.ivClosedPostVersions != null && (l = (Long)this.ivClosedPostVersions.remove(subjectInfoImpl)) != null) {
            if (this.ivClosedPostVersionsAged != null) {
                this.ivClosedPostVersionsAged.remove(subjectInfoImpl);
            }
            return l;
        }
        if (this.ivClosedPostVersionsAged != null && (l = (Long)this.ivClosedPostVersionsAged.remove(subjectInfoImpl)) != null) {
            return l;
        }
        return null;
    }

    private synchronized void purgePostVersionCaches() {
        this.ivClosedPostVersionsAged = this.ivClosedPostVersions;
        this.ivClosedPostVersions = null;
        if (this.ivClosedPostVersionsAged != null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "purgePostVersionCaches", "rescheduling alarm");
            }
            AlarmManager.createNonDeferrable(this.ivCleanCachePeriod, new PostVersionCacheCleaner());
        } else if (TC.isDebugEnabled()) {
            Tr.debug(TC, "purgePostVersionCaches", "no alarm rescheduled");
        }
    }

    private void getLocalPosts(ReportStateMsg[] reportStateMsgArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getLocalPosts : adding " + this.ivLocalPosts.size() + " Subjects.");
        }
        int n = reportStateMsgArray.length;
        if (this.ivLocalPosts.size() > 0) {
            Iterator iterator = this.ivLocalPosts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
                BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry.getValue();
                if (bulletinBoardPost.getValue() == null) {
                    if (!TC.isEventEnabled()) continue;
                    Tr.event(TC, "getLocalPosts - ignoring post", new Object[]{subjectInfoImpl, "No local post from this server"});
                    continue;
                }
                int n2 = subjectInfoImpl.getActiveCoordinatorIndex(n);
                reportStateMsgArray[n2].addBulletinBoardLocalPost(subjectInfoImpl, bulletinBoardPost);
                if (!TC.isEventEnabled()) continue;
                Tr.event(TC, "getLocalPosts - adding post", new Object[]{subjectInfoImpl, bulletinBoardPost, new Integer(n2)});
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getLocalPosts()");
        }
    }

    private void getProxyPosts(ReportStateMsg[] reportStateMsgArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getProxyPosts: adding " + this.ivProxyPosts.size() + " Subjects.");
        }
        int n = reportStateMsgArray.length;
        if (this.ivBridgeUpdatesSuspended) {
            if (TC.isEntryEnabled()) {
                Tr.entry(TC, "getProxyPosts - Rebuild ongoing");
            }
            return;
        }
        if (this.ivProxyPosts.size() > 0) {
            Iterator iterator = this.ivProxyPosts.keySet().iterator();
            while (iterator.hasNext()) {
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)iterator.next();
                Map map = this.ivProxyPosts.get(subjectInfoImpl);
                if (map.isEmpty()) {
                    if (!TC.isEventEnabled()) continue;
                    Tr.event(TC, "getProxyPosts - ignoring subject", new Object[]{subjectInfoImpl, "No proxy posts"});
                    continue;
                }
                int n2 = subjectInfoImpl.getActiveCoordinatorIndex(n);
                reportStateMsgArray[n2].addBulletinBoardProxyPostMap(subjectInfoImpl, map);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getProxyPosts");
        }
    }

    private void getSubscribers(ReportStateMsg[] reportStateMsgArray) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getSubscribers");
        }
        int n = reportStateMsgArray.length;
        if (this.ivSubscribers.size() > 0) {
            Boolean bl = new Boolean(true);
            Iterator iterator = this.ivSubscribers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
                SubscriberList subscriberList = (SubscriberList)entry.getValue();
                int n2 = subjectInfoImpl.getActiveCoordinatorIndex(n);
                boolean bl2 = subscriberList.normalSubscribersExist();
                boolean bl3 = false;
                if (bl2) {
                    reportStateMsgArray[n2].addBulletinBoardLocalSubscriber(subjectInfoImpl, bl);
                }
                if (bl3 = subscriberList.proxySubscribersExist()) {
                    reportStateMsgArray[n2].addBulletinBoardProxySubscriber(subjectInfoImpl, bl);
                }
                if (!TC.isEventEnabled()) continue;
                Object[] objectArray = new Object[]{subjectInfoImpl, new Integer(n2), new Boolean(bl2), new Boolean(bl3)};
                Tr.event(TC, "getSubscribers - adding subscription", objectArray);
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getSubscribers()");
        }
    }

    private void checkForeignStateForOrphanedSubjects(Set set) {
        Set set2 = this.ivProxyPosts.keySet();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)iterator.next();
            if (set.contains(subjectInfoImpl)) continue;
            Tr.error(TC, "HMGR5013", new Object[]{svClassName, "checkForeignStateForOrphanedSubjects", subjectInfoImpl, " Stale proxy post found after bridge failed to close all posts for previously owned subject."});
        }
    }

    private void convertToTransparentBridges() {
        if (this.ivSubjectData.size() > 0) {
            Iterator iterator = this.ivSubjectData.keySet().iterator();
            while (iterator.hasNext()) {
                SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)iterator.next();
                BulletinBoardServerPosts bulletinBoardServerPosts = this.ivSubjectData.get(subjectInfoImpl);
                if (bulletinBoardServerPosts == null) {
                    if (!TC.isDebugEnabled()) continue;
                    Tr.error(TC, "convertToTransparentBridges - empty Subject", subjectInfoImpl);
                    continue;
                }
                Map map = bulletinBoardServerPosts.getAndOwnEntries();
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    String string = (String)entry.getKey();
                    BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry.getValue();
                    if (this.ivDCSMemberName.equals(string)) {
                        this.ivLocalPosts.put(subjectInfoImpl, bulletinBoardPost);
                        continue;
                    }
                    this.ivProxyPosts.put(subjectInfoImpl, bulletinBoardPost);
                }
            }
            this.ivSubjectData = new SubjectDataMap();
        }
    }

    private void removeDeadSubjects(Set set, int n, int n2, boolean bl) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadSubjects()", set.size() + " subjects included in this view.");
        }
        SubjectValue[] subjectValueArray = new SubjectValue[]{};
        Iterator iterator = this.ivSubscribers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            SubscriberList subscriberList = (SubscriberList)entry.getValue();
            if (!subjectInfoImpl.isAssignedToActiveCoordinator(n, n2) || set.contains(subjectInfoImpl)) continue;
            SubjectValue[] subjectValueArray2 = subscriberList.getCurrentSubjectValues();
            SubjectValue[] subjectValueArray3 = subjectValueArray;
            if (bl) {
                subjectValueArray3 = this.removeLocalSubjectValues(subjectValueArray2);
            }
            if (subjectValueArray2.length == subjectValueArray3.length) continue;
            Set set2 = this.calculateCurrentPostingServers(subjectValueArray2);
            if (subjectValueArray3.length > 0) {
                Set set3 = this.calculateCurrentPostingServers(subjectValueArray3);
                set2.removeAll(set3);
            }
            subscriberList.notifyAll(subjectValueArray3, Collections.EMPTY_SET, set2);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadSubjects()");
        }
    }

    private void removeDeadProxyPosts(Set set, int n, int n2) throws HAInternalStateException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeDeadProxyPosts()", set.size() + " subjects included in this view.");
        }
        Iterator iterator = this.ivSubscribers.entrySet().iterator();
        while (iterator.hasNext()) {
            SubjectValue[] subjectValueArray;
            SubjectValue[] subjectValueArray2;
            Map.Entry entry = iterator.next();
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)entry.getKey();
            SubscriberList subscriberList = (SubscriberList)entry.getValue();
            if (!subjectInfoImpl.isAssignedToActiveCoordinator(n, n2) || set.contains(subjectInfoImpl) || (subjectValueArray2 = subscriberList.getCurrentSubjectValues()).length == (subjectValueArray = this.removeProxySubjectValues(subjectValueArray2)).length) continue;
            Set set2 = this.calculateCurrentPostingServers(subjectValueArray2);
            if (subjectValueArray.length > 0) {
                Set set3 = this.calculateCurrentPostingServers(subjectValueArray);
                set2.removeAll(set3);
            }
            subscriberList.notifyAll(subjectValueArray, Collections.EMPTY_SET, set2);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeDeadProxyPosts()");
        }
    }

    private void processEmptySubjects(SubscriberUpdateMsg subscriberUpdateMsg) {
        SubjectValue[] subjectValueArray = new SubjectValue[]{};
        Set set = subscriberUpdateMsg.getEmptySubjects();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SubjectInfoImpl subjectInfoImpl = (SubjectInfoImpl)iterator.next();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "processEmptySubjects - remove subject", subjectInfoImpl);
            }
            this.ivUninitializedSubjects.remove(subjectInfoImpl);
            SubscriberList subscriberList = (SubscriberList)this.ivSubscribers.get(subjectInfoImpl);
            if (subscriberList == null) {
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "processEmptySubjects - no subscribers", subjectInfoImpl);
                continue;
            }
            SubjectValue[] subjectValueArray2 = subscriberList.getCurrentSubjectValues();
            if (subjectValueArray2.length != 0) continue;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "processEmptySubjects - calling back", new Object[]{subjectInfoImpl});
            }
            subscriberList.notifyBridges(subjectValueArray, Collections.EMPTY_SET, Collections.EMPTY_SET);
        }
    }

    private Set calculateCurrentPostingServers(SubjectValue[] subjectValueArray) {
        int n = subjectValueArray.length;
        HashSet<String> hashSet = new HashSet<String>(n + n);
        if (n == 0) {
            return hashSet;
        }
        for (int i = 0; i < n; ++i) {
            String string = subjectValueArray[i].getServerName();
            hashSet.add(string);
        }
        return hashSet;
    }

    private SubjectValue[] calculateChangedLocalSubjectValues(SubjectValue[] subjectValueArray, Set set) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "calculateChangedLocalSubjectValues - input", subjectValueArray);
            Tr.debug(TC, "calculateChangedLocalSubjectValues - changed", set);
        }
        ArrayList<SubjectValueImpl> arrayList = new ArrayList<SubjectValueImpl>();
        int n = subjectValueArray.length;
        for (int i = 0; i < n; ++i) {
            SubjectValueImpl subjectValueImpl = (SubjectValueImpl)subjectValueArray[i];
            if (subjectValueImpl.isProxyPost() || !set.contains(subjectValueImpl.getServerName())) continue;
            arrayList.add(subjectValueImpl);
        }
        n = arrayList.size();
        SubjectValue[] subjectValueArray2 = new SubjectValue[n];
        subjectValueArray2 = arrayList.toArray(subjectValueArray2);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "calculateChangedLocalSubjectValues - output", subjectValueArray2);
        }
        return subjectValueArray2;
    }

    private SubjectValue[] removeLocalSubjectValues(SubjectValue[] subjectValueArray) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeLocalSubjectValues - input", subjectValueArray);
        }
        SubjectValue[] subjectValueArray2 = null;
        if (subjectValueArray == null) {
            subjectValueArray2 = new SubjectValue[]{};
        } else {
            ArrayList<SubjectValueImpl> arrayList = new ArrayList<SubjectValueImpl>();
            int n = subjectValueArray.length;
            for (int i = 0; i < n; ++i) {
                SubjectValueImpl subjectValueImpl = (SubjectValueImpl)subjectValueArray[i];
                if (!subjectValueImpl.isProxyPost()) continue;
                arrayList.add(subjectValueImpl);
            }
            n = arrayList.size();
            subjectValueArray2 = new SubjectValue[n];
            subjectValueArray2 = arrayList.toArray(subjectValueArray2);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeLocalSubjectValues - output", subjectValueArray2);
        }
        return subjectValueArray2;
    }

    private SubjectValue[] removeProxySubjectValues(SubjectValue[] subjectValueArray) {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeProxySubjectValues - input", subjectValueArray);
        }
        SubjectValue[] subjectValueArray2 = null;
        if (subjectValueArray == null) {
            subjectValueArray2 = new SubjectValue[]{};
        } else {
            ArrayList<SubjectValueImpl> arrayList = new ArrayList<SubjectValueImpl>();
            int n = subjectValueArray.length;
            for (int i = 0; i < n; ++i) {
                SubjectValueImpl subjectValueImpl = (SubjectValueImpl)subjectValueArray[i];
                if (subjectValueImpl.isProxyPost()) continue;
                arrayList.add(subjectValueImpl);
            }
            n = arrayList.size();
            subjectValueArray2 = new SubjectValue[n];
            subjectValueArray2 = arrayList.toArray(subjectValueArray2);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeProxySubjectValues - output", subjectValueArray2);
        }
        return subjectValueArray2;
    }

    private void removeAllProxyPosts() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "removeAllProxyPosts()");
        }
        Iterator iterator = this.ivSubscribers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SubscriberList subscriberList = (SubscriberList)entry.getValue();
            SubjectValue[] subjectValueArray = subscriberList.getCurrentSubjectValues();
            ArrayList<SubjectValueImpl> arrayList = new ArrayList<SubjectValueImpl>();
            HashSet<String> hashSet = new HashSet<String>();
            int n = subjectValueArray.length;
            for (int i = 0; i < n; ++i) {
                SubjectValueImpl subjectValueImpl = (SubjectValueImpl)subjectValueArray[i];
                if (!subjectValueImpl.isProxyPost()) {
                    arrayList.add(subjectValueImpl);
                    continue;
                }
                hashSet.add(subjectValueImpl.getServerName());
            }
            if (hashSet.isEmpty()) continue;
            n = arrayList.size();
            SubjectValue[] subjectValueArray2 = new SubjectValue[n];
            subjectValueArray2 = arrayList.toArray(subjectValueArray2);
            subscriberList.replaceAndNotifyLocals(subjectValueArray2, hashSet);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "removeAllProxyPosts()");
        }
    }

    private final class PostVersionCacheCleaner
    implements AlarmListener {
        private PostVersionCacheCleaner() {
        }

        public void alarm(Object object) {
            LocalBulletinBoardStateManager.this.purgePostVersionCaches();
        }
    }

    private class BBoardUserCallback
    implements UserCallback {
        private SubjectSubscriptionImpl ivSsi;
        private SubjectValue[] ivValues;
        Set ivRemoved;
        private String ivUserCallbackName;

        BBoardUserCallback(SubjectSubscriptionImpl subjectSubscriptionImpl, SubjectValue[] subjectValueArray, Set set) {
            this.ivSsi = subjectSubscriptionImpl;
            this.ivValues = subjectValueArray;
            this.ivRemoved = set;
            this.ivUserCallbackName = this.ivSsi.isBridgeSubscription() ? ((SubjectProxySubscriptionImpl)this.ivSsi).getProxyCallback().getClass().getName() : this.ivSsi.getCallback().getClass().getName();
        }

        public void doCallback() {
            long l = 0L;
            long l2 = 0L;
            boolean bl = LocalBulletinBoardStateManager.this.ivStatsMgr.doCalculateFinest();
            if (this.ivSsi.isBridgeSubscription()) {
                SubjectSubscriptionProxyEvents subjectSubscriptionProxyEvents = ((SubjectProxySubscriptionImpl)this.ivSsi).getProxyCallback();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doCallback - " + subjectSubscriptionProxyEvents.getClass().getName() + ".updated()");
                }
                if (bl) {
                    l = System.currentTimeMillis();
                }
                subjectSubscriptionProxyEvents.updated(this.ivSsi, this.ivValues, this.ivRemoved);
                if (bl) {
                    l2 = System.currentTimeMillis();
                }
            } else {
                SubjectSubscriptionEvents subjectSubscriptionEvents = this.ivSsi.getCallback();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doCallback - " + subjectSubscriptionEvents.getClass().getName() + ".updated()");
                }
                if (bl) {
                    l = System.currentTimeMillis();
                }
                subjectSubscriptionEvents.updated(this.ivSsi, this.ivValues);
                if (bl) {
                    l2 = System.currentTimeMillis();
                }
            }
            if (bl) {
                LocalBulletinBoardStateManager.this.ivStatsMgr.callbackCompleted(this.ivSsi, this.ivValues, l2 - l);
            }
        }

        public int getQueue(int n) {
            int n2 = 0;
            int n3 = Math.abs(this.ivSsi.getSubjectInternal().hashCode());
            if (n3 < 0) {
                n3 = 0;
            }
            n2 = n3 % n;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "getQueue() - SubjectSubscription hashcode=" + n3 + ", number of queues=" + n + ", hc % numberOfQueues=" + n2);
            }
            return n2;
        }

        public String getUserClassName() {
            return this.ivUserCallbackName;
        }

        public String toString() {
            try {
                return this.ivSsi.getSubject().toString();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, LocalBulletinBoardStateManager.svClassName, "1468", this);
                return "BulletinBoard: closed subject";
            }
        }
    }

    private class SubscriberList {
        private ArrayList ivSubscribersToASubject = new ArrayList();
        private boolean ivInitialBridgeCallbackCompleted = false;
        private SubjectInfoImpl ivSubscribedToSubject;

        public SubscriberList(SubjectInfoImpl subjectInfoImpl) {
            this.ivSubscribedToSubject = subjectInfoImpl;
        }

        protected void addSubscriber(SubjectSubscriptionImpl subjectSubscriptionImpl) {
            this.ivSubscribersToASubject.add(subjectSubscriptionImpl);
            SubjectValue[] subjectValueArray = this.getCurrentSubjectValues();
            if (subjectSubscriptionImpl.isBridgeSubscription()) {
                Object[] objectArray;
                if (TC.isDebugEnabled()) {
                    objectArray = new Object[]{subjectSubscriptionImpl.getSubjectInternal(), new Integer(this.ivSubscribersToASubject.size())};
                    Tr.debug(TC, "addSubscriber - bridge", objectArray);
                }
                if (subjectValueArray.length != 0) {
                    objectArray = LocalBulletinBoardStateManager.this.calculateCurrentPostingServers(subjectValueArray);
                    SubjectValue[] subjectValueArray2 = LocalBulletinBoardStateManager.this.calculateChangedLocalSubjectValues(subjectValueArray, (Set)objectArray);
                    if (subjectValueArray2.length != 0) {
                        this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray2, Collections.EMPTY_SET);
                        this.ivInitialBridgeCallbackCompleted = true;
                    } else if (LocalBulletinBoardStateManager.this.ivCurrentProtocol >= 5) {
                        this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray2, Collections.EMPTY_SET);
                        this.ivInitialBridgeCallbackCompleted = true;
                    }
                } else if (LocalBulletinBoardStateManager.this.ivCurrentProtocol >= 5 && !LocalBulletinBoardStateManager.this.ivUninitializedSubjects.contains(subjectSubscriptionImpl.ivSubject)) {
                    this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray, Collections.EMPTY_SET);
                    this.ivInitialBridgeCallbackCompleted = true;
                }
            } else {
                if (TC.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{subjectSubscriptionImpl.getSubjectInternal(), new Integer(this.ivSubscribersToASubject.size())};
                    Tr.debug(TC, "addSubscriber - normal", objectArray);
                }
                if (subjectValueArray.length != 0) {
                    this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray, Collections.EMPTY_SET);
                }
            }
        }

        protected void removeSubscriber(SubjectSubscription subjectSubscription) {
            this.ivSubscribersToASubject.remove(subjectSubscription);
        }

        protected int size() {
            return this.ivSubscribersToASubject.size();
        }

        protected boolean isEmpty() {
            return this.ivSubscribersToASubject.isEmpty();
        }

        protected SubjectValue[] getCurrentSubjectValues() {
            SubjectValue[] subjectValueArray = new SubjectValue[]{};
            int n = this.ivSubscribersToASubject.size();
            for (int i = n - 1; i > -1; --i) {
                try {
                    SubjectSubscriptionImpl subjectSubscriptionImpl = (SubjectSubscriptionImpl)this.ivSubscribersToASubject.get(i);
                    subjectValueArray = subjectSubscriptionImpl.getValues();
                    break;
                }
                catch (SubjectSubscriptionClosedException subjectSubscriptionClosedException) {
                    FFDCFilter.processException((Throwable)subjectSubscriptionClosedException, LocalBulletinBoardStateManager.svClassName, "1091", this);
                    this.ivSubscribersToASubject.remove(i);
                    continue;
                }
            }
            return subjectValueArray;
        }

        protected boolean proxySubscribersExist() {
            int n = this.ivSubscribersToASubject.size();
            for (int i = 0; i < n; ++i) {
                SubjectSubscriptionImpl subjectSubscriptionImpl = (SubjectSubscriptionImpl)this.ivSubscribersToASubject.get(i);
                if (!subjectSubscriptionImpl.isBridgeSubscription()) continue;
                return true;
            }
            return false;
        }

        protected boolean normalSubscribersExist() {
            int n = this.ivSubscribersToASubject.size();
            for (int i = 0; i < n; ++i) {
                SubjectSubscriptionImpl subjectSubscriptionImpl = (SubjectSubscriptionImpl)this.ivSubscribersToASubject.get(i);
                if (subjectSubscriptionImpl.isBridgeSubscription()) continue;
                return true;
            }
            return false;
        }

        protected void notifyAll(SubjectValue[] subjectValueArray, Set set, Set set2) {
            int n = this.ivSubscribersToASubject.size();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "notify", new Object[]{new Integer(n)});
            }
            Set set3 = null;
            SubjectValue[] subjectValueArray2 = null;
            boolean bl = false;
            for (int i = n - 1; i > -1; --i) {
                SubjectSubscriptionImpl subjectSubscriptionImpl = (SubjectSubscriptionImpl)this.ivSubscribersToASubject.get(i);
                if (subjectSubscriptionImpl.isClosed()) {
                    Tr.error(TC, "HMGR0169", new Object[]{"all", subjectSubscriptionImpl.getSubjectInternal()});
                    this.ivSubscribersToASubject.remove(i);
                    continue;
                }
                subjectSubscriptionImpl.setValue(subjectValueArray);
                if (!subjectSubscriptionImpl.isBridgeSubscription()) {
                    this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray, set2);
                    continue;
                }
                if (!this.ivInitialBridgeCallbackCompleted) {
                    SubjectValue[] subjectValueArray3 = this.calculateLocalSubjectValues(subjectValueArray);
                    bl = true;
                    this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray3, new HashSet());
                    continue;
                }
                if (subjectValueArray2 == null) {
                    subjectValueArray2 = LocalBulletinBoardStateManager.this.calculateChangedLocalSubjectValues(subjectValueArray, set);
                    set3 = this.calculateRemovedLocalPosters(set2);
                }
                if (subjectValueArray2.length == 0 && set3.size() == 0) continue;
                this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray2, set3);
            }
            if (bl) {
                this.ivInitialBridgeCallbackCompleted = true;
            }
        }

        protected void notifyBridges(SubjectValue[] subjectValueArray, Set set, Set set2) {
            int n = this.ivSubscribersToASubject.size();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "notifyBridges", new Object[]{new Integer(n)});
            }
            Set set3 = null;
            SubjectValue[] subjectValueArray2 = null;
            boolean bl = false;
            for (int i = n - 1; i > -1; --i) {
                SubjectSubscriptionImpl subjectSubscriptionImpl = (SubjectSubscriptionImpl)this.ivSubscribersToASubject.get(i);
                if (subjectSubscriptionImpl.isClosed()) {
                    Tr.error(TC, "HMGR0169", new Object[]{"bridge", subjectSubscriptionImpl.getSubjectInternal()});
                    this.ivSubscribersToASubject.remove(i);
                    continue;
                }
                subjectSubscriptionImpl.setValue(subjectValueArray);
                if (!subjectSubscriptionImpl.isBridgeSubscription()) continue;
                if (!this.ivInitialBridgeCallbackCompleted) {
                    bl = true;
                    this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray, new HashSet());
                    continue;
                }
                if (subjectValueArray2 == null) {
                    subjectValueArray2 = LocalBulletinBoardStateManager.this.calculateChangedLocalSubjectValues(subjectValueArray, set);
                    set3 = this.calculateRemovedLocalPosters(set2);
                }
                if (subjectValueArray2.length == 0 && set3.size() == 0) continue;
                this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray2, set3);
            }
            if (bl) {
                this.ivInitialBridgeCallbackCompleted = true;
            }
        }

        protected void replaceAndNotifyLocals(SubjectValue[] subjectValueArray, Set set) {
            int n = this.ivSubscribersToASubject.size();
            for (int i = n - 1; i > -1; --i) {
                SubjectSubscriptionImpl subjectSubscriptionImpl = (SubjectSubscriptionImpl)this.ivSubscribersToASubject.get(i);
                subjectSubscriptionImpl.setValue(subjectValueArray);
                if (subjectSubscriptionImpl.isBridgeSubscription()) continue;
                this.sendSubscriptionChangedCallback(subjectSubscriptionImpl, subjectValueArray, set);
            }
        }

        protected void updateSubjectAndNotify(Map map, boolean bl) throws HAInternalStateException {
            if (this.ivSubscribersToASubject.isEmpty()) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateSubjectAndNotifyBBSUM - no subscribers", this.ivSubscribedToSubject);
                }
                return;
            }
            if (map == null) {
                this.clearAllPosts();
            } else {
                if (bl && map.size() == 0) {
                    HAInternalStateException hAInternalStateException = new HAInternalStateException("empty subject map not allowed");
                    Tr.error(TC, "HMGR5008", hAInternalStateException);
                    throw hAInternalStateException;
                }
                Map map2 = this.unpackBboardServerPosts(map);
                SubjectValue[] subjectValueArray = this.getCurrentSubjectValues();
                HashSet hashSet = new HashSet();
                HashSet hashSet2 = new HashSet();
                HashSet hashSet3 = new HashSet();
                SubjectValue[] subjectValueArray2 = this.updateSubjectValues(subjectValueArray, map2, hashSet, hashSet2, hashSet3, bl);
                this.notifyAndSynthesize(subjectValueArray2, hashSet, hashSet2, hashSet3);
            }
        }

        protected void updateSubjectAndNotify(Map map, int n, int n2) throws HAInternalStateException {
            if (this.ivSubscribersToASubject.isEmpty()) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateSubjectAndNotifySUM - no subscribers", this.ivSubscribedToSubject);
                }
                return;
            }
            SubjectValue[] subjectValueArray = this.getCurrentSubjectValues();
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            HashSet hashSet3 = new HashSet();
            SubjectValue[] subjectValueArray2 = this.updateSubjectValues(subjectValueArray, map, hashSet, hashSet2, hashSet3, n, n2);
            this.notifyAndSynthesize(subjectValueArray2, hashSet, hashSet2, hashSet3);
        }

        private Map unpackBboardServerPosts(Map map) {
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                BulletinBoardServerPosts bulletinBoardServerPosts = (BulletinBoardServerPosts)map.get(string);
                if (bulletinBoardServerPosts == null) {
                    hashMap.put(string, null);
                    continue;
                }
                Map map2 = bulletinBoardServerPosts.getAndOwnEntries();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "unpackServerPosts", new Object[]{string, map2});
                }
                hashMap.put(string, map2);
            }
            return hashMap;
        }

        private void notifyAndSynthesize(SubjectValue[] subjectValueArray, Set set, Set set2, Set set3) {
            if (set.size() == 0 && set2.size() == 0) {
                SubjectValue[] subjectValueArray2 = this.getCurrentSubjectValues();
                if (subjectValueArray2.length != 0) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "notifyAndSynthesize", "Existing posts present but no posts changes detected");
                    }
                } else if (LocalBulletinBoardStateManager.this.ivCurrentProtocol < 5) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "notifyAndSynthesize", "No existing posts present, no posts changes detected but not running the optimized bboard protocol.");
                    }
                } else {
                    boolean bl = true;
                    for (int i = 0; i < subjectValueArray.length; ++i) {
                        if (subjectValueArray[i].getVersion() == -1L) continue;
                        bl = false;
                    }
                    if (bl) {
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "notifyAndSynthesize - all posts closed and no local state, calling bridges back with EMPTY_SET", new Object[]{this.ivSubscribedToSubject});
                        }
                        SubjectValue[] subjectValueArray3 = new SubjectValue[]{};
                        this.notifyBridges(subjectValueArray3, Collections.EMPTY_SET, Collections.EMPTY_SET);
                    } else if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "notifyAndSynthesize", "No existing posts present, no posts changes detected but post non closed updates were found.");
                    }
                }
            } else if (set3.size() == 0) {
                this.notifyAll(subjectValueArray, set, set2);
            } else {
                SubjectValue[] subjectValueArray4 = this.removeUpdatesForImplicitlyClosedPosts(subjectValueArray, set3, set, set2);
                this.notifyAll(subjectValueArray4, set, set2);
                set2.clear();
                this.notifyAll(subjectValueArray, set3, set2);
            }
        }

        private SubjectValue[] removeUpdatesForImplicitlyClosedPosts(SubjectValue[] subjectValueArray, Set set, Set set2, Set set3) {
            SubjectValue[] subjectValueArray2;
            ArrayList<SubjectValue> arrayList = new ArrayList<SubjectValue>(subjectValueArray.length);
            for (int i = 0; i < subjectValueArray.length; ++i) {
                if (set.contains(subjectValueArray[i].getServerName())) continue;
                arrayList.add(subjectValueArray[i]);
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                subjectValueArray2 = (SubjectValue[])iterator.next();
                set2.remove(subjectValueArray2);
                set3.add(subjectValueArray2);
            }
            subjectValueArray2 = new SubjectValue[arrayList.size()];
            subjectValueArray2 = arrayList.toArray(subjectValueArray2);
            return subjectValueArray2;
        }

        private SubjectValue[] updateSubjectValues(SubjectValue[] subjectValueArray, Map map, Set set, Set set2, Set set3, boolean bl) {
            ArrayList arrayList = new ArrayList(map.size());
            if (subjectValueArray == null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateSubjectValues() - no existing SubjectValues");
                }
            } else {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateSubjectValues() - existing SubjectValues", new Integer(subjectValueArray.length));
                }
                int n = subjectValueArray.length;
                for (int i = 0; i < n; ++i) {
                    SubjectValueImpl subjectValueImpl = (SubjectValueImpl)subjectValueArray[i];
                    boolean bl2 = true;
                    if (LocalBulletinBoardStateManager.this.ivCurrentProtocol < 1) {
                        bl2 = false;
                    }
                    subjectValueImpl.processUpdateToExistingPost(arrayList, map, set, set2, set3, bl, bl2);
                }
            }
            this.processNewPosts(arrayList, map, set);
            SubjectValue[] subjectValueArray2 = new SubjectValue[arrayList.size()];
            subjectValueArray2 = arrayList.toArray(subjectValueArray2);
            return subjectValueArray2;
        }

        private SubjectValue[] updateSubjectValues(SubjectValue[] subjectValueArray, Map map, Set set, Set set2, Set set3, int n, int n2) {
            ArrayList arrayList = new ArrayList(map.size());
            if (subjectValueArray == null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateSubjectValues() - no existing SubjectValues");
                }
            } else {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateSubjectValues() - existing SubjectValues", new Integer(subjectValueArray.length));
                }
                int n3 = subjectValueArray.length;
                for (int i = 0; i < n3; ++i) {
                    SubjectValueImpl subjectValueImpl = (SubjectValueImpl)subjectValueArray[i];
                    if (subjectValueImpl.isProxyPost()) {
                        subjectValueImpl.updateProxyPost(arrayList, map, set, set2, set3, n2);
                        continue;
                    }
                    subjectValueImpl.updateLocalPost(arrayList, map, set, set2, set3, n);
                }
            }
            this.processNewPostsTransparentMode(arrayList, map, set);
            SubjectValue[] subjectValueArray2 = new SubjectValue[arrayList.size()];
            subjectValueArray2 = arrayList.toArray(subjectValueArray2);
            return subjectValueArray2;
        }

        private void processNewPosts(ArrayList arrayList, Map map, Set set) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Map map2 = (Map)entry.getValue();
                if (map2 == null) continue;
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry2.getValue();
                    if (bulletinBoardPost.getVersion() <= 0L) continue;
                    SubjectValueImpl subjectValueImpl = new SubjectValueImpl(string, bulletinBoardPost);
                    arrayList.add(subjectValueImpl);
                    String string2 = subjectValueImpl.getServerName();
                    set.add(string2);
                    if (!TC.isDebugEnabled()) continue;
                    Tr.debug(TC, "processNewPosts - merging new post into list of updated SujectValues", new Object[]{string2, bulletinBoardPost});
                }
            }
        }

        private void processNewPostsTransparentMode(ArrayList arrayList, Map map, Set set) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)entry.getValue();
                if (bulletinBoardPost == null) {
                    if (!TC.isDebugEnabled()) continue;
                    Tr.debug(TC, "processNewPostsTransparentMode - null", new Object[]{"LBBSM", "newTransparentPost", "post is null"});
                    continue;
                }
                if (bulletinBoardPost.getVersion() <= 0L) continue;
                SubjectValueImpl subjectValueImpl = null;
                subjectValueImpl = LocalBulletinBoardStateManager.this.ivCoreGroupMembers.contains(string) ? new SubjectValueImpl(string, bulletinBoardPost) : new SubjectValueImpl("bridge", bulletinBoardPost);
                arrayList.add(subjectValueImpl);
                set.add(string);
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "processNewPostsTransparentMode - add", new Object[]{string, bulletinBoardPost});
            }
        }

        private void clearAllPosts() throws HAInternalStateException {
            SubjectValue[] subjectValueArray;
            int n = LocalBulletinBoardStateManager.this.ivSubscribers.size();
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "clearAllPosts", new Object[]{this.ivSubscribedToSubject, new Integer(n)});
            }
            if ((subjectValueArray = this.getCurrentSubjectValues()) == null || subjectValueArray.length == 0) {
                Tr.error(TC, "HMGR5014", new Object[]{this.ivSubscribedToSubject});
                HAInternalStateException hAInternalStateException = new HAInternalStateException("Unexpectedly encountered existing values of null or length = 0.");
                throw hAInternalStateException;
            }
            Set set = LocalBulletinBoardStateManager.this.calculateCurrentPostingServers(subjectValueArray);
            this.notifyAll(new SubjectValue[0], Collections.EMPTY_SET, set);
        }

        private Set calculateRemovedLocalPosters(Set set) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "filterRemovedServersForBridge - input", set);
            }
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!LocalBulletinBoardStateManager.this.ivCoreGroupMembers.contains(string)) continue;
                hashSet.add(string);
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "filterRemovedServersForBridge - output", hashSet);
            }
            return Collections.unmodifiableSet(hashSet);
        }

        private SubjectValue[] calculateLocalSubjectValues(SubjectValue[] subjectValueArray) {
            SubjectValue[] subjectValueArray2;
            int n;
            ArrayList<SubjectValue[]> arrayList = new ArrayList<SubjectValue[]>();
            for (n = 0; n < subjectValueArray.length; ++n) {
                subjectValueArray2 = (SubjectValue[])subjectValueArray[n];
                if (subjectValueArray2.isProxyPost()) continue;
                arrayList.add(subjectValueArray2);
            }
            n = arrayList.size();
            subjectValueArray2 = new SubjectValue[n];
            subjectValueArray2 = arrayList.toArray(subjectValueArray2);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "calculateLocalSubjectValues - output", subjectValueArray2);
            }
            return subjectValueArray2;
        }

        private void sendSubscriptionChangedCallback(SubjectSubscriptionImpl subjectSubscriptionImpl, SubjectValue[] subjectValueArray, Set set) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "sendSubscriptionChangedCallback", subjectValueArray);
            }
            BBoardUserCallback bBoardUserCallback = new BBoardUserCallback(subjectSubscriptionImpl, subjectValueArray, set);
            UserCallbacks.executeCallback(bBoardUserCallback);
        }
    }
}

