/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.ws.hamanager.bboard.LocalBulletinBoardStateManager;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectPostCallback;
import com.ibm.wsspi.hamanager.bboard.SubjectPostClosedException;

public class SubjectPostImpl
implements SubjectPost {
    private static final TraceComponent TC = Tr.register(SubjectPostImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    SubjectInfoImpl subject;
    BulletinBoardPost post;
    LocalBulletinBoardStateManager manager;
    SubjectPostCallback callback;
    private boolean ivProxyPost;

    SubjectPostImpl(SubjectInfoImpl subjectInfoImpl, BulletinBoardPost bulletinBoardPost, LocalBulletinBoardStateManager localBulletinBoardStateManager, boolean bl) {
        this.subject = subjectInfoImpl;
        this.post = bulletinBoardPost;
        this.manager = localBulletinBoardStateManager;
        this.ivProxyPost = bl;
    }

    public synchronized void updatePost(byte[] byArray) throws SubjectPostClosedException {
        if (byArray == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "updatePost", new Object[]{this.subject, "null value was passed, update ignored."});
            }
            return;
        }
        this.check();
        if (this.ivProxyPost) {
            String string = "updatePost(byte[]) was called on proxy post " + this.post;
            HAInternalStateException hAInternalStateException = new HAInternalStateException(string);
            Tr.error(TC, "HMGR0108", new Object[]{"SubjectPost", "updatePost()", hAInternalStateException});
        }
        this.manager.updatePost(this, this.post, this.subject, byArray, this.ivProxyPost);
    }

    public synchronized void updateProxyPost(byte[] byArray, long l) throws HAException {
        if (byArray == null) {
            throw new HAParameterRejectedException("null value was passed.");
        }
        this.check();
        if (l <= this.post.getVersion()) {
            throw new HAParameterRejectedException("Current version is " + this.post.getVersion() + ", specified version = " + l);
        }
        if (!this.ivProxyPost) {
            String string = "updateProxyPost() was called on a non-proxy post " + this.post;
            HAInternalStateException hAInternalStateException = new HAInternalStateException(string);
            Tr.error(TC, "HMGR0108", new Object[]{"SubjectPost", "updateProxyPost()", hAInternalStateException});
        }
        this.manager.updatePost(this, this.post, this.subject, byArray, this.ivProxyPost);
    }

    public synchronized void close() throws SubjectPostClosedException {
        this.check();
        if (TC.isEventEnabled()) {
            Tr.event(TC, "close", new Object[]{this.subject, new Long(this.post.getVersion())});
        }
        this.manager.closePost(this, this.subject, this.post, this.ivProxyPost);
        this.subject = null;
        this.post = null;
        this.callback = null;
    }

    public synchronized void registerCallback(SubjectPostCallback subjectPostCallback) {
        this.callback = subjectPostCallback;
        if (subjectPostCallback != null) {
            subjectPostCallback.postHasSubscribers(this);
        }
    }

    private void check() throws SubjectPostClosedException {
        if (this.subject == null) {
            throw new SubjectPostClosedException("SubjectPost for subject closed");
        }
    }
}

