/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ws.hamanager.bboard.LocalBulletinBoardStateManager;
import com.ibm.ws.hamanager.bboard.SubjectInfoImpl;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionClosedException;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;

public class SubjectSubscriptionImpl
implements SubjectSubscription {
    private boolean ivClosed = false;
    protected SubjectInfoImpl ivSubject = null;
    protected LocalBulletinBoardStateManager ivBulletinBoardStateManager;
    private SubjectSubscriptionEvents ivCallback;
    private SubjectValue[] ivData;

    SubjectSubscriptionImpl(SubjectInfoImpl subjectInfoImpl, LocalBulletinBoardStateManager localBulletinBoardStateManager) {
        this.ivSubject = subjectInfoImpl;
        this.ivBulletinBoardStateManager = localBulletinBoardStateManager;
        this.ivData = new SubjectValue[0];
    }

    SubjectSubscriptionImpl(SubjectInfoImpl subjectInfoImpl, LocalBulletinBoardStateManager localBulletinBoardStateManager, SubjectValue[] subjectValueArray) {
        this.ivSubject = subjectInfoImpl;
        this.ivBulletinBoardStateManager = localBulletinBoardStateManager;
        this.ivData = subjectValueArray;
    }

    SubjectSubscriptionImpl(SubjectInfoImpl subjectInfoImpl, SubjectSubscriptionEvents subjectSubscriptionEvents, LocalBulletinBoardStateManager localBulletinBoardStateManager) {
        this.ivSubject = subjectInfoImpl;
        this.ivCallback = subjectSubscriptionEvents;
        this.ivBulletinBoardStateManager = localBulletinBoardStateManager;
        this.ivData = new SubjectValue[0];
    }

    SubjectSubscriptionImpl(SubjectInfoImpl subjectInfoImpl, SubjectSubscriptionEvents subjectSubscriptionEvents, LocalBulletinBoardStateManager localBulletinBoardStateManager, SubjectValue[] subjectValueArray) {
        this.ivSubject = subjectInfoImpl;
        this.ivCallback = subjectSubscriptionEvents;
        this.ivBulletinBoardStateManager = localBulletinBoardStateManager;
        this.ivData = subjectValueArray;
    }

    public void close() throws SubjectSubscriptionClosedException {
        this.check();
        this.ivBulletinBoardStateManager.unsubscribe(this.ivSubject, this);
        this.ivClosed = true;
    }

    public SubjectInfo getSubject() throws SubjectSubscriptionClosedException {
        return this.ivSubject;
    }

    SubjectValue[] getValues() throws SubjectSubscriptionClosedException {
        this.check();
        return this.ivData;
    }

    synchronized void setValue(SubjectValue[] subjectValueArray) {
        this.ivData = subjectValueArray;
    }

    void closeImplicit() {
        this.ivClosed = true;
    }

    SubjectSubscriptionEvents getCallback() {
        return this.ivCallback;
    }

    SubjectValue[] getData() {
        return this.ivData;
    }

    SubjectInfoImpl getSubjectInternal() {
        return this.ivSubject;
    }

    boolean isBridgeSubscription() {
        return false;
    }

    boolean isClosed() {
        return this.ivClosed;
    }

    void check() throws SubjectSubscriptionClosedException {
        if (this.ivClosed) {
            String string = "SubjectSubscripton for subject " + this.ivSubject + " has been previously closed";
            throw new SubjectSubscriptionClosedException(string);
        }
    }
}

