/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.bboard;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.hamanager.bboard.BulletinBoardPost;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class SubjectValueImpl
implements SubjectValue,
Externalizable {
    private static final long serialVersionUID = -3961915112728644241L;
    private static final TraceComponent TC = Tr.register(SubjectValueImpl.class.getName(), "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final int svVersion = 1;
    private String ivLocalPostingServerName;
    private BulletinBoardPost ivPost;

    public SubjectValueImpl() {
    }

    public SubjectValueImpl(String string, BulletinBoardPost bulletinBoardPost) {
        this.ivLocalPostingServerName = string;
        this.ivPost = bulletinBoardPost;
    }

    public String getServerName() {
        return this.ivPost.getOriginalServer();
    }

    public byte[] getValues() {
        return this.ivPost.getValue();
    }

    public long getVersion() {
        return this.ivPost.getVersion();
    }

    public boolean isProxyPost() {
        return !this.ivLocalPostingServerName.equals(this.ivPost.getOriginalServer());
    }

    public String toString() {
        return "<SubjectValue : LocalPostingServer = " + this.ivLocalPostingServerName + ", Post = " + this.ivPost + ">";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.ivLocalPostingServerName = objectInput.readUTF();
        this.ivPost = (BulletinBoardPost)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        objectOutput.writeUTF(this.ivLocalPostingServerName);
        objectOutput.writeObject(this.ivPost);
    }

    public void processUpdateToExistingPost(ArrayList arrayList, Map map, Set set, Set set2, Set set3, boolean bl, boolean bl2) {
        Map map2;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "processUpdateToExistingPost", new Object[]{this, new Boolean(bl), new Boolean(bl2), map});
        }
        if ((map2 = (Map)map.get(this.ivLocalPostingServerName)) == null) {
            this.noUpdateReceived(map, set2, arrayList, bl);
        } else {
            this.possibleUpdateReceived(map2, set, set2, arrayList, set3, bl, bl2);
        }
    }

    private void noUpdateReceived(Map map, Set set, ArrayList arrayList, boolean bl) {
        boolean bl2 = true;
        if (map.containsKey(this.ivLocalPostingServerName)) {
            set.add(this.ivPost.getOriginalServer());
        } else if (!bl) {
            arrayList.add(this);
            bl2 = false;
        } else {
            set.add(this.ivPost.getOriginalServer());
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{this.ivLocalPostingServerName, new Boolean(bl), new Boolean(bl2), this.ivPost};
            Tr.debug(TC, "noUpdateReceived", objectArray);
        }
    }

    private void possibleUpdateReceived(Map map, Set set, Set set2, ArrayList arrayList, Set set3, boolean bl, boolean bl2) {
        int n = set.size() + set2.size() + set3.size();
        int n2 = arrayList.size();
        String string = this.ivPost.getOriginalServer();
        BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)map.remove(string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "possibleUpdateReceived", new Object[]{this.ivPost, bulletinBoardPost, new Boolean(bl2)});
        }
        if (bulletinBoardPost == null) {
            if (!bl2 || bl) {
                set2.add(string);
            } else {
                arrayList.add(this);
            }
        } else {
            long l = this.ivPost.getVersion();
            long l2 = bulletinBoardPost.getVersion();
            if (!bl2 || bl) {
                if (l == l2) {
                    arrayList.add(this);
                } else {
                    this.processUpdateWithVersionChange(set, arrayList, set3, bulletinBoardPost);
                }
            } else if (l2 == -1L) {
                set2.add(this.getServerName());
            } else {
                this.processUpdateWithVersionChange(set, arrayList, set3, bulletinBoardPost);
            }
        }
        int n3 = set.size() + set2.size() + set3.size();
        int n4 = arrayList.size();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "possibleUpdateReceived: Delta's for changedState and completeState sizes", new Object[]{bulletinBoardPost, new Integer(n3 - n), new Integer(n4 - n2)});
        }
    }

    private void processUpdateWithVersionChange(Set set, ArrayList arrayList, Set set2, BulletinBoardPost bulletinBoardPost) {
        long l = this.ivPost.getVersion();
        long l2 = bulletinBoardPost.getVersion();
        SubjectValueImpl subjectValueImpl = new SubjectValueImpl(this.ivLocalPostingServerName, bulletinBoardPost);
        arrayList.add(subjectValueImpl);
        set.add(subjectValueImpl.getServerName());
        if (l2 < l) {
            set2.add(subjectValueImpl.getServerName());
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "processUpdateWithVersionChange - implicit close condition.");
            }
        }
    }

    public void updateProxyPost(ArrayList arrayList, Map map, Set set, Set set2, Set set3, int n) {
        boolean bl = map.containsKey(this.ivPost.getOriginalServer());
        BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)map.remove(this.ivPost.getOriginalServer());
        if (n == 0) {
            Object[] objectArray;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "updateProxyPost.NODATA", new Object[]{this.ivPost, bulletinBoardPost});
            }
            arrayList.add(this);
            if (bulletinBoardPost != null) {
                objectArray = new Object[]{"ProxyPost", "NODATA", "post"};
                Tr.error(TC, "HMGR0170", objectArray);
            }
            if (bl) {
                objectArray = new Object[]{"ProxyPost", "NODATA", "key"};
                Tr.error(TC, "HMGR0170", objectArray);
            }
            return;
        }
        if (n == 1) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "updateProxyPost.REPLACE", new Object[]{this.ivPost, bulletinBoardPost});
            }
            if (bulletinBoardPost == null) {
                if (bl) {
                    Object[] objectArray = new Object[]{"ProxyPost", "REPLACE", "key"};
                    Tr.error(TC, "HMGR0170", objectArray);
                }
                set2.add(this.ivPost.getOriginalServer());
                return;
            }
            if (bulletinBoardPost.getVersion() == -1L) {
                Object[] objectArray = new Object[]{"ProxyPost", "REPLACE", "closed post"};
                Tr.error(TC, "HMGR0170", objectArray);
                return;
            }
            this.processUpdate(bulletinBoardPost, arrayList, set, set2, set3, true);
            return;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "updateProxyPost.MERGE", new Object[]{this.ivPost, bulletinBoardPost, new Boolean(bl)});
        }
        if (bulletinBoardPost == null) {
            if (bl) {
                set2.add(this.ivPost.getOriginalServer());
            } else {
                arrayList.add(this);
            }
            return;
        }
        if (bulletinBoardPost.getVersion() == -1L) {
            set2.add(this.ivPost.getOriginalServer());
            return;
        }
        this.processUpdate(bulletinBoardPost, arrayList, set, set2, set3, false);
    }

    public void updateLocalPost(ArrayList arrayList, Map map, Set set, Set set2, Set set3, int n) {
        boolean bl = map.containsKey(this.ivPost.getOriginalServer());
        BulletinBoardPost bulletinBoardPost = (BulletinBoardPost)map.remove(this.ivPost.getOriginalServer());
        if (n == 0) {
            Object[] objectArray;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "updateLocalPost.NODATA", new Object[]{this.ivPost, bulletinBoardPost});
            }
            arrayList.add(this);
            if (bulletinBoardPost != null) {
                objectArray = new Object[]{"LocalPost", "NODATA", "post"};
                Tr.error(TC, "HMGR0170", objectArray);
            }
            if (bl) {
                objectArray = new Object[]{"LocalPost", "NODATA", "key"};
                Tr.error(TC, "HMGR0170", objectArray);
            }
            return;
        }
        if (n == 1) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "updateLocalPost.REPLACE", new Object[]{this.ivPost, bulletinBoardPost});
            }
            if (bulletinBoardPost == null) {
                if (bl) {
                    Object[] objectArray = new Object[]{"LocalPost", "REPLACE", "key"};
                    Tr.error(TC, "HMGR0170", objectArray);
                }
                set2.add(this.ivPost.getOriginalServer());
                return;
            }
            if (bulletinBoardPost.getVersion() == -1L) {
                Object[] objectArray = new Object[]{"LocalPost", "REPLACE", "closed post"};
                Tr.error(TC, "HMGR0170", objectArray);
                return;
            }
            this.processUpdate(bulletinBoardPost, arrayList, set, set2, set3, true);
            return;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "updateLocalPost.MERGE", new Object[]{this.ivPost, bulletinBoardPost, new Boolean(bl)});
        }
        if (bulletinBoardPost == null) {
            if (bl) {
                set2.add(this.ivPost.getOriginalServer());
            } else {
                arrayList.add(this);
            }
            return;
        }
        if (bulletinBoardPost.getVersion() == -1L) {
            set2.add(this.ivPost.getOriginalServer());
            return;
        }
        this.processUpdate(bulletinBoardPost, arrayList, set, set2, set3, false);
    }

    private void processUpdate(BulletinBoardPost bulletinBoardPost, ArrayList arrayList, Set set, Set set2, Set set3, boolean bl) {
        int n = set.size() + set2.size() + set3.size();
        int n2 = arrayList.size();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "processUpdate", new Object[]{this.ivPost, bulletinBoardPost, new Boolean(bl)});
        }
        long l = this.ivPost.getVersion();
        long l2 = bulletinBoardPost.getVersion();
        if (bl) {
            if (l == l2) {
                arrayList.add(this);
            } else {
                this.processUpdateWithVersionChange(set, arrayList, set3, bulletinBoardPost);
            }
        } else if (l2 == -1L) {
            set2.add(this.getServerName());
        } else {
            this.processUpdateWithVersionChange(set, arrayList, set3, bulletinBoardPost);
        }
        int n3 = set.size() + set2.size() + set3.size();
        int n4 = arrayList.size();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "processUpdate: Delta's for changedState and completeState sizes", new Object[]{bulletinBoardPost, new Integer(n3 - n), new Integer(n4 - n2)});
        }
    }
}

