/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.corestack;

import com.ibm.ws.hamanager.coordinator.corestack.CoreStackTransportType;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.corestack.CoreStackInfo;
import com.ibm.wsspi.hamanager.quorum.ServerPowerController;
import java.util.HashMap;
import java.util.Map;

public class CoreStackInfoImpl
implements CoreStackInfo {
    private CoreStackTransportType ivTransportType = CoreStackTransportType.CHANNEL_FW;
    private String ivCoreGroupName;
    private String ivServerName;
    private ChannelFrameworkService ivChfw;
    private String ivChainName;
    private int ivNumCoordinators = 1;
    private String[] ivPreferredServers = new String[0];
    private int ivMessageCacheFrequencyMillis = 500;
    private int ivIsAliveTimeSecs = 120;
    private int ivTransportBufferSize = 10;
    private int ivMaxTransportMemorySize = 20;
    private int ivSocketBufferSize = 2;
    private int ivDataStackMemorySize = 50;
    private boolean ivUsePooledMemory = true;
    private int ivDCSThreads = 4;
    private int ivFDTransmissionMillis = 30000;
    private int ivFDConsecutiveMissed = 6;
    private int ivMessageSize = 4096;
    private int ivMemberBringupTimeSecs = 15;
    private int ivCompletenessVsSpeed = 1;
    private int ivDiscoveryTimeSecs = 60;
    private int ivFwDiscoveryTimeSecs = 30;
    private Map ivSSLProps;
    private String ivSecret = null;
    private int ivSecretMaxSize = 4096;
    private boolean ivSecureToken = true;
    private int ivIPRefreshPeriod = 60;
    private boolean ivTransportDiagnostics = false;
    private Map ivProtocolVersions = new HashMap();
    private boolean ivEnableDCSConfigChecks;
    private String ivGroupRangeStart;
    private String ivGroupRangeEnd;
    private int ivMultiCastPort;
    private int ivMulticastTTL = 1;
    private ServerPowerController ivServerPowerController;

    public CoreStackInfoImpl() {
        this.ivProtocolVersions.put("DCS_PROTOCOL", "6.0.0");
        this.ivProtocolVersions.put("HAM_PROTOCOL", "6.0.0");
        this.ivEnableDCSConfigChecks = true;
    }

    public void setName(String string) {
        this.ivCoreGroupName = string;
        if (this.ivSecret == null) {
            this.ivSecret = string;
        }
    }

    public String getName() {
        return this.ivCoreGroupName;
    }

    public void setServerName(String string) {
        this.ivServerName = string;
    }

    public String getServerName() {
        return this.ivServerName;
    }

    public void setChannelFramework(ChannelFrameworkService channelFrameworkService) throws HAParameterRejectedException {
        if (channelFrameworkService == null) {
            throw new HAParameterRejectedException("Null ChannelFrameworkService is not allowed");
        }
        this.ivChfw = channelFrameworkService;
    }

    public ChannelFrameworkService getChannelFramework() {
        return this.ivChfw;
    }

    public void setChannelChainName(String string) throws HAParameterRejectedException {
        if (string == null || string.length() == 0) {
            throw new HAParameterRejectedException("A null or empty chain name is not allowed");
        }
        this.ivChainName = string;
    }

    public String getChannelChainName() {
        return this.ivChainName;
    }

    public void setNumCoordinators(int n) throws HAParameterRejectedException {
        if (n < 1) {
            throw new HAParameterRejectedException("Number of coordinators " + n + " is out of range");
        }
        this.ivNumCoordinators = n;
    }

    public int getNumCoordinators() {
        return this.ivNumCoordinators;
    }

    public void setPreferredCoordinators(String[] stringArray) throws HAParameterRejectedException {
        if (stringArray == null) {
            throw new HAParameterRejectedException("Null preferred coordinator servers is not allowed");
        }
        this.ivPreferredServers = stringArray;
    }

    public String[] getPreferredCoordinators() {
        return this.ivPreferredServers;
    }

    public void setTransportBufferSize(int n) throws HAParameterRejectedException {
        if (n < 10) {
            throw new HAParameterRejectedException("Transport Buffer size " + n + " is out of range");
        }
        this.ivTransportBufferSize = n;
        if (this.ivMaxTransportMemorySize < this.ivTransportBufferSize) {
            this.ivMaxTransportMemorySize = this.ivTransportBufferSize;
        }
    }

    public int getTransportBufferSize() {
        return this.ivTransportBufferSize;
    }

    public void setMaximumTransportMemorySize(int n) throws HAParameterRejectedException {
        if (n < this.ivTransportBufferSize) {
            throw new HAParameterRejectedException("Maximum Transport Memory size must not be less than buffer size");
        }
        this.ivMaxTransportMemorySize = n;
    }

    public int getMaximumTransportMemorySize() {
        return this.ivMaxTransportMemorySize;
    }

    public void setSocketBufferSize(int n) throws HAParameterRejectedException {
        if (n < 0 || n > 3) {
            throw new HAParameterRejectedException("SocketBufferSize " + n + " is out of range");
        }
        this.ivSocketBufferSize = n;
    }

    public int getSocketBufferSize() {
        return this.ivSocketBufferSize;
    }

    public void setCachedUpdateFrequency(int n) throws HAParameterRejectedException {
        if (n < 250 || n > 30000) {
            throw new HAParameterRejectedException("Cached update frequency " + n + " is out of range");
        }
        this.ivMessageCacheFrequencyMillis = n;
    }

    public int getCachedUpdateFrequency() {
        return this.ivMessageCacheFrequencyMillis;
    }

    public void setIsAliveTime(int n) throws HAParameterRejectedException {
        this.ivIsAliveTimeSecs = n;
    }

    public int getIsAliveTime() {
        return this.ivIsAliveTimeSecs;
    }

    public void setDataStackMemory(int n) throws HAParameterRejectedException {
        if (n < 1 || n > 256) {
            throw new HAParameterRejectedException("Data Stack Memory " + n + " is out of range");
        }
        this.ivDataStackMemorySize = n;
    }

    public int getDataStackMemory() {
        return this.ivDataStackMemorySize;
    }

    public void setNumberOfThreads(int n) throws HAParameterRejectedException {
        if (n < 4) {
            throw new HAParameterRejectedException("Number of threads " + n + " is out of range");
        }
        this.ivDCSThreads = n;
    }

    public int getNumberOfThreads() {
        return this.ivDCSThreads;
    }

    public void setFailureDetectorTransmissionInterval(int n) throws HAParameterRejectedException {
        if (n < 0) {
            throw new HAParameterRejectedException("Failure detection transmission " + n + " is out of range");
        }
        this.ivFDTransmissionMillis = n;
    }

    public int getFailureDetectorTransmissionInterval() {
        return this.ivFDTransmissionMillis;
    }

    public void setFailureDetectorTimeout(int n) throws HAParameterRejectedException {
        if (n < 1) {
            throw new HAParameterRejectedException("Failure detection timeout " + n + " is out of range");
        }
        this.ivFDConsecutiveMissed = n;
    }

    public int getFailureDetectorTimeout() {
        return this.ivFDConsecutiveMissed;
    }

    public void setUsePooledMemory(boolean bl) throws HAParameterRejectedException {
        this.ivUsePooledMemory = bl;
    }

    public boolean getUsePooledMemory() {
        return this.ivUsePooledMemory;
    }

    public void setExpectedMessageSize(int n) throws HAParameterRejectedException {
        if (n < 1024) {
            throw new HAParameterRejectedException("Expected message size " + n + " is out of range");
        }
        this.ivMessageSize = n;
    }

    public int getExpectedMessageSize() {
        return this.ivMessageSize;
    }

    public void setMemberBringupTimeSecs(int n) throws HAParameterRejectedException {
        if (n < 1) {
            throw new HAParameterRejectedException("Member bringup time " + n + " is out of range");
        }
        this.ivMemberBringupTimeSecs = n;
    }

    public int getMemberBringupTimeSecs() {
        return this.ivMemberBringupTimeSecs;
    }

    public void setCompletenessVsSpeed(int n) throws HAParameterRejectedException {
        if (n < 1 || n > 5) {
            throw new HAParameterRejectedException("Completeness vs speed " + n + " is out of range");
        }
        this.ivCompletenessVsSpeed = n;
    }

    public int getCompletenessVsSpeed() {
        return this.ivCompletenessVsSpeed;
    }

    public void setDiscoveryIntervalSecs(int n) throws HAParameterRejectedException {
        if (n < 1) {
            throw new HAParameterRejectedException("Discovery interval " + n + " is out of range");
        }
        this.ivDiscoveryTimeSecs = n;
    }

    public int getDiscoveryIntervalSecs() {
        return this.ivDiscoveryTimeSecs;
    }

    public void setFirewallDiscoveryIntervalSecs(int n) throws HAParameterRejectedException {
        if (n < 1) {
            throw new HAParameterRejectedException("Firewall discovery interval " + n + " is out of range");
        }
        this.ivFwDiscoveryTimeSecs = n;
    }

    public int getFirewallDiscoveryIntervalSecs() {
        return this.ivFwDiscoveryTimeSecs;
    }

    public void setSSLProperties(Map map) throws HAParameterRejectedException {
        if (map == null) {
            throw new HAParameterRejectedException("Null SSL Properties map is not allowed");
        }
        this.ivSSLProps = map;
    }

    public Map getSSLProperties() {
        return this.ivSSLProps;
    }

    public void setSharedSecret(String string) throws HAParameterRejectedException {
        if (string == null || string.length() == 0) {
            throw new HAParameterRejectedException("Null or empty SharedSecret not allowed");
        }
        this.ivSecret = string;
    }

    public String getSharedSecret() {
        return this.ivSecret;
    }

    public void setSharedSecretTokenSize(int n) throws HAParameterRejectedException {
        if (n < 1024) {
            throw new HAParameterRejectedException("Shared secret size is too small");
        }
        this.ivSecretMaxSize = n;
    }

    public int getSharedSecretTokenSize() {
        return this.ivSecretMaxSize;
    }

    public void setUseSecureConnections(boolean bl) {
        this.ivSecureToken = bl;
    }

    public boolean getUseSecureConnections() {
        return this.ivSecureToken;
    }

    public void setIPCacheRefreshInterval(int n) throws HAParameterRejectedException {
        if (n < 1) {
            throw new HAParameterRejectedException("IP Cache refresh interval is out of range");
        }
        this.ivIPRefreshPeriod = n;
    }

    public int getIPCacheRefreshInterval() {
        return this.ivIPRefreshPeriod;
    }

    public void setEnableTransportDiagnostics(boolean bl) {
        this.ivTransportDiagnostics = bl;
    }

    public boolean getEnableTransportDiagnostics() {
        return this.ivTransportDiagnostics;
    }

    public void setProtocolVersions(Map map) {
        this.ivProtocolVersions = map;
    }

    public Map getProtocolVersions() {
        return this.ivProtocolVersions;
    }

    public void setEnableCoreStackConfigChecks(boolean bl) {
        this.ivEnableDCSConfigChecks = bl;
    }

    public boolean getEnableCoreStackConfigChecks() {
        return this.ivEnableDCSConfigChecks;
    }

    public ServerPowerController getServerPowerController() {
        return this.ivServerPowerController;
    }

    public void setTransportType(CoreStackTransportType coreStackTransportType) {
        this.ivTransportType = coreStackTransportType;
    }

    public CoreStackTransportType getTransportType() {
        return this.ivTransportType;
    }

    public void setServerPowerController(ServerPowerController serverPowerController) {
        this.ivServerPowerController = serverPowerController;
    }

    public void setMulticastAttributes(String string, String string2, int n) {
        this.ivGroupRangeStart = string;
        this.ivGroupRangeEnd = string2;
        this.ivMultiCastPort = n;
    }

    public String getMulticastGroupRangeStart() {
        return this.ivGroupRangeStart;
    }

    public String getMultiCastGroupRangeEnd() {
        return this.ivGroupRangeEnd;
    }

    public int getMultiCastPort() {
        return this.ivMultiCastPort;
    }

    public void setMulticastTTL(int n) throws HAParameterRejectedException {
        if (n < 1) {
            throw new HAParameterRejectedException("value " + n + " is invalid");
        }
        this.ivMulticastTTL = n;
    }

    public int getMultiCastTTL() {
        return this.ivMulticastTTL;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Transport Type ");
        stringBuffer.append(this.ivTransportType);
        stringBuffer.append(", Number of Coordinators ");
        stringBuffer.append(this.ivNumCoordinators);
        stringBuffer.append(", Preferred Coordinator Servers ");
        stringBuffer.append(this.ivPreferredServers);
        stringBuffer.append(", Cache Setting ");
        stringBuffer.append(this.ivMessageCacheFrequencyMillis);
        stringBuffer.append(", IsAlive time ");
        stringBuffer.append(this.ivIsAliveTimeSecs);
        stringBuffer.append(", Transport buffer size ");
        stringBuffer.append(this.ivTransportBufferSize);
        stringBuffer.append(", Max transport buffer size ");
        stringBuffer.append(this.ivMaxTransportMemorySize);
        stringBuffer.append(", Socket buffer setting ");
        stringBuffer.append(this.ivSocketBufferSize);
        stringBuffer.append(", Data Stack Size ");
        stringBuffer.append(this.ivDataStackMemorySize);
        stringBuffer.append(", Use Pooled memory ");
        stringBuffer.append(this.ivUsePooledMemory);
        stringBuffer.append(", DCS threads ");
        stringBuffer.append(this.ivDCSThreads);
        stringBuffer.append(", Failure Detector period ");
        stringBuffer.append(this.ivFDTransmissionMillis);
        stringBuffer.append(", Failure Detector missed ");
        stringBuffer.append(this.ivFDConsecutiveMissed);
        stringBuffer.append(", Message size ");
        stringBuffer.append(this.ivMessageSize);
        stringBuffer.append(", Member bringup time ");
        stringBuffer.append(this.ivMemberBringupTimeSecs);
        stringBuffer.append(", Completeness vs Speed ");
        stringBuffer.append(this.ivCompletenessVsSpeed);
        stringBuffer.append(", Discovery period ");
        stringBuffer.append(this.ivDiscoveryTimeSecs);
        stringBuffer.append(", Firewall discovery period ");
        stringBuffer.append(this.ivFwDiscoveryTimeSecs);
        stringBuffer.append(", Token ");
        stringBuffer.append(this.ivSecret);
        stringBuffer.append(", Max token size ");
        stringBuffer.append(this.ivSecretMaxSize);
        stringBuffer.append(", Use secure token ");
        stringBuffer.append(this.ivSecureToken);
        stringBuffer.append(", IP Refresh Period ");
        stringBuffer.append(this.ivIPRefreshPeriod);
        stringBuffer.append(", Transport Diagnostics Enabled ");
        stringBuffer.append(this.ivTransportDiagnostics);
        stringBuffer.append(", Multicast TTL ");
        stringBuffer.append(this.ivMulticastTTL);
        stringBuffer.append(", DCSProtocol Version ");
        stringBuffer.append(this.ivProtocolVersions.get("DCS_PROTOCOL"));
        stringBuffer.append(", HAMProtocol Version ");
        stringBuffer.append(this.ivProtocolVersions.get("HAM_PROTOCOL"));
        return stringBuffer.toString();
    }
}

