/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.dcs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.AddressResolver;
import com.ibm.ws.dcs.common.MemberAddress;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.hamanager.Version;
import com.ibm.ws.hamanager.coordinator.dcs.DefinedSetUpdate;
import com.ibm.ws.hamanager.coordinator.dcs.HostNameMap;
import com.ibm.ws.hamanager.coordinator.dcs.HostNameMapManager;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.corestack.CoreStackInfo;
import com.ibm.wsspi.hamanager.corestack.CoreStackMemberInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CoreStackMembershipManager
implements AddressResolver {
    private static String svClassName = CoreStackMembershipManager.class.getName();
    private static final TraceComponent TC = Tr.register(CoreStackMembershipManager.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private String ivLocalMemberName;
    private boolean ivLocalMemberBindsAll = false;
    private Map ivCoreStackMembers = new HashMap();
    private Map ivMembers = new HashMap();
    private HostNameMapManager ivHostNameManager;
    private Version ivProtocolVersion;
    private Set ivConflictingMembers;

    public CoreStackMembershipManager(CoreStackInfo coreStackInfo, CoreStackMemberInfo[] coreStackMemberInfoArray, Version version) throws HAException {
        this.ivLocalMemberName = coreStackInfo.getServerName();
        this.ivHostNameManager = new HostNameMapManager(coreStackInfo.getIPCacheRefreshInterval(), this);
        this.ivProtocolVersion = version;
        int n = coreStackMemberInfoArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            CoreStackMemberInfo coreStackMemberInfo = coreStackMemberInfoArray[i];
            String string = coreStackMemberInfo.getServerName();
            this.createMemberMapping(coreStackMemberInfo);
            if (!string.equals(this.ivLocalMemberName)) continue;
            bl = true;
            String string2 = coreStackMemberInfo.getLocalInterface();
            if (!string2.equals("*")) continue;
            this.ivLocalMemberBindsAll = true;
        }
        if (!bl) {
            Tr.error(TC, "HMGR0002");
            throw new HAException("Local Member " + this.ivLocalMemberName + " is not a member of the core group");
        }
        this.ivConflictingMembers = new HashSet();
        this.updateDuplicateMappings(true);
    }

    public synchronized Map getDefinedSet() throws HAException {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        Set set = this.ivCoreStackMembers.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            CoreStackMemberInfo coreStackMemberInfo = (CoreStackMemberInfo)entry.getValue();
            Member member = (Member)this.ivMembers.get(string);
            if (member == null) {
                throw new HAInternalStateException("Unable to find Member mapping for member " + string);
            }
            Properties properties = this.getMemberAsProperties(member, coreStackMemberInfo.getPassiveDiscovery());
            hashMap.put(string, properties);
        }
        if (hashMap.size() == 0) {
            throw new HAInternalStateException("No valid members in defined set");
        }
        return hashMap;
    }

    public synchronized DefinedSetUpdate updateCoreStackMembership(CoreStackMemberInfo[] coreStackMemberInfoArray, boolean bl) throws DataStackException {
        try {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "updateCoreStackMembership", new Boolean(bl));
            }
            String[] stringArray = this.computeMembersToRemove(coreStackMemberInfoArray);
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "updateCoreStackMembership - removing", stringArray);
            }
            CoreStackMemberInfo[] coreStackMemberInfoArray2 = this.computeMembersToAdd(coreStackMemberInfoArray);
            Map map = null;
            if (coreStackMemberInfoArray2 != null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateCoreStackMembership - adding", coreStackMemberInfoArray2);
                }
                if (bl) {
                    map = this.convertHAMMembersToDCSProperties(coreStackMemberInfoArray2);
                }
            }
            this.updateInconsistentMembers(coreStackMemberInfoArray);
            this.updateDuplicateMappings(true);
            return new DefinedSetUpdate(map, stringArray);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "214", this);
            throw new DataStackException("Failure updating membership list", throwable);
        }
    }

    public synchronized Map addDefined(CoreStackMemberInfo coreStackMemberInfo, boolean bl) throws DataStackException {
        try {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "addDefined", coreStackMemberInfo);
            }
            this.createMemberMapping(coreStackMemberInfo);
            this.updateDuplicateMappings(false);
            if (!bl) {
                return null;
            }
            CoreStackMemberInfo[] coreStackMemberInfoArray = new CoreStackMemberInfo[]{coreStackMemberInfo};
            return this.convertHAMMembersToDCSProperties(coreStackMemberInfoArray);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "250", this);
            throw new DataStackException("addDefined", throwable);
        }
    }

    public synchronized String[] removeDefined(String string, boolean bl) throws DataStackException {
        try {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "removeDefined", string);
            }
            this.removeMemberMapping(string);
            this.updateDuplicateMappings(false);
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        catch (HAException hAException) {
            FFDCFilter.processException((Throwable)hAException, svClassName, "285", this);
            throw new DataStackException("removeDefined", hAException);
        }
    }

    public synchronized MemberAddress getAddress(String string) {
        Member member = (Member)this.ivMembers.get(string);
        if (member == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "getAddress - memberName not found. returning null", string);
            }
            return null;
        }
        MemberInfo memberInfo = this.ivLocalMemberName.equals(string) ? member.getInitialMapping() : member.getNextMapping();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getAddress", new Object[]{string, memberInfo});
        }
        return memberInfo;
    }

    public synchronized int getLocalBindingOption() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getLocalBindingOption", new Boolean(this.ivLocalMemberBindsAll));
        }
        if (this.ivLocalMemberBindsAll) {
            if (this.ivProtocolVersion.getDCSProtocolVersion() < 10) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    public synchronized boolean isPassiveDiscovery(String string) {
        CoreStackMemberInfo coreStackMemberInfo = (CoreStackMemberInfo)this.ivCoreStackMembers.get(string);
        if (coreStackMemberInfo == null) {
            return false;
        }
        return coreStackMemberInfo.getPassiveDiscovery();
    }

    public synchronized Set getCoreGroupMembers() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.ivCoreStackMembers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashSet.add(string);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public synchronized boolean isIpPortConflicting(String string) {
        return this.ivConflictingMembers.contains(string);
    }

    synchronized void updateDuplicateMappings(boolean bl) {
        this.ivConflictingMembers.clear();
        HashMap hashMap = this.getIpPortMemberMapping();
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            if (list.size() <= 1) continue;
            this.ivConflictingMembers.addAll(list);
            if (!bl) continue;
            Tr.error(TC, "HMGR0031", new Object[]{list.toString(), string});
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "updateDuplicateMappings", new Object[]{this.ivConflictingMembers.toString()});
        }
    }

    private HashMap getIpPortMemberMapping() {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        Iterator iterator = this.ivMembers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Member member = (Member)entry.getValue();
            String[] stringArray = member.ivHostIps.getAllIPs();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = this.getIpPortMapping(stringArray[i], member.ivPort);
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(string);
            }
        }
        return hashMap;
    }

    private void createMemberMapping(CoreStackMemberInfo coreStackMemberInfo) throws HAException {
        String string = coreStackMemberInfo.getServerName();
        Object v = this.ivMembers.get(string);
        if (v != null) {
            throw new HAInternalStateException("Member mapping for member " + string + " already exists");
        }
        v = this.ivCoreStackMembers.get(string);
        if (v != null) {
            throw new HAInternalStateException("CoreStackMember mapping for member " + string + " already exists");
        }
        String string2 = coreStackMemberInfo.getIPIdentifier();
        HostNameMap hostNameMap = this.ivHostNameManager.getHostNameMap(string2, string);
        int n = coreStackMemberInfo.getPort();
        Member member = new Member(string, string2, n, hostNameMap);
        this.ivMembers.put(string, member);
        this.ivCoreStackMembers.put(string, coreStackMemberInfo);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "createMemberMapping", member);
        }
    }

    private void removeMemberMapping(String string) throws HAInternalStateException {
        Object v = this.ivMembers.get(string);
        if (v == null) {
            throw new HAInternalStateException("Member mapping for member " + string + " does not exist");
        }
        v = this.ivCoreStackMembers.get(string);
        if (v == null) {
            throw new HAInternalStateException("CoreStackMember mapping for member " + string + " does not exist");
        }
        Member member = (Member)this.ivMembers.remove(string);
        CoreStackMemberInfo coreStackMemberInfo = (CoreStackMemberInfo)this.ivCoreStackMembers.remove(string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeMemberMapping", new Object[]{string, member, coreStackMemberInfo});
        }
    }

    private CoreStackMemberInfo[] computeMembersToAdd(CoreStackMemberInfo[] coreStackMemberInfoArray) throws HAException {
        ArrayList<CoreStackMemberInfo> arrayList = new ArrayList<CoreStackMemberInfo>();
        int n = coreStackMemberInfoArray.length;
        for (int i = 0; i < n; ++i) {
            String string = coreStackMemberInfoArray[i].getServerName();
            CoreStackMemberInfo coreStackMemberInfo = (CoreStackMemberInfo)this.ivCoreStackMembers.get(string);
            if (coreStackMemberInfo != null) continue;
            this.createMemberMapping(coreStackMemberInfoArray[i]);
            arrayList.add(coreStackMemberInfoArray[i]);
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        CoreStackMemberInfo[] coreStackMemberInfoArray2 = new CoreStackMemberInfo[n];
        coreStackMemberInfoArray2 = arrayList.toArray(coreStackMemberInfoArray2);
        return coreStackMemberInfoArray2;
    }

    private String[] computeMembersToRemove(CoreStackMemberInfo[] coreStackMemberInfoArray) throws HAInternalStateException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.ivCoreStackMembers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.memberIsInList(coreStackMemberInfoArray, string)) continue;
            arrayList.add(string);
            if (!TC.isDebugEnabled()) continue;
            Tr.debug(TC, "compute removed core stack members", string);
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            this.removeMemberMapping(string);
            stringArray[i] = string;
        }
        return stringArray;
    }

    private void updateInconsistentMembers(CoreStackMemberInfo[] coreStackMemberInfoArray) throws HAException {
        int n = coreStackMemberInfoArray.length;
        for (int i = 0; i < n; ++i) {
            CoreStackMemberInfo coreStackMemberInfo = coreStackMemberInfoArray[i];
            String string = coreStackMemberInfo.getServerName();
            CoreStackMemberInfo coreStackMemberInfo2 = (CoreStackMemberInfo)this.ivCoreStackMembers.get(string);
            if (coreStackMemberInfo2 == null) {
                Tr.debug(TC, "updateInconsistentMembers - found no entry for member", string);
                continue;
            }
            if (coreStackMemberInfo2.equals(coreStackMemberInfo)) continue;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "updateInconsistentMembers", string);
            }
            this.removeMemberMapping(string);
            this.createMemberMapping(coreStackMemberInfo);
        }
    }

    private Map convertHAMMembersToDCSProperties(CoreStackMemberInfo[] coreStackMemberInfoArray) throws HAException {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        int n = coreStackMemberInfoArray.length;
        for (int i = 0; i < n; ++i) {
            CoreStackMemberInfo coreStackMemberInfo = coreStackMemberInfoArray[i];
            String string = coreStackMemberInfo.getServerName();
            if (string.equals(this.ivLocalMemberName)) {
                throw new HAInternalStateException("Attempting to re-add the local member to the defined set");
            }
            Member member = (Member)this.ivMembers.get(string);
            if (member == null) {
                throw new HAInternalStateException("Member mapping not found for member " + string);
            }
            Properties properties = this.getMemberAsProperties(member, coreStackMemberInfo.getPassiveDiscovery());
            hashMap.put(string, properties);
            if (!TC.isDebugEnabled()) continue;
            Tr.debug(TC, "convertHAMMembersToDCSProperties", string);
        }
        return hashMap;
    }

    private Properties getMemberAsProperties(Member member, boolean bl) {
        MemberInfo memberInfo = member.getInitialMapping();
        String string = memberInfo.getIp();
        String string2 = new Integer(memberInfo.getPort()).toString();
        Properties properties = new Properties();
        properties.setProperty("IpAddress", string);
        properties.setProperty("Port", string2);
        if (bl) {
            properties.setProperty("DiscoveryPassive", "true");
        } else {
            properties.setProperty("DiscoveryPassive", "false");
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{member.ivMemberName, string, string2, new Boolean(bl)};
            Tr.debug(TC, "getMemberAsProperties", objectArray);
        }
        return properties;
    }

    private boolean memberIsInList(CoreStackMemberInfo[] coreStackMemberInfoArray, String string) {
        int n = coreStackMemberInfoArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = coreStackMemberInfoArray[i].getServerName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private String getIpPortMapping(String string, int n) {
        return string + "::" + n;
    }

    private class MemberInfo
    implements MemberAddress {
        String ivIP;
        int ivPort;

        MemberInfo(String string, int n) {
            this.ivIP = string;
            this.ivPort = n;
        }

        public String getIp() {
            return this.ivIP;
        }

        public int getPort() {
            return this.ivPort;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("MemberInfo: IP ");
            stringBuffer.append(this.ivIP);
            stringBuffer.append(", port ");
            stringBuffer.append(this.ivPort);
            return stringBuffer.toString();
        }
    }

    private class Member {
        private String ivMemberName;
        private String ivHostName;
        private int ivPort;
        private HostNameMap ivHostIps;
        private int ivNextIpIndex;
        private MemberInfo ivInitialMemberInfo;

        Member(String string, String string2, int n, HostNameMap hostNameMap) {
            this.ivMemberName = string;
            this.ivHostName = string2;
            this.ivPort = n;
            this.ivHostIps = hostNameMap;
            this.ivNextIpIndex = 0;
        }

        MemberInfo getNextMapping() {
            int n = this.ivHostIps.getNumberOfMappings();
            if (this.ivNextIpIndex >= n) {
                this.ivNextIpIndex = 0;
            }
            String string = this.ivHostIps.getMapping(this.ivNextIpIndex++);
            return new MemberInfo(string, this.ivPort);
        }

        synchronized MemberInfo getInitialMapping() {
            if (this.ivInitialMemberInfo == null) {
                String string = this.ivHostIps.getMapping(0);
                this.ivInitialMemberInfo = new MemberInfo(string, this.ivPort);
            }
            return this.ivInitialMemberInfo;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Member ");
            stringBuffer.append(this.ivMemberName);
            stringBuffer.append(", host name ");
            stringBuffer.append(this.ivHostName);
            stringBuffer.append(", port ");
            stringBuffer.append(this.ivPort);
            stringBuffer.append(", Initial Member");
            stringBuffer.append(this.ivInitialMemberInfo);
            stringBuffer.append(", ");
            stringBuffer.append(this.ivHostIps);
            return stringBuffer.toString();
        }
    }
}

