/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.dcs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.DCS;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackInfoImpl;
import com.ibm.ws.hamanager.coordinator.impl.DCSPlugin;
import com.ibm.ws.hamanager.datastack.DataStack;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.datastack.DataStackImpl;
import com.ibm.ws.hamanager.datastack.SyncDataReqCallback;
import com.ibm.ws.hamanager.datastack.SyncDataStackImpl;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.datastack.DataStackAlreadyCreatedException;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataStackManager {
    private static final TraceComponent TC = Tr.register(DataStackManager.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private Map ivDataStacks = new HashMap();

    public synchronized DataStack createDataStack(String string, DCS dCS, DCSPlugin dCSPlugin, boolean bl, HAGroupImpl hAGroupImpl, CoreStackInfoImpl coreStackInfoImpl, Map map, DataStackCallback dataStackCallback, SyncDataReqCallback syncDataReqCallback, String[] stringArray) throws DataStackException {
        DataStack dataStack = (DataStack)this.ivDataStacks.get(string);
        if (dataStack != null) {
            throw new DataStackAlreadyCreatedException("A data stack with name " + string + " already exists");
        }
        dataStack = syncDataReqCallback == null ? new DataStackImpl(dCS, dCSPlugin, string, "BASE", bl, hAGroupImpl, coreStackInfoImpl, map, stringArray, dataStackCallback) : new SyncDataStackImpl(dCS, dCSPlugin, string, "SYNC", bl, hAGroupImpl, coreStackInfoImpl, map, stringArray, dataStackCallback, syncDataReqCallback);
        this.ivDataStacks.put(string, dataStack);
        return dataStack;
    }

    public synchronized void removeDataStack(String string) {
        this.ivDataStacks.remove(string);
    }

    public synchronized void setDataStackProtocolVersion(int n, StateVersion stateVersion) throws DataStackException {
    }

    public synchronized void removeDataStackMembers(String[] stringArray) throws DCSException, HAInternalStateException {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "removeDataStackMembers", stringArray);
        }
        Iterator iterator = this.ivDataStacks.values().iterator();
        while (iterator.hasNext()) {
            DataStackImpl dataStackImpl = (DataStackImpl)iterator.next();
            dataStackImpl.removeMembers(stringArray);
        }
    }
}

