/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.dcs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.HARuntimeException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

class HostNameMap {
    private static String svClassName = HostNameMap.class.getName();
    private static final TraceComponent TC = Tr.register(HostNameMap.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private String ivHostName;
    private String[] ivIps;

    HostNameMap(String string, Map map, Set set) throws HAException {
        this.ivHostName = string;
        InetAddress[] inetAddressArray = null;
        try {
            inetAddressArray = this.getInetAddresses();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, svClassName, "416", this);
            Tr.error(TC, "HMGR0024", new Object[]{string, unknownHostException});
            throw new HAException("Host name " + string + " is not registered in DNS", unknownHostException);
        }
        this.ivIps = this.filterInetAddresses(inetAddressArray, false);
        if (this.ivIps != null) {
            this.detectDuplicateAddresses(this.ivIps, map, set);
        } else {
            this.ivIps = this.filterInetAddresses(inetAddressArray, true);
            if (this.ivIps == null) {
                throw new HAInternalStateException("No InetAddresses found for host name " + this.ivHostName);
            }
            Tr.warning(TC, "HMGR0064", string);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "HostNameMapping created for host " + this.ivHostName, this.ivIps);
        }
    }

    public String getHostName() {
        return this.ivHostName;
    }

    public synchronized int getNumberOfMappings() {
        return this.ivIps.length;
    }

    public synchronized String getMapping(int n) {
        int n2 = this.ivIps.length;
        if (n < n2) {
            return this.ivIps[n];
        }
        return this.ivIps[n %= n2];
    }

    synchronized void updateAddresses(Map map, Set set) {
        try {
            InetAddress[] inetAddressArray = this.getInetAddresses();
            String[] stringArray = this.filterInetAddresses(inetAddressArray, false);
            if (stringArray == null) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "updateAddresses - no non-loopback mappings in DNS");
                }
                return;
            }
            this.detectDuplicateAddresses(stringArray, map, set);
            this.ivIps = stringArray;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "930", this);
            Tr.error(TC, "HMGR0024", new Object[]{this.ivHostName, throwable});
        }
    }

    synchronized String[] getAllIPs() {
        String[] stringArray = new String[this.ivIps.length];
        System.arraycopy(this.ivIps, 0, stringArray, 0, this.ivIps.length);
        return stringArray;
    }

    private InetAddress[] getInetAddresses() throws UnknownHostException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(this.ivHostName);
        if (inetAddressArray == null || inetAddressArray.length == 0) {
            throw new HARuntimeException("InetAddress.getAllByName returned invalid data");
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "getInetAddresses - getAllByName returned", inetAddressArray);
        }
        return inetAddressArray;
    }

    private String[] filterInetAddresses(InetAddress[] inetAddressArray, boolean bl) {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        int n = inetAddressArray.length;
        for (int i = 0; i < n; ++i) {
            InetAddress inetAddress = inetAddressArray[i];
            boolean bl2 = inetAddress.isLoopbackAddress();
            if (bl) {
                if (!bl2) continue;
                arrayList.add(inetAddress);
                continue;
            }
            if (bl2) continue;
            arrayList.add(inetAddress);
        }
        n = arrayList.size();
        if (n == 0) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "filterInetAddresses - no InetAddresses passed the loopback/nonloopback test");
            }
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            InetAddress inetAddress = (InetAddress)arrayList.get(i);
            String string = inetAddress.getHostAddress();
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        n = arrayList2.size();
        String[] stringArray = null;
        if (n > 0) {
            stringArray = new String[n];
            stringArray = arrayList2.toArray(stringArray);
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "filterInetAddresses - resolved IPs", stringArray);
        }
        return stringArray;
    }

    private void detectDuplicateAddresses(String[] stringArray, Map map, Set set) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (set.contains(string)) {
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "detectDuplicateIPs - previously detected duplicate", new Object[]{this.ivHostName, string});
                continue;
            }
            String string2 = map.put(string, this.ivHostName);
            if (string2 == null) continue;
            if (this.hostsAreSame(this.ivHostName, string2)) {
                if (!TC.isDebugEnabled()) continue;
                Tr.debug(TC, "detectDuplicateIPs - same host", new Object[]{this.ivHostName, string2, string});
                continue;
            }
            set.add(string);
            Tr.error(TC, "HMGR0027", new Object[]{string, this.ivHostName, string2});
        }
    }

    private boolean hostsAreSame(String string, String string2) {
        int n;
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "hostsAreSame - checking host names", new Object[]{string, string2});
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        int n2 = string.indexOf(".");
        if (n2 * (n = string2.indexOf(".")) >= 0) {
            return false;
        }
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string.equalsIgnoreCase(string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Host Name ");
        stringBuffer.append(this.ivHostName);
        stringBuffer.append(", IP mappings ");
        for (int i = 0; i < this.ivIps.length; ++i) {
            stringBuffer.append(this.ivIps[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

