/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.dcs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.hamanager.coordinator.dcs.CoreStackMembershipManager;
import com.ibm.ws.hamanager.coordinator.dcs.HostNameMap;
import com.ibm.wsspi.hamanager.HAException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HostNameMapManager {
    private static String svClassName = HostNameMapManager.class.getName();
    private static final TraceComponent TC = Tr.register(HostNameMapManager.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private Map ivHostNameMappings = new HashMap();
    private Map ivIPHostMappings = new HashMap();
    private Set ivDuplicateIPs = new HashSet();
    private IPRefresher ivRefresher;

    HostNameMapManager(int n, CoreStackMembershipManager coreStackMembershipManager) {
        this.ivRefresher = new IPRefresher(n, coreStackMembershipManager);
    }

    synchronized HostNameMap getHostNameMap(String string, String string2) throws HAException {
        HostNameMap hostNameMap = (HostNameMap)this.ivHostNameMappings.get(string);
        if (hostNameMap != null) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "found existing HostNameMap for " + string, hostNameMap);
            }
            return hostNameMap;
        }
        hostNameMap = new HostNameMap(string, this.ivIPHostMappings, this.ivDuplicateIPs);
        this.ivHostNameMappings.put(string, hostNameMap);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "created HostNameMap for " + string, hostNameMap);
        }
        return hostNameMap;
    }

    private final class IPRefresher
    implements AlarmListener {
        private CoreStackMembershipManager ivCsMembershipMgr;
        private int ivRefreshTimeMillis;

        IPRefresher(int n, CoreStackMembershipManager coreStackMembershipManager) {
            this.ivRefreshTimeMillis = n * 60000;
            this.ivCsMembershipMgr = coreStackMembershipManager;
            AlarmManager.createNonDeferrable(this.ivRefreshTimeMillis, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            HostNameMapManager hostNameMapManager = HostNameMapManager.this;
            synchronized (hostNameMapManager) {
                Iterator iterator = HostNameMapManager.this.ivHostNameMappings.values().iterator();
                while (iterator.hasNext()) {
                    HostNameMap hostNameMap = (HostNameMap)iterator.next();
                    hostNameMap.updateAddresses(HostNameMapManager.this.ivIPHostMappings, HostNameMapManager.this.ivDuplicateIPs);
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "IPAddressRefresher - reschedule alarm");
                }
                AlarmManager.createNonDeferrable(this.ivRefreshTimeMillis, this);
            }
            this.ivCsMembershipMgr.updateDuplicateMappings(true);
        }
    }
}

