/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.hamanager.jmx.GroupMemberState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.hamanager.coordinator.MemberData;
import com.ibm.ws.hamanager.coordinator.impl.CoordinatorImpl;
import com.ibm.ws.hamanager.coordinator.impl.GlobalGroupStateManager;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicy;
import com.ibm.ws.hamanager.coordinator.policy.MemberActivationController;
import com.ibm.ws.hamanager.impl.MemberDataImpl;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.NotPossibleAtThisTimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

final class AppGroupState
implements MemberActivationController {
    private static final TraceComponent TC = Tr.register(AppGroupState.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = "AppGroupState";
    private GroupName ivGroupName;
    private final CoordinatorImpl ivCoordinator;
    private GlobalGroupStateManager ivGroupStateManager;
    private GroupPolicy ivPolicy;
    private TreeMap ivMemberMap;
    private boolean ivIsStable;
    private long ivTimeMoveActiveMemberStarted;
    private String ivHintForFutureActiveMember;
    private String ivClusterName;
    private boolean ivGroupDisabled = false;

    AppGroupState(CoordinatorImpl coordinatorImpl, GlobalGroupStateManager globalGroupStateManager, GroupName groupName, GroupPolicy groupPolicy, String string, MemberDataImpl memberDataImpl) {
        this.ivCoordinator = coordinatorImpl;
        this.ivGroupStateManager = globalGroupStateManager;
        this.ivIsStable = true;
        this.ivPolicy = groupPolicy;
        this.ivGroupName = groupName;
        this.ivMemberMap = new TreeMap();
        this.ivMemberMap.put(string, memberDataImpl);
        if (memberDataImpl.getState().equals(GroupMemberState.GROUP_DISABLED)) {
            this.ivGroupDisabled = true;
        }
        this.ivClusterName = (String)groupName.getGroupProperties().get("IBM_hc");
        this.computeStability();
    }

    public void makeMemberActive(GroupMemberId groupMemberId) throws NotPossibleAtThisTimeException {
        String string = groupMemberId.getServerName();
        MemberDataImpl memberDataImpl = (MemberDataImpl)this.ivMemberMap.get(string);
        if (!memberDataImpl.getState().equals(GroupMemberState.IDLE)) {
            Tr.warning(TC, "HMGR0221", new Object[]{"active", groupMemberId, this.ivGroupName});
            throw new NotPossibleAtThisTimeException("member is not IDLE");
        }
        memberDataImpl.setState(GroupMemberState.ACTIVATING);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "makeMemberActive - activate member", memberDataImpl);
        }
        this.ivGroupStateManager.requestMemberStateChange(this.ivGroupName, string, GroupMemberState.ACTIVATING);
    }

    public void makeAnyIdleMemberActive() throws NotPossibleAtThisTimeException, HAInternalStateException {
        String string = null;
        if (this.ivHintForFutureActiveMember != null) {
            string = this.ivHintForFutureActiveMember;
            this.ivHintForFutureActiveMember = null;
            long l = System.currentTimeMillis() - this.ivTimeMoveActiveMemberStarted;
            Tr.info(TC, "HMGR1105", new Object[]{this.ivGroupName.toString(), string, "" + l});
        } else {
            ArrayList arrayList = this.getWLMCandidates(true);
            if (arrayList.size() == 0) {
                Tr.info(TC, "HMGR1108", this.ivGroupName);
                return;
            }
            string = this.ivCoordinator.getWLMProvider().getBestCandidate(true, arrayList);
        }
        if (string == null) {
            throw new NotPossibleAtThisTimeException("WLM Provider did not find any activateable members for group " + this.ivGroupName);
        }
        MemberDataImpl memberDataImpl = (MemberDataImpl)this.ivMemberMap.get(string);
        this.makeMemberActive(memberDataImpl.getMemberId());
    }

    public void makeMemberIdle(GroupMemberId groupMemberId) throws NotPossibleAtThisTimeException {
        String string = groupMemberId.getServerName();
        MemberDataImpl memberDataImpl = (MemberDataImpl)this.ivMemberMap.get(string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "makeMemberIdle - deactivate member", memberDataImpl);
        }
        if (!memberDataImpl.getState().equals(GroupMemberState.ACTIVATED)) {
            Tr.warning(TC, "HMGR0221", new Object[]{"IDLE", groupMemberId, this.ivGroupName});
            throw new NotPossibleAtThisTimeException("member is not ACTIVATED");
        }
        memberDataImpl.setState(GroupMemberState.DEACTIVATING);
        this.ivGroupStateManager.requestMemberStateChange(this.ivGroupName, string, GroupMemberState.DEACTIVATING);
    }

    public void makeAnyActiveMemberIdle() throws NotPossibleAtThisTimeException, HAInternalStateException {
        ArrayList arrayList = this.getWLMCandidates(false);
        if (arrayList.size() == 0) {
            Tr.info(TC, "HMGR1109", this.ivGroupName);
            return;
        }
        String string = this.ivCoordinator.getWLMProvider().getBestCandidate(false, arrayList);
        if (string == null) {
            throw new NotPossibleAtThisTimeException("WLM Provider did not find any deactivateable members for group " + this.ivGroupName);
        }
        MemberDataImpl memberDataImpl = (MemberDataImpl)this.ivMemberMap.get(string);
        this.makeMemberIdle(memberDataImpl.getMemberId());
    }

    GroupName getGroupName() {
        return this.ivGroupName;
    }

    boolean addOrReplaceMember(String string, MemberDataImpl memberDataImpl) throws HAInternalStateException {
        MemberDataImpl memberDataImpl2 = (MemberDataImpl)this.ivMemberMap.get(string);
        this.ivMemberMap.put(string, memberDataImpl);
        this.computeStability();
        if (memberDataImpl2 == null) {
            if (this.ivGroupDisabled) {
                GroupMemberState groupMemberState = memberDataImpl.getState();
                if (!groupMemberState.equals(GroupMemberState.GROUP_DISABLED)) {
                    memberDataImpl.setState(GroupMemberState.GROUP_DISABLED);
                    this.ivGroupStateManager.requestMemberStateChange(this.ivGroupName, string, GroupMemberState.GROUP_DISABLED);
                }
            } else if (memberDataImpl.getState().equals(GroupMemberState.GROUP_DISABLED)) {
                this.ivGroupDisabled = true;
                this.groupDisableAllExistingMembers();
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "addOrReplaceMember - add", new Object[]{this.ivGroupName, memberDataImpl, new Boolean(this.ivGroupDisabled)});
            }
            return true;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "addOrReplaceMember - replace", new Object[]{this.ivGroupName, memberDataImpl, memberDataImpl2});
        }
        if (memberDataImpl.getMemberId().equals(memberDataImpl2.getMemberId())) {
            return true;
        }
        Object[] objectArray = new Object[]{this.ivGroupName, memberDataImpl2, memberDataImpl};
        Tr.error(TC, "HMGR5003", objectArray);
        throw new HAInternalStateException("An invalid membership change for a group member was detected");
    }

    MemberData removeMember(String string) {
        this.invalidateFutureServerName(string);
        MemberData memberData = (MemberData)this.ivMemberMap.remove(string);
        if (this.ivMemberMap.size() != 0 && memberData != null) {
            this.computeStability();
        }
        return memberData;
    }

    boolean containsMember(String string) {
        MemberDataImpl memberDataImpl = this.getMember(string);
        return memberDataImpl != null;
    }

    MemberDataImpl getMember(String string) {
        MemberDataImpl memberDataImpl = (MemberDataImpl)this.ivMemberMap.get(string);
        return memberDataImpl;
    }

    MemberDataImpl[] getMembers() {
        return this.getMemberDataAsArray();
    }

    boolean containsMembers() {
        return this.ivMemberMap.size() != 0;
    }

    Map getMemberMap() {
        return this.ivMemberMap;
    }

    boolean enableMember(String string) throws NotPossibleAtThisTimeException {
        if (this.ivGroupDisabled) {
            throw new NotPossibleAtThisTimeException("Group is disabled");
        }
        MemberDataImpl memberDataImpl = (MemberDataImpl)this.ivMemberMap.get(string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "enableMember", new Object[]{string, memberDataImpl});
        }
        if (memberDataImpl == null) {
            return false;
        }
        GroupMemberState groupMemberState = memberDataImpl.getState();
        if (groupMemberState.equals(GroupMemberState.DISABLED)) {
            memberDataImpl.setState(GroupMemberState.IDLE);
            this.ivGroupStateManager.requestMemberStateChange(this.ivGroupName, string, GroupMemberState.IDLE);
            return true;
        }
        return false;
    }

    boolean enableGroup() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "enableGroup", new Object[]{this.ivGroupName, new Boolean(this.ivGroupDisabled)});
        }
        if (!this.ivGroupDisabled) {
            return false;
        }
        this.ivGroupDisabled = false;
        this.groupEnableAllExistingMembers();
        return true;
    }

    boolean disableMember(String string) throws NotPossibleAtThisTimeException {
        MemberDataImpl memberDataImpl = (MemberDataImpl)this.ivMemberMap.get(string);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "disableMember", new Object[]{string, memberDataImpl});
        }
        if (this.ivGroupDisabled) {
            throw new NotPossibleAtThisTimeException("Group is disabled");
        }
        if (memberDataImpl == null) {
            return false;
        }
        GroupMemberState groupMemberState = memberDataImpl.getState();
        if (groupMemberState.equals(GroupMemberState.DISABLED)) {
            return false;
        }
        memberDataImpl.setState(GroupMemberState.DISABLED);
        this.ivGroupStateManager.requestMemberStateChange(this.ivGroupName, string, GroupMemberState.DISABLED);
        return true;
    }

    void disableGroup() {
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "disableGroup", this.ivGroupName);
        }
        if (this.ivGroupDisabled) {
            return;
        }
        this.ivGroupDisabled = true;
        this.groupDisableAllExistingMembers();
    }

    void disableGroupIfQuorumSensitive() {
        if (this.ivClusterName == null) {
            return;
        }
        if (this.ivGroupDisabled) {
            return;
        }
        if (!this.ivPolicy.isQuorumRequired()) {
            return;
        }
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "disableQuorumSensitiveGroup", this.ivGroupName);
        }
        this.groupDisableAllExistingMembers();
    }

    boolean applyPolicy(boolean bl) {
        if (this.ivPolicy == null || this.ivGroupDisabled) {
            return true;
        }
        if (TC.isDebugEnabled()) {
            boolean bl2 = this.isGroupAtSameUserVersionLevel();
            Object[] objectArray = new Object[]{this.ivGroupName, String.valueOf(this.ivIsStable), String.valueOf(bl2)};
            Tr.debug(TC, "applyPolicy() : groupName, isStable and isSameUserVersion", objectArray);
        }
        if (!this.ivIsStable) {
            return false;
        }
        try {
            if (this.ivClusterName != null && this.ivPolicy.isQuorumRequired() && !this.ivCoordinator.doesClusterHaveQuorum(this.ivClusterName, true, bl)) {
                return false;
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "applyPolicy() : Good to go...either policy doesn't care, we have quorum, or quorum checking is disabled.");
            }
            return this.ivPolicy.checkGroup(this.getMemberDataAsArray(), this);
        }
        catch (HAInternalStateException hAInternalStateException) {
            FFDCFilter.processException((Throwable)hAInternalStateException, svClassName, "535", this);
            Tr.error(TC, "HMGR0209", new Object[]{this.ivGroupName, hAInternalStateException});
            return true;
        }
    }

    void migrateActiveMember(String string, String string2) throws NotPossibleAtThisTimeException, HAInternalStateException {
        MemberData memberData;
        if (this.ivIsStable && this.ivPolicy != null) {
            memberData = (MemberData)this.ivMemberMap.get(string);
            MemberData memberData2 = (MemberData)this.ivMemberMap.get(string2);
            if (memberData == null || memberData2 == null) {
                String string3 = memberData == null ? string : string2;
                Tr.warning(TC, "HMGR0220", new Object[]{string3, this.ivGroupName});
                throw new NotPossibleAtThisTimeException("member " + string3 + " does not exist");
            }
            if (!memberData.getState().equals(GroupMemberState.ACTIVATED)) {
                Tr.warning(TC, "HMGR0221", new Object[]{"IDLE", memberData, this.ivGroupName});
                throw new NotPossibleAtThisTimeException("Not ACTIVATED");
            }
            if (!memberData2.getState().equals(GroupMemberState.IDLE)) {
                Tr.warning(TC, "HMGR0221", new Object[]{"ACTIVE", memberData2, this.ivGroupName});
                throw new NotPossibleAtThisTimeException("Not IDLE");
            }
        } else {
            Tr.warning(TC, "HMGR0222", this.ivGroupName);
            throw new NotPossibleAtThisTimeException("Can't migrate the active member. The group is unstable");
        }
        this.ivHintForFutureActiveMember = string2;
        this.ivTimeMoveActiveMemberStarted = System.currentTimeMillis();
        this.makeMemberIdle(memberData.getMemberId());
    }

    boolean removeDeadMembers(Set set) {
        ArrayList<String> arrayList = new ArrayList<String>(this.ivMemberMap.size());
        Iterator iterator = this.ivMemberMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!set.contains(string)) continue;
            arrayList.add(string);
            if (!TC.isDebugEnabled()) continue;
            Tr.debug(TC, "removeDeadGroupMembers -adding member to purge list", string);
        }
        int n = arrayList.size();
        if (n == 0) {
            return false;
        }
        for (int i = n - 1; i >= 0; --i) {
            String string = (String)arrayList.get(i);
            this.invalidateFutureServerName(string);
            this.ivMemberMap.remove(string);
        }
        this.computeStability();
        return true;
    }

    GroupPolicy getPolicy() {
        return this.ivPolicy;
    }

    void setPolicy(GroupPolicy groupPolicy) {
        this.ivPolicy = groupPolicy;
    }

    boolean hasQuorum(boolean bl) {
        if (this.ivPolicy.isQuorumRequired() && this.ivClusterName != null) {
            return this.ivCoordinator.doesClusterHaveQuorum(this.ivClusterName, false, bl);
        }
        return false;
    }

    boolean isGroupDisabled() {
        return this.ivGroupDisabled;
    }

    private void invalidateFutureServerName(String string) {
        if (this.ivHintForFutureActiveMember != null && this.ivHintForFutureActiveMember.equals(string)) {
            this.ivHintForFutureActiveMember = null;
        }
    }

    private void computeStability() {
        if (!this.isGroupAtSameUserVersionLevel()) {
            this.ivIsStable = false;
            return;
        }
        Iterator iterator = this.ivMemberMap.values().iterator();
        while (iterator.hasNext()) {
            MemberDataImpl memberDataImpl = (MemberDataImpl)iterator.next();
            GroupMemberState groupMemberState = memberDataImpl.getState();
            if (!groupMemberState.equals(GroupMemberState.ACTIVATING) && !groupMemberState.equals(GroupMemberState.DEACTIVATING)) continue;
            this.ivIsStable = false;
            return;
        }
        this.ivIsStable = true;
    }

    private MemberDataImpl[] getMemberDataAsArray() {
        Collection collection = this.ivMemberMap.values();
        MemberDataImpl[] memberDataImplArray = collection.toArray(new MemberDataImpl[collection.size()]);
        return memberDataImplArray;
    }

    private boolean isGroupAtSameUserVersionLevel() {
        Iterator iterator = this.ivMemberMap.values().iterator();
        String string = null;
        while (iterator.hasNext()) {
            MemberDataImpl memberDataImpl = (MemberDataImpl)iterator.next();
            String string2 = memberDataImpl.getMemberId().getVersionString();
            if (string == null) {
                string = string2;
                continue;
            }
            if (string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    private ArrayList getWLMCandidates(boolean bl) throws HAInternalStateException {
        int n = this.ivMemberMap.size();
        if (n == 0) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("Member list is emtpy");
            Tr.error(TC, "HMGR5004", new Object[]{this.ivGroupName, hAInternalStateException});
            throw hAInternalStateException;
        }
        GroupMemberState groupMemberState = bl ? GroupMemberState.IDLE : GroupMemberState.ACTIVATED;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        Set set = this.ivMemberMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            MemberDataImpl memberDataImpl = (MemberDataImpl)entry.getValue();
            if (!memberDataImpl.getState().equals(groupMemberState)) continue;
            arrayList.add(string);
        }
        if (arrayList.isEmpty() && TC.isDebugEnabled()) {
            Tr.debug(TC, "no wlm candidates in group", this.ivMemberMap);
        }
        return arrayList;
    }

    private void groupEnableAllExistingMembers() {
        Set set = this.ivMemberMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            MemberDataImpl memberDataImpl = (MemberDataImpl)entry.getValue();
            memberDataImpl.setState(GroupMemberState.IDLE);
            this.ivGroupStateManager.requestMemberStateChange(this.ivGroupName, string, GroupMemberState.IDLE);
        }
    }

    private void groupDisableAllExistingMembers() {
        Set set = this.ivMemberMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            MemberDataImpl memberDataImpl = (MemberDataImpl)entry.getValue();
            memberDataImpl.setState(GroupMemberState.GROUP_DISABLED);
            this.ivGroupStateManager.requestMemberStateChange(this.ivGroupName, string, GroupMemberState.GROUP_DISABLED);
        }
    }

    void dumpDiagnostic(IncidentStream incidentStream) {
    }
}

