/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.hamanager.coordinator.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.hamanager.JVMController;
import com.ibm.ws.hamanager.Providers;
import com.ibm.ws.hamanager.Version;
import com.ibm.ws.hamanager.agent.AgentClassFactoryImpl;
import com.ibm.ws.hamanager.bboard.BulletinBoardFactoryImpl;
import com.ibm.ws.hamanager.bboard.LocalBulletinBoardStateManager;
import com.ibm.ws.hamanager.coordinator.Coordinator;
import com.ibm.ws.hamanager.coordinator.HAManagerCoordinatorCallback;
import com.ibm.ws.hamanager.coordinator.HAPolicyManager;
import com.ibm.ws.hamanager.coordinator.HAPolicyRule;
import com.ibm.ws.hamanager.coordinator.StateExchangeListener;
import com.ibm.ws.hamanager.coordinator.WorkloadManagementProvider;
import com.ibm.ws.hamanager.coordinator.corestack.CoreStackFactoryImpl;
import com.ibm.ws.hamanager.coordinator.impl.DCSPlugin;
import com.ibm.ws.hamanager.coordinator.impl.DCSPluginImpl;
import com.ibm.ws.hamanager.coordinator.impl.DCSPluginSingleServerImpl;
import com.ibm.ws.hamanager.coordinator.impl.GlobalBBoardBifurcatedStateManager;
import com.ibm.ws.hamanager.coordinator.impl.GlobalBBoardUnifiedStateManager;
import com.ibm.ws.hamanager.coordinator.impl.GlobalBulletinBoardStateManager;
import com.ibm.ws.hamanager.coordinator.impl.GlobalGroupStateManager;
import com.ibm.ws.hamanager.coordinator.impl.HAPolicyManagerImpl;
import com.ibm.ws.hamanager.coordinator.impl.JVMControllerImpl;
import com.ibm.ws.hamanager.coordinator.impl.MessageCache;
import com.ibm.ws.hamanager.coordinator.impl.RPCResponseCollector;
import com.ibm.ws.hamanager.coordinator.impl.WLMProviderImpl;
import com.ibm.ws.hamanager.coordinator.policy.GroupPolicyFactory;
import com.ibm.ws.hamanager.coordinator.policy.impl.NOOPPolicyFactory;
import com.ibm.ws.hamanager.coordinator.policy.impl.OneOfNPolicyFactory;
import com.ibm.ws.hamanager.coordinator.vsmessages.AttentionRequiredMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupLocalMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupMemberActivationCmdMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.GroupUpdateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.HAMMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportClusterProcessStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.ReportStateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.TerminateJVMMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.bboard.BulletinBoardSubscriberUpdateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.bboard.SubscriberUpdateMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.BulletinBoardSnapshotMessage;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.CheckGroup;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.GroupStateJMXMarker;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.JMXActionMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.JMXCoordinatorRPCMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.MigrateActiveMemberMsg;
import com.ibm.ws.hamanager.coordinator.vsmessages.jmx.ResetQuorumProvidersMsg;
import com.ibm.ws.hamanager.datastack.DataStack;
import com.ibm.ws.hamanager.datastack.DataStackCallback;
import com.ibm.ws.hamanager.datastack.SyncDataReqCallback;
import com.ibm.ws.hamanager.impl.GroupManagerImpl;
import com.ibm.ws.hamanager.impl.HAGroupImpl;
import com.ibm.ws.hamanager.impl.HAManagerImpl;
import com.ibm.ws.hamanager.impl.UserCallbacks;
import com.ibm.ws.hamanager.partitionedmanager.ManagedGroupDataFactoryImpl;
import com.ibm.ws.hamanager.pmi.HAManagerPerf;
import com.ibm.ws.hamanager.quorum.QuorumProviderFactoryImpl;
import com.ibm.ws.hamanager.utils.HAMUtil;
import com.ibm.ws.hamanager.utils.StringUtils;
import com.ibm.wsspi.hamanager.DuplicatePoliciesMatchGroupException;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAException;
import com.ibm.wsspi.hamanager.HAInternalStateException;
import com.ibm.wsspi.hamanager.NoPolicyDefinedForGroupException;
import com.ibm.wsspi.hamanager.agent.AgentClassFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardListener;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.hamanager.corestack.CoreStackFactory;
import com.ibm.wsspi.hamanager.corestack.CoreStackInfo;
import com.ibm.wsspi.hamanager.corestack.CoreStackListener;
import com.ibm.wsspi.hamanager.corestack.CoreStackMemberInfo;
import com.ibm.wsspi.hamanager.datastack.DataStackException;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import com.ibm.wsspi.hamanager.partitionedmanager.ManagedGroupDataFactory;
import com.ibm.wsspi.hamanager.quorum.CoreStackPropertyProvider;
import com.ibm.wsspi.hamanager.quorum.QuorumProvider;
import com.ibm.wsspi.hamanager.quorum.QuorumProviderFactory;
import com.ibm.wsspi.hamanager.quorum.ServerPowerController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CoordinatorImpl
implements Coordinator,
CoreStack {
    private static final TraceComponent TC = Tr.register(CoordinatorImpl.class, "HAManager", "com.ibm.ws.hamanager.nls.HAManagerMessages");
    private static final String svClassName = CoordinatorImpl.class.getName();
    private final int COORDINATOR_STATE_FAILED = 0;
    private final int COORDINATOR_STATE_IDLE = 1;
    private final int COORDINATOR_STATE_ACTIVATING = 2;
    private final int COORDINATOR_STATE_ACTIVE = 3;
    private final int COORDINATOR_STATE_ACTIVE_PARTIAL_REBUILD = 4;
    private final String[] STATES = new String[]{"STATE_FAILED", "STATE_IDLE", "STATE_ACTIVATING", "STATE_ACTIVE", "STATE_ACTIVE_PARTIAL_REBUILD"};
    private long ivHAMMessageVersion = HAMMessage.CURRENT;
    private boolean ivDefault;
    private String ivCoreGroupName;
    private String ivDCSMemberName;
    private ServerPowerController ivServerPowerController;
    private HAPolicyManagerImpl ivPolicyManager = null;
    private WorkloadManagementProvider ivWlmProvider = null;
    private JVMController ivJvmController = null;
    private HAManagerCoordinatorCallback ivHaManagerCallback = null;
    private BulletinBoardFactoryImpl ivBulletinboardFactory;
    private GroupManagerImpl ivGroupManager;
    private AgentClassFactoryImpl ivAgentClassFactory;
    private ManagedGroupDataFactoryImpl ivManagedGroupDataFactory;
    private HAManagerPerf ivPmi;
    private MessageCache ivMessageCache;
    private Version ivProtocolVersion;
    private Map ivQuorumProviders = null;
    private QuorumProviderFactory ivQuorumProviderFactory;
    private boolean ivQuorumDetectionEnabled = true;
    private RPCResponseCollector ivClusterStateHolder = null;
    private GlobalGroupStateManager ivGlobalGroupStateManager;
    private GlobalBulletinBoardStateManager ivGlobalBboardStateManager;
    private LocalBulletinBoardStateManager ivLocalBulletinBoardStateManager;
    private ViewChangeManager ivViewChangeManager;
    private CoordinatorStateManager ivCoordStateMgr;
    private ActiveCoordinatorManager ivAcManager;
    private StateRebuildTimer ivStateRebuildTimer;
    private GlobalStateRebuildManager ivGSRManager;
    private PartialStateRebuildManager ivPSRManager;
    private StartBridgeRebuildManager ivFSRManager;
    private Set ivCoreGroupBridgeMembers;
    private boolean ivDCSUnstable = true;
    private DCSPlugin ivDCS;
    private CoreStackListener ivCSListener;
    private boolean ivHAMPending = false;

    public CoordinatorImpl(CoreStackInfo coreStackInfo, CoreStackMemberInfo[] coreStackMemberInfoArray, CoreStackListener coreStackListener, StateExchangeListener stateExchangeListener, StateBlob stateBlob, boolean bl, Set set) throws HAInternalStateException {
        this.ivDefault = bl;
        this.ivCSListener = coreStackListener;
        this.ivServerPowerController = coreStackInfo.getServerPowerController();
        this.ivCoreGroupBridgeMembers = set;
        try {
            if (this.ivDefault) {
                UserCallbacks.initialize();
            }
            this.ivCoreGroupName = coreStackInfo.getName();
            this.ivDCSMemberName = coreStackInfo.getServerName();
            int n = coreStackInfo.getNumCoordinators();
            String[] stringArray = coreStackInfo.getPreferredCoordinators();
            int n2 = coreStackInfo.getCachedUpdateFrequency();
            boolean bl2 = Providers.getConfigProvider().startAsActiveCoordinator();
            this.ivProtocolVersion = new Version(this.ivDefault, coreStackInfo.getProtocolVersions());
            if (bl2 || coreStackMemberInfoArray.length == 1) {
                this.ivCoordStateMgr = new CoordinatorStateManager(true);
                this.ivAcManager = new ActiveCoordinatorManager(true, n, stringArray);
                this.ivMessageCache = new MessageCache(this, this.ivProtocolVersion, 1, n2);
                Tr.info(TC, "HMGR0206", new Object[]{this.ivCoreGroupName, this.getActiveCoordinatorSet()});
            } else {
                this.ivCoordStateMgr = new CoordinatorStateManager(false);
                this.ivAcManager = new ActiveCoordinatorManager(false, n, stringArray);
                this.ivMessageCache = new MessageCache(this, this.ivProtocolVersion, 0, n2);
                Tr.info(TC, "HMGR0228", new Object[]{this.ivCoreGroupName, this.getActiveCoordinatorSet()});
            }
            this.ivViewChangeManager = new ViewChangeManager();
            this.ivStateRebuildTimer = new StateRebuildTimer();
            this.ivGSRManager = new GlobalStateRebuildManager();
            this.ivPSRManager = new PartialStateRebuildManager();
            this.ivGlobalGroupStateManager = new GlobalGroupStateManager(this, this.ivMessageCache);
            boolean bl3 = this.ivAcManager.isActiveCoordinator();
            HashSet<String> hashSet = new HashSet<String>();
            int n3 = coreStackMemberInfoArray.length;
            for (int i = 0; i < n3; ++i) {
                hashSet.add(coreStackMemberInfoArray[i].getServerName());
            }
            Set set2 = Collections.unmodifiableSet(hashSet);
            this.ivLocalBulletinBoardStateManager = new LocalBulletinBoardStateManager(this, this.ivDCSMemberName, this.ivMessageCache, set2, this.ivProtocolVersion, set);
            if (this.ivProtocolVersion.getHAMProtocolVersion() < 5) {
                this.ivGlobalBboardStateManager = new GlobalBBoardUnifiedStateManager(this, this.ivMessageCache, bl3, this.ivProtocolVersion);
            } else {
                String[] stringArray2 = this.ivAcManager.getActiveCoordinators();
                this.ivGlobalBboardStateManager = new GlobalBBoardBifurcatedStateManager(this, this.ivMessageCache, bl3, this.ivProtocolVersion, set2, stringArray2);
                this.ivFSRManager = new StartBridgeRebuildManager(this.ivLocalBulletinBoardStateManager, (GlobalBBoardBifurcatedStateManager)this.ivGlobalBboardStateManager, set);
            }
            this.ivPolicyManager = new HAPolicyManagerImpl(this.ivCoreGroupName, this.ivDefault);
            this.ivJvmController = new JVMControllerImpl(this.ivDefault);
            this.ivWlmProvider = new WLMProviderImpl(this.ivDefault);
            int n4 = coreStackInfo.getIsAliveTime();
            HAManagerImpl hAManagerImpl = new HAManagerImpl(this, this.ivCoreGroupName, this.ivDCSMemberName, this.ivMessageCache, n4, this.ivDefault);
            this.ivGroupManager = new GroupManagerImpl(hAManagerImpl, this.ivCoreGroupName);
            this.ivBulletinboardFactory = new BulletinBoardFactoryImpl(this.ivLocalBulletinBoardStateManager);
            this.ivAgentClassFactory = new AgentClassFactoryImpl(hAManagerImpl, this.ivGroupManager);
            this.ivManagedGroupDataFactory = new ManagedGroupDataFactoryImpl();
            this.ivQuorumProviders = new HashMap();
            this.ivQuorumProviderFactory = new QuorumProviderFactoryImpl();
            if (Providers.getConfigProvider().useSingleServerPlugin()) {
                if (!this.ivDefault) {
                    Tr.error(TC, "HMGR0227");
                    throw new HAException("cannot create a Gateway Core Stack on a single server");
                }
                this.ivDCS = new DCSPluginSingleServerImpl(this, this.ivCoreGroupName, this.ivDCSMemberName);
            } else {
                int n5 = this.getRecommendedCoreGroupSizeLimit();
                if (coreStackMemberInfoArray.length > n5) {
                    Object[] objectArray = new Object[]{this.ivCoreGroupName, new Integer(coreStackMemberInfoArray.length), new Integer(n5)};
                    Tr.warning(TC, "HMGR0008", objectArray);
                }
                this.ivDCS = new DCSPluginImpl(this, bl, coreStackListener, stateExchangeListener, coreStackInfo, coreStackMemberInfoArray, stateBlob, this.ivProtocolVersion);
            }
            this.ivViewChangeManager.setInitalViewId(this.ivDCS.getViewId());
            this.ivDCSUnstable = false;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "288", this);
            throw new HAInternalStateException("failure creating the Coordinator", throwable);
        }
    }

    public CoreStackFactory getCoreStackFactory() {
        return new CoreStackFactoryImpl();
    }

    public AgentClassFactory getAgentClassFactory() {
        return this.ivAgentClassFactory;
    }

    public ManagedGroupDataFactory getManagedGroupDataFactory() {
        return this.ivManagedGroupDataFactory;
    }

    public BulletinBoardFactory getBulletinboardFactory() {
        return this.ivBulletinboardFactory;
    }

    public GroupManager getGroupManager() {
        return this.ivGroupManager;
    }

    public void addBulletinBoardListener(BulletinBoardListener bulletinBoardListener) {
        if (bulletinBoardListener == null) {
            return;
        }
        this.ivGlobalBboardStateManager.addListener(bulletinBoardListener);
    }

    public void removeBulletinBoardListener(BulletinBoardListener bulletinBoardListener) {
        if (bulletinBoardListener == null) {
            return;
        }
        this.ivGlobalBboardStateManager.removeListener(bulletinBoardListener);
    }

    public int updateCoreStackMembers(CoreStackMemberInfo[] coreStackMemberInfoArray, int n) throws DataStackException {
        int n2 = this.ivDCS.updateCoreStackMembership(coreStackMemberInfoArray, n);
        Set set = this.ivDCS.getCoreGroupMembers();
        this.ivLocalBulletinBoardStateManager.updateCoreGroupMembership(set);
        this.ivGlobalBboardStateManager.updateCoreGroupMembership(set);
        return n2;
    }

    public int addDefined(CoreStackMemberInfo coreStackMemberInfo, int n) throws DataStackException {
        int n2 = this.ivDCS.addDefined(coreStackMemberInfo, n);
        Set set = this.ivDCS.getCoreGroupMembers();
        this.ivLocalBulletinBoardStateManager.updateCoreGroupMembership(set);
        this.ivGlobalBboardStateManager.updateCoreGroupMembership(set);
        return n2;
    }

    public int removeDefined(String string, int n) throws DataStackException {
        int n2 = this.ivDCS.removeDefined(string, n);
        Set set = this.ivDCS.getCoreGroupMembers();
        this.ivLocalBulletinBoardStateManager.updateCoreGroupMembership(set);
        this.ivGlobalBboardStateManager.updateCoreGroupMembership(set);
        return n2;
    }

    public void updateProtocolVersions(Map map) throws DataStackException {
        int n = this.ivProtocolVersion.getHAMProtocolVersion();
        String string = (String)map.get("HAM_PROTOCOL");
        String string2 = (String)map.get("DCS_PROTOCOL");
        boolean bl = this.ivProtocolVersion.updateProtocolVersions(map);
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "updateProtocolVersion", new Object[]{string2, string, new Boolean(bl)});
        }
        if (this.ivDefault && bl) {
            int n2 = this.ivProtocolVersion.getHAMProtocolVersion();
            if (n < 5 && n2 >= 5) {
                boolean bl2 = this.ivAcManager.isActiveCoordinator();
                String[] stringArray = this.ivAcManager.getActiveCoordinators();
                GlobalBBoardBifurcatedStateManager globalBBoardBifurcatedStateManager = new GlobalBBoardBifurcatedStateManager(this, this.ivMessageCache, bl2, this.ivProtocolVersion, this.ivDCS.getCoreGroupMembers(), stringArray);
                this.ivGlobalBboardStateManager = this.ivGlobalBboardStateManager.transferInternalState(globalBBoardBifurcatedStateManager);
                this.ivFSRManager = new StartBridgeRebuildManager(this.ivLocalBulletinBoardStateManager, (GlobalBBoardBifurcatedStateManager)this.ivGlobalBboardStateManager, this.ivCoreGroupBridgeMembers);
            }
            this.ivViewChangeManager.rebuildRequired();
        }
        this.ivDCS.updateProtocolVersion(string2);
    }

    public synchronized void bridgeStateUnsychronized(Set set) throws HAException {
        int n = this.ivProtocolVersion.getHAMProtocolVersion();
        if (n < 5) {
            throw new HAException("Method called when protocol version is " + n);
        }
        this.ivLocalBulletinBoardStateManager.bridgeStateUnsynchronized(set);
    }

    public synchronized void bridgeStateSynchronized(Set set) throws HAException {
        int n = this.ivProtocolVersion.getHAMProtocolVersion();
        if (n < 5) {
            throw new HAException("Method called when protocol version is " + n);
        }
        this.ivLocalBulletinBoardStateManager.bridgeStateSynchronized(set);
    }

    public boolean transparentBridgeFailoverEnabled() {
        int n = this.ivProtocolVersion.getHAMProtocolVersion();
        return n >= 5;
    }

    public void shutdown() {
        if (this.ivDefault) {
            Tr.info(TC, "HMGR0137");
        } else {
            Tr.info(TC, "HMGR0138", this.ivCoreGroupName);
            this.ivDCS.terminateCoreStack();
        }
    }

    public CoreStackPropertyProvider getCoreStackPropertyProvider() {
        return this.ivCSListener;
    }

    public synchronized void setQuorumProviderFactory(QuorumProviderFactory quorumProviderFactory) {
        this.ivQuorumProviderFactory = quorumProviderFactory;
        this.ivQuorumProviders.clear();
    }

    public QuorumProviderFactory getQuorumProviderFactory() {
        return this.ivQuorumProviderFactory;
    }

    public void disableQuorumDetection() {
        this.ivQuorumDetectionEnabled = false;
    }

    public void requestCheckGroup(GroupName groupName) throws HAInternalStateException, DataStackException {
        this.sendMessageToActiveCoordinator(groupName, new CheckGroup(groupName));
    }

    public synchronized void sendMessageToActiveCoordinators(HAMMessage hAMMessage) throws DataStackException, HAInternalStateException {
        String[] stringArray = this.ivAcManager.getActiveCoordinators();
        if (stringArray == null || stringArray.length == 0) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("No active Coordinators to get state from");
            Tr.error(TC, "HMGR5005", hAInternalStateException);
            throw hAInternalStateException;
        }
        this.sendMessage(stringArray, hAMMessage);
    }

    public synchronized void sendMessageToActiveCoordinator(GroupName groupName, HAMMessage hAMMessage) throws DataStackException, HAInternalStateException {
        String[] stringArray = this.ivAcManager.getActiveCoordinators();
        if (stringArray == null || stringArray.length == 0) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("No active Coordinators to get state from");
            Tr.error(TC, "HMGR5005", hAInternalStateException);
            throw hAInternalStateException;
        }
        int n = this.getGroupNameHash(groupName);
        this.sendMessage(stringArray[n], hAMMessage);
    }

    public synchronized void moveActiveMemberForGroup(GroupName groupName, String string, String string2) throws HAException, DataStackException {
        String[] stringArray = this.ivAcManager.getActiveCoordinators();
        if (stringArray == null || stringArray.length == 0) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("No active Coordinators to get state from");
            Tr.error(TC, "HMGR5005", hAInternalStateException);
            throw hAInternalStateException;
        }
        MigrateActiveMemberMsg migrateActiveMemberMsg = new MigrateActiveMemberMsg(groupName, string, string2);
        int n = this.getGroupNameHash(groupName);
        String string3 = stringArray[n];
        this.sendMessage(string3, (HAMMessage)migrateActiveMemberMsg);
    }

    public void setClusterStateHolder(RPCResponseCollector rPCResponseCollector) {
        this.ivClusterStateHolder = rPCResponseCollector;
    }

    public synchronized Set getActiveCoordinatorSet() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = this.ivAcManager.getActiveCoordinators();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        return hashSet;
    }

    public synchronized String getActiveCoordinator(GroupName groupName) throws HAInternalStateException {
        String[] stringArray = this.ivAcManager.getActiveCoordinators();
        if (stringArray == null || stringArray.length == 0) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("No active Coordinators");
            Tr.error(TC, "HMGR5005", hAInternalStateException);
            throw hAInternalStateException;
        }
        int n = this.getGroupNameHash(groupName);
        return stringArray[n];
    }

    private final synchronized int getGroupNameHash(GroupName groupName) {
        String[] stringArray = this.ivAcManager.getActiveCoordinators();
        return HAMUtil.calculateCoordinatorIndex(groupName, stringArray.length);
    }

    public void setPMI(HAManagerPerf hAManagerPerf) {
        this.ivPmi = hAManagerPerf;
        if (this.ivHaManagerCallback != null) {
            this.ivHaManagerCallback.setPMI(hAManagerPerf);
        }
    }

    public HAManagerPerf getPMI() {
        return this.ivPmi;
    }

    public String getCoreGroupName() {
        return this.ivCoreGroupName;
    }

    public String getServerName() {
        return this.ivDCSMemberName;
    }

    public HAPolicyManager getPolicyManager() {
        return this.ivPolicyManager;
    }

    public WorkloadManagementProvider getWLMProvider() {
        return this.ivWlmProvider;
    }

    public void setHAManagerCallback(HAManagerCoordinatorCallback hAManagerCoordinatorCallback) {
        this.ivHaManagerCallback = hAManagerCoordinatorCallback;
    }

    public JVMController getJVMController() {
        return this.ivJvmController;
    }

    public void sendMessage(String string, HAMMessage hAMMessage) throws DataStackException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "SendMessage - Point-to-Point", new Object[]{string, hAMMessage});
        }
        hAMMessage.setSender(this.ivDCSMemberName);
        this.ivDCS.sendMessage(string, hAMMessage);
    }

    public void sendMessage(String[] stringArray, HAMMessage hAMMessage) throws DataStackException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "SendMessage - Selective Multicast", hAMMessage);
            Tr.event(TC, "targets", stringArray);
        }
        hAMMessage.setSender(this.ivDCSMemberName);
        this.ivDCS.sendMessage(stringArray, hAMMessage);
    }

    public void sendGroupMessage(MsgQoS msgQoS, String[] stringArray, GroupLocalMessage groupLocalMessage) throws DataStackException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "SendGroupMessage", groupLocalMessage);
            Tr.event(TC, "targets", stringArray);
        }
        groupLocalMessage.setSender(this.ivDCSMemberName);
        this.ivDCS.sendGroupMessage(msgQoS, stringArray, groupLocalMessage);
    }

    public synchronized boolean doesClusterHaveQuorum(String string, boolean bl, boolean bl2) {
        if (!this.ivQuorumDetectionEnabled || this.ivQuorumProviderFactory == null) {
            return true;
        }
        QuorumProvider quorumProvider = (QuorumProvider)this.ivQuorumProviders.get(string);
        if (quorumProvider == null) {
            try {
                String[] stringArray = Providers.getConfigProvider().getClusterMemberNames(string);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "doesClusterHaveQuorum - creating provider", stringArray);
                }
                if (stringArray == null) {
                    return true;
                }
                quorumProvider = this.ivQuorumProviderFactory.createQuorumProviderInstance(string);
                quorumProvider.initialize(stringArray, this.ivViewChangeManager.getCurrentViewMembers());
                this.ivQuorumProviders.put(string, quorumProvider);
            }
            catch (HAException hAException) {
                FFDCFilter.processException((Throwable)hAException, svClassName, "633", this);
                Tr.error(TC, "HMGR0133", new Object[]{string, hAException});
                return false;
            }
        }
        boolean bl3 = quorumProvider.hasQuorum();
        if (!bl) {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "doesClusterHaveQuorum - noEnforce", new Boolean(bl3));
            }
            return bl3;
        }
        boolean bl4 = quorumProvider.wasServerPowerDownPerformed();
        if (!bl3 || bl4) {
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{new Boolean(bl3), new Boolean(bl4)};
                Tr.debug(TC, "doesClusterHaveQuorum - enforce", objectArray);
            }
            return bl3;
        }
        Collection collection = null;
        collection = bl2 ? quorumProvider.getOffLineMembers() : quorumProvider.getFailedServers();
        if (TC.isDebugEnabled()) {
            Tr.debug(TC, "doesClusterHaveQuorum - isolate servers", collection);
        }
        if (collection != null) {
            String[] stringArray = new String[collection.size()];
            collection.toArray(stringArray);
            if (this.ivServerPowerController != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (!this.ivServerPowerController.powerDown(string2, this.ivCSListener)) {
                        Tr.info(TC, "HMGR0158", stringArray[i]);
                        this.ivGlobalGroupStateManager.disableQuorumSensitiveGroupsForCluster(string);
                        break;
                    }
                    Tr.info(TC, "HMGR0144", stringArray[i]);
                }
                quorumProvider.serverPowerDownComplete();
            } else if (TC.isDebugEnabled()) {
                Tr.debug(TC, "doesClusterHaveQuorum", "no ServerPowerController");
            }
        }
        return bl3;
    }

    public boolean isHardwareQuorumEnforced(GroupName groupName) throws NoPolicyDefinedForGroupException, DuplicatePoliciesMatchGroupException, HAInternalStateException {
        HAPolicyRule hAPolicyRule = this.ivPolicyManager.findHAPolicyRuleForGroup(groupName);
        GroupPolicyFactory groupPolicyFactory = hAPolicyRule.getGroupPolicyFactory();
        if (groupPolicyFactory.isStatic()) {
            String[] stringArray = hAPolicyRule.getServerAttributes();
            return stringArray == null || stringArray.length == 1;
        }
        if (groupPolicyFactory instanceof NOOPPolicyFactory) {
            return true;
        }
        if (groupPolicyFactory instanceof OneOfNPolicyFactory) {
            return hAPolicyRule.isQuorumNeeded() && this.ivServerPowerController != null;
        }
        return false;
    }

    public DataStack createDataStack(String string, boolean bl, HAGroupImpl hAGroupImpl, DataStackCallback dataStackCallback, SyncDataReqCallback syncDataReqCallback, String[] stringArray) throws DataStackException {
        return this.ivDCS.createDataStack(string, bl, hAGroupImpl, dataStackCallback, syncDataReqCallback, stringArray);
    }

    public String[] getCurrentViewMembers() {
        return this.ivViewChangeManager.getCurrentViewMembers();
    }

    public boolean isDefaultCoreStack() {
        return this.ivDefault;
    }

    void dumpDiagnostics(IncidentStream incidentStream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean sendCachedUpdates() {
        this.ivHAMPending = true;
        CoordinatorImpl coordinatorImpl = this;
        synchronized (coordinatorImpl) {
            if (this.ivDCSUnstable) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "dcs is unstable - postpone sending messages");
                }
                this.ivHAMPending = false;
                return false;
            }
            String[] stringArray = this.ivAcManager.getActiveCoordinators();
            if (stringArray == null || stringArray.length == 0) {
                HAInternalStateException hAInternalStateException = new HAInternalStateException("No active Coordinators to send state to");
                Tr.error(TC, "HMGR5005", hAInternalStateException);
                this.ivHAMPending = false;
                return false;
            }
            MessageCache messageCache = this.ivMessageCache;
            synchronized (messageCache) {
                HAMMessage[] hAMMessageArray = this.ivMessageCache.getCachedMessages();
                int n = hAMMessageArray.length;
                try {
                    for (int i = 0; i < n; ++i) {
                        HAMMessage hAMMessage = hAMMessageArray[i];
                        if (hAMMessage == null) continue;
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "sendCachedUpdates", new Object[]{new Integer(i), stringArray[i]});
                        }
                        this.sendMessage(stringArray[i], hAMMessage);
                        hAMMessageArray[i] = null;
                    }
                }
                catch (DataStackException dataStackException) {
                    FFDCFilter.processException((Throwable)dataStackException, svClassName, "848", this);
                    Tr.error(TC, "HMGR0113", dataStackException);
                    this.ivMessageCache.unsendableMessages(hAMMessageArray);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, svClassName, "852", this);
                    Tr.error(TC, "HMGR0114", throwable);
                }
            }
            if (this.ivAcManager.isActiveCoordinator()) {
                boolean bl = this.ivGlobalGroupStateManager.sendCachedGroupMessages();
                boolean bl2 = this.ivGlobalBboardStateManager.sendCachedMessages();
                this.ivMessageCache.activeCoordinatorMessagesSent();
                if (!bl || !bl2) {
                    this.ivMessageCache.activeCoordinatorMessagesToSend();
                }
            }
            this.ivHAMPending = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reportStateToActiveCoordinators() throws HAInternalStateException, DataStackException {
        String[] stringArray;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "reportStateToActiveCoordinators");
        }
        if ((stringArray = this.ivAcManager.getActiveCoordinators()) == null || stringArray.length == 0) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("No active Coordinators to get state from");
            Tr.error(TC, "HMGR5005", hAInternalStateException);
            throw hAInternalStateException;
        }
        ReportClusterProcessStateMsg[] reportClusterProcessStateMsgArray = new ReportClusterProcessStateMsg[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            reportClusterProcessStateMsgArray[i] = new ReportClusterProcessStateMsg();
        }
        HAManagerCoordinatorCallback hAManagerCoordinatorCallback = this.ivHaManagerCallback;
        synchronized (hAManagerCoordinatorCallback) {
            this.ivHaManagerCallback.getStateForAllGroups(reportClusterProcessStateMsgArray);
            LocalBulletinBoardStateManager localBulletinBoardStateManager = this.ivLocalBulletinBoardStateManager;
            synchronized (localBulletinBoardStateManager) {
                this.ivLocalBulletinBoardStateManager.getAllState(reportClusterProcessStateMsgArray);
                this.ivMessageCache.clearAllMessages();
                try {
                    for (int i = 0; i < reportClusterProcessStateMsgArray.length; ++i) {
                        ReportClusterProcessStateMsg reportClusterProcessStateMsg = reportClusterProcessStateMsgArray[i];
                        this.sendMessage(stringArray[i], (HAMMessage)reportClusterProcessStateMsg);
                    }
                }
                catch (DataStackException dataStackException) {
                    FFDCFilter.processException((Throwable)dataStackException, svClassName, "794", this);
                    Tr.error(TC, "HMGR0141", dataStackException);
                    throw dataStackException;
                }
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "reportStateToActiveCoordinators");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reportAllStateToActiveCoordinators() throws HAInternalStateException, DataStackException {
        String[] stringArray;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "reportAllStateToActiveCoordinators");
        }
        if ((stringArray = this.ivAcManager.getActiveCoordinators()) == null || stringArray.length == 0) {
            HAInternalStateException hAInternalStateException = new HAInternalStateException("No active Coordinators to get state from");
            Tr.error(TC, "HMGR5005", hAInternalStateException);
            throw hAInternalStateException;
        }
        ReportStateMsg[] reportStateMsgArray = new ReportStateMsg[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            reportStateMsgArray[i] = new ReportStateMsg();
        }
        HAManagerCoordinatorCallback hAManagerCoordinatorCallback = this.ivHaManagerCallback;
        synchronized (hAManagerCoordinatorCallback) {
            this.ivHaManagerCallback.getStateForAllGroups(reportStateMsgArray);
            LocalBulletinBoardStateManager localBulletinBoardStateManager = this.ivLocalBulletinBoardStateManager;
            synchronized (localBulletinBoardStateManager) {
                this.ivLocalBulletinBoardStateManager.getAllState(reportStateMsgArray);
                this.ivMessageCache.clearAllMessages();
                try {
                    for (int i = 0; i < reportStateMsgArray.length; ++i) {
                        ReportStateMsg reportStateMsg = reportStateMsgArray[i];
                        this.sendMessage(stringArray[i], (HAMMessage)reportStateMsg);
                    }
                }
                catch (DataStackException dataStackException) {
                    FFDCFilter.processException((Throwable)dataStackException, svClassName, "794", this);
                    Tr.error(TC, "HMGR0141", dataStackException);
                    throw dataStackException;
                }
            }
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "reportAllStateToActiveCoordinators");
        }
    }

    public void stopDefaultCoreStack() {
        this.ivHaManagerCallback.shutdown();
        UserCallbacks.shutdown();
        this.ivDCS.terminateCoreStack();
    }

    public void distributeDefaultCoreStackConfiguration(StateBlob stateBlob) throws DataStackException {
        this.ivDCS.setStateExchangeBlob(stateBlob);
    }

    public synchronized void installDefaultCoreStackConfig(int n, String[] stringArray, String string, Map map, boolean bl) {
        this.ivViewChangeManager.defaultCoreStackConfigChanged();
        if (bl) {
            this.ivQuorumProviders.clear();
        }
        this.ivAcManager.possibleConfigurationUpdateReceived(n, stringArray);
        this.ivDCS.setSharedSecret(string);
        boolean bl2 = false;
        if (map != null) {
            bl2 = this.ivPolicyManager.merge(map);
        }
        if (bl2) {
            this.ivHaManagerCallback.reloadPolicies();
            if (this.ivAcManager.isActiveCoordinator()) {
                this.ivGlobalGroupStateManager.reloadPolicies();
                this.ivGlobalGroupStateManager.runAllPolicies(false);
            }
        }
        if (TC.isDebugEnabled()) {
            Object[] objectArray = new Object[]{string, new Integer(n), new Boolean(bl2)};
            Tr.debug(TC, "installDefaultCoreStackConfig", objectArray);
            Tr.debug(TC, "installDefaultCoreStackConfig", stringArray);
        }
    }

    boolean outboundMessagesWaiting() {
        return this.ivHAMPending;
    }

    synchronized void viewAboutToChange() {
        this.ivMessageCache.disableCache();
        this.ivDCSUnstable = true;
    }

    synchronized void viewChangeCompleted(Comparable comparable, String[] stringArray) {
        this.ivDCSUnstable = false;
        this.ivViewChangeManager.installNewView(comparable, stringArray);
        this.ivMessageCache.enableCache();
    }

    synchronized void onMessage(String string, HAMMessage hAMMessage) {
        try {
            if (string == null) {
                HAInternalStateException hAInternalStateException = new HAInternalStateException("onMessage - message sender is null");
                Tr.error(TC, "HMGR5007", hAInternalStateException);
                throw hAInternalStateException;
            }
            if (!hAMMessage.canMessageBeProcessed(this.ivHAMMessageVersion)) {
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "unknown message", hAMMessage.getDescription());
                }
                return;
            }
            if (hAMMessage instanceof TerminateJVMMsg) {
                this.ivCoordStateMgr.failed();
                this.ivJvmController.panicJVM("Remote panic request");
            }
            if (hAMMessage instanceof AttentionRequiredMsg) {
                AttentionRequiredMsg attentionRequiredMsg = (AttentionRequiredMsg)hAMMessage;
                Tr.warning(TC, "HMGR0235", new Object[]{string, attentionRequiredMsg.getReasonMsgID()});
                return;
            }
            int n = this.ivCoordStateMgr.getState();
            switch (n) {
                case 0: {
                    this.processOnMessageStateFailed(string, hAMMessage);
                    break;
                }
                case 1: {
                    this.processOnMessageStateIdle(string, hAMMessage);
                    break;
                }
                case 2: {
                    this.processOnMessageStateActivating(string, hAMMessage);
                    break;
                }
                case 3: {
                    this.processOnMessageStateActive(string, hAMMessage);
                    break;
                }
                case 4: {
                    this.processOnMessageStateActive(string, hAMMessage);
                    break;
                }
                default: {
                    Tr.error(TC, "HMGR0203", new Object[]{this.STATES[n], hAMMessage});
                }
            }
            if (TC.isEventEnabled()) {
                Tr.event(TC, "processed onMessage()");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, svClassName, "1110", this);
            Tr.error(TC, "HMGR0204", new Object[]{hAMMessage, throwable});
        }
    }

    private final void processOnMessageStateFailed(String string, Object object) {
        Tr.error(TC, "HMGR0208", object);
    }

    private final void processOnMessageStateIdle(String string, Object object) throws DataStackException, HAInternalStateException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "processOnMessageStateIdle", new Object[]{string, object});
        }
        if (object instanceof BulletinBoardSubscriberUpdateMsg) {
            this.processBulletinBoardSubscriberUpdateMsg((BulletinBoardSubscriberUpdateMsg)object);
        } else if (object instanceof SubscriberUpdateMsg) {
            this.processSubscriberUpdateMsg((SubscriberUpdateMsg)object);
        } else if (object instanceof GroupUpdateMsg) {
            this.ivHaManagerCallback.groupMembershipUpdate((GroupUpdateMsg)object);
        } else if (object instanceof GroupMemberActivationCmdMsg) {
            this.ivHaManagerCallback.groupStateUpdate((GroupMemberActivationCmdMsg)object);
        } else if (object instanceof GroupLocalMessage) {
            this.ivHaManagerCallback.onMessage(string, (GroupLocalMessage)object);
        } else if (object instanceof JMXCoordinatorRPCMsg) {
            this.processJMXRPCMessage(string, (JMXCoordinatorRPCMsg)object);
        } else {
            int n = this.ivCoordStateMgr.getState();
            Tr.error(TC, "HMGR0205", new Object[]{this.STATES[n], object});
        }
    }

    private final void processOnMessageStateActive(String string, Object object) throws DataStackException, HAException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "processOnMessageStateActive()", new Object[]{string, object});
        }
        if (object instanceof BulletinBoardSubscriberUpdateMsg) {
            this.processBulletinBoardSubscriberUpdateMsg((BulletinBoardSubscriberUpdateMsg)object);
        } else if (object instanceof SubscriberUpdateMsg) {
            this.processSubscriberUpdateMsg((SubscriberUpdateMsg)object);
        } else if (object instanceof GroupUpdateMsg) {
            this.ivHaManagerCallback.groupMembershipUpdate((GroupUpdateMsg)object);
        } else if (object instanceof GroupMemberActivationCmdMsg) {
            this.ivHaManagerCallback.groupStateUpdate((GroupMemberActivationCmdMsg)object);
        } else if (object instanceof GroupLocalMessage) {
            this.ivHaManagerCallback.onMessage(string, (GroupLocalMessage)object);
        } else if (object instanceof ReportClusterProcessStateMsg) {
            ReportClusterProcessStateMsg reportClusterProcessStateMsg = (ReportClusterProcessStateMsg)object;
            this.ivGlobalBboardStateManager.updateState(string, reportClusterProcessStateMsg, false);
            this.ivGlobalGroupStateManager.updateState(string, reportClusterProcessStateMsg);
            if (this.ivCoordStateMgr.getState() == 4) {
                this.ivPSRManager.checkPartialStateRebuildComplete(string);
            }
        } else if (object instanceof ReportStateMsg) {
            ReportStateMsg reportStateMsg = (ReportStateMsg)object;
            this.ivGlobalBboardStateManager.updateState(string, reportStateMsg, false);
            this.ivGlobalGroupStateManager.updateState(string, reportStateMsg);
            if (this.ivCoordStateMgr.getState() == 4) {
                this.ivPSRManager.checkPartialStateRebuildComplete(string);
            }
        } else if (object instanceof JMXCoordinatorRPCMsg) {
            this.processJMXRPCMessage(string, (JMXCoordinatorRPCMsg)object);
        } else if (object instanceof JMXActionMsg) {
            this.ivGlobalGroupStateManager.handleJMXActionMsg((JMXActionMsg)object);
        } else if (object instanceof MigrateActiveMemberMsg) {
            this.ivGlobalGroupStateManager.handleMoveActiveMember((MigrateActiveMemberMsg)object);
        } else if (object instanceof CheckGroup) {
            this.ivGlobalGroupStateManager.runPolicy(((CheckGroup)object).getGroupName(), false);
        } else if (object instanceof ResetQuorumProvidersMsg) {
            this.ivQuorumProviders.clear();
            this.ivGlobalGroupStateManager.runAllPolicies(false);
        } else {
            int n = this.ivCoordStateMgr.getState();
            Tr.error(TC, "HMGR0205", new Object[]{this.STATES[n], object});
        }
    }

    private final void processOnMessageStateActivating(String string, Object object) throws DataStackException, HAInternalStateException {
        if (TC.isEventEnabled()) {
            Tr.event(TC, "processOnMessageStateActivating", new Object[]{string, object});
        }
        if (object instanceof BulletinBoardSubscriberUpdateMsg) {
            this.processBulletinBoardSubscriberUpdateMsg((BulletinBoardSubscriberUpdateMsg)object);
        } else if (object instanceof SubscriberUpdateMsg) {
            this.processSubscriberUpdateMsg((SubscriberUpdateMsg)object);
        } else if (object instanceof GroupUpdateMsg) {
            this.ivHaManagerCallback.groupMembershipUpdate((GroupUpdateMsg)object);
        } else if (object instanceof GroupMemberActivationCmdMsg) {
            this.ivHaManagerCallback.groupStateUpdate((GroupMemberActivationCmdMsg)object);
        } else if (object instanceof GroupLocalMessage) {
            this.ivHaManagerCallback.onMessage(string, (GroupLocalMessage)object);
        } else if (object instanceof ReportClusterProcessStateMsg) {
            ReportClusterProcessStateMsg reportClusterProcessStateMsg = (ReportClusterProcessStateMsg)object;
            boolean bl = this.ivGSRManager.reportStateMsgReceivedWhileActivating(string);
            this.ivGlobalBboardStateManager.updateState(string, reportClusterProcessStateMsg, bl);
            this.ivGlobalGroupStateManager.updateState(string, reportClusterProcessStateMsg);
            this.ivGSRManager.checkGlobalStateRebuildComplete();
        } else if (object instanceof ReportStateMsg) {
            ReportStateMsg reportStateMsg = (ReportStateMsg)object;
            boolean bl = this.ivGSRManager.reportStateMsgReceivedWhileActivating(string);
            this.ivGlobalBboardStateManager.updateState(string, reportStateMsg, bl);
            this.ivGlobalGroupStateManager.updateState(string, reportStateMsg);
            this.ivGSRManager.checkGlobalStateRebuildComplete();
        } else if (object instanceof JMXCoordinatorRPCMsg) {
            this.processJMXRPCMessage(string, (JMXCoordinatorRPCMsg)object);
        } else if (!(object instanceof CheckGroup)) {
            if (object instanceof ResetQuorumProvidersMsg) {
                this.ivQuorumProviders.clear();
            } else {
                int n = this.ivCoordStateMgr.getState();
                Tr.error(TC, "HMGR0205", new Object[]{this.STATES[n], object});
            }
        }
    }

    private void processJMXRPCMessage(String string, JMXCoordinatorRPCMsg jMXCoordinatorRPCMsg) throws DataStackException, HAInternalStateException {
        if (jMXCoordinatorRPCMsg.isReply()) {
            if (jMXCoordinatorRPCMsg.isCorrectRequestor(this.ivClusterStateHolder) && this.ivClusterStateHolder.addResponse(string, jMXCoordinatorRPCMsg) && TC.isDebugEnabled()) {
                Tr.debug(TC, "processJMXRPCMessage() notify all responses received");
            }
        } else {
            jMXCoordinatorRPCMsg.setReply(true);
            if (jMXCoordinatorRPCMsg instanceof GroupStateJMXMarker) {
                this.ivGlobalGroupStateManager.handleJMXRequest(jMXCoordinatorRPCMsg);
            }
            if (jMXCoordinatorRPCMsg instanceof BulletinBoardSnapshotMessage) {
                BulletinBoardSnapshotMessage bulletinBoardSnapshotMessage = (BulletinBoardSnapshotMessage)jMXCoordinatorRPCMsg;
                this.ivGlobalBboardStateManager.handleJMXRequest(bulletinBoardSnapshotMessage);
            }
            this.sendMessage(string, (HAMMessage)jMXCoordinatorRPCMsg);
        }
    }

    private void processBulletinBoardSubscriberUpdateMsg(BulletinBoardSubscriberUpdateMsg bulletinBoardSubscriberUpdateMsg) throws HAInternalStateException {
        boolean bl = bulletinBoardSubscriberUpdateMsg.getTotal();
        if (!bl) {
            this.ivLocalBulletinBoardStateManager.processSubjectUpdates(bulletinBoardSubscriberUpdateMsg, false);
        } else {
            Object object;
            int n;
            String string = bulletinBoardSubscriberUpdateMsg.getSender();
            int n2 = -1;
            String[] stringArray = this.ivAcManager.getActiveCoordinators();
            for (n = 0; n < stringArray.length; ++n) {
                object = stringArray[n];
                if (!string.equals(object)) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                String string2 = "Message sender " + string + " is not a valid active coordinator.";
                object = new HAInternalStateException(string2);
                Tr.error(TC, "HMGR5005", object);
                throw object;
            }
            n = this.ivAcManager.getNumberOfActiveCoordinators();
            this.ivLocalBulletinBoardStateManager.processGlobalStateRebuildMsg(bulletinBoardSubscriberUpdateMsg, n2, n);
        }
    }

    private void processSubscriberUpdateMsg(SubscriberUpdateMsg subscriberUpdateMsg) throws HAInternalStateException {
        int n = subscriberUpdateMsg.getLocalMode();
        int n2 = subscriberUpdateMsg.getProxyMode();
        if (n != 1 && n2 != 1) {
            this.ivLocalBulletinBoardStateManager.processSubjectUpdates(subscriberUpdateMsg);
        } else {
            Object object;
            int n3;
            String string = subscriberUpdateMsg.getSender();
            int n4 = -1;
            String[] stringArray = this.ivAcManager.getActiveCoordinators();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                object = stringArray[n3];
                if (!string.equals(object)) continue;
                n4 = n3;
                break;
            }
            if (n4 == -1) {
                String string2 = "Message sender " + string + " is not a valid active coordinator.";
                object = new HAInternalStateException(string2);
                Tr.error(TC, "HMGR5005", object);
                throw object;
            }
            n3 = this.ivAcManager.getNumberOfActiveCoordinators();
            if (n == 1) {
                boolean bl = false;
                if (n2 == 0) {
                    bl = true;
                }
                this.ivLocalBulletinBoardStateManager.processGlobalStateRebuildMsg(subscriberUpdateMsg, n4, n3, bl);
            } else {
                this.ivLocalBulletinBoardStateManager.processBridgeRebuildMsg(subscriberUpdateMsg, n4, n3);
            }
        }
    }

    private int getRecommendedCoreGroupSizeLimit() {
        if (this.ivProtocolVersion == null) {
            return 50;
        }
        if (this.ivProtocolVersion.getDCSProtocolVersion() < 10) {
            return 50;
        }
        return 100;
    }

    private class StateRebuildTimer {
        private static final int DEFAULT_REBUILD_TIMEOUT_AND_MSG_PERIOD = 120000;
        private long ivRebuildTimeOut = 120000L;
        private Alarm ivAlarm = null;
        private RebuildTimeoutAction ivRebuildTOAction = null;
        private boolean ivRebuildTimeOutDetectionEnabled = true;

        StateRebuildTimer() {
        }

        synchronized void scheduleRebuildTimeoutAlarm() {
            this.determineOverrides();
            if (this.ivRebuildTimeOutDetectionEnabled) {
                this.cancelRebuildTimeoutAlarm();
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Scheduling rebuild time-out alarm.  Timeout=" + this.ivRebuildTimeOut / 1000L + " seconds");
                }
                this.ivRebuildTOAction = new RebuildTimeoutAction();
                this.ivAlarm = AlarmManager.createNonDeferrable(this.ivRebuildTimeOut, this.ivRebuildTOAction);
            }
        }

        synchronized void cancelRebuildTimeoutAlarm() {
            if (this.ivRebuildTimeOutDetectionEnabled) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "Cancelling rebuild time-out alarm. ivAlarm=" + this.ivAlarm + ", ivRebuildTOAction=" + this.ivRebuildTOAction);
                }
                if (this.ivAlarm != null) {
                    this.ivAlarm.cancel();
                    this.ivAlarm = null;
                }
                if (this.ivRebuildTOAction != null) {
                    this.ivRebuildTOAction.cancel();
                    this.ivRebuildTOAction = null;
                }
            }
        }

        private void determineOverrides() {
            this.ivRebuildTimeOutDetectionEnabled = true;
            this.ivRebuildTimeOut = 120000L;
            String string = null;
            try {
                string = Providers.getConfigProvider().getCustomProperty("IBM_CS_COORDINATOR_REBUILD_TIMEOUT_SECS");
                if (string != null) {
                    int n = Integer.parseInt(string);
                    if (n <= 0) {
                        this.ivRebuildTimeOutDetectionEnabled = false;
                    } else {
                        this.ivRebuildTimeOut = n * 1000;
                    }
                    Tr.info(TC, "HMGR0226", new Object[]{"IBM_CS_COORDINATOR_REBUILD_TIMEOUT_SECS", new Integer(n)});
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "2981");
                Tr.error(TC, "HMGR0225", new Object[]{"IBM_CS_COORDINATOR_REBUILD_TIMEOUT_SECS", string, throwable});
            }
        }

        private final class RebuildTimeoutAction
        implements AlarmListener {
            private boolean actionCancelled = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alarm(Object object) {
                StateRebuildTimer stateRebuildTimer = StateRebuildTimer.this;
                synchronized (stateRebuildTimer) {
                    int n;
                    if (this.actionCancelled) {
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "aborting rebuild time-out action");
                        }
                        return;
                    }
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "Rebuild time-out detected. Action running...");
                    }
                    if ((n = CoordinatorImpl.this.ivCoordStateMgr.getState()) == 2 || n == 4) {
                        Set set = n == 2 ? CoordinatorImpl.this.ivGSRManager.waitingForStateFrom() : CoordinatorImpl.this.ivPSRManager.waitingForStateFrom();
                        Tr.warning(TC, "HMGR0234", set);
                        if (TC.isDebugEnabled()) {
                            Tr.debug(TC, "Scheduling rebuild time-out error message alarm.  Timeout=120 seconds");
                        }
                        StateRebuildTimer.this.ivAlarm = AlarmManager.createNonDeferrable(120000L, this);
                    } else if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "Rebuild time-out. No action taken.  Coordinator State=" + n);
                    }
                }
            }

            void cancel() {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "rebuild time-out action has been cancelled");
                }
                this.actionCancelled = true;
            }
        }
    }

    private class StartBridgeRebuildManager {
        private LocalBulletinBoardStateManager ivLocalBulletinBoardStateManager;
        private GlobalBBoardBifurcatedStateManager ivGlobalBulletinBoardStateManager;
        private Set ivConfiguredBridgesInLocalCoreGroup;
        private Set ivBridgesInPreviousView = new HashSet();
        private String[] ivCurrentViewMembers = new String[0];

        StartBridgeRebuildManager(LocalBulletinBoardStateManager localBulletinBoardStateManager, GlobalBBoardBifurcatedStateManager globalBBoardBifurcatedStateManager, Set set) {
            this.ivLocalBulletinBoardStateManager = localBulletinBoardStateManager;
            this.ivGlobalBulletinBoardStateManager = globalBBoardBifurcatedStateManager;
            this.ivConfiguredBridgesInLocalCoreGroup = set;
        }

        boolean installNewView(String[] stringArray, String[] stringArray2, boolean bl) throws HAInternalStateException, DataStackException {
            int n = CoordinatorImpl.this.ivProtocolVersion.getHAMProtocolVersion();
            if (n < 5) {
                return false;
            }
            this.ivCurrentViewMembers = stringArray2;
            Set set = this.getBridgesInCurrentView();
            boolean bl2 = false;
            if (this.ivBridgesInPreviousView.size() != 0 && set.size() == 0) {
                bl2 = true;
            }
            boolean bl3 = true;
            if (!bl2) {
                bl3 = !this.ivBridgesInPreviousView.containsAll(set);
            }
            this.ivBridgesInPreviousView = set;
            this.ivLocalBulletinBoardStateManager.installNewView(stringArray2, bl, bl2, set);
            boolean bl4 = CoordinatorImpl.this.ivAcManager.isActiveCoordinator();
            String[] stringArray3 = CoordinatorImpl.this.ivAcManager.getActiveCoordinators();
            this.ivGlobalBulletinBoardStateManager.installNewView(stringArray2, bl, bl4, stringArray3);
            return bl3;
        }

        private Set getBridgesInCurrentView() {
            HashSet<String> hashSet = new HashSet<String>();
            if (this.ivConfiguredBridgesInLocalCoreGroup.size() > 0) {
                for (int i = 0; i < this.ivCurrentViewMembers.length; ++i) {
                    if (!this.ivConfiguredBridgesInLocalCoreGroup.contains(this.ivCurrentViewMembers[i])) continue;
                    hashSet.add(this.ivCurrentViewMembers[i]);
                }
            }
            return hashSet;
        }
    }

    private class GlobalStateRebuildManager {
        private Set ivGSRMessageSenders = new HashSet();
        private boolean ivRebuildCompleteMessagesWaiting = false;

        GlobalStateRebuildManager() {
        }

        boolean reportStateMsgReceivedWhileActivating(String string) {
            boolean bl = this.ivGSRMessageSenders.add(string);
            return bl;
        }

        void checkGlobalStateRebuildComplete() throws HAInternalStateException {
            if (this.ivGSRMessageSenders.size() == CoordinatorImpl.this.ivViewChangeManager.getCurrentViewMembers().length) {
                CoordinatorImpl.this.ivStateRebuildTimer.cancelRebuildTimeoutAlarm();
                this.exitRebuildingState();
            }
        }

        void initiateGlobalStateRebuild(boolean bl) {
            this.ivRebuildCompleteMessagesWaiting = false;
            this.ivGSRMessageSenders.clear();
            CoordinatorImpl.this.ivQuorumProviders.clear();
            if (bl) {
                CoordinatorImpl.this.ivStateRebuildTimer.scheduleRebuildTimeoutAlarm();
            }
            CoordinatorImpl.this.ivGlobalBboardStateManager.startGSR(bl);
            CoordinatorImpl.this.ivGlobalGroupStateManager.startRebuild(bl);
        }

        void attemptCompletionOfGlobalStateRebuild(Set set) throws HAInternalStateException {
            Object[] objectArray;
            if (TC.isDebugEnabled()) {
                objectArray = new Object[]{new Boolean(this.ivRebuildCompleteMessagesWaiting), this.ivGSRMessageSenders};
                Tr.debug(TC, "attemptCompletionOfGlobalStateRebuild", objectArray);
            }
            if (this.ivRebuildCompleteMessagesWaiting) {
                this.exitRebuildingState();
            } else if (set != null && set.size() > 0) {
                objectArray = set.iterator();
                while (objectArray.hasNext()) {
                    String string = (String)objectArray.next();
                    this.ivGSRMessageSenders.remove(string);
                }
                this.checkGlobalStateRebuildComplete();
            }
        }

        Set waitingForStateFrom() {
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = CoordinatorImpl.this.ivViewChangeManager.getCurrentViewMembers();
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.ivGSRMessageSenders.contains(stringArray[i])) continue;
                hashSet.add(stringArray[i]);
            }
            return hashSet;
        }

        private void exitRebuildingState() throws HAInternalStateException {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "exitGlobalRebuildState", new Boolean(CoordinatorImpl.this.ivDCSUnstable));
            }
            if (CoordinatorImpl.this.ivDCSUnstable) {
                this.ivRebuildCompleteMessagesWaiting = true;
            } else {
                boolean bl = CoordinatorImpl.this.ivGlobalGroupStateManager.rebuildComplete();
                boolean bl2 = CoordinatorImpl.this.ivGlobalBboardStateManager.gsrRebuildComplete();
                CoordinatorImpl.this.ivMessageCache.rebuildComplete();
                if (!bl || !bl2) {
                    CoordinatorImpl.this.ivMessageCache.activeCoordinatorMessagesToSend();
                }
                CoordinatorImpl.this.ivCoordStateMgr.stateRebuildCompleted();
            }
        }
    }

    private class PartialStateRebuildManager {
        private Set ivPartialStateRebuildMessageSenders = new HashSet();

        PartialStateRebuildManager() {
        }

        void checkPartialStateRebuildComplete(String string) throws HAInternalStateException {
            this.ivPartialStateRebuildMessageSenders.remove(string);
            if (this.ivPartialStateRebuildMessageSenders.size() == 0) {
                CoordinatorImpl.this.ivStateRebuildTimer.cancelRebuildTimeoutAlarm();
                this.exitRebuildingState();
            }
        }

        void initiatePartialStateRebuild(String[] stringArray, String[] stringArray2, Set set) throws HAInternalStateException {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "initiatePartialStateRebuild");
            }
            this.calculatePSRMessageSenders(stringArray, stringArray2, set);
            if (this.ivPartialStateRebuildMessageSenders.size() > 0) {
                CoordinatorImpl.this.ivStateRebuildTimer.scheduleRebuildTimeoutAlarm();
                CoordinatorImpl.this.ivMessageCache.partialStateRebuildRequired();
            } else {
                this.exitRebuildingState();
            }
        }

        Set waitingForStateFrom() {
            return this.ivPartialStateRebuildMessageSenders;
        }

        private void exitRebuildingState() {
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "exitPartialRebuildState");
            }
            if (CoordinatorImpl.this.ivDCSUnstable) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "exitPartialRebuildState", "DCS is unstable");
                }
            } else {
                boolean bl = CoordinatorImpl.this.ivGlobalGroupStateManager.sendCachedGroupMessages();
                boolean bl2 = CoordinatorImpl.this.ivGlobalBboardStateManager.sendCachedMessages();
                CoordinatorImpl.this.ivMessageCache.rebuildComplete();
                if (!bl || !bl2) {
                    CoordinatorImpl.this.ivMessageCache.activeCoordinatorMessagesToSend();
                }
                CoordinatorImpl.this.ivCoordStateMgr.stateRebuildCompleted();
            }
        }

        private void calculatePSRMessageSenders(String[] stringArray, String[] stringArray2, Set set) {
            Object object;
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "calculatePSRMessageSenders - initiated", this.ivPartialStateRebuildMessageSenders);
            }
            if (this.ivPartialStateRebuildMessageSenders.size() > 0 && set.size() > 0) {
                object = set.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    this.ivPartialStateRebuildMessageSenders.remove(string);
                }
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "calculatePSRMessageSenders - remove dead", this.ivPartialStateRebuildMessageSenders);
                }
            }
            if ((object = StringUtils.computeRemovedStrings(stringArray2, stringArray)).size() != 0) {
                if (this.ivPartialStateRebuildMessageSenders.size() != 0) {
                    object.addAll(this.ivPartialStateRebuildMessageSenders);
                }
                this.ivPartialStateRebuildMessageSenders = object;
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "calculatePSRMessageSenders - completed", this.ivPartialStateRebuildMessageSenders);
            }
        }
    }

    private class CoordinatorStateManager {
        private int ivCurrentState = 0;

        CoordinatorStateManager(boolean bl) {
            this.ivCurrentState = bl ? 3 : 1;
        }

        int getState() {
            return this.ivCurrentState;
        }

        void failed() {
            this.ivCurrentState = 0;
        }

        void stateRebuildCompleted() {
            this.ivCurrentState = 3;
            Tr.info(TC, "HMGR0206", new Object[]{CoordinatorImpl.this.ivCoreGroupName, CoordinatorImpl.this.getActiveCoordinatorSet()});
        }

        boolean installNewView(String[] stringArray, String[] stringArray2, Set set, boolean bl) {
            boolean bl2 = false;
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{new Boolean(bl)};
                Tr.debug(TC, "CoordinatorStateManager.installNewView() ", objectArray);
            }
            try {
                boolean bl3;
                boolean bl4 = CoordinatorImpl.this.ivAcManager.isActiveCoordinator();
                bl2 = CoordinatorImpl.this.ivAcManager.electActiveCoordinators(stringArray2);
                boolean bl5 = CoordinatorImpl.this.ivAcManager.isActiveCoordinator();
                boolean bl6 = bl3 = bl2 || bl;
                if (bl3) {
                    CoordinatorImpl.this.ivMessageCache.globalStateRebuildRequired(CoordinatorImpl.this.ivAcManager.getNumberOfActiveCoordinators());
                }
                this.calculateNewState(bl4, bl5, bl3, stringArray, stringArray2, set);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "1942", this);
                Tr.error(TC, "HMGR0120", new Object[]{"CoordinatorStateManager.installNewView", throwable});
            }
            return bl2;
        }

        private void calculateNewState(boolean bl, boolean bl2, boolean bl3, String[] stringArray, String[] stringArray2, Set set) throws HAInternalStateException {
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{CoordinatorImpl.this.STATES[this.ivCurrentState], new Boolean(bl), new Boolean(bl2), new Boolean(bl3)};
                Tr.debug(TC, "CoordinatorStateManager.calculateNewState", objectArray);
            }
            if (!bl) {
                if (bl2) {
                    this.ivCurrentState = 2;
                    CoordinatorImpl.this.ivGSRManager.initiateGlobalStateRebuild(true);
                } else {
                    this.ivCurrentState = 1;
                    Tr.info(TC, "HMGR0228", new Object[]{CoordinatorImpl.this.ivCoreGroupName, CoordinatorImpl.this.getActiveCoordinatorSet()});
                }
            } else if (!bl2) {
                this.ivCurrentState = 1;
                Tr.info(TC, "HMGR0207", new Object[]{CoordinatorImpl.this.ivCoreGroupName, CoordinatorImpl.this.getActiveCoordinatorSet()});
                CoordinatorImpl.this.ivGSRManager.initiateGlobalStateRebuild(false);
            } else if (bl3) {
                this.ivCurrentState = 2;
                CoordinatorImpl.this.ivGSRManager.initiateGlobalStateRebuild(true);
            } else {
                if (set.size() > 0) {
                    CoordinatorImpl.this.ivGlobalBboardStateManager.removeDeadServers(set);
                    CoordinatorImpl.this.ivGlobalGroupStateManager.removeDeadServers(set);
                }
                if (this.ivCurrentState == 2) {
                    CoordinatorImpl.this.ivGSRManager.attemptCompletionOfGlobalStateRebuild(set);
                }
                if (this.ivCurrentState == 2) {
                    if (TC.isDebugEnabled()) {
                        Tr.debug(TC, "CoordinatorStateManager.calculateNewState", "GSR continues");
                    }
                } else {
                    this.ivCurrentState = 4;
                    CoordinatorImpl.this.ivPSRManager.initiatePartialStateRebuild(stringArray, stringArray2, set);
                }
            }
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "CoordinatorStateManager.calculateNewState", CoordinatorImpl.this.STATES[this.ivCurrentState]);
            }
        }
    }

    private class ActiveCoordinatorManager {
        private int ivMaxActiveCoordinators;
        private String[] ivPreferredCoordinators;
        private boolean ivIsActiveCoordinator = false;
        private int ivNumberActiveCoordinators;
        private String[] ivActiveCoordinators;

        ActiveCoordinatorManager(boolean bl, int n, String[] stringArray) {
            this.ivMaxActiveCoordinators = n;
            this.ivPreferredCoordinators = stringArray;
            if (bl) {
                this.ivIsActiveCoordinator = true;
                this.ivNumberActiveCoordinators = 1;
                this.ivActiveCoordinators = new String[]{CoordinatorImpl.this.ivDCSMemberName};
            } else {
                this.ivIsActiveCoordinator = false;
                this.ivNumberActiveCoordinators = 0;
                this.ivActiveCoordinators = null;
            }
        }

        boolean isActiveCoordinator() {
            return this.ivIsActiveCoordinator;
        }

        int getNumberOfActiveCoordinators() {
            return this.ivNumberActiveCoordinators;
        }

        String[] getActiveCoordinators() {
            return this.ivActiveCoordinators;
        }

        void possibleConfigurationUpdateReceived(int n, String[] stringArray) {
            this.ivMaxActiveCoordinators = n;
            this.ivPreferredCoordinators = stringArray;
        }

        boolean electActiveCoordinators(String[] stringArray) {
            boolean bl;
            Object[] objectArray = this.ivActiveCoordinators;
            this.ivNumberActiveCoordinators = Math.min(this.ivMaxActiveCoordinators, stringArray.length);
            this.ivActiveCoordinators = new String[this.ivNumberActiveCoordinators];
            int n = 0;
            String[] stringArray2 = this.getPresentPreferredCoordinators(stringArray);
            if (stringArray2 != null) {
                bl = stringArray2.length;
                for (boolean bl2 = false; bl2 < bl && n < this.ivNumberActiveCoordinators; bl2 += 1, ++n) {
                    this.ivActiveCoordinators[bl2] = stringArray2[bl2];
                }
            }
            if (n < this.ivNumberActiveCoordinators) {
                bl = false;
                while (n < this.ivNumberActiveCoordinators) {
                    String string;
                    if (StringUtils.arrayContainsString(string = stringArray[bl++], this.ivActiveCoordinators)) continue;
                    this.ivActiveCoordinators[n++] = string;
                }
            }
            this.ivIsActiveCoordinator = StringUtils.arrayContainsString(CoordinatorImpl.this.ivDCSMemberName, this.ivActiveCoordinators);
            boolean bl3 = bl = !Arrays.equals(objectArray, this.ivActiveCoordinators);
            if (TC.isEventEnabled()) {
                Object[] objectArray2 = new Object[]{new Integer(this.ivMaxActiveCoordinators), new Integer(this.ivNumberActiveCoordinators), new Boolean(this.ivIsActiveCoordinator), new Boolean(bl)};
                Tr.event(TC, "electActiveCoordinators()", objectArray2);
                Tr.event(TC, "new active coordinator list", this.ivActiveCoordinators);
            }
            return bl;
        }

        private String[] getPresentPreferredCoordinators(String[] stringArray) {
            if (this.ivPreferredCoordinators == null || this.ivPreferredCoordinators.length == 0) {
                return null;
            }
            int n = this.ivPreferredCoordinators.length;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                if (!StringUtils.arrayContainsString(this.ivPreferredCoordinators[i], stringArray)) continue;
                arrayList.add(this.ivPreferredCoordinators[i]);
            }
            n = arrayList.size();
            if (n == 0) {
                return null;
            }
            String[] stringArray2 = new String[n];
            arrayList.toArray(stringArray2);
            return stringArray2;
        }
    }

    private class ViewChangeManager {
        private Comparable ivViewID = "No View";
        private String[] ivViewMembers;
        private boolean ivRebuildRequired = false;
        private boolean ivConfigInstalled = false;

        ViewChangeManager() {
            this.ivViewMembers = new String[]{CoordinatorImpl.this.ivDCSMemberName};
        }

        void setInitalViewId(Comparable comparable) {
            this.ivViewID = comparable;
        }

        String[] getCurrentViewMembers() {
            return this.ivViewMembers;
        }

        void rebuildRequired() {
            this.ivRebuildRequired = true;
        }

        void defaultCoreStackConfigChanged() {
            this.ivConfigInstalled = true;
        }

        void installNewView(Comparable comparable, String[] stringArray) {
            if (TC.isEntryEnabled()) {
                Tr.entry(TC, "installNewView", new Object[]{CoordinatorImpl.this.ivCoreGroupName, comparable});
            }
            try {
                String[] stringArray2;
                String[] stringArray3 = this.ivViewMembers;
                this.ivViewID = comparable;
                this.ivViewMembers = stringArray;
                boolean bl = this.isTrivialViewChange(stringArray3, stringArray);
                if (bl) {
                    return;
                }
                this.ivConfigInstalled = false;
                Set set = StringUtils.computeRemovedStrings(stringArray3, stringArray);
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "installNewView - dead servers", set);
                }
                Iterator iterator = CoordinatorImpl.this.ivQuorumProviders.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    stringArray2 = (String[])entry.getValue();
                    stringArray2.recalcQuorum(stringArray, set);
                }
                boolean bl2 = CoordinatorImpl.this.ivCoordStateMgr.installNewView(stringArray3, stringArray, set, this.ivRebuildRequired);
                if (CoordinatorImpl.this.ivProtocolVersion.getHAMProtocolVersion() >= 5) {
                    if (bl2) {
                        stringArray2 = CoordinatorImpl.this.ivAcManager.getActiveCoordinators();
                        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray2));
                        CoordinatorImpl.this.ivGlobalBboardStateManager.fireActiveCoordinatorChange(hashSet);
                    }
                    boolean bl3 = this.ivRebuildRequired || bl2;
                    CoordinatorImpl.this.ivFSRManager.installNewView(stringArray3, stringArray, bl3);
                }
                if (CoordinatorImpl.this.ivQuorumDetectionEnabled && CoordinatorImpl.this.ivHaManagerCallback.hasActiveMembersInMinorityPartition()) {
                    CoordinatorImpl.this.ivCoordStateMgr.failed();
                    CoordinatorImpl.this.ivJvmController.panicJVM("Active members and lost quorum");
                }
                if (this.ivRebuildRequired || bl2) {
                    if (CoordinatorImpl.this.ivProtocolVersion.getHAMProtocolVersion() < 5) {
                        this.ivRebuildRequired = false;
                        CoordinatorImpl.this.reportStateToActiveCoordinators();
                    } else {
                        this.ivRebuildRequired = false;
                        CoordinatorImpl.this.reportAllStateToActiveCoordinators();
                    }
                }
                Tr.info(TC, "HMGR0218", new Object[]{CoordinatorImpl.this.ivCoreGroupName, this.ivViewID, new Integer(this.ivViewMembers.length)});
                if (TC.isEntryEnabled()) {
                    Tr.exit(TC, "installNewView");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, svClassName, "1617", this);
                Tr.error(TC, "HMGR0120", new Object[]{"installNewView", throwable});
            }
        }

        private boolean isTrivialViewChange(String[] stringArray, String[] stringArray2) {
            boolean bl;
            int n = stringArray.length;
            int n2 = stringArray2.length;
            if (TC.isDebugEnabled()) {
                Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Boolean(this.ivConfigInstalled), new Boolean(this.ivRebuildRequired)};
                Tr.debug(TC, "isTrivialViewChange", objectArray);
            }
            if (this.ivConfigInstalled || this.ivRebuildRequired) {
                return false;
            }
            int n3 = CoordinatorImpl.this.ivCoordStateMgr.getState();
            if (n3 == 2 || n3 == 4) {
                return false;
            }
            if (n == n2 && (bl = StringUtils.compareStringArraysForExactEquality(stringArray, stringArray2))) {
                if (TC.isDebugEnabled()) {
                    Tr.debug(TC, "isTrivial view change", "Trivial view change detected");
                }
                return true;
            }
            return false;
        }
    }
}

